/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.ExtensionPoint;
import org.sonar.api.batch.ScannerSide;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.config.Configuration;

@ScannerSide
@ExtensionPoint
public class PylintConfiguration {
    public static final String PYLINT_CONFIG_KEY = "sonar.python.pylint_config";
    public static final String PYLINT_KEY = "sonar.python.pylint";
    private final Configuration conf;

    public PylintConfiguration(Configuration conf) {
        this.conf = conf;
    }

    public String getPylintConfigPath(FileSystem fileSystem) {
        String configPath = this.conf.get(PYLINT_CONFIG_KEY).orElse("");
        if (StringUtils.isEmpty(configPath)) {
            return null;
        }
        File configFile = new File(configPath);
        if (!configFile.isAbsolute()) {
            File projectRoot = fileSystem.baseDir();
            configFile = new File(projectRoot.getPath(), configPath);
        }
        return configFile.getAbsolutePath();
    }

    public String getPylintPath() {
        return this.conf.get(PYLINT_KEY).orElse(null);
    }
}

