/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.python.pylint;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.command.Command;
import org.sonar.api.utils.command.CommandExecutor;
import org.sonar.api.utils.command.StreamConsumer;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.python.pylint.CommandStreamConsumer;
import org.sonar.plugins.python.pylint.Issue;
import org.sonar.plugins.python.pylint.PylintArguments;
import org.sonar.plugins.python.pylint.PylintReportParser;

public class PylintIssuesAnalyzer {
    private static final Logger LOG = Loggers.get(PylintIssuesAnalyzer.class);
    private static final String FALLBACK_PYLINT = "pylint";
    private String pylint = null;
    private String pylintConfigParam = null;
    private PylintArguments pylintArguments;

    PylintIssuesAnalyzer(String pylintPath, String pylintConfigPath) {
        this(pylintPath, pylintConfigPath, new PylintArguments(Command.create((String)PylintIssuesAnalyzer.pylintPathWithDefault(pylintPath)).addArgument("--version")));
    }

    PylintIssuesAnalyzer(String pylintPath, @Nullable String pylintConfigPath, PylintArguments arguments) {
        this.pylint = PylintIssuesAnalyzer.pylintPathWithDefault(pylintPath);
        if (pylintConfigPath != null) {
            if (!new File(pylintConfigPath).exists()) {
                throw new IllegalStateException("Cannot find the pylint configuration file: " + pylintConfigPath);
            }
            this.pylintConfigParam = "--rcfile=" + pylintConfigPath;
        }
        this.pylintArguments = arguments;
    }

    private static String pylintPathWithDefault(@Nullable String pylintPath) {
        if (pylintPath != null) {
            if (!new File(pylintPath).exists()) {
                throw new IllegalStateException("Cannot find the pylint executable: " + pylintPath);
            }
            return pylintPath;
        }
        return FALLBACK_PYLINT;
    }

    public List<Issue> analyze(String path, Charset charset, File out) throws IOException {
        Command command = Command.create((String)this.pylint).addArguments(this.pylintArguments.arguments()).addArgument(path);
        if (this.pylintConfigParam != null) {
            command.addArgument(this.pylintConfigParam);
        }
        LOG.debug("Calling command: '{}'", (Object)command);
        long timeoutMS = 300000L;
        CommandStreamConsumer stdOut = new CommandStreamConsumer();
        CommandStreamConsumer stdErr = new CommandStreamConsumer();
        CommandExecutor.create().execute(command, (StreamConsumer)stdOut, (StreamConsumer)stdErr, timeoutMS);
        if (stdErr.getData().size() > 1) {
            LOG.warn("Output on the error channel detected: this is probably due to a problem on pylint's side.");
            String data = StringUtils.join(stdErr.getData(), "\n");
            LOG.warn("Content of the error stream: \n\"{}\"", (Object)data);
        }
        String str = StringUtils.join(stdOut.getData(), "\n");
        Files.write(out.toPath(), str.getBytes(charset), new OpenOption[0]);
        return this.parseOutput(stdOut.getData());
    }

    protected List<Issue> parseOutput(List<String> lines) {
        LinkedList<Issue> issues = new LinkedList<Issue>();
        PylintReportParser parser = new PylintReportParser();
        if (!lines.isEmpty()) {
            for (String line : lines) {
                Issue issue = parser.parseLine(line);
                if (issue == null) continue;
                issues.add(issue);
            }
        }
        return issues;
    }
}

