/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.python.PythonCheck;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.checks.CheckUtils;

@Rule(key="S2712")
public class ReturnAndYieldInOneFunctionCheck
extends PythonCheck {
    public static final String MESSAGE = "Use only \"return\" or only \"yield\", not both.";
    public static final String CHECK_KEY = "S2712";

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.singleton(PythonGrammar.FUNCDEF);
    }

    @Override
    public void visitNode(AstNode node) {
        List<AstNode> returnStatements = node.getDescendants(PythonGrammar.RETURN_STMT);
        List<AstNode> yieldStatements = node.getDescendants(PythonGrammar.YIELD_STMT);
        if (yieldStatements.isEmpty() || ReturnAndYieldInOneFunctionCheck.allInNestedFunction(yieldStatements, node)) {
            return;
        }
        for (AstNode returnStatement : returnStatements) {
            if (!ReturnAndYieldInOneFunctionCheck.returnHasArgument(returnStatement) || !CheckUtils.insideFunction(returnStatement, node)) continue;
            this.addIssue(node.getFirstChild(PythonGrammar.FUNCNAME), MESSAGE);
            return;
        }
    }

    private static boolean returnHasArgument(AstNode returnStatement) {
        return returnStatement.getFirstChild(PythonGrammar.TESTLIST) != null;
    }

    private static boolean allInNestedFunction(List<AstNode> statements, AstNode func) {
        for (AstNode statement : statements) {
            if (!CheckUtils.insideFunction(statement, func)) continue;
            return false;
        }
        return true;
    }
}

