/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.python.metrics;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.sonar.python.PythonVisitor;
import org.sonar.python.api.PythonGrammar;
import org.sonar.python.api.PythonKeyword;
import org.sonar.python.api.PythonPunctuator;

public class CognitiveComplexityVisitor
extends PythonVisitor {
    private int complexity = 0;
    private Deque<NestingLevel> nestingLevelStack = new LinkedList<NestingLevel>();
    @Nullable
    private final SecondaryLocationConsumer secondaryLocationConsumer;

    CognitiveComplexityVisitor(@Nullable SecondaryLocationConsumer secondaryLocationConsumer) {
        this.secondaryLocationConsumer = secondaryLocationConsumer;
        this.nestingLevelStack.push(new NestingLevel());
    }

    public static int complexity(AstNode node, @Nullable SecondaryLocationConsumer secondaryLocationConsumer) {
        CognitiveComplexityVisitor visitor = new CognitiveComplexityVisitor(secondaryLocationConsumer);
        visitor.scanNode(node);
        return visitor.complexity;
    }

    public int getComplexity() {
        return this.complexity;
    }

    @Override
    public Set<AstNodeType> subscribedKinds() {
        return Collections.unmodifiableSet(new HashSet<Enum>(Arrays.asList(PythonGrammar.IF_STMT, PythonKeyword.ELIF, PythonKeyword.ELSE, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.EXCEPT_CLAUSE, PythonGrammar.AND_TEST, PythonGrammar.OR_TEST, PythonGrammar.TEST, PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF, PythonGrammar.SUITE)));
    }

    @Override
    public void visitNode(AstNode astNode) {
        if (astNode.is(PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF)) {
            this.nestingLevelStack.push(new NestingLevel(this.nestingLevelStack.peek(), astNode));
        } else if (astNode.is(PythonGrammar.SUITE)) {
            if (CognitiveComplexityVisitor.isSuiteIncrementsNestingLevel(astNode)) {
                this.nestingLevelStack.peek().increment();
            }
        } else if (astNode.is(PythonGrammar.IF_STMT, PythonGrammar.WHILE_STMT, PythonGrammar.FOR_STMT, PythonGrammar.EXCEPT_CLAUSE)) {
            this.incrementWithNesting(astNode.getFirstChild());
        } else if (astNode.is(PythonKeyword.ELIF) || astNode.is(PythonKeyword.ELSE) && astNode.getNextSibling().is(PythonPunctuator.COLON)) {
            this.incrementWithoutNesting(astNode);
        } else if (astNode.is(PythonGrammar.AND_TEST, PythonGrammar.OR_TEST)) {
            this.incrementWithoutNesting(astNode.getFirstChild(PythonKeyword.AND, PythonKeyword.OR));
        } else if (astNode.is(PythonGrammar.TEST) && astNode.hasDirectChildren(PythonKeyword.IF)) {
            this.incrementWithNesting(astNode.getFirstChild(PythonKeyword.IF));
            this.nestingLevelStack.peek().increment();
        }
    }

    @Override
    public void leaveNode(AstNode astNode) {
        if (astNode.is(PythonGrammar.FUNCDEF, PythonGrammar.CLASSDEF)) {
            this.nestingLevelStack.pop();
        } else if (astNode.is(PythonGrammar.SUITE)) {
            if (CognitiveComplexityVisitor.isSuiteIncrementsNestingLevel(astNode)) {
                this.nestingLevelStack.peek().decrement();
            }
        } else if (astNode.is(PythonGrammar.TEST) && astNode.hasDirectChildren(PythonKeyword.IF)) {
            this.nestingLevelStack.peek().decrement();
        }
    }

    private static boolean isSuiteIncrementsNestingLevel(AstNode astNode) {
        AstNode previousSibling = astNode.getPreviousSibling().getPreviousSibling();
        if (previousSibling.is(PythonKeyword.TRY, PythonKeyword.FINALLY)) {
            return false;
        }
        return !astNode.getParent().is(PythonGrammar.CLASSDEF, PythonGrammar.FUNCDEF, PythonGrammar.WITH_STMT);
    }

    private void incrementWithNesting(AstNode secondaryLocationNode) {
        this.incrementComplexity(secondaryLocationNode, 1 + this.nestingLevelStack.peek().level());
    }

    private void incrementWithoutNesting(AstNode secondaryLocationNode) {
        this.incrementComplexity(secondaryLocationNode, 1);
    }

    private void incrementComplexity(AstNode secondaryLocationNode, int currentNodeComplexity) {
        if (this.secondaryLocationConsumer != null) {
            this.secondaryLocationConsumer.consume(secondaryLocationNode, CognitiveComplexityVisitor.secondaryMessage(currentNodeComplexity));
        }
        this.complexity += currentNodeComplexity;
    }

    private static String secondaryMessage(int complexity) {
        if (complexity == 1) {
            return "+1";
        }
        return String.format("+%s (incl %s for nesting)", complexity, complexity - 1);
    }

    private static class NestingLevel {
        @Nullable
        private AstNode astNode;
        private int level;

        private NestingLevel() {
            this.astNode = null;
            this.level = 0;
        }

        private NestingLevel(NestingLevel parent, AstNode astNode) {
            this.astNode = astNode;
            this.level = astNode.is(PythonGrammar.FUNCDEF) ? (parent.isWrapperFunction(astNode) ? parent.level : (parent.isFunction() ? parent.level + 1 : 0)) : 0;
        }

        private boolean isFunction() {
            return this.astNode != null && this.astNode.is(PythonGrammar.FUNCDEF);
        }

        private boolean isWrapperFunction(AstNode childFunction) {
            if (this.astNode != null && this.astNode.is(PythonGrammar.FUNCDEF)) {
                AstNode childStatement = childFunction.getParent().getParent();
                return this.astNode.getFirstChild(PythonGrammar.SUITE).getChildren(PythonGrammar.STATEMENT).stream().filter(statement -> statement != childStatement).allMatch(NestingLevel::isSimpleReturn);
            }
            return false;
        }

        private static boolean isSimpleReturn(AstNode statement) {
            AstNode returnStatement = NestingLevel.lookupOnlyChild(statement.getFirstChild(PythonGrammar.STMT_LIST), PythonGrammar.SIMPLE_STMT, PythonGrammar.RETURN_STMT);
            return returnStatement != null && NestingLevel.lookupOnlyChild(returnStatement.getFirstChild(PythonGrammar.TESTLIST), PythonGrammar.TEST, PythonGrammar.ATOM, PythonGrammar.NAME) != null;
        }

        @Nullable
        private static AstNode lookupOnlyChild(@Nullable AstNode parent, AstNodeType ... types) {
            if (parent == null) {
                return null;
            }
            AstNode result = parent;
            for (AstNodeType type : types) {
                List<AstNode> children = result.getChildren();
                if (children.size() != 1 || !children.get(0).is(type)) {
                    return null;
                }
                result = children.get(0);
            }
            return result;
        }

        private int level() {
            return this.level;
        }

        private void increment() {
            ++this.level;
        }

        private void decrement() {
            --this.level;
        }
    }

    public static interface SecondaryLocationConsumer {
        public void consume(AstNode var1, String var2);
    }
}

