/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.io.IOException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Properties;
import javax.annotation.Nullable;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.StartTlsRequest;
import javax.naming.ldap.StartTlsResponse;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.CallbackHandlerImpl;
import org.sonar.plugins.ldap.Krb5LoginConfiguration;
import org.sonar.plugins.ldap.LdapException;

public class LdapContextFactory {
    private static final Logger LOG = Loggers.get(LdapContextFactory.class);
    static final String AUTH_METHOD_SIMPLE = "simple";
    static final String AUTH_METHOD_GSSAPI = "GSSAPI";
    static final String AUTH_METHOD_DIGEST_MD5 = "DIGEST-MD5";
    static final String AUTH_METHOD_CRAM_MD5 = "CRAM-MD5";
    private static final String REFERRALS_FOLLOW_MODE = "follow";
    private static final String REFERRALS_IGNORE_MODE = "ignore";
    private static final String DEFAULT_AUTHENTICATION = "simple";
    private static final String DEFAULT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String SUN_CONNECTION_POOLING_PROPERTY = "com.sun.jndi.ldap.connect.pool";
    private static final String SASL_REALM_PROPERTY = "java.naming.security.sasl.realm";
    private final String providerUrl;
    private final boolean startTLS;
    private final String authentication;
    private final String factory;
    private final String username;
    private final String password;
    private final String realm;
    private final String referral;

    public LdapContextFactory(Settings settings, String settingsPrefix, String ldapUrl) {
        this.authentication = StringUtils.defaultString((String)settings.getString(settingsPrefix + ".authentication"), (String)"simple");
        this.factory = StringUtils.defaultString((String)settings.getString(settingsPrefix + ".contextFactoryClass"), (String)DEFAULT_FACTORY);
        this.realm = settings.getString(settingsPrefix + ".realm");
        this.providerUrl = ldapUrl;
        this.startTLS = settings.getBoolean(settingsPrefix + ".StartTLS");
        this.username = settings.getString(settingsPrefix + ".bindDn");
        this.password = settings.getString(settingsPrefix + ".bindPassword");
        this.referral = LdapContextFactory.getReferralsMode(settings, settingsPrefix + ".followReferrals");
    }

    public InitialDirContext createBindContext() throws NamingException {
        if (this.isGssapi()) {
            return this.createInitialDirContextUsingGssapi(this.username, this.password);
        }
        return this.createInitialDirContext(this.username, this.password, true);
    }

    public InitialDirContext createUserContext(String principal, String credentials) throws NamingException {
        return this.createInitialDirContext(principal, credentials, false);
    }

    private InitialDirContext createInitialDirContext(String principal, String credentials, boolean pooling) throws NamingException {
        InitialLdapContext ctx;
        if (this.startTLS) {
            Properties env = new Properties();
            env.put("java.naming.factory.initial", this.factory);
            env.put("java.naming.provider.url", this.providerUrl);
            env.put("java.naming.referral", this.referral);
            ctx = new InitialLdapContext(env, null);
            StartTlsResponse tls = (StartTlsResponse)ctx.extendedOperation(new StartTlsRequest());
            try {
                tls.negotiate();
            }
            catch (IOException e) {
                NamingException ex = new NamingException("StartTLS failed");
                ex.initCause(e);
                throw ex;
            }
            ctx.addToEnvironment("java.naming.security.authentication", this.authentication);
            ctx.addToEnvironment("java.naming.security.principal", principal);
            ctx.addToEnvironment("java.naming.security.credentials", credentials);
            ctx.reconnect(null);
        } else {
            ctx = new InitialLdapContext(this.getEnvironment(principal, credentials, pooling), null);
        }
        return ctx;
    }

    private InitialDirContext createInitialDirContextUsingGssapi(String principal, String credentials) throws NamingException {
        InitialDirContext initialDirContext;
        Configuration.setConfiguration(new Krb5LoginConfiguration());
        try {
            LoginContext lc = new LoginContext(this.getClass().getName(), new CallbackHandlerImpl(principal, credentials));
            lc.login();
            initialDirContext = Subject.doAs(lc.getSubject(), new PrivilegedExceptionAction<InitialDirContext>(){

                @Override
                public InitialDirContext run() throws NamingException {
                    Properties env = new Properties();
                    env.put("java.naming.factory.initial", LdapContextFactory.this.factory);
                    env.put("java.naming.provider.url", LdapContextFactory.this.providerUrl);
                    env.put("java.naming.referral", LdapContextFactory.this.referral);
                    return new InitialLdapContext(env, null);
                }
            });
        }
        catch (PrivilegedActionException | LoginException e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.initCause(e);
            throw namingException;
        }
        return initialDirContext;
    }

    private Properties getEnvironment(@Nullable String principal, @Nullable String credentials, boolean pooling) {
        Properties env = new Properties();
        env.put("java.naming.security.authentication", this.authentication);
        if (this.realm != null) {
            env.put(SASL_REALM_PROPERTY, this.realm);
        }
        if (pooling) {
            env.put(SUN_CONNECTION_POOLING_PROPERTY, "true");
        }
        env.put("java.naming.factory.initial", this.factory);
        env.put("java.naming.provider.url", this.providerUrl);
        env.put("java.naming.referral", this.referral);
        if (principal != null) {
            env.put("java.naming.security.principal", principal);
        }
        LOG.debug("Initializing LDAP context {}", (Object)env);
        if (credentials != null) {
            env.put("java.naming.security.credentials", credentials);
        }
        return env;
    }

    public boolean isSasl() {
        return AUTH_METHOD_DIGEST_MD5.equals(this.authentication) || AUTH_METHOD_CRAM_MD5.equals(this.authentication) || AUTH_METHOD_GSSAPI.equals(this.authentication);
    }

    public boolean isGssapi() {
        return AUTH_METHOD_GSSAPI.equals(this.authentication);
    }

    public void testConnection() {
        if (StringUtils.isBlank((String)this.username) && this.isSasl()) {
            throw new IllegalArgumentException("When using SASL - property ldap.bindDn is required");
        }
        try {
            this.createBindContext();
            LOG.info("Test LDAP connection on {}: OK", (Object)this.providerUrl);
        }
        catch (NamingException e) {
            LOG.info("Test LDAP connection: FAIL");
            throw new LdapException("Unable to open LDAP connection", e);
        }
    }

    public String getProviderUrl() {
        return this.providerUrl;
    }

    public String getReferral() {
        return this.referral;
    }

    private static String getReferralsMode(Settings settings, String followReferralsSettingKey) {
        if (settings.hasKey(followReferralsSettingKey)) {
            return settings.getBoolean(followReferralsSettingKey) ? REFERRALS_FOLLOW_MODE : REFERRALS_IGNORE_MODE;
        }
        return REFERRALS_FOLLOW_MODE;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{url=" + this.providerUrl + ", authentication=" + this.authentication + ", factory=" + this.factory + ", bindDn=" + this.username + ", realm=" + this.realm + ", referral=" + this.referral + "}";
    }
}

