/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.sonar.api.security.ExternalGroupsProvider;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.LdapContextFactory;
import org.sonar.plugins.ldap.LdapException;
import org.sonar.plugins.ldap.LdapGroupMapping;
import org.sonar.plugins.ldap.LdapUserMapping;

public class LdapGroupsProvider
extends ExternalGroupsProvider {
    private static final Logger LOG = Loggers.get(LdapGroupsProvider.class);
    private final Map<String, LdapContextFactory> contextFactories;
    private final Map<String, LdapUserMapping> userMappings;
    private final Map<String, LdapGroupMapping> groupMappings;

    public LdapGroupsProvider(Map<String, LdapContextFactory> contextFactories, Map<String, LdapUserMapping> userMappings, Map<String, LdapGroupMapping> groupMapping) {
        this.contextFactories = contextFactories;
        this.userMappings = userMappings;
        this.groupMappings = groupMapping;
    }

    public Collection<String> doGetGroups(ExternalGroupsProvider.Context context) {
        return this.getGroups(context.getUsername());
    }

    public Collection<String> getGroups(String username) {
        this.checkPrerequisites(username);
        HashSet<String> groups = new HashSet<String>();
        ArrayList<LdapException> exceptions = new ArrayList<LdapException>();
        for (String serverKey : this.userMappings.keySet()) {
            SearchResult searchResult;
            if (!this.groupMappings.containsKey(serverKey) || (searchResult = this.searchUserGroups(username, exceptions, serverKey)) == null) continue;
            try {
                NamingEnumeration<SearchResult> result = this.groupMappings.get(serverKey).createSearch(this.contextFactories.get(serverKey), searchResult).find();
                groups.addAll(this.mapGroups(serverKey, result));
                break;
            }
            catch (NamingException e) {
                LOG.debug(e.getMessage(), (Object)e);
                exceptions.add(new LdapException(String.format("Unable to retrieve groups for user %s in %s", username, serverKey), e));
            }
        }
        LdapGroupsProvider.checkResults(groups, exceptions);
        return groups;
    }

    private static void checkResults(Set<String> groups, List<LdapException> exceptions) {
        if (groups.isEmpty() && !exceptions.isEmpty()) {
            throw exceptions.iterator().next();
        }
    }

    private void checkPrerequisites(String username) {
        if (this.userMappings.isEmpty() || this.groupMappings.isEmpty()) {
            throw new LdapException(String.format("Unable to retrieve details for user %s: No user or group mapping found.", username));
        }
    }

    private SearchResult searchUserGroups(String username, List<LdapException> exceptions, String serverKey) {
        SearchResult searchResult = null;
        try {
            LOG.debug("Requesting groups for user {}", (Object)username);
            searchResult = this.userMappings.get(serverKey).createSearch(this.contextFactories.get(serverKey), username).returns(this.groupMappings.get(serverKey).getRequiredUserAttributes()).findUnique();
        }
        catch (NamingException e) {
            LOG.debug(e.getMessage(), (Object)e);
            exceptions.add(new LdapException(String.format("Unable to retrieve groups for user %s in %s", username, serverKey), e));
        }
        return searchResult;
    }

    private Collection<String> mapGroups(String serverKey, NamingEnumeration<SearchResult> searchResult) throws NamingException {
        HashSet<String> groups = new HashSet<String>();
        while (searchResult.hasMoreElements()) {
            SearchResult obj = (SearchResult)searchResult.nextElement();
            Attributes attributes = obj.getAttributes();
            String groupId = (String)attributes.get(this.groupMappings.get(serverKey).getIdAttribute()).get();
            groups.add(groupId);
        }
        return groups;
    }
}

