/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.util.Map;
import org.sonar.api.security.Authenticator;
import org.sonar.api.security.ExternalGroupsProvider;
import org.sonar.api.security.ExternalUsersProvider;
import org.sonar.api.security.SecurityRealm;
import org.sonar.plugins.ldap.LdapAuthenticator;
import org.sonar.plugins.ldap.LdapContextFactory;
import org.sonar.plugins.ldap.LdapGroupMapping;
import org.sonar.plugins.ldap.LdapGroupsProvider;
import org.sonar.plugins.ldap.LdapSettingsManager;
import org.sonar.plugins.ldap.LdapUserMapping;
import org.sonar.plugins.ldap.LdapUsersProvider;

public class LdapRealm
extends SecurityRealm {
    private LdapUsersProvider usersProvider;
    private LdapGroupsProvider groupsProvider;
    private LdapAuthenticator authenticator;
    private final LdapSettingsManager settingsManager;

    public LdapRealm(LdapSettingsManager settingsManager) {
        this.settingsManager = settingsManager;
    }

    public String getName() {
        return "LDAP";
    }

    public void init() {
        Map<String, LdapContextFactory> contextFactories = this.settingsManager.getContextFactories();
        Map<String, LdapUserMapping> userMappings = this.settingsManager.getUserMappings();
        this.usersProvider = new LdapUsersProvider(contextFactories, userMappings);
        this.authenticator = new LdapAuthenticator(contextFactories, userMappings);
        Map<String, LdapGroupMapping> groupMappings = this.settingsManager.getGroupMappings();
        if (!groupMappings.isEmpty()) {
            this.groupsProvider = new LdapGroupsProvider(contextFactories, userMappings, groupMappings);
        }
        for (LdapContextFactory contextFactory : contextFactories.values()) {
            contextFactory.testConnection();
        }
    }

    public Authenticator doGetAuthenticator() {
        return this.authenticator;
    }

    public ExternalUsersProvider getUsersProvider() {
        return this.usersProvider;
    }

    public ExternalGroupsProvider getGroupsProvider() {
        return this.groupsProvider;
    }
}

