/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.util.Arrays;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.PartialResultException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.ContextHelper;
import org.sonar.plugins.ldap.LdapContextFactory;

public class LdapSearch {
    private static final Logger LOG = Loggers.get(LdapSearch.class);
    private final LdapContextFactory contextFactory;
    private String baseDn;
    private int scope = 2;
    private String request;
    private String[] parameters;
    private String[] returningAttributes;

    public LdapSearch(LdapContextFactory contextFactory) {
        this.contextFactory = contextFactory;
    }

    public LdapSearch setBaseDn(String baseDn) {
        this.baseDn = baseDn;
        return this;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public LdapSearch setScope(int scope) {
        this.scope = scope;
        return this;
    }

    public int getScope() {
        return this.scope;
    }

    public LdapSearch setRequest(String request) {
        this.request = request;
        return this;
    }

    public String getRequest() {
        return this.request;
    }

    public LdapSearch setParameters(String ... parameters) {
        this.parameters = parameters;
        return this;
    }

    public String[] getParameters() {
        return this.parameters;
    }

    public LdapSearch returns(String ... attributes) {
        this.returningAttributes = attributes;
        return this;
    }

    public String[] getReturningAttributes() {
        return this.returningAttributes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingEnumeration<SearchResult> find() throws NamingException {
        NamingEnumeration<SearchResult> result;
        LOG.debug("Search: {}", (Object)this);
        InitialDirContext context = null;
        boolean threw = false;
        try {
            context = this.contextFactory.createBindContext();
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.scope);
            controls.setReturningAttributes(this.returningAttributes);
            result = context.search(this.baseDn, this.request, (Object[])this.parameters, controls);
            threw = true;
        }
        finally {
            ContextHelper.close(context, threw);
        }
        return result;
    }

    public SearchResult findUnique() throws NamingException {
        NamingEnumeration<SearchResult> result = this.find();
        if (LdapSearch.hasMore(result)) {
            SearchResult obj = result.next();
            if (!LdapSearch.hasMore(result)) {
                return obj;
            }
            throw new NamingException("Non unique result for " + this.toString());
        }
        return null;
    }

    private static boolean hasMore(NamingEnumeration<SearchResult> result) throws NamingException {
        try {
            return result.hasMore();
        }
        catch (PartialResultException e) {
            LOG.debug("More result might be forthcoming if the referral is followed", (Object)e);
            return false;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{baseDn=" + this.baseDn + ", scope=" + this.scopeToString() + ", request=" + this.request + ", parameters=" + Arrays.toString(this.parameters) + ", attributes=" + Arrays.toString(this.returningAttributes) + "}";
    }

    private String scopeToString() {
        switch (this.scope) {
            case 1: {
                return "onelevel";
            }
            case 0: {
                return "object";
            }
        }
        return "subtree";
    }
}

