/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.ldap;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.config.Settings;
import org.sonar.api.server.ServerSide;
import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;
import org.sonar.plugins.ldap.LdapAutodiscovery;
import org.sonar.plugins.ldap.LdapContextFactory;
import org.sonar.plugins.ldap.LdapException;
import org.sonar.plugins.ldap.LdapGroupMapping;
import org.sonar.plugins.ldap.LdapUserMapping;

@ServerSide
public class LdapSettingsManager {
    private static final Logger LOG = Loggers.get(LdapSettingsManager.class);
    private static final String LDAP_SERVERS_PROPERTY = "ldap.servers";
    private static final String LDAP_PROPERTY_PREFIX = "ldap";
    private static final String DEFAULT_LDAP_SERVER_KEY = "<default>";
    private final Settings settings;
    private final LdapAutodiscovery ldapAutodiscovery;
    private Map<String, LdapUserMapping> userMappings = null;
    private Map<String, LdapGroupMapping> groupMappings = null;
    private Map<String, LdapContextFactory> contextFactories;

    public LdapSettingsManager(Settings settings, LdapAutodiscovery ldapAutodiscovery) {
        this.settings = settings;
        this.ldapAutodiscovery = ldapAutodiscovery;
    }

    public Map<String, LdapUserMapping> getUserMappings() {
        if (this.userMappings == null) {
            this.userMappings = new LinkedHashMap<String, LdapUserMapping>();
            String[] serverKeys = this.settings.getStringArray(LDAP_SERVERS_PROPERTY);
            if (serverKeys.length > 0) {
                for (String serverKey : serverKeys) {
                    LdapUserMapping userMapping = new LdapUserMapping(this.settings, "ldap." + serverKey);
                    if (StringUtils.isNotBlank((String)userMapping.getBaseDn())) {
                        LOG.info("User mapping for server {}: {}", (Object)serverKey, (Object)userMapping);
                        this.userMappings.put(serverKey, userMapping);
                        continue;
                    }
                    LOG.info("Users will not be synchronized for server {}, because property 'ldap.{}.user.baseDn' is empty.", (Object)serverKey, (Object)serverKey);
                }
            } else {
                LdapUserMapping userMapping = new LdapUserMapping(this.settings, LDAP_PROPERTY_PREFIX);
                if (StringUtils.isNotBlank((String)userMapping.getBaseDn())) {
                    LOG.info("User mapping: {}", (Object)userMapping);
                    this.userMappings.put(DEFAULT_LDAP_SERVER_KEY, userMapping);
                } else {
                    LOG.info("Users will not be synchronized, because property 'ldap.user.baseDn' is empty.");
                }
            }
        }
        return this.userMappings;
    }

    public Map<String, LdapGroupMapping> getGroupMappings() {
        if (this.groupMappings == null) {
            this.groupMappings = new LinkedHashMap<String, LdapGroupMapping>();
            String[] serverKeys = this.settings.getStringArray(LDAP_SERVERS_PROPERTY);
            if (serverKeys.length > 0) {
                for (String serverKey : serverKeys) {
                    LdapGroupMapping groupMapping = new LdapGroupMapping(this.settings, "ldap." + serverKey);
                    if (StringUtils.isNotBlank((String)groupMapping.getBaseDn())) {
                        LOG.info("Group mapping for server {}: {}", (Object)serverKey, (Object)groupMapping);
                        this.groupMappings.put(serverKey, groupMapping);
                        continue;
                    }
                    LOG.info("Groups will not be synchronized for server {}, because property 'ldap.{}.group.baseDn' is empty.", (Object)serverKey, (Object)serverKey);
                }
            } else {
                LdapGroupMapping groupMapping = new LdapGroupMapping(this.settings, LDAP_PROPERTY_PREFIX);
                if (StringUtils.isNotBlank((String)groupMapping.getBaseDn())) {
                    LOG.info("Group mapping: {}", (Object)groupMapping);
                    this.groupMappings.put(DEFAULT_LDAP_SERVER_KEY, groupMapping);
                } else {
                    LOG.info("Groups will not be synchronized, because property 'ldap.group.baseDn' is empty.");
                }
            }
        }
        return this.groupMappings;
    }

    public Map<String, LdapContextFactory> getContextFactories() {
        if (this.contextFactories == null) {
            this.contextFactories = new LinkedHashMap<String, LdapContextFactory>();
            String[] serverKeys = this.settings.getStringArray(LDAP_SERVERS_PROPERTY);
            if (serverKeys.length > 0) {
                this.initMultiLdapConfiguration(serverKeys);
            } else {
                this.initSimpleLdapConfiguration();
            }
        }
        return this.contextFactories;
    }

    private void initSimpleLdapConfiguration() {
        String realm = this.settings.getString("ldap.realm");
        String ldapUrlKey = "ldap.url";
        String ldapUrl = this.settings.getString(ldapUrlKey);
        if (ldapUrl == null && realm != null) {
            LOG.warn("Auto-discovery feature is deprecated, please use '{}' to specify LDAP url", (Object)ldapUrlKey);
            List<LdapAutodiscovery.LdapSrvRecord> ldapServers = this.ldapAutodiscovery.getLdapServers(realm);
            if (ldapServers.isEmpty()) {
                throw new LdapException(String.format("The property '%s' is empty and SonarQube is not able to auto-discover any LDAP server.", ldapUrlKey));
            }
            int index = 1;
            for (LdapAutodiscovery.LdapSrvRecord ldapSrvRecord : ldapServers) {
                if (!StringUtils.isNotBlank((String)ldapSrvRecord.getServerUrl())) continue;
                LOG.info("Detected server: {}", (Object)ldapSrvRecord.getServerUrl());
                LdapContextFactory contextFactory = new LdapContextFactory(this.settings, LDAP_PROPERTY_PREFIX, ldapSrvRecord.getServerUrl());
                this.contextFactories.put(DEFAULT_LDAP_SERVER_KEY + index, contextFactory);
                ++index;
            }
        } else {
            if (StringUtils.isBlank((String)ldapUrl)) {
                throw new LdapException(String.format("The property '%s' is empty and no realm configured to try auto-discovery.", ldapUrlKey));
            }
            LdapContextFactory contextFactory = new LdapContextFactory(this.settings, LDAP_PROPERTY_PREFIX, ldapUrl);
            this.contextFactories.put(DEFAULT_LDAP_SERVER_KEY, contextFactory);
        }
    }

    private void initMultiLdapConfiguration(String[] serverKeys) {
        if (this.settings.hasKey("ldap.url") || this.settings.hasKey("ldap.realm")) {
            throw new LdapException("When defining multiple LDAP servers with the property 'ldap.servers', all LDAP properties must be linked to one of those servers. Please remove properties like 'ldap.url', 'ldap.realm', ...");
        }
        for (String serverKey : serverKeys) {
            String prefix = "ldap." + serverKey;
            String ldapUrlKey = prefix + ".url";
            String ldapUrl = this.settings.getString(ldapUrlKey);
            if (StringUtils.isBlank((String)ldapUrl)) {
                throw new LdapException(String.format("The property '%s' property is empty while it is mandatory.", ldapUrlKey));
            }
            LdapContextFactory contextFactory = new LdapContextFactory(this.settings, prefix, ldapUrl);
            this.contextFactories.put(serverKey, contextFactory);
        }
    }
}

