/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.fs.internal;

import java.util.Locale;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.fs.internal.AbstractFilePredicate;

public class FileExtensionPredicate
extends AbstractFilePredicate {
    private final String extension;

    public FileExtensionPredicate(String extension) {
        this.extension = FileExtensionPredicate.lowercase(extension);
    }

    @Override
    public boolean apply(InputFile inputFile) {
        return this.extension.equals(FileExtensionPredicate.getExtension(inputFile));
    }

    @Override
    public Iterable<InputFile> get(FileSystem.Index index) {
        return index.getFilesByExtension(this.extension);
    }

    public static String getExtension(InputFile inputFile) {
        return FileExtensionPredicate.getExtension(inputFile.filename());
    }

    static String getExtension(String name) {
        int index = name.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return FileExtensionPredicate.lowercase(name.substring(index + 1));
    }

    private static String lowercase(String extension) {
        return extension.toLowerCase(Locale.ENGLISH);
    }
}

