/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.sonar.api.batch.sensor.internal.SensorStorage;

public abstract class DefaultStorable {
    protected final transient SensorStorage storage;
    private transient boolean saved = false;

    public DefaultStorable() {
        this.storage = null;
    }

    public DefaultStorable(@Nullable SensorStorage storage) {
        this.storage = storage;
    }

    public final void save() {
        Objects.requireNonNull(this.storage, "No persister on this object");
        Preconditions.checkState((!this.saved ? 1 : 0) != 0, (Object)"This object was already saved");
        this.doSave();
        this.saved = true;
    }

    protected abstract void doSave();

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

