/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.batch.sensor.rule.internal;

import com.google.common.base.Preconditions;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.rule.Severity;
import org.sonar.api.batch.sensor.internal.DefaultStorable;
import org.sonar.api.batch.sensor.internal.SensorStorage;
import org.sonar.api.batch.sensor.rule.AdHocRule;
import org.sonar.api.batch.sensor.rule.NewAdHocRule;
import org.sonar.api.rules.RuleType;

public class DefaultAdHocRule
extends DefaultStorable
implements AdHocRule,
NewAdHocRule {
    private Severity severity;
    private RuleType type;
    private String name;
    private String description;
    private String engineId;
    private String ruleId;

    public DefaultAdHocRule() {
        super(null);
    }

    public DefaultAdHocRule(@Nullable SensorStorage storage) {
        super(storage);
    }

    @Override
    public DefaultAdHocRule severity(Severity severity) {
        this.severity = severity;
        return this;
    }

    @Override
    public String engineId() {
        return this.engineId;
    }

    @Override
    public String ruleId() {
        return this.ruleId;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    @CheckForNull
    public String description() {
        return this.description;
    }

    @Override
    public Severity severity() {
        return this.severity;
    }

    @Override
    public void doSave() {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.engineId), (Object)"Engine id is mandatory on ad hoc rule");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.ruleId), (Object)"Rule id is mandatory on ad hoc rule");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.name), (Object)"Name is mandatory on every ad hoc rule");
        Preconditions.checkState((this.severity != null ? 1 : 0) != 0, (Object)"Severity is mandatory on every ad hoc rule");
        Preconditions.checkState((this.type != null ? 1 : 0) != 0, (Object)"Type is mandatory on every ad hoc rule");
        this.storage.store(this);
    }

    @Override
    public RuleType type() {
        return this.type;
    }

    @Override
    public DefaultAdHocRule engineId(String engineId) {
        this.engineId = engineId;
        return this;
    }

    @Override
    public DefaultAdHocRule ruleId(String ruleId) {
        this.ruleId = ruleId;
        return this;
    }

    @Override
    public DefaultAdHocRule name(String name) {
        this.name = name;
        return this;
    }

    @Override
    public DefaultAdHocRule description(@Nullable String description) {
        this.description = description;
        return this;
    }

    @Override
    public DefaultAdHocRule type(RuleType type) {
        this.type = type;
        return this;
    }
}

