/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.ce.measure.test;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.sonar.api.ce.measure.Component;
import org.sonar.api.ce.measure.Issue;
import org.sonar.api.ce.measure.Measure;
import org.sonar.api.ce.measure.MeasureComputer;
import org.sonar.api.ce.measure.Settings;
import org.sonar.api.ce.measure.test.TestMeasure;

public class TestMeasureComputerContext
implements MeasureComputer.MeasureComputerContext {
    private final Component component;
    private final MeasureComputer.MeasureComputerDefinition definition;
    private final Settings settings;
    private Map<String, Measure> componentMeasureByMetricKey = new HashMap<String, Measure>();
    private Multimap<String, Measure> childrenComponentMeasureByMetricKey = ArrayListMultimap.create();
    private List<Issue> issues = new ArrayList<Issue>();

    public TestMeasureComputerContext(Component component, Settings settings, MeasureComputer.MeasureComputerDefinition definition) {
        this.settings = settings;
        this.component = component;
        this.definition = definition;
    }

    @Override
    public Component getComponent() {
        return this.component;
    }

    @Override
    public Settings getSettings() {
        return this.settings;
    }

    @Override
    @CheckForNull
    public Measure getMeasure(String metric) {
        this.validateInputMetric(metric);
        return this.componentMeasureByMetricKey.get(metric);
    }

    @Override
    public Iterable<Measure> getChildrenMeasures(String metric) {
        this.validateInputMetric(metric);
        return this.childrenComponentMeasureByMetricKey.get((Object)metric);
    }

    @Override
    public void addMeasure(String metricKey, int value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, int value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, Integer ... values) {
        for (Integer value : values) {
            this.childrenComponentMeasureByMetricKey.put((Object)metricKey, (Object)TestMeasure.createMeasure(value));
        }
    }

    @Override
    public void addMeasure(String metricKey, double value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, double value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, Double ... values) {
        for (Double value : values) {
            this.childrenComponentMeasureByMetricKey.put((Object)metricKey, (Object)TestMeasure.createMeasure(value));
        }
    }

    @Override
    public void addMeasure(String metricKey, long value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, long value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, Long ... values) {
        for (Long value : values) {
            this.childrenComponentMeasureByMetricKey.put((Object)metricKey, (Object)TestMeasure.createMeasure(value));
        }
    }

    @Override
    public void addMeasure(String metricKey, String value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    @Override
    public void addMeasure(String metricKey, boolean value) {
        this.validateAddMeasure(metricKey);
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, boolean value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addInputMeasure(String metricKey, String value) {
        this.componentMeasureByMetricKey.put(metricKey, TestMeasure.createMeasure(value));
    }

    public void addChildrenMeasures(String metricKey, String ... values) {
        for (String value : values) {
            this.childrenComponentMeasureByMetricKey.put((Object)metricKey, (Object)TestMeasure.createMeasure(value));
        }
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public void setIssues(List<Issue> issues) {
        this.issues = issues;
    }

    private void validateInputMetric(String metric) {
        HashSet<String> allowedMetrics = new HashSet<String>();
        allowedMetrics.addAll(this.definition.getInputMetrics());
        allowedMetrics.addAll(this.definition.getOutputMetrics());
        Preconditions.checkArgument((boolean)allowedMetrics.contains(metric), (String)"Only metrics in %s can be used to load measures", (Object[])new Object[]{this.definition.getInputMetrics()});
    }

    private void validateAddMeasure(String metricKey) {
        Preconditions.checkArgument((boolean)this.definition.getOutputMetrics().contains(metricKey), (String)"Only metrics in %s can be used to add measures. Metric '%s' is not allowed.", (Object[])new Object[]{this.definition.getOutputMetrics(), metricKey});
        if (this.componentMeasureByMetricKey.get(metricKey) != null) {
            throw new UnsupportedOperationException(String.format("A measure on metric '%s' already exists", metricKey));
        }
    }
}

