/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.internal;

import com.google.common.base.Preconditions;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.sonar.api.SonarEdition;
import org.sonar.api.SonarProduct;
import org.sonar.api.SonarQubeSide;
import org.sonar.api.SonarRuntime;
import org.sonar.api.utils.Version;

@Immutable
public class SonarRuntimeImpl
implements SonarRuntime {
    private final Version version;
    private final SonarProduct product;
    private final SonarQubeSide sonarQubeSide;
    private final SonarEdition edition;

    private SonarRuntimeImpl(Version version, SonarProduct product, @Nullable SonarQubeSide sonarQubeSide, @Nullable SonarEdition edition) {
        this.edition = edition;
        Objects.requireNonNull(product);
        Preconditions.checkArgument((product == SonarProduct.SONARQUBE == (sonarQubeSide != null) ? 1 : 0) != 0, (Object)"sonarQubeSide should be provided only for SonarQube product");
        Preconditions.checkArgument((product == SonarProduct.SONARQUBE == (edition != null) ? 1 : 0) != 0, (Object)"edition should be provided only for SonarQube product");
        this.version = Objects.requireNonNull(version);
        this.product = product;
        this.sonarQubeSide = sonarQubeSide;
    }

    @Override
    public Version getApiVersion() {
        return this.version;
    }

    @Override
    public SonarProduct getProduct() {
        return this.product;
    }

    @Override
    public SonarQubeSide getSonarQubeSide() {
        if (this.sonarQubeSide == null) {
            throw new UnsupportedOperationException("Can only be called in SonarQube");
        }
        return this.sonarQubeSide;
    }

    @Override
    public SonarEdition getEdition() {
        if (this.sonarQubeSide == null) {
            throw new UnsupportedOperationException("Can only be called in SonarQube");
        }
        return this.edition;
    }

    public static SonarRuntime forSonarQube(Version version, SonarQubeSide side, SonarEdition edition) {
        return new SonarRuntimeImpl(version, SonarProduct.SONARQUBE, side, edition);
    }

    public static SonarRuntime forSonarLint(Version version) {
        return new SonarRuntimeImpl(version, SonarProduct.SONARLINT, null, null);
    }
}

