/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.resources;

import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.sonar.api.ce.ComputeEngineSide;
import org.sonar.api.resources.ResourceType;
import org.sonar.api.resources.ResourceTypeTree;
import org.sonar.api.server.ServerSide;

@ServerSide
@ComputeEngineSide
@Beta
public class ResourceTypes {
    private final Map<String, ResourceTypeTree> treeByQualifier;
    private final Map<String, ResourceType> typeByQualifier;
    private final Collection<ResourceType> rootTypes;

    public ResourceTypes(ResourceTypeTree[] trees) {
        Objects.requireNonNull(trees);
        LinkedHashMap<String, ResourceTypeTree> treeMap = new LinkedHashMap<String, ResourceTypeTree>();
        LinkedHashMap<String, ResourceType> typeMap = new LinkedHashMap<String, ResourceType>();
        LinkedHashSet<ResourceType> rootsSet = new LinkedHashSet<ResourceType>();
        for (ResourceTypeTree tree : trees) {
            rootsSet.add(tree.getRootType());
            for (ResourceType type : tree.getTypes()) {
                if (treeMap.containsKey(type.getQualifier())) {
                    throw new IllegalStateException("Qualifier " + type.getQualifier() + " is defined in several trees");
                }
                treeMap.put(type.getQualifier(), tree);
                typeMap.put(type.getQualifier(), type);
            }
        }
        this.treeByQualifier = Collections.unmodifiableMap(new LinkedHashMap(treeMap));
        this.typeByQualifier = Collections.unmodifiableMap(new LinkedHashMap(typeMap));
        this.rootTypes = Collections.unmodifiableList(new ArrayList(rootsSet));
    }

    public ResourceType get(String qualifier) {
        ResourceType type = this.typeByQualifier.get(qualifier);
        return type != null ? type : ResourceType.builder(qualifier).build();
    }

    public Collection<ResourceType> getAll() {
        return this.typeByQualifier.values();
    }

    public Collection<ResourceType> getRoots() {
        return this.rootTypes;
    }

    public boolean isQualifierPresent(String qualifier) {
        return this.typeByQualifier.get(qualifier) != null;
    }

    public List<String> getLeavesQualifiers(String qualifier) {
        ResourceTypeTree tree = this.getTree(qualifier);
        if (tree != null) {
            return tree.getLeaves();
        }
        return Collections.emptyList();
    }

    private ResourceTypeTree getTree(String qualifier) {
        return this.treeByQualifier.get(qualifier);
    }
}

