/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.server.rule;

import org.apache.commons.lang.StringUtils;
import org.sonar.api.i18n.RuleI18n;
import org.sonar.api.server.rule.RulesDefinition;

public class RulesDefinitionI18nLoader {
    private final RuleI18n i18n;

    public RulesDefinitionI18nLoader(RuleI18n i18n) {
        this.i18n = i18n;
    }

    public void load(RulesDefinition.NewRepository repo) {
        for (RulesDefinition.NewRule rule : repo.rules()) {
            String desc;
            String name = this.i18n.getName(repo.key(), rule.key());
            if (StringUtils.isNotBlank((String)name)) {
                rule.setName(name);
            }
            if (StringUtils.isNotBlank((String)(desc = this.i18n.getDescription(repo.key(), rule.key())))) {
                rule.setHtmlDescription(desc);
            }
            for (RulesDefinition.NewParam param : rule.params()) {
                String paramDesc = this.i18n.getParamDescription(repo.key(), rule.key(), param.key());
                if (!StringUtils.isNotBlank((String)paramDesc)) continue;
                param.setDescription(paramDesc);
            }
        }
    }
}

