/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.api.utils;

import com.google.common.base.Splitter;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang.StringUtils;

@Immutable
public class Version
implements Comparable<Version> {
    private static final long DEFAULT_BUILD_NUMBER = 0L;
    private static final int DEFAULT_PATCH = 0;
    private static final String DEFAULT_QUALIFIER = "";
    private static final String QUALIFIER_SEPARATOR = "-";
    private static final char SEQUENCE_SEPARATOR = '.';
    private static final Splitter SEQUENCE_SPLITTER = Splitter.on((char)'.');
    private final int major;
    private final int minor;
    private final int patch;
    private final long buildNumber;
    private final String qualifier;

    private Version(int major, int minor, int patch, long buildNumber, String qualifier) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.buildNumber = buildNumber;
        this.qualifier = Objects.requireNonNull(qualifier, "Version qualifier must not be null");
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public long buildNumber() {
        return this.buildNumber;
    }

    public String qualifier() {
        return this.qualifier;
    }

    public static Version parse(String text) {
        String s = StringUtils.trimToEmpty((String)text);
        String qualifier = StringUtils.substringAfter((String)s, (String)QUALIFIER_SEPARATOR);
        if (!qualifier.isEmpty()) {
            s = StringUtils.substringBefore((String)s, (String)QUALIFIER_SEPARATOR);
        }
        List fields = SEQUENCE_SPLITTER.splitToList((CharSequence)s);
        int major = 0;
        int minor = 0;
        int patch = 0;
        long buildNumber = 0L;
        int size = fields.size();
        if (size > 0) {
            major = Version.parseFieldAsInt((String)fields.get(0));
            if (size > 1) {
                minor = Version.parseFieldAsInt((String)fields.get(1));
                if (size > 2) {
                    patch = Version.parseFieldAsInt((String)fields.get(2));
                    if (size > 3) {
                        buildNumber = Version.parseFieldAsLong((String)fields.get(3));
                        if (size > 4) {
                            throw new IllegalArgumentException("Maximum 4 fields are accepted: " + text);
                        }
                    }
                }
            }
        }
        return new Version(major, minor, patch, buildNumber, qualifier);
    }

    public static Version create(int major, int minor) {
        return new Version(major, minor, 0, 0L, DEFAULT_QUALIFIER);
    }

    public static Version create(int major, int minor, int patch) {
        return new Version(major, minor, patch, 0L, DEFAULT_QUALIFIER);
    }

    @Deprecated
    public static Version create(int major, int minor, int patch, String qualifier) {
        return new Version(major, minor, patch, 0L, qualifier);
    }

    private static int parseFieldAsInt(String field) {
        if (field.isEmpty()) {
            return 0;
        }
        return Integer.parseInt(field);
    }

    private static long parseFieldAsLong(String field) {
        if (field.isEmpty()) {
            return 0L;
        }
        return Long.parseLong(field);
    }

    public boolean isGreaterThanOrEqual(Version than) {
        return this.compareTo(than) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        if (this.major != version.major) {
            return false;
        }
        if (this.minor != version.minor) {
            return false;
        }
        if (this.patch != version.patch) {
            return false;
        }
        return this.buildNumber == version.buildNumber;
    }

    public int hashCode() {
        int result = this.major;
        result = 31 * result + this.minor;
        result = 31 * result + this.patch;
        result = 31 * result + (int)(this.buildNumber ^ this.buildNumber >>> 32);
        return result;
    }

    @Override
    public int compareTo(Version other) {
        int c = this.major - other.major;
        if (c == 0 && (c = this.minor - other.minor) == 0 && (c = this.patch - other.patch) == 0) {
            long diff = this.buildNumber - other.buildNumber;
            c = diff > 0L ? 1 : (diff < 0L ? -1 : 0);
        }
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.major).append('.').append(this.minor);
        if (this.patch > 0 || this.buildNumber > 0L) {
            sb.append('.').append(this.patch);
            if (this.buildNumber > 0L) {
                sb.append('.').append(this.buildNumber);
            }
        }
        if (!this.qualifier.isEmpty()) {
            sb.append(QUALIFIER_SEPARATOR).append(this.qualifier);
        }
        return sb.toString();
    }
}

