// Copyright 2020 The TensorFlow Runtime Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Program adapted from //tensorflow/compiler/xla/service/gpu/tests:mnist.
// It is not intended as an apple-to-apple benchmark though.

// RUN: bef_executor_lite %s.bef | FileCheck %s

// CHECK: 'main' returned !tfrt.chain value
func.func @main() -> !tfrt.chain {
  %ordinal = tfrt.constant.i32 0
  %device = tfrt_gpu.device.get CUDA, %ordinal
  %context = tfrt_gpu.context.create %device
  %allocator = tfrt_gpu.allocator.create %context
  %stream = tfrt_gpu.stream.create %context
  %ch0 = tfrt.new.chain

  %size0 = tfrt.constant.i64 78400
  %size1 = tfrt.constant.i64 100
  %size2 = tfrt.constant.i64 31360
  %size3 = tfrt.constant.i64 40
  %size4 = tfrt.constant.i64 4
  %size5 = tfrt.constant.i64 8
  %size6 = tfrt.constant.i64 4
  %size7 = tfrt.constant.i64 4
  %size8 = tfrt.constant.i64 31360
  %size9 = tfrt.constant.i64 31360
  %sizeA = tfrt.constant.i64 40
  %sizeB = tfrt.constant.i64 40
  %sizeC = tfrt.constant.i64 4
  %sizeD = tfrt.constant.i64 349272

  %buf0 = tfrt_gpu.mem.allocate %allocator, %stream, %size0, %ch0
  %buf1 = tfrt_gpu.mem.allocate %allocator, %stream, %size1, %ch0
  %buf2 = tfrt_gpu.mem.allocate %allocator, %stream, %size2, %ch0
  %buf3 = tfrt_gpu.mem.allocate %allocator, %stream, %size3, %ch0
  %buf4 = tfrt_gpu.mem.allocate %allocator, %stream, %size4, %ch0
  %buf5 = tfrt_gpu.mem.allocate %allocator, %stream, %size5, %ch0
  %buf6 = tfrt_gpu.mem.allocate %allocator, %stream, %size6, %ch0
  %buf7 = tfrt_gpu.mem.allocate %allocator, %stream, %size7, %ch0
  %buf8 = tfrt_gpu.mem.allocate %allocator, %stream, %size8, %ch0
  %buf9 = tfrt_gpu.mem.allocate %allocator, %stream, %size9, %ch0
  %bufA = tfrt_gpu.mem.allocate %allocator, %stream, %sizeA, %ch0
  %bufB = tfrt_gpu.mem.allocate %allocator, %stream, %sizeB, %ch0
  %bufC = tfrt_gpu.mem.allocate %allocator, %stream, %sizeC, %ch0
  %bufD = tfrt_gpu.mem.allocate %allocator, %stream, %sizeD, %ch0

  %value = tfrt.constant.i32 0x3f803f80
  %ch1 = tfrt_gpu.mem.set %buf0, %value, %stream, %ch0 : i32
  %ch2 = tfrt_gpu.mem.set %buf1, %value, %stream, %ch1 : i32
  %ch3 = tfrt_gpu.mem.set %buf2, %value, %stream, %ch2 : i32
  %ch4 = tfrt_gpu.mem.set %buf3, %value, %stream, %ch3 : i32
  %ch5 = tfrt_gpu.mem.set %buf4, %value, %stream, %ch4 : i32
  %ch6 = tfrt_gpu.mem.set %buf5, %value, %stream, %ch5 : i32
  %ch7 = tfrt_gpu.mem.set %buf6, %value, %stream, %ch6 : i32
  %ch8 = tfrt_gpu.mem.set %buf7, %value, %stream, %ch7 : i32
  %ch9 = tfrt_gpu.mem.set %buf8, %value, %stream, %ch8 : i32
  %chA = tfrt_gpu.mem.set %buf9, %value, %stream, %ch9 : i32
  %chB = tfrt_gpu.mem.set %bufA, %value, %stream, %chA : i32
  %chC = tfrt_gpu.mem.set %bufB, %value, %stream, %chB : i32
  %chD = tfrt_gpu.mem.set %bufC, %value, %stream, %chC : i32
  %chE = tfrt_gpu.mem.set %bufD, %value, %stream, %chD : i32

  %count = tfrt.constant.i32 20
  %result:16 = tfrt.repeat.i32 %count,
      %chE, %stream, %buf0, %buf1, %buf2, %buf3, %buf4, %buf5,
      %buf6, %buf7, %buf8, %buf9, %bufA, %bufB, %bufC, %bufD
    : !tfrt.chain, !tfrt_gpu.stream, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
      !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
      !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
      !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer
  {
    %chF = tfrt.call @a_inference_train_mnist_213(
      %chE, %stream, %buf0, %buf1, %buf2, %buf3, %buf4, %buf5,
      %buf6, %buf7, %buf8, %buf9, %bufA, %bufB, %bufC, %bufD
    ) : (
      !tfrt.chain, !tfrt_gpu.stream, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
      !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
      !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
      !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer
    ) -> (!tfrt.chain)

    tfrt.return
        %chF, %stream, %buf0, %buf1, %buf2, %buf3, %buf4, %buf5,
        %buf6, %buf7, %buf8, %buf9, %bufA, %bufB, %bufC, %bufD
      : !tfrt.chain, !tfrt_gpu.stream, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
        !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
        !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer,
        !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer
  }

  tfrt.return %result#0 : !tfrt.chain
}

func.func @buffer_for_constant_66(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.buffer {
  %0 = tfrt.once @gpu_module_1(%arg0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %1 = tfrt_gpu.module.get_global %0 {name = "buffer_for_constant_66"}
  tfrt.return %1 : !tfrt_gpu.buffer
}
func.func @gpu_module(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09fusion_9_a_inference_train_mnist_213_199\0A\0A.visible .entry fusion_9_a_inference_train_mnist_213_199(\0A\09.param .u64 fusion_9_a_inference_train_mnist_213_199_param_0,\0A\09.param .u64 fusion_9_a_inference_train_mnist_213_199_param_1\0A)\0A.reqntid 256, 1, 1\0A{\0A\09.reg .pred \09%p<2>;\0A\09.reg .b16 \09%rs<5>;\0A\09.reg .b32 \09%r<6>;\0A\09.reg .f32 \09%f<5>;\0A\09.reg .b64 \09%rd<9>;\0A\0A\09mov.u32 \09%r2, %ctaid.x;\0A\09mov.u32 \09%r3, %tid.x;\0A\09shl.b32 \09%r4, %r2, 10;\0A\09shl.b32 \09%r5, %r3, 2;\0A\09or.b32  \09%r1, %r4, %r5;\0A\09setp.lt.u32 \09%p1, %r1, 78400;\0A\09@%p1 bra \09LBB0_2;\0A\09bra.uni \09LBB0_1;\0ALBB0_2:\0A\09ld.param.u64 \09%rd3, [fusion_9_a_inference_train_mnist_213_199_param_0];\0A\09ld.param.u64 \09%rd4, [fusion_9_a_inference_train_mnist_213_199_param_1];\0A\09cvta.to.global.u64 \09%rd1, %rd4;\0A\09cvta.to.global.u64 \09%rd2, %rd3;\0A\09cvt.u64.u32 \09%rd5, %r1;\0A\09add.s64 \09%rd6, %rd2, %rd5;\0A\09ld.global.nc.v4.u8 \09{%rs1, %rs2, %rs3, %rs4}, [%rd6];\0A\09cvt.rn.f32.u16 \09%f1, %rs1;\0A\09mul.wide.u32 \09%rd7, %r1, 4;\0A\09add.s64 \09%rd8, %rd1, %rd7;\0A\09cvt.rn.f32.u16 \09%f2, %rs2;\0A\09cvt.rn.f32.u16 \09%f3, %rs3;\0A\09cvt.rn.f32.u16 \09%f4, %rs4;\0A\09st.global.v4.f32 \09[%rd8], {%f1, %f2, %f3, %f4};\0ALBB0_1:\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @gpu_module_0(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09broadcast_41_a_inference_train_mnist_213_199\0A\0A.visible .entry broadcast_41_a_inference_train_mnist_213_199(\0A\09.param .u64 broadcast_41_a_inference_train_mnist_213_199_param_0,\0A\09.param .u64 broadcast_41_a_inference_train_mnist_213_199_param_1\0A)\0A.reqntid 250, 1, 1\0A{\0A\09.reg .b16 \09%rs<6>;\0A\09.reg .b32 \09%r<19>;\0A\09.reg .f32 \09%f<5>;\0A\09.reg .b64 \09%rd<15>;\0A\0A\09ld.param.u64 \09%rd1, [broadcast_41_a_inference_train_mnist_213_199_param_0];\0A\09ld.param.u64 \09%rd2, [broadcast_41_a_inference_train_mnist_213_199_param_1];\0A\09cvta.to.global.u64 \09%rd3, %rd2;\0A\09cvta.to.global.u64 \09%rd4, %rd1;\0A\09mov.u32 \09%r1, %tid.x;\0A\09shl.b32 \09%r2, %r1, 2;\0A\09or.b32  \09%r3, %r2, 1;\0A\09or.b32  \09%r4, %r2, 2;\0A\09or.b32  \09%r5, %r2, 3;\0A\09mul.hi.u32 \09%r6, %r5, -858993459;\0A\09shr.u32 \09%r7, %r6, 3;\0A\09mul.lo.s32 \09%r8, %r7, 10;\0A\09sub.s32 \09%r9, %r5, %r8;\0A\09mul.hi.u32 \09%r10, %r4, -858993459;\0A\09shr.u32 \09%r11, %r10, 3;\0A\09mul.lo.s32 \09%r12, %r11, 10;\0A\09sub.s32 \09%r13, %r4, %r12;\0A\09mul.hi.u32 \09%r14, %r3, -858993459;\0A\09shr.u32 \09%r15, %r14, 3;\0A\09mul.lo.s32 \09%r16, %r15, 10;\0A\09sub.s32 \09%r17, %r3, %r16;\0A\09cvt.u16.u32 \09%rs1, %r2;\0A\09mul.hi.u16 \09%rs2, %rs1, -13107;\0A\09shr.u16 \09%rs3, %rs2, 3;\0A\09mul.lo.s16 \09%rs4, %rs3, 10;\0A\09sub.s16 \09%rs5, %rs1, %rs4;\0A\09cvt.u32.u16 \09%r18, %rs5;\0A\09mul.wide.u32 \09%rd5, %r18, 4;\0A\09add.s64 \09%rd6, %rd4, %rd5;\0A\09ld.global.nc.f32 \09%f1, [%rd6];\0A\09mul.wide.u32 \09%rd7, %r2, 4;\0A\09add.s64 \09%rd8, %rd3, %rd7;\0A\09mul.wide.u32 \09%rd9, %r17, 4;\0A\09add.s64 \09%rd10, %rd4, %rd9;\0A\09ld.global.nc.f32 \09%f2, [%rd10];\0A\09mul.wide.u32 \09%rd11, %r13, 4;\0A\09add.s64 \09%rd12, %rd4, %rd11;\0A\09ld.global.nc.f32 \09%f3, [%rd12];\0A\09mul.wide.u32 \09%rd13, %r9, 4;\0A\09add.s64 \09%rd14, %rd4, %rd13;\0A\09ld.global.nc.f32 \09%f4, [%rd14];\0A\09st.global.v4.f32 \09[%rd8], {%f1, %f2, %f3, %f4};\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @gpu_module_1(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09reduce_71_a_inference_train_mnist_213_199\0A.visible .global .align 128 .b8 buffer_for_constant_66[4] = {0, 0, 128, 255};\0A\0A.visible .entry reduce_71_a_inference_train_mnist_213_199(\0A\09.param .u64 reduce_71_a_inference_train_mnist_213_199_param_0,\0A\09.param .u64 reduce_71_a_inference_train_mnist_213_199_param_1\0A)\0A.reqntid 25, 1, 1\0A{\0A\09.reg .pred \09%p<77>;\0A\09.reg .b32 \09%r<3>;\0A\09.reg .f32 \09%f<117>;\0A\09.reg .b64 \09%rd<9>;\0A\0A\09ld.param.u64 \09%rd1, [reduce_71_a_inference_train_mnist_213_199_param_0];\0A\09ld.param.u64 \09%rd2, [reduce_71_a_inference_train_mnist_213_199_param_1];\0A\09cvta.to.global.u64 \09%rd3, %rd2;\0A\09cvta.to.global.u64 \09%rd4, %rd1;\0A\09mov.u32 \09%r1, %tid.x;\0A\09shl.b32 \09%r2, %r1, 2;\0A\09mul.wide.u32 \09%rd5, %r2, 40;\0A\09add.s64 \09%rd6, %rd4, %rd5;\0A\09ld.global.nc.v4.f32 \09{%f1, %f2, %f3, %f4}, [%rd6];\0A\09setp.le.f32 \09%p1, %f1, 0fFF800000;\0A\09selp.f32 \09%f5, 0fFF800000, %f1, %p1;\0A\09setp.ge.f32 \09%p2, %f5, %f2;\0A\09setp.nan.f32 \09%p3, %f5, %f5;\0A\09selp.f32 \09%f6, %f5, %f2, %p2;\0A\09selp.f32 \09%f7, %f5, %f6, %p3;\0A\09setp.ge.f32 \09%p4, %f7, %f3;\0A\09setp.nan.f32 \09%p5, %f7, %f7;\0A\09selp.f32 \09%f8, %f7, %f3, %p4;\0A\09selp.f32 \09%f9, %f7, %f8, %p5;\0A\09setp.ge.f32 \09%p6, %f9, %f4;\0A\09setp.nan.f32 \09%p7, %f9, %f9;\0A\09selp.f32 \09%f10, %f9, %f4, %p6;\0A\09selp.f32 \09%f11, %f9, %f10, %p7;\0A\09ld.global.nc.v4.f32 \09{%f12, %f13, %f14, %f15}, [%rd6+16];\0A\09setp.ge.f32 \09%p8, %f11, %f12;\0A\09setp.nan.f32 \09%p9, %f11, %f11;\0A\09selp.f32 \09%f16, %f11, %f12, %p8;\0A\09selp.f32 \09%f17, %f11, %f16, %p9;\0A\09setp.ge.f32 \09%p10, %f17, %f13;\0A\09setp.nan.f32 \09%p11, %f17, %f17;\0A\09selp.f32 \09%f18, %f17, %f13, %p10;\0A\09selp.f32 \09%f19, %f17, %f18, %p11;\0A\09setp.ge.f32 \09%p12, %f19, %f14;\0A\09setp.nan.f32 \09%p13, %f19, %f19;\0A\09selp.f32 \09%f20, %f19, %f14, %p12;\0A\09selp.f32 \09%f21, %f19, %f20, %p13;\0A\09setp.ge.f32 \09%p14, %f21, %f15;\0A\09setp.nan.f32 \09%p15, %f21, %f21;\0A\09selp.f32 \09%f22, %f21, %f15, %p14;\0A\09selp.f32 \09%f23, %f21, %f22, %p15;\0A\09ld.global.nc.v4.f32 \09{%f24, %f25, %f26, %f27}, [%rd6+32];\0A\09setp.ge.f32 \09%p16, %f23, %f24;\0A\09setp.nan.f32 \09%p17, %f23, %f23;\0A\09selp.f32 \09%f28, %f23, %f24, %p16;\0A\09selp.f32 \09%f29, %f23, %f28, %p17;\0A\09setp.ge.f32 \09%p18, %f29, %f25;\0A\09setp.nan.f32 \09%p19, %f29, %f29;\0A\09selp.f32 \09%f30, %f29, %f25, %p18;\0A\09selp.f32 \09%f31, %f29, %f30, %p19;\0A\09mul.wide.u32 \09%rd7, %r2, 4;\0A\09add.s64 \09%rd8, %rd3, %rd7;\0A\09setp.le.f32 \09%p20, %f26, 0fFF800000;\0A\09selp.f32 \09%f32, 0fFF800000, %f26, %p20;\0A\09setp.ge.f32 \09%p21, %f32, %f27;\0A\09setp.nan.f32 \09%p22, %f32, %f32;\0A\09selp.f32 \09%f33, %f32, %f27, %p21;\0A\09selp.f32 \09%f34, %f32, %f33, %p22;\0A\09ld.global.nc.v4.f32 \09{%f35, %f36, %f37, %f38}, [%rd6+48];\0A\09setp.ge.f32 \09%p23, %f34, %f35;\0A\09setp.nan.f32 \09%p24, %f34, %f34;\0A\09selp.f32 \09%f39, %f34, %f35, %p23;\0A\09selp.f32 \09%f40, %f34, %f39, %p24;\0A\09setp.ge.f32 \09%p25, %f40, %f36;\0A\09setp.nan.f32 \09%p26, %f40, %f40;\0A\09selp.f32 \09%f41, %f40, %f36, %p25;\0A\09selp.f32 \09%f42, %f40, %f41, %p26;\0A\09setp.ge.f32 \09%p27, %f42, %f37;\0A\09setp.nan.f32 \09%p28, %f42, %f42;\0A\09selp.f32 \09%f43, %f42, %f37, %p27;\0A\09selp.f32 \09%f44, %f42, %f43, %p28;\0A\09setp.ge.f32 \09%p29, %f44, %f38;\0A\09setp.nan.f32 \09%p30, %f44, %f44;\0A\09selp.f32 \09%f45, %f44, %f38, %p29;\0A\09selp.f32 \09%f46, %f44, %f45, %p30;\0A\09ld.global.nc.v4.f32 \09{%f47, %f48, %f49, %f50}, [%rd6+64];\0A\09setp.ge.f32 \09%p31, %f46, %f47;\0A\09setp.nan.f32 \09%p32, %f46, %f46;\0A\09selp.f32 \09%f51, %f46, %f47, %p31;\0A\09selp.f32 \09%f52, %f46, %f51, %p32;\0A\09setp.ge.f32 \09%p33, %f52, %f48;\0A\09setp.nan.f32 \09%p34, %f52, %f52;\0A\09selp.f32 \09%f53, %f52, %f48, %p33;\0A\09selp.f32 \09%f54, %f52, %f53, %p34;\0A\09setp.ge.f32 \09%p35, %f54, %f49;\0A\09setp.nan.f32 \09%p36, %f54, %f54;\0A\09selp.f32 \09%f55, %f54, %f49, %p35;\0A\09selp.f32 \09%f56, %f54, %f55, %p36;\0A\09setp.ge.f32 \09%p37, %f56, %f50;\0A\09setp.nan.f32 \09%p38, %f56, %f56;\0A\09selp.f32 \09%f57, %f56, %f50, %p37;\0A\09selp.f32 \09%f58, %f56, %f57, %p38;\0A\09ld.global.nc.v4.f32 \09{%f59, %f60, %f61, %f62}, [%rd6+80];\0A\09setp.le.f32 \09%p39, %f59, 0fFF800000;\0A\09selp.f32 \09%f63, 0fFF800000, %f59, %p39;\0A\09setp.ge.f32 \09%p40, %f63, %f60;\0A\09setp.nan.f32 \09%p41, %f63, %f63;\0A\09selp.f32 \09%f64, %f63, %f60, %p40;\0A\09selp.f32 \09%f65, %f63, %f64, %p41;\0A\09setp.ge.f32 \09%p42, %f65, %f61;\0A\09setp.nan.f32 \09%p43, %f65, %f65;\0A\09selp.f32 \09%f66, %f65, %f61, %p42;\0A\09selp.f32 \09%f67, %f65, %f66, %p43;\0A\09setp.ge.f32 \09%p44, %f67, %f62;\0A\09setp.nan.f32 \09%p45, %f67, %f67;\0A\09selp.f32 \09%f68, %f67, %f62, %p44;\0A\09selp.f32 \09%f69, %f67, %f68, %p45;\0A\09ld.global.nc.v4.f32 \09{%f70, %f71, %f72, %f73}, [%rd6+96];\0A\09setp.ge.f32 \09%p46, %f69, %f70;\0A\09setp.nan.f32 \09%p47, %f69, %f69;\0A\09selp.f32 \09%f74, %f69, %f70, %p46;\0A\09selp.f32 \09%f75, %f69, %f74, %p47;\0A\09setp.ge.f32 \09%p48, %f75, %f71;\0A\09setp.nan.f32 \09%p49, %f75, %f75;\0A\09selp.f32 \09%f76, %f75, %f71, %p48;\0A\09selp.f32 \09%f77, %f75, %f76, %p49;\0A\09setp.ge.f32 \09%p50, %f77, %f72;\0A\09setp.nan.f32 \09%p51, %f77, %f77;\0A\09selp.f32 \09%f78, %f77, %f72, %p50;\0A\09selp.f32 \09%f79, %f77, %f78, %p51;\0A\09setp.ge.f32 \09%p52, %f79, %f73;\0A\09setp.nan.f32 \09%p53, %f79, %f79;\0A\09selp.f32 \09%f80, %f79, %f73, %p52;\0A\09selp.f32 \09%f81, %f79, %f80, %p53;\0A\09ld.global.nc.v4.f32 \09{%f82, %f83, %f84, %f85}, [%rd6+112];\0A\09setp.ge.f32 \09%p54, %f81, %f82;\0A\09setp.nan.f32 \09%p55, %f81, %f81;\0A\09selp.f32 \09%f86, %f81, %f82, %p54;\0A\09selp.f32 \09%f87, %f81, %f86, %p55;\0A\09setp.ge.f32 \09%p56, %f87, %f83;\0A\09setp.nan.f32 \09%p57, %f87, %f87;\0A\09selp.f32 \09%f88, %f87, %f83, %p56;\0A\09selp.f32 \09%f89, %f87, %f88, %p57;\0A\09setp.le.f32 \09%p58, %f84, 0fFF800000;\0A\09selp.f32 \09%f90, 0fFF800000, %f84, %p58;\0A\09setp.ge.f32 \09%p59, %f90, %f85;\0A\09setp.nan.f32 \09%p60, %f90, %f90;\0A\09selp.f32 \09%f91, %f90, %f85, %p59;\0A\09selp.f32 \09%f92, %f90, %f91, %p60;\0A\09ld.global.nc.v4.f32 \09{%f93, %f94, %f95, %f96}, [%rd6+128];\0A\09setp.ge.f32 \09%p61, %f92, %f93;\0A\09setp.nan.f32 \09%p62, %f92, %f92;\0A\09selp.f32 \09%f97, %f92, %f93, %p61;\0A\09selp.f32 \09%f98, %f92, %f97, %p62;\0A\09setp.ge.f32 \09%p63, %f98, %f94;\0A\09setp.nan.f32 \09%p64, %f98, %f98;\0A\09selp.f32 \09%f99, %f98, %f94, %p63;\0A\09selp.f32 \09%f100, %f98, %f99, %p64;\0A\09setp.ge.f32 \09%p65, %f100, %f95;\0A\09setp.nan.f32 \09%p66, %f100, %f100;\0A\09selp.f32 \09%f101, %f100, %f95, %p65;\0A\09selp.f32 \09%f102, %f100, %f101, %p66;\0A\09setp.ge.f32 \09%p67, %f102, %f96;\0A\09setp.nan.f32 \09%p68, %f102, %f102;\0A\09selp.f32 \09%f103, %f102, %f96, %p67;\0A\09selp.f32 \09%f104, %f102, %f103, %p68;\0A\09ld.global.nc.v4.f32 \09{%f105, %f106, %f107, %f108}, [%rd6+144];\0A\09setp.ge.f32 \09%p69, %f104, %f105;\0A\09setp.nan.f32 \09%p70, %f104, %f104;\0A\09selp.f32 \09%f109, %f104, %f105, %p69;\0A\09selp.f32 \09%f110, %f104, %f109, %p70;\0A\09setp.ge.f32 \09%p71, %f110, %f106;\0A\09setp.nan.f32 \09%p72, %f110, %f110;\0A\09selp.f32 \09%f111, %f110, %f106, %p71;\0A\09selp.f32 \09%f112, %f110, %f111, %p72;\0A\09setp.ge.f32 \09%p73, %f112, %f107;\0A\09setp.nan.f32 \09%p74, %f112, %f112;\0A\09selp.f32 \09%f113, %f112, %f107, %p73;\0A\09selp.f32 \09%f114, %f112, %f113, %p74;\0A\09setp.ge.f32 \09%p75, %f114, %f108;\0A\09setp.nan.f32 \09%p76, %f114, %f114;\0A\09selp.f32 \09%f115, %f114, %f108, %p75;\0A\09selp.f32 \09%f116, %f114, %f115, %p76;\0A\09st.global.v4.f32 \09[%rd8], {%f31, %f58, %f89, %f116};\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @gpu_module_2(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09fusion_10_a_inference_train_mnist_213_199\0A\0A.visible .entry fusion_10_a_inference_train_mnist_213_199(\0A\09.param .u64 fusion_10_a_inference_train_mnist_213_199_param_0,\0A\09.param .u64 fusion_10_a_inference_train_mnist_213_199_param_1,\0A\09.param .u64 fusion_10_a_inference_train_mnist_213_199_param_2\0A)\0A.reqntid 25, 1, 1\0A{\0A\09.reg .b32 \09%r<83>;\0A\09.reg .f32 \09%f<527>;\0A\09.reg .b64 \09%rd<12>;\0A\0A\09ld.param.u64 \09%rd1, [fusion_10_a_inference_train_mnist_213_199_param_0];\0A\09ld.param.u64 \09%rd2, [fusion_10_a_inference_train_mnist_213_199_param_2];\0A\09cvta.to.global.u64 \09%rd3, %rd2;\0A\09ld.param.u64 \09%rd4, [fusion_10_a_inference_train_mnist_213_199_param_1];\0A\09cvta.to.global.u64 \09%rd5, %rd4;\0A\09cvta.to.global.u64 \09%rd6, %rd1;\0A\09mov.u32 \09%r1, %tid.x;\0A\09shl.b32 \09%r2, %r1, 2;\0A\09mul.wide.u32 \09%rd7, %r2, 4;\0A\09add.s64 \09%rd8, %rd5, %rd7;\0A\09ld.global.nc.v4.f32 \09{%f1, %f2, %f3, %f4}, [%rd8];\0A\09mul.wide.u32 \09%rd9, %r2, 40;\0A\09add.s64 \09%rd10, %rd6, %rd9;\0A\09ld.global.nc.v4.f32 \09{%f5, %f6, %f7, %f8}, [%rd10];\0A\09sub.rn.f32 \09%f9, %f5, %f1;\0A\09fma.rn.f32 \09%f10, %f9, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f11, %f10;\0A\09mov.f32 \09%f12, 0f4B400001;\0A\09mov.f32 \09%f13, 0f437C0000;\0A\09fma.rm.f32 \09%f14, %f11, %f13, %f12;\0A\09add.rn.f32 \09%f15, %f14, 0fCB40007F;\0A\09neg.f32 \09%f16, %f15;\0A\09fma.rn.f32 \09%f17, %f9, 0f3FB8AA3B, %f16;\0A\09fma.rn.f32 \09%f18, %f9, 0f32A57060, %f17;\0A\09mov.b32 \09%r3, %f14;\0A\09shl.b32 \09%r4, %r3, 23;\0A\09mov.b32 \09%f19, %r4;\0A\09ex2.approx.ftz.f32 \09%f20, %f18;\0A\09mul.rn.f32 \09%f21, %f20, %f19;\0A\09add.rn.f32 \09%f22, %f21, 0f00000000;\0A\09sub.rn.f32 \09%f23, %f6, %f1;\0A\09fma.rn.f32 \09%f24, %f23, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f25, %f24;\0A\09fma.rm.f32 \09%f26, %f25, %f13, %f12;\0A\09add.rn.f32 \09%f27, %f26, 0fCB40007F;\0A\09neg.f32 \09%f28, %f27;\0A\09fma.rn.f32 \09%f29, %f23, 0f3FB8AA3B, %f28;\0A\09fma.rn.f32 \09%f30, %f23, 0f32A57060, %f29;\0A\09mov.b32 \09%r5, %f26;\0A\09shl.b32 \09%r6, %r5, 23;\0A\09mov.b32 \09%f31, %r6;\0A\09ex2.approx.ftz.f32 \09%f32, %f30;\0A\09mul.rn.f32 \09%f33, %f32, %f31;\0A\09add.rn.f32 \09%f34, %f22, %f33;\0A\09sub.rn.f32 \09%f35, %f7, %f1;\0A\09fma.rn.f32 \09%f36, %f35, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f37, %f36;\0A\09fma.rm.f32 \09%f38, %f37, %f13, %f12;\0A\09add.rn.f32 \09%f39, %f38, 0fCB40007F;\0A\09neg.f32 \09%f40, %f39;\0A\09fma.rn.f32 \09%f41, %f35, 0f3FB8AA3B, %f40;\0A\09fma.rn.f32 \09%f42, %f35, 0f32A57060, %f41;\0A\09mov.b32 \09%r7, %f38;\0A\09shl.b32 \09%r8, %r7, 23;\0A\09mov.b32 \09%f43, %r8;\0A\09ex2.approx.ftz.f32 \09%f44, %f42;\0A\09mul.rn.f32 \09%f45, %f44, %f43;\0A\09add.rn.f32 \09%f46, %f34, %f45;\0A\09sub.rn.f32 \09%f47, %f8, %f1;\0A\09fma.rn.f32 \09%f48, %f47, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f49, %f48;\0A\09fma.rm.f32 \09%f50, %f49, %f13, %f12;\0A\09add.rn.f32 \09%f51, %f50, 0fCB40007F;\0A\09neg.f32 \09%f52, %f51;\0A\09fma.rn.f32 \09%f53, %f47, 0f3FB8AA3B, %f52;\0A\09fma.rn.f32 \09%f54, %f47, 0f32A57060, %f53;\0A\09mov.b32 \09%r9, %f50;\0A\09shl.b32 \09%r10, %r9, 23;\0A\09mov.b32 \09%f55, %r10;\0A\09ex2.approx.ftz.f32 \09%f56, %f54;\0A\09mul.rn.f32 \09%f57, %f56, %f55;\0A\09add.rn.f32 \09%f58, %f46, %f57;\0A\09ld.global.nc.v4.f32 \09{%f59, %f60, %f61, %f62}, [%rd10+16];\0A\09sub.rn.f32 \09%f63, %f59, %f1;\0A\09fma.rn.f32 \09%f64, %f63, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f65, %f64;\0A\09fma.rm.f32 \09%f66, %f65, %f13, %f12;\0A\09add.rn.f32 \09%f67, %f66, 0fCB40007F;\0A\09neg.f32 \09%f68, %f67;\0A\09fma.rn.f32 \09%f69, %f63, 0f3FB8AA3B, %f68;\0A\09fma.rn.f32 \09%f70, %f63, 0f32A57060, %f69;\0A\09mov.b32 \09%r11, %f66;\0A\09shl.b32 \09%r12, %r11, 23;\0A\09mov.b32 \09%f71, %r12;\0A\09ex2.approx.ftz.f32 \09%f72, %f70;\0A\09mul.rn.f32 \09%f73, %f72, %f71;\0A\09add.rn.f32 \09%f74, %f58, %f73;\0A\09sub.rn.f32 \09%f75, %f60, %f1;\0A\09fma.rn.f32 \09%f76, %f75, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f77, %f76;\0A\09fma.rm.f32 \09%f78, %f77, %f13, %f12;\0A\09add.rn.f32 \09%f79, %f78, 0fCB40007F;\0A\09neg.f32 \09%f80, %f79;\0A\09fma.rn.f32 \09%f81, %f75, 0f3FB8AA3B, %f80;\0A\09fma.rn.f32 \09%f82, %f75, 0f32A57060, %f81;\0A\09mov.b32 \09%r13, %f78;\0A\09shl.b32 \09%r14, %r13, 23;\0A\09mov.b32 \09%f83, %r14;\0A\09ex2.approx.ftz.f32 \09%f84, %f82;\0A\09mul.rn.f32 \09%f85, %f84, %f83;\0A\09add.rn.f32 \09%f86, %f74, %f85;\0A\09sub.rn.f32 \09%f87, %f61, %f1;\0A\09fma.rn.f32 \09%f88, %f87, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f89, %f88;\0A\09fma.rm.f32 \09%f90, %f89, %f13, %f12;\0A\09add.rn.f32 \09%f91, %f90, 0fCB40007F;\0A\09neg.f32 \09%f92, %f91;\0A\09fma.rn.f32 \09%f93, %f87, 0f3FB8AA3B, %f92;\0A\09fma.rn.f32 \09%f94, %f87, 0f32A57060, %f93;\0A\09mov.b32 \09%r15, %f90;\0A\09shl.b32 \09%r16, %r15, 23;\0A\09mov.b32 \09%f95, %r16;\0A\09ex2.approx.ftz.f32 \09%f96, %f94;\0A\09mul.rn.f32 \09%f97, %f96, %f95;\0A\09add.rn.f32 \09%f98, %f86, %f97;\0A\09sub.rn.f32 \09%f99, %f62, %f1;\0A\09fma.rn.f32 \09%f100, %f99, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f101, %f100;\0A\09fma.rm.f32 \09%f102, %f101, %f13, %f12;\0A\09add.rn.f32 \09%f103, %f102, 0fCB40007F;\0A\09neg.f32 \09%f104, %f103;\0A\09fma.rn.f32 \09%f105, %f99, 0f3FB8AA3B, %f104;\0A\09fma.rn.f32 \09%f106, %f99, 0f32A57060, %f105;\0A\09mov.b32 \09%r17, %f102;\0A\09shl.b32 \09%r18, %r17, 23;\0A\09mov.b32 \09%f107, %r18;\0A\09ex2.approx.ftz.f32 \09%f108, %f106;\0A\09mul.rn.f32 \09%f109, %f108, %f107;\0A\09add.rn.f32 \09%f110, %f98, %f109;\0A\09ld.global.nc.v4.f32 \09{%f111, %f112, %f113, %f114}, [%rd10+32];\0A\09sub.rn.f32 \09%f115, %f111, %f1;\0A\09fma.rn.f32 \09%f116, %f115, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f117, %f116;\0A\09fma.rm.f32 \09%f118, %f117, %f13, %f12;\0A\09add.rn.f32 \09%f119, %f118, 0fCB40007F;\0A\09neg.f32 \09%f120, %f119;\0A\09fma.rn.f32 \09%f121, %f115, 0f3FB8AA3B, %f120;\0A\09fma.rn.f32 \09%f122, %f115, 0f32A57060, %f121;\0A\09mov.b32 \09%r19, %f118;\0A\09shl.b32 \09%r20, %r19, 23;\0A\09mov.b32 \09%f123, %r20;\0A\09ex2.approx.ftz.f32 \09%f124, %f122;\0A\09mul.rn.f32 \09%f125, %f124, %f123;\0A\09add.rn.f32 \09%f126, %f110, %f125;\0A\09sub.rn.f32 \09%f127, %f112, %f1;\0A\09fma.rn.f32 \09%f128, %f127, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f129, %f128;\0A\09fma.rm.f32 \09%f130, %f129, %f13, %f12;\0A\09add.rn.f32 \09%f131, %f130, 0fCB40007F;\0A\09neg.f32 \09%f132, %f131;\0A\09fma.rn.f32 \09%f133, %f127, 0f3FB8AA3B, %f132;\0A\09fma.rn.f32 \09%f134, %f127, 0f32A57060, %f133;\0A\09mov.b32 \09%r21, %f130;\0A\09shl.b32 \09%r22, %r21, 23;\0A\09mov.b32 \09%f135, %r22;\0A\09ex2.approx.ftz.f32 \09%f136, %f134;\0A\09mul.rn.f32 \09%f137, %f136, %f135;\0A\09add.rn.f32 \09%f138, %f126, %f137;\0A\09add.s64 \09%rd11, %rd3, %rd7;\0A\09sub.rn.f32 \09%f139, %f113, %f2;\0A\09fma.rn.f32 \09%f140, %f139, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f141, %f140;\0A\09fma.rm.f32 \09%f142, %f141, %f13, %f12;\0A\09add.rn.f32 \09%f143, %f142, 0fCB40007F;\0A\09neg.f32 \09%f144, %f143;\0A\09fma.rn.f32 \09%f145, %f139, 0f3FB8AA3B, %f144;\0A\09fma.rn.f32 \09%f146, %f139, 0f32A57060, %f145;\0A\09mov.b32 \09%r23, %f142;\0A\09shl.b32 \09%r24, %r23, 23;\0A\09mov.b32 \09%f147, %r24;\0A\09ex2.approx.ftz.f32 \09%f148, %f146;\0A\09mul.rn.f32 \09%f149, %f148, %f147;\0A\09add.rn.f32 \09%f150, %f149, 0f00000000;\0A\09sub.rn.f32 \09%f151, %f114, %f2;\0A\09fma.rn.f32 \09%f152, %f151, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f153, %f152;\0A\09fma.rm.f32 \09%f154, %f153, %f13, %f12;\0A\09add.rn.f32 \09%f155, %f154, 0fCB40007F;\0A\09neg.f32 \09%f156, %f155;\0A\09fma.rn.f32 \09%f157, %f151, 0f3FB8AA3B, %f156;\0A\09fma.rn.f32 \09%f158, %f151, 0f32A57060, %f157;\0A\09mov.b32 \09%r25, %f154;\0A\09shl.b32 \09%r26, %r25, 23;\0A\09mov.b32 \09%f159, %r26;\0A\09ex2.approx.ftz.f32 \09%f160, %f158;\0A\09mul.rn.f32 \09%f161, %f160, %f159;\0A\09add.rn.f32 \09%f162, %f150, %f161;\0A\09ld.global.nc.v4.f32 \09{%f163, %f164, %f165, %f166}, [%rd10+48];\0A\09sub.rn.f32 \09%f167, %f163, %f2;\0A\09fma.rn.f32 \09%f168, %f167, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f169, %f168;\0A\09fma.rm.f32 \09%f170, %f169, %f13, %f12;\0A\09add.rn.f32 \09%f171, %f170, 0fCB40007F;\0A\09neg.f32 \09%f172, %f171;\0A\09fma.rn.f32 \09%f173, %f167, 0f3FB8AA3B, %f172;\0A\09fma.rn.f32 \09%f174, %f167, 0f32A57060, %f173;\0A\09mov.b32 \09%r27, %f170;\0A\09shl.b32 \09%r28, %r27, 23;\0A\09mov.b32 \09%f175, %r28;\0A\09ex2.approx.ftz.f32 \09%f176, %f174;\0A\09mul.rn.f32 \09%f177, %f176, %f175;\0A\09add.rn.f32 \09%f178, %f162, %f177;\0A\09sub.rn.f32 \09%f179, %f164, %f2;\0A\09fma.rn.f32 \09%f180, %f179, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f181, %f180;\0A\09fma.rm.f32 \09%f182, %f181, %f13, %f12;\0A\09add.rn.f32 \09%f183, %f182, 0fCB40007F;\0A\09neg.f32 \09%f184, %f183;\0A\09fma.rn.f32 \09%f185, %f179, 0f3FB8AA3B, %f184;\0A\09fma.rn.f32 \09%f186, %f179, 0f32A57060, %f185;\0A\09mov.b32 \09%r29, %f182;\0A\09shl.b32 \09%r30, %r29, 23;\0A\09mov.b32 \09%f187, %r30;\0A\09ex2.approx.ftz.f32 \09%f188, %f186;\0A\09mul.rn.f32 \09%f189, %f188, %f187;\0A\09add.rn.f32 \09%f190, %f178, %f189;\0A\09sub.rn.f32 \09%f191, %f165, %f2;\0A\09fma.rn.f32 \09%f192, %f191, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f193, %f192;\0A\09fma.rm.f32 \09%f194, %f193, %f13, %f12;\0A\09add.rn.f32 \09%f195, %f194, 0fCB40007F;\0A\09neg.f32 \09%f196, %f195;\0A\09fma.rn.f32 \09%f197, %f191, 0f3FB8AA3B, %f196;\0A\09fma.rn.f32 \09%f198, %f191, 0f32A57060, %f197;\0A\09mov.b32 \09%r31, %f194;\0A\09shl.b32 \09%r32, %r31, 23;\0A\09mov.b32 \09%f199, %r32;\0A\09ex2.approx.ftz.f32 \09%f200, %f198;\0A\09mul.rn.f32 \09%f201, %f200, %f199;\0A\09add.rn.f32 \09%f202, %f190, %f201;\0A\09sub.rn.f32 \09%f203, %f166, %f2;\0A\09fma.rn.f32 \09%f204, %f203, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f205, %f204;\0A\09fma.rm.f32 \09%f206, %f205, %f13, %f12;\0A\09add.rn.f32 \09%f207, %f206, 0fCB40007F;\0A\09neg.f32 \09%f208, %f207;\0A\09fma.rn.f32 \09%f209, %f203, 0f3FB8AA3B, %f208;\0A\09fma.rn.f32 \09%f210, %f203, 0f32A57060, %f209;\0A\09mov.b32 \09%r33, %f206;\0A\09shl.b32 \09%r34, %r33, 23;\0A\09mov.b32 \09%f211, %r34;\0A\09ex2.approx.ftz.f32 \09%f212, %f210;\0A\09mul.rn.f32 \09%f213, %f212, %f211;\0A\09add.rn.f32 \09%f214, %f202, %f213;\0A\09ld.global.nc.v4.f32 \09{%f215, %f216, %f217, %f218}, [%rd10+64];\0A\09sub.rn.f32 \09%f219, %f215, %f2;\0A\09fma.rn.f32 \09%f220, %f219, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f221, %f220;\0A\09fma.rm.f32 \09%f222, %f221, %f13, %f12;\0A\09add.rn.f32 \09%f223, %f222, 0fCB40007F;\0A\09neg.f32 \09%f224, %f223;\0A\09fma.rn.f32 \09%f225, %f219, 0f3FB8AA3B, %f224;\0A\09fma.rn.f32 \09%f226, %f219, 0f32A57060, %f225;\0A\09mov.b32 \09%r35, %f222;\0A\09shl.b32 \09%r36, %r35, 23;\0A\09mov.b32 \09%f227, %r36;\0A\09ex2.approx.ftz.f32 \09%f228, %f226;\0A\09mul.rn.f32 \09%f229, %f228, %f227;\0A\09add.rn.f32 \09%f230, %f214, %f229;\0A\09sub.rn.f32 \09%f231, %f216, %f2;\0A\09fma.rn.f32 \09%f232, %f231, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f233, %f232;\0A\09fma.rm.f32 \09%f234, %f233, %f13, %f12;\0A\09add.rn.f32 \09%f235, %f234, 0fCB40007F;\0A\09neg.f32 \09%f236, %f235;\0A\09fma.rn.f32 \09%f237, %f231, 0f3FB8AA3B, %f236;\0A\09fma.rn.f32 \09%f238, %f231, 0f32A57060, %f237;\0A\09mov.b32 \09%r37, %f234;\0A\09shl.b32 \09%r38, %r37, 23;\0A\09mov.b32 \09%f239, %r38;\0A\09ex2.approx.ftz.f32 \09%f240, %f238;\0A\09mul.rn.f32 \09%f241, %f240, %f239;\0A\09add.rn.f32 \09%f242, %f230, %f241;\0A\09sub.rn.f32 \09%f243, %f217, %f2;\0A\09fma.rn.f32 \09%f244, %f243, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f245, %f244;\0A\09fma.rm.f32 \09%f246, %f245, %f13, %f12;\0A\09add.rn.f32 \09%f247, %f246, 0fCB40007F;\0A\09neg.f32 \09%f248, %f247;\0A\09fma.rn.f32 \09%f249, %f243, 0f3FB8AA3B, %f248;\0A\09fma.rn.f32 \09%f250, %f243, 0f32A57060, %f249;\0A\09mov.b32 \09%r39, %f246;\0A\09shl.b32 \09%r40, %r39, 23;\0A\09mov.b32 \09%f251, %r40;\0A\09ex2.approx.ftz.f32 \09%f252, %f250;\0A\09mul.rn.f32 \09%f253, %f252, %f251;\0A\09add.rn.f32 \09%f254, %f242, %f253;\0A\09sub.rn.f32 \09%f255, %f218, %f2;\0A\09fma.rn.f32 \09%f256, %f255, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f257, %f256;\0A\09fma.rm.f32 \09%f258, %f257, %f13, %f12;\0A\09add.rn.f32 \09%f259, %f258, 0fCB40007F;\0A\09neg.f32 \09%f260, %f259;\0A\09fma.rn.f32 \09%f261, %f255, 0f3FB8AA3B, %f260;\0A\09fma.rn.f32 \09%f262, %f255, 0f32A57060, %f261;\0A\09mov.b32 \09%r41, %f258;\0A\09shl.b32 \09%r42, %r41, 23;\0A\09mov.b32 \09%f263, %r42;\0A\09ex2.approx.ftz.f32 \09%f264, %f262;\0A\09mul.rn.f32 \09%f265, %f264, %f263;\0A\09add.rn.f32 \09%f266, %f254, %f265;\0A\09ld.global.nc.v4.f32 \09{%f267, %f268, %f269, %f270}, [%rd10+80];\0A\09sub.rn.f32 \09%f271, %f267, %f3;\0A\09fma.rn.f32 \09%f272, %f271, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f273, %f272;\0A\09fma.rm.f32 \09%f274, %f273, %f13, %f12;\0A\09add.rn.f32 \09%f275, %f274, 0fCB40007F;\0A\09neg.f32 \09%f276, %f275;\0A\09fma.rn.f32 \09%f277, %f271, 0f3FB8AA3B, %f276;\0A\09fma.rn.f32 \09%f278, %f271, 0f32A57060, %f277;\0A\09mov.b32 \09%r43, %f274;\0A\09shl.b32 \09%r44, %r43, 23;\0A\09mov.b32 \09%f279, %r44;\0A\09ex2.approx.ftz.f32 \09%f280, %f278;\0A\09mul.rn.f32 \09%f281, %f280, %f279;\0A\09add.rn.f32 \09%f282, %f281, 0f00000000;\0A\09sub.rn.f32 \09%f283, %f268, %f3;\0A\09fma.rn.f32 \09%f284, %f283, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f285, %f284;\0A\09fma.rm.f32 \09%f286, %f285, %f13, %f12;\0A\09add.rn.f32 \09%f287, %f286, 0fCB40007F;\0A\09neg.f32 \09%f288, %f287;\0A\09fma.rn.f32 \09%f289, %f283, 0f3FB8AA3B, %f288;\0A\09fma.rn.f32 \09%f290, %f283, 0f32A57060, %f289;\0A\09mov.b32 \09%r45, %f286;\0A\09shl.b32 \09%r46, %r45, 23;\0A\09mov.b32 \09%f291, %r46;\0A\09ex2.approx.ftz.f32 \09%f292, %f290;\0A\09mul.rn.f32 \09%f293, %f292, %f291;\0A\09add.rn.f32 \09%f294, %f282, %f293;\0A\09sub.rn.f32 \09%f295, %f269, %f3;\0A\09fma.rn.f32 \09%f296, %f295, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f297, %f296;\0A\09fma.rm.f32 \09%f298, %f297, %f13, %f12;\0A\09add.rn.f32 \09%f299, %f298, 0fCB40007F;\0A\09neg.f32 \09%f300, %f299;\0A\09fma.rn.f32 \09%f301, %f295, 0f3FB8AA3B, %f300;\0A\09fma.rn.f32 \09%f302, %f295, 0f32A57060, %f301;\0A\09mov.b32 \09%r47, %f298;\0A\09shl.b32 \09%r48, %r47, 23;\0A\09mov.b32 \09%f303, %r48;\0A\09ex2.approx.ftz.f32 \09%f304, %f302;\0A\09mul.rn.f32 \09%f305, %f304, %f303;\0A\09add.rn.f32 \09%f306, %f294, %f305;\0A\09sub.rn.f32 \09%f307, %f270, %f3;\0A\09fma.rn.f32 \09%f308, %f307, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f309, %f308;\0A\09fma.rm.f32 \09%f310, %f309, %f13, %f12;\0A\09add.rn.f32 \09%f311, %f310, 0fCB40007F;\0A\09neg.f32 \09%f312, %f311;\0A\09fma.rn.f32 \09%f313, %f307, 0f3FB8AA3B, %f312;\0A\09fma.rn.f32 \09%f314, %f307, 0f32A57060, %f313;\0A\09mov.b32 \09%r49, %f310;\0A\09shl.b32 \09%r50, %r49, 23;\0A\09mov.b32 \09%f315, %r50;\0A\09ex2.approx.ftz.f32 \09%f316, %f314;\0A\09mul.rn.f32 \09%f317, %f316, %f315;\0A\09add.rn.f32 \09%f318, %f306, %f317;\0A\09ld.global.nc.v4.f32 \09{%f319, %f320, %f321, %f322}, [%rd10+96];\0A\09sub.rn.f32 \09%f323, %f319, %f3;\0A\09fma.rn.f32 \09%f324, %f323, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f325, %f324;\0A\09fma.rm.f32 \09%f326, %f325, %f13, %f12;\0A\09add.rn.f32 \09%f327, %f326, 0fCB40007F;\0A\09neg.f32 \09%f328, %f327;\0A\09fma.rn.f32 \09%f329, %f323, 0f3FB8AA3B, %f328;\0A\09fma.rn.f32 \09%f330, %f323, 0f32A57060, %f329;\0A\09mov.b32 \09%r51, %f326;\0A\09shl.b32 \09%r52, %r51, 23;\0A\09mov.b32 \09%f331, %r52;\0A\09ex2.approx.ftz.f32 \09%f332, %f330;\0A\09mul.rn.f32 \09%f333, %f332, %f331;\0A\09add.rn.f32 \09%f334, %f318, %f333;\0A\09sub.rn.f32 \09%f335, %f320, %f3;\0A\09fma.rn.f32 \09%f336, %f335, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f337, %f336;\0A\09fma.rm.f32 \09%f338, %f337, %f13, %f12;\0A\09add.rn.f32 \09%f339, %f338, 0fCB40007F;\0A\09neg.f32 \09%f340, %f339;\0A\09fma.rn.f32 \09%f341, %f335, 0f3FB8AA3B, %f340;\0A\09fma.rn.f32 \09%f342, %f335, 0f32A57060, %f341;\0A\09mov.b32 \09%r53, %f338;\0A\09shl.b32 \09%r54, %r53, 23;\0A\09mov.b32 \09%f343, %r54;\0A\09ex2.approx.ftz.f32 \09%f344, %f342;\0A\09mul.rn.f32 \09%f345, %f344, %f343;\0A\09add.rn.f32 \09%f346, %f334, %f345;\0A\09sub.rn.f32 \09%f347, %f321, %f3;\0A\09fma.rn.f32 \09%f348, %f347, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f349, %f348;\0A\09fma.rm.f32 \09%f350, %f349, %f13, %f12;\0A\09add.rn.f32 \09%f351, %f350, 0fCB40007F;\0A\09neg.f32 \09%f352, %f351;\0A\09fma.rn.f32 \09%f353, %f347, 0f3FB8AA3B, %f352;\0A\09fma.rn.f32 \09%f354, %f347, 0f32A57060, %f353;\0A\09mov.b32 \09%r55, %f350;\0A\09shl.b32 \09%r56, %r55, 23;\0A\09mov.b32 \09%f355, %r56;\0A\09ex2.approx.ftz.f32 \09%f356, %f354;\0A\09mul.rn.f32 \09%f357, %f356, %f355;\0A\09add.rn.f32 \09%f358, %f346, %f357;\0A\09sub.rn.f32 \09%f359, %f322, %f3;\0A\09fma.rn.f32 \09%f360, %f359, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f361, %f360;\0A\09fma.rm.f32 \09%f362, %f361, %f13, %f12;\0A\09add.rn.f32 \09%f363, %f362, 0fCB40007F;\0A\09neg.f32 \09%f364, %f363;\0A\09fma.rn.f32 \09%f365, %f359, 0f3FB8AA3B, %f364;\0A\09fma.rn.f32 \09%f366, %f359, 0f32A57060, %f365;\0A\09mov.b32 \09%r57, %f362;\0A\09shl.b32 \09%r58, %r57, 23;\0A\09mov.b32 \09%f367, %r58;\0A\09ex2.approx.ftz.f32 \09%f368, %f366;\0A\09mul.rn.f32 \09%f369, %f368, %f367;\0A\09add.rn.f32 \09%f370, %f358, %f369;\0A\09ld.global.nc.v4.f32 \09{%f371, %f372, %f373, %f374}, [%rd10+112];\0A\09sub.rn.f32 \09%f375, %f371, %f3;\0A\09fma.rn.f32 \09%f376, %f375, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f377, %f376;\0A\09fma.rm.f32 \09%f378, %f377, %f13, %f12;\0A\09add.rn.f32 \09%f379, %f378, 0fCB40007F;\0A\09neg.f32 \09%f380, %f379;\0A\09fma.rn.f32 \09%f381, %f375, 0f3FB8AA3B, %f380;\0A\09fma.rn.f32 \09%f382, %f375, 0f32A57060, %f381;\0A\09mov.b32 \09%r59, %f378;\0A\09shl.b32 \09%r60, %r59, 23;\0A\09mov.b32 \09%f383, %r60;\0A\09ex2.approx.ftz.f32 \09%f384, %f382;\0A\09mul.rn.f32 \09%f385, %f384, %f383;\0A\09add.rn.f32 \09%f386, %f370, %f385;\0A\09sub.rn.f32 \09%f387, %f372, %f3;\0A\09fma.rn.f32 \09%f388, %f387, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f389, %f388;\0A\09fma.rm.f32 \09%f390, %f389, %f13, %f12;\0A\09add.rn.f32 \09%f391, %f390, 0fCB40007F;\0A\09neg.f32 \09%f392, %f391;\0A\09fma.rn.f32 \09%f393, %f387, 0f3FB8AA3B, %f392;\0A\09fma.rn.f32 \09%f394, %f387, 0f32A57060, %f393;\0A\09mov.b32 \09%r61, %f390;\0A\09shl.b32 \09%r62, %r61, 23;\0A\09mov.b32 \09%f395, %r62;\0A\09ex2.approx.ftz.f32 \09%f396, %f394;\0A\09mul.rn.f32 \09%f397, %f396, %f395;\0A\09add.rn.f32 \09%f398, %f386, %f397;\0A\09sub.rn.f32 \09%f399, %f373, %f4;\0A\09fma.rn.f32 \09%f400, %f399, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f401, %f400;\0A\09fma.rm.f32 \09%f402, %f401, %f13, %f12;\0A\09add.rn.f32 \09%f403, %f402, 0fCB40007F;\0A\09neg.f32 \09%f404, %f403;\0A\09fma.rn.f32 \09%f405, %f399, 0f3FB8AA3B, %f404;\0A\09fma.rn.f32 \09%f406, %f399, 0f32A57060, %f405;\0A\09mov.b32 \09%r63, %f402;\0A\09shl.b32 \09%r64, %r63, 23;\0A\09mov.b32 \09%f407, %r64;\0A\09ex2.approx.ftz.f32 \09%f408, %f406;\0A\09mul.rn.f32 \09%f409, %f408, %f407;\0A\09add.rn.f32 \09%f410, %f409, 0f00000000;\0A\09sub.rn.f32 \09%f411, %f374, %f4;\0A\09fma.rn.f32 \09%f412, %f411, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f413, %f412;\0A\09fma.rm.f32 \09%f414, %f413, %f13, %f12;\0A\09add.rn.f32 \09%f415, %f414, 0fCB40007F;\0A\09neg.f32 \09%f416, %f415;\0A\09fma.rn.f32 \09%f417, %f411, 0f3FB8AA3B, %f416;\0A\09fma.rn.f32 \09%f418, %f411, 0f32A57060, %f417;\0A\09mov.b32 \09%r65, %f414;\0A\09shl.b32 \09%r66, %r65, 23;\0A\09mov.b32 \09%f419, %r66;\0A\09ex2.approx.ftz.f32 \09%f420, %f418;\0A\09mul.rn.f32 \09%f421, %f420, %f419;\0A\09add.rn.f32 \09%f422, %f410, %f421;\0A\09ld.global.nc.v4.f32 \09{%f423, %f424, %f425, %f426}, [%rd10+128];\0A\09sub.rn.f32 \09%f427, %f423, %f4;\0A\09fma.rn.f32 \09%f428, %f427, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f429, %f428;\0A\09fma.rm.f32 \09%f430, %f429, %f13, %f12;\0A\09add.rn.f32 \09%f431, %f430, 0fCB40007F;\0A\09neg.f32 \09%f432, %f431;\0A\09fma.rn.f32 \09%f433, %f427, 0f3FB8AA3B, %f432;\0A\09fma.rn.f32 \09%f434, %f427, 0f32A57060, %f433;\0A\09mov.b32 \09%r67, %f430;\0A\09shl.b32 \09%r68, %r67, 23;\0A\09mov.b32 \09%f435, %r68;\0A\09ex2.approx.ftz.f32 \09%f436, %f434;\0A\09mul.rn.f32 \09%f437, %f436, %f435;\0A\09add.rn.f32 \09%f438, %f422, %f437;\0A\09sub.rn.f32 \09%f439, %f424, %f4;\0A\09fma.rn.f32 \09%f440, %f439, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f441, %f440;\0A\09fma.rm.f32 \09%f442, %f441, %f13, %f12;\0A\09add.rn.f32 \09%f443, %f442, 0fCB40007F;\0A\09neg.f32 \09%f444, %f443;\0A\09fma.rn.f32 \09%f445, %f439, 0f3FB8AA3B, %f444;\0A\09fma.rn.f32 \09%f446, %f439, 0f32A57060, %f445;\0A\09mov.b32 \09%r69, %f442;\0A\09shl.b32 \09%r70, %r69, 23;\0A\09mov.b32 \09%f447, %r70;\0A\09ex2.approx.ftz.f32 \09%f448, %f446;\0A\09mul.rn.f32 \09%f449, %f448, %f447;\0A\09add.rn.f32 \09%f450, %f438, %f449;\0A\09sub.rn.f32 \09%f451, %f425, %f4;\0A\09fma.rn.f32 \09%f452, %f451, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f453, %f452;\0A\09fma.rm.f32 \09%f454, %f453, %f13, %f12;\0A\09add.rn.f32 \09%f455, %f454, 0fCB40007F;\0A\09neg.f32 \09%f456, %f455;\0A\09fma.rn.f32 \09%f457, %f451, 0f3FB8AA3B, %f456;\0A\09fma.rn.f32 \09%f458, %f451, 0f32A57060, %f457;\0A\09mov.b32 \09%r71, %f454;\0A\09shl.b32 \09%r72, %r71, 23;\0A\09mov.b32 \09%f459, %r72;\0A\09ex2.approx.ftz.f32 \09%f460, %f458;\0A\09mul.rn.f32 \09%f461, %f460, %f459;\0A\09add.rn.f32 \09%f462, %f450, %f461;\0A\09sub.rn.f32 \09%f463, %f426, %f4;\0A\09fma.rn.f32 \09%f464, %f463, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f465, %f464;\0A\09fma.rm.f32 \09%f466, %f465, %f13, %f12;\0A\09add.rn.f32 \09%f467, %f466, 0fCB40007F;\0A\09neg.f32 \09%f468, %f467;\0A\09fma.rn.f32 \09%f469, %f463, 0f3FB8AA3B, %f468;\0A\09fma.rn.f32 \09%f470, %f463, 0f32A57060, %f469;\0A\09mov.b32 \09%r73, %f466;\0A\09shl.b32 \09%r74, %r73, 23;\0A\09mov.b32 \09%f471, %r74;\0A\09ex2.approx.ftz.f32 \09%f472, %f470;\0A\09mul.rn.f32 \09%f473, %f472, %f471;\0A\09add.rn.f32 \09%f474, %f462, %f473;\0A\09ld.global.nc.v4.f32 \09{%f475, %f476, %f477, %f478}, [%rd10+144];\0A\09sub.rn.f32 \09%f479, %f475, %f4;\0A\09fma.rn.f32 \09%f480, %f479, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f481, %f480;\0A\09fma.rm.f32 \09%f482, %f481, %f13, %f12;\0A\09add.rn.f32 \09%f483, %f482, 0fCB40007F;\0A\09neg.f32 \09%f484, %f483;\0A\09fma.rn.f32 \09%f485, %f479, 0f3FB8AA3B, %f484;\0A\09fma.rn.f32 \09%f486, %f479, 0f32A57060, %f485;\0A\09mov.b32 \09%r75, %f482;\0A\09shl.b32 \09%r76, %r75, 23;\0A\09mov.b32 \09%f487, %r76;\0A\09ex2.approx.ftz.f32 \09%f488, %f486;\0A\09mul.rn.f32 \09%f489, %f488, %f487;\0A\09add.rn.f32 \09%f490, %f474, %f489;\0A\09sub.rn.f32 \09%f491, %f476, %f4;\0A\09fma.rn.f32 \09%f492, %f491, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f493, %f492;\0A\09fma.rm.f32 \09%f494, %f493, %f13, %f12;\0A\09add.rn.f32 \09%f495, %f494, 0fCB40007F;\0A\09neg.f32 \09%f496, %f495;\0A\09fma.rn.f32 \09%f497, %f491, 0f3FB8AA3B, %f496;\0A\09fma.rn.f32 \09%f498, %f491, 0f32A57060, %f497;\0A\09mov.b32 \09%r77, %f494;\0A\09shl.b32 \09%r78, %r77, 23;\0A\09mov.b32 \09%f499, %r78;\0A\09ex2.approx.ftz.f32 \09%f500, %f498;\0A\09mul.rn.f32 \09%f501, %f500, %f499;\0A\09add.rn.f32 \09%f502, %f490, %f501;\0A\09sub.rn.f32 \09%f503, %f477, %f4;\0A\09fma.rn.f32 \09%f504, %f503, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f505, %f504;\0A\09fma.rm.f32 \09%f506, %f505, %f13, %f12;\0A\09add.rn.f32 \09%f507, %f506, 0fCB40007F;\0A\09neg.f32 \09%f508, %f507;\0A\09fma.rn.f32 \09%f509, %f503, 0f3FB8AA3B, %f508;\0A\09fma.rn.f32 \09%f510, %f503, 0f32A57060, %f509;\0A\09mov.b32 \09%r79, %f506;\0A\09shl.b32 \09%r80, %r79, 23;\0A\09mov.b32 \09%f511, %r80;\0A\09ex2.approx.ftz.f32 \09%f512, %f510;\0A\09mul.rn.f32 \09%f513, %f512, %f511;\0A\09add.rn.f32 \09%f514, %f502, %f513;\0A\09sub.rn.f32 \09%f515, %f478, %f4;\0A\09fma.rn.f32 \09%f516, %f515, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f517, %f516;\0A\09fma.rm.f32 \09%f518, %f517, %f13, %f12;\0A\09add.rn.f32 \09%f519, %f518, 0fCB40007F;\0A\09neg.f32 \09%f520, %f519;\0A\09fma.rn.f32 \09%f521, %f515, 0f3FB8AA3B, %f520;\0A\09fma.rn.f32 \09%f522, %f515, 0f32A57060, %f521;\0A\09mov.b32 \09%r81, %f518;\0A\09shl.b32 \09%r82, %r81, 23;\0A\09mov.b32 \09%f523, %r82;\0A\09ex2.approx.ftz.f32 \09%f524, %f522;\0A\09mul.rn.f32 \09%f525, %f524, %f523;\0A\09add.rn.f32 \09%f526, %f514, %f525;\0A\09st.global.v4.f32 \09[%rd11], {%f138, %f266, %f398, %f526};\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @gpu_module_3(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09input_fusion_reduce_a_inference_train_mnist_213_199\0A.shared .align 4 .b8 shared_cache[4224];\0A\0A.visible .entry input_fusion_reduce_a_inference_train_mnist_213_199(\0A\09.param .u64 input_fusion_reduce_a_inference_train_mnist_213_199_param_0,\0A\09.param .u64 input_fusion_reduce_a_inference_train_mnist_213_199_param_1,\0A\09.param .u64 input_fusion_reduce_a_inference_train_mnist_213_199_param_2,\0A\09.param .u64 input_fusion_reduce_a_inference_train_mnist_213_199_param_3,\0A\09.param .u64 input_fusion_reduce_a_inference_train_mnist_213_199_param_4,\0A\09.param .u64 input_fusion_reduce_a_inference_train_mnist_213_199_param_5\0A)\0A.reqntid 1024, 1, 1\0A{\0A\09.reg .pred \09%p<8>;\0A\09.reg .b16 \09%rs<2>;\0A\09.reg .b32 \09%r<12>;\0A\09.reg .f32 \09%f<41>;\0A\09.reg .b64 \09%rd<51>;\0A\0A\09mov.u32 \09%r1, %tid.x;\0A\09and.b32  \09%r3, %r1, 31;\0A\09shr.u32 \09%r2, %r1, 5;\0A\09setp.gt.u32 \09%p1, %r3, 9;\0A\09cvt.u64.u32 \09%rd7, %r3;\0A\09mov.f32 \09%f40, 0f80000000;\0A\09shl.b64 \09%rd45, %rd7, 2;\0A\09cvt.u32.u64 \09%r11, %rd7;\0A\09@%p1 bra \09LBB0_3;\0A\09ld.param.u64 \09%rd24, [input_fusion_reduce_a_inference_train_mnist_213_199_param_0];\0A\09ld.param.u64 \09%rd25, [input_fusion_reduce_a_inference_train_mnist_213_199_param_5];\0A\09cvta.to.global.u64 \09%rd1, %rd25;\0A\09ld.param.u64 \09%rd26, [input_fusion_reduce_a_inference_train_mnist_213_199_param_1];\0A\09ld.param.u64 \09%rd28, [input_fusion_reduce_a_inference_train_mnist_213_199_param_2];\0A\09ld.param.u64 \09%rd29, [input_fusion_reduce_a_inference_train_mnist_213_199_param_3];\0A\09cvta.to.global.u64 \09%rd3, %rd29;\0A\09cvta.to.global.u64 \09%rd4, %rd28;\0A\09cvta.to.global.u64 \09%rd5, %rd26;\0A\09cvta.to.global.u64 \09%rd6, %rd24;\0A\09cvt.u64.u32 \09%rd30, %r1;\0A\09shr.u64 \09%rd50, %rd30, 5;\0A\09mul.lo.s64 \09%rd31, %rd50, 40;\0A\09add.s64 \09%rd33, %rd31, %rd45;\0A\09add.s64 \09%rd49, %rd4, %rd33;\0A\09shl.b64 \09%rd34, %rd50, 2;\0A\09add.s64 \09%rd48, %rd3, %rd34;\0A\09add.s64 \09%rd47, %rd5, %rd34;\0A\09add.s64 \09%rd46, %rd1, %rd33;\0A\09mov.f32 \09%f40, 0f80000000;\0A\09mov.f32 \09%f12, 0f4B400001;\0A\09mov.f32 \09%f13, 0f437C0000;\0ALBB0_2:\0A\09ld.global.nc.f32 \09%f7, [%rd49];\0A\09ld.global.nc.f32 \09%f8, [%rd48];\0A\09sub.rn.f32 \09%f9, %f7, %f8;\0A\09fma.rn.f32 \09%f10, %f9, 0f3BBB989D, 0f3F000000;\0A\09cvt.sat.f32.f32 \09%f11, %f10;\0A\09fma.rm.f32 \09%f14, %f11, %f13, %f12;\0A\09add.rn.f32 \09%f15, %f14, 0fCB40007F;\0A\09neg.f32 \09%f16, %f15;\0A\09fma.rn.f32 \09%f17, %f9, 0f3FB8AA3B, %f16;\0A\09fma.rn.f32 \09%f18, %f9, 0f32A57060, %f17;\0A\09mov.b32 \09%r5, %f14;\0A\09shl.b32 \09%r6, %r5, 23;\0A\09mov.b32 \09%f19, %r6;\0A\09ex2.approx.ftz.f32 \09%f20, %f18;\0A\09mul.rn.f32 \09%f21, %f20, %f19;\0A\09ld.global.nc.f32 \09%f22, [%rd47];\0A\09div.full.f32 \09%f23, %f21, %f22;\0A\09add.s64 \09%rd35, %rd6, %rd50;\0A\09ld.global.nc.u8 \09%rs1, [%rd35];\0A\09cvt.u32.u8 \09%r7, %rs1;\0A\09setp.lt.u32 \09%p2, %r7, 10;\0A\09setp.eq.s32 \09%p3, %r11, %r7;\0A\09selp.f32 \09%f24, 0f3F800000, 0f00000000, %p3;\0A\09selp.f32 \09%f25, 0f00000000, 0f7FC00000, %p2;\0A\09add.rn.f32 \09%f26, %f25, %f24;\0A\09sub.rn.f32 \09%f27, %f23, %f26;\0A\09mul.rn.f32 \09%f28, %f27, 0f3C23D70A;\0A\09add.rn.f32 \09%f40, %f40, %f28;\0A\09st.global.f32 \09[%rd46], %f28;\0A\09add.s64 \09%rd50, %rd50, 32;\0A\09cvt.u32.u64 \09%r8, %rd50;\0A\09add.s32 \09%r9, %r8, -32;\0A\09add.s64 \09%rd49, %rd49, 1280;\0A\09add.s64 \09%rd48, %rd48, 128;\0A\09add.s64 \09%rd47, %rd47, 128;\0A\09add.s64 \09%rd46, %rd46, 1280;\0A\09setp.gt.u32 \09%p4, %r9, 67;\0A\09@%p4 bra \09LBB0_3;\0A\09bra.uni \09LBB0_2;\0ALBB0_3:\0A\09mul.lo.s64 \09%rd36, %rd7, 132;\0A\09mov.u64 \09%rd37, shared_cache;\0A\09add.s64 \09%rd38, %rd37, %rd36;\0A\09mul.wide.u32 \09%rd39, %r2, 4;\0A\09add.s64 \09%rd40, %rd38, %rd39;\0A\09st.shared.f32 \09[%rd40], %f40;\0A\09bar.sync \090;\0A\09mul.wide.u32 \09%rd41, %r2, 132;\0A\09add.s64 \09%rd42, %rd37, %rd41;\0A\09add.s64 \09%rd44, %rd42, %rd45;\0A\09ld.shared.f32 \09%f29, [%rd44];\0A\09shfl.sync.down.b32\09%f30, %f29, 16, 31, -1;\0A\09add.rn.f32 \09%f31, %f29, %f30;\0A\09shfl.sync.down.b32\09%f32, %f31, 8, 31, -1;\0A\09add.rn.f32 \09%f33, %f31, %f32;\0A\09shfl.sync.down.b32\09%f34, %f33, 4, 31, -1;\0A\09add.rn.f32 \09%f35, %f33, %f34;\0A\09shfl.sync.down.b32\09%f36, %f35, 2, 31, -1;\0A\09add.rn.f32 \09%f37, %f35, %f36;\0A\09shfl.sync.down.b32\09%f38, %f37, 1, 31, -1;\0A\09add.rn.f32 \09%f4, %f37, %f38;\0A\09st.shared.f32 \09[%rd44], %f4;\0A\09setp.gt.u32 \09%p5, %r1, 319;\0A\09setp.ne.s32 \09%p6, %r11, 0;\0A\09or.pred  \09%p7, %p5, %p6;\0A\09@%p7 bra \09LBB0_5;\0A\09ld.param.u64 \09%rd27, [input_fusion_reduce_a_inference_train_mnist_213_199_param_4];\0A\09cvta.to.global.u64 \09%rd2, %rd27;\0A\09add.s64 \09%rd23, %rd2, %rd39;\0A\09st.global.f32 \09[%rd23], %f4;\0ALBB0_5:\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @gpu_module_4(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09fusion_5_a_inference_train_mnist_213_199\0A\0A.visible .entry fusion_5_a_inference_train_mnist_213_199(\0A\09.param .u64 fusion_5_a_inference_train_mnist_213_199_param_0,\0A\09.param .u64 fusion_5_a_inference_train_mnist_213_199_param_1,\0A\09.param .u64 fusion_5_a_inference_train_mnist_213_199_param_2,\0A\09.param .u64 fusion_5_a_inference_train_mnist_213_199_param_3,\0A\09.param .u64 fusion_5_a_inference_train_mnist_213_199_param_4,\0A\09.param .u64 fusion_5_a_inference_train_mnist_213_199_param_5\0A)\0A.reqntid 1, 1, 1\0A{\0A\09.reg .pred \09%p<48>;\0A\09.reg .b32 \09%r<47>;\0A\09.reg .f32 \09%f<185>;\0A\09.reg .b64 \09%rd<15>;\0A\0A\09ld.param.u64 \09%rd5, [fusion_5_a_inference_train_mnist_213_199_param_0];\0A\09ld.param.u64 \09%rd7, [fusion_5_a_inference_train_mnist_213_199_param_1];\0A\09ld.param.u64 \09%rd9, [fusion_5_a_inference_train_mnist_213_199_param_2];\0A\09ld.param.u64 \09%rd10, [fusion_5_a_inference_train_mnist_213_199_param_3];\0A\09cvta.to.global.u64 \09%rd11, %rd10;\0A\09cvta.to.global.u64 \09%rd12, %rd9;\0A\09cvta.to.global.u64 \09%rd13, %rd7;\0A\09ld.global.nc.f32 \09%f1, [%rd13];\0A\09ld.global.nc.f32 \09%f2, [%rd12];\0A\09ld.global.nc.u64 \09%rd14, [%rd11];\0A\09add.s64 \09%rd4, %rd14, 1;\0A\09cvt.rn.f32.s64 \09%f3, %rd4;\0A\09mul.rn.f32 \09%f28, %f3, 0f3F000000;\0A\09cvt.rzi.f32.f32 \09%f29, %f28;\0A\09add.rn.f32 \09%f30, %f29, %f29;\0A\09sub.rn.f32 \09%f31, %f3, %f30;\0A\09abs.f32 \09%f4, %f31;\0A\09setp.eq.f32 \09%p3, %f4, 0f3F800000;\0A\09abs.f32 \09%f5, %f2;\0A\09abs.f32 \09%f6, %f3;\0A\09setp.gt.f32 \09%p6, %f6, 0f77F684DF;\0A\09mul.rn.f32 \09%f72, %f3, 0f39000000;\0A\09selp.f32 \09%f7, %f72, %f3, %p6;\0A\09setp.lt.f32 \09%p10, %f2, 0f00000000;\0A\09and.pred  \09%p1, %p10, %p3;\0A\09setp.neu.f32 \09%p11, %f2, 0f00000000;\0A\09@%p11 bra \09LBB0_2;\0A\09add.rn.f32 \09%f98, %f2, %f2;\0A\09mov.b32 \09%r13, %f98;\0A\09selp.b32 \09%r14, %r13, 0, %p3;\0A\09setp.lt.s64 \09%p13, %rd4, 0;\0A\09or.b32  \09%r15, %r14, 2139095040;\0A\09selp.b32 \09%r16, %r15, %r14, %p13;\0A\09mov.b32 \09%f182, %r16;\0A\09bra.uni \09LBB0_3;\0ALBB0_2:\0A\09setp.lt.f32 \09%p4, %f5, 0f00800000;\0A\09selp.f32 \09%f32, 0fC3170000, 0fC2FE0000, %p4;\0A\09mul.rn.f32 \09%f33, %f5, 0f4B800000;\0A\09selp.f32 \09%f34, %f33, %f5, %p4;\0A\09mov.b32 \09%r1, %f34;\0A\09and.b32  \09%r2, %r1, 8388607;\0A\09or.b32  \09%r3, %r2, 1065353216;\0A\09mov.b32 \09%f35, %r3;\0A\09shr.u32 \09%r4, %r1, 23;\0A\09cvt.rn.f32.u32 \09%f36, %r4;\0A\09add.rn.f32 \09%f37, %f32, %f36;\0A\09setp.gt.f32 \09%p5, %f35, 0f3FB504F3;\0A\09mul.rn.f32 \09%f38, %f35, 0f3F000000;\0A\09add.rn.f32 \09%f39, %f37, 0f3F800000;\0A\09selp.f32 \09%f40, %f39, %f37, %p5;\0A\09selp.f32 \09%f41, %f38, %f35, %p5;\0A\09add.rn.f32 \09%f42, %f41, 0fBF800000;\0A\09add.rn.f32 \09%f27, %f41, 0f3F800000;\0A\09// begin inline asm\0A\09rcp.approx.ftz.f32 %f26,%f27;\0A\09// end inline asm\0A\09add.rn.f32 \09%f43, %f42, %f42;\0A\09mul.rn.f32 \09%f44, %f26, %f43;\0A\09mul.rn.f32 \09%f45, %f44, %f44;\0A\09fma.rn.f32 \09%f46, %f45, 0f3B18F0FE, 0f3C4CAF63;\0A\09fma.rn.f32 \09%f47, %f46, %f45, 0f3DAAAABD;\0A\09mul.rn.f32 \09%f48, %f45, %f47;\0A\09mul.rn.f32 \09%f49, %f44, %f48;\0A\09sub.rn.f32 \09%f50, %f42, %f44;\0A\09add.rn.f32 \09%f51, %f50, %f50;\0A\09neg.f32 \09%f52, %f44;\0A\09fma.rn.f32 \09%f53, %f52, %f42, %f51;\0A\09mul.rn.f32 \09%f54, %f26, %f53;\0A\09add.rn.f32 \09%f55, %f44, %f49;\0A\09sub.rn.f32 \09%f56, %f44, %f55;\0A\09add.rn.f32 \09%f57, %f49, %f56;\0A\09add.rn.f32 \09%f58, %f54, %f57;\0A\09add.rn.f32 \09%f59, %f55, %f58;\0A\09sub.rn.f32 \09%f60, %f55, %f59;\0A\09add.rn.f32 \09%f61, %f58, %f60;\0A\09mul.rn.f32 \09%f62, %f40, 0f3F317200;\0A\09mul.rn.f32 \09%f63, %f40, 0f35BFBE8E;\0A\09add.rn.f32 \09%f64, %f62, %f59;\0A\09sub.rn.f32 \09%f65, %f62, %f64;\0A\09add.rn.f32 \09%f66, %f59, %f65;\0A\09add.rn.f32 \09%f67, %f61, %f66;\0A\09add.rn.f32 \09%f68, %f63, %f67;\0A\09add.rn.f32 \09%f69, %f64, %f68;\0A\09sub.rn.f32 \09%f70, %f64, %f69;\0A\09add.rn.f32 \09%f71, %f68, %f70;\0A\09mul.rn.f32 \09%f73, %f7, %f69;\0A\09neg.f32 \09%f74, %f73;\0A\09fma.rn.f32 \09%f75, %f7, %f69, %f74;\0A\09fma.rn.f32 \09%f76, %f7, %f71, %f75;\0A\09fma.rn.f32 \09%f77, %f69, 0f00000000, %f76;\0A\09add.rn.f32 \09%f78, %f73, %f77;\0A\09sub.rn.f32 \09%f79, %f73, %f78;\0A\09add.rn.f32 \09%f80, %f77, %f79;\0A\09mov.b32 \09%r5, %f78;\0A\09setp.eq.s32 \09%p7, %r5, 1118925336;\0A\09add.rn.f32 \09%f81, %f80, 0f37000000;\0A\09selp.f32 \09%f82, %f81, %f80, %p7;\0A\09selp.f32 \09%f83, 0f42B17217, %f78, %p7;\0A\09mul.rn.f32 \09%f84, %f83, 0f3FB8AA3B;\0A\09cvt.rzi.f32.f32 \09%f85, %f84;\0A\09abs.f32 \09%f86, %f85;\0A\09setp.gt.f32 \09%p8, %f86, 0f42FC0000;\0A\09mov.b32 \09%r6, %f85;\0A\09and.b32  \09%r7, %r6, -2147483648;\0A\09or.b32  \09%r8, %r7, 1123811328;\0A\09mov.b32 \09%f87, %r8;\0A\09selp.f32 \09%f88, %f87, %f85, %p8;\0A\09fma.rn.f32 \09%f89, %f88, 0fBF317218, %f83;\0A\09fma.rn.f32 \09%f90, %f88, 0f3102E308, %f89;\0A\09mul.rn.f32 \09%f91, %f90, 0f3FB8AA3B;\0A\09add.rn.f32 \09%f92, %f88, 0f4B40007F;\0A\09mov.b32 \09%r9, %f92;\0A\09shl.b32 \09%r10, %r9, 23;\0A\09mov.b32 \09%f93, %r10;\0A\09ex2.approx.ftz.f32 \09%f94, %f91;\0A\09mul.rn.f32 \09%f95, %f94, %f93;\0A\09setp.neu.f32 \09%p9, %f95, 0f7F800000;\0A\09fma.rn.f32 \09%f96, %f95, %f82, %f95;\0A\09selp.f32 \09%f8, %f96, %f95, %p9;\0A\09mov.b32 \09%r11, %f8;\0A\09xor.b32  \09%r12, %r11, -2147483648;\0A\09mov.b32 \09%f97, %r12;\0A\09selp.f32 \09%f182, %f97, %f8, %p1;\0ALBB0_3:\0A\09cvta.to.global.u64 \09%rd3, %rd5;\0A\09add.rn.f32 \09%f99, %f5, %f6;\0A\09mov.b32 \09%r17, %f99;\0A\09setp.lt.s32 \09%p14, %r17, 2139095040;\0A\09setp.gtu.f32 \09%p47, %f6, 0f7F800000;\0A\09@%p14 bra \09LBB0_10;\0A\09setp.gtu.f32 \09%p15, %f5, 0f7F800000;\0A\09or.pred  \09%p17, %p15, %p47;\0A\09@!%p17 bra \09LBB0_6;\0A\09bra.uni \09LBB0_5;\0ALBB0_5:\0A\09add.rn.f32 \09%f182, %f2, %f3;\0A\09bra.uni \09LBB0_10;\0ALBB0_6:\0A\09setp.neu.f32 \09%p18, %f6, 0f7F800000;\0A\09@%p18 bra \09LBB0_8;\0A\09setp.gt.f32 \09%p21, %f5, 0f3F800000;\0A\09selp.b32 \09%r21, 2139095040, 0, %p21;\0A\09setp.lt.s64 \09%p22, %rd4, 0;\0A\09xor.b32  \09%r22, %r21, 2139095040;\0A\09selp.b32 \09%r23, %r22, %r21, %p22;\0A\09setp.eq.f32 \09%p23, %f2, 0fBF800000;\0A\09mov.b32 \09%f100, %r23;\0A\09selp.f32 \09%f182, 0f3F800000, %f100, %p23;\0A\09bra.uni \09LBB0_10;\0ALBB0_8:\0A\09setp.neu.f32 \09%p19, %f5, 0f7F800000;\0A\09@%p19 bra \09LBB0_10;\0A\09setp.gt.s64 \09%p20, %rd4, -1;\0A\09selp.b32 \09%r18, 2139095040, 0, %p20;\0A\09or.b32  \09%r19, %r18, -2147483648;\0A\09selp.b32 \09%r20, %r19, %r18, %p1;\0A\09mov.b32 \09%f182, %r20;\0ALBB0_10:\0A\09ld.param.u64 \09%rd6, [fusion_5_a_inference_train_mnist_213_199_param_5];\0A\09ld.param.u64 \09%rd8, [fusion_5_a_inference_train_mnist_213_199_param_4];\0A\09ld.global.nc.f32 \09%f16, [%rd3];\0A\09abs.f32 \09%f17, %f16;\0A\09setp.lt.f32 \09%p30, %f16, 0f00000000;\0A\09and.pred  \09%p2, %p30, %p3;\0A\09setp.neu.f32 \09%p31, %f16, 0f00000000;\0A\09@%p31 bra \09LBB0_12;\0A\09add.rn.f32 \09%f168, %f16, %f16;\0A\09mov.b32 \09%r36, %f168;\0A\09selp.b32 \09%r37, %r36, 0, %p3;\0A\09setp.lt.s64 \09%p33, %rd4, 0;\0A\09or.b32  \09%r38, %r37, 2139095040;\0A\09selp.b32 \09%r39, %r38, %r37, %p33;\0A\09mov.b32 \09%f184, %r39;\0A\09bra.uni \09LBB0_13;\0ALBB0_12:\0A\09setp.lt.f32 \09%p25, %f17, 0f00800000;\0A\09selp.f32 \09%f103, 0fC3170000, 0fC2FE0000, %p25;\0A\09mul.rn.f32 \09%f104, %f17, 0f4B800000;\0A\09selp.f32 \09%f105, %f104, %f17, %p25;\0A\09mov.b32 \09%r24, %f105;\0A\09and.b32  \09%r25, %r24, 8388607;\0A\09or.b32  \09%r26, %r25, 1065353216;\0A\09mov.b32 \09%f106, %r26;\0A\09shr.u32 \09%r27, %r24, 23;\0A\09cvt.rn.f32.u32 \09%f107, %r27;\0A\09add.rn.f32 \09%f108, %f103, %f107;\0A\09setp.gt.f32 \09%p26, %f106, 0f3FB504F3;\0A\09mul.rn.f32 \09%f109, %f106, 0f3F000000;\0A\09add.rn.f32 \09%f110, %f108, 0f3F800000;\0A\09selp.f32 \09%f111, %f110, %f108, %p26;\0A\09selp.f32 \09%f112, %f109, %f106, %p26;\0A\09add.rn.f32 \09%f113, %f112, 0fBF800000;\0A\09add.rn.f32 \09%f102, %f112, 0f3F800000;\0A\09// begin inline asm\0A\09rcp.approx.ftz.f32 %f101,%f102;\0A\09// end inline asm\0A\09add.rn.f32 \09%f114, %f113, %f113;\0A\09mul.rn.f32 \09%f115, %f101, %f114;\0A\09mul.rn.f32 \09%f116, %f115, %f115;\0A\09fma.rn.f32 \09%f117, %f116, 0f3B18F0FE, 0f3C4CAF63;\0A\09fma.rn.f32 \09%f118, %f117, %f116, 0f3DAAAABD;\0A\09mul.rn.f32 \09%f119, %f116, %f118;\0A\09mul.rn.f32 \09%f120, %f115, %f119;\0A\09sub.rn.f32 \09%f121, %f113, %f115;\0A\09add.rn.f32 \09%f122, %f121, %f121;\0A\09neg.f32 \09%f123, %f115;\0A\09fma.rn.f32 \09%f124, %f123, %f113, %f122;\0A\09mul.rn.f32 \09%f125, %f101, %f124;\0A\09add.rn.f32 \09%f126, %f115, %f120;\0A\09sub.rn.f32 \09%f127, %f115, %f126;\0A\09add.rn.f32 \09%f128, %f120, %f127;\0A\09add.rn.f32 \09%f129, %f125, %f128;\0A\09add.rn.f32 \09%f130, %f126, %f129;\0A\09sub.rn.f32 \09%f131, %f126, %f130;\0A\09add.rn.f32 \09%f132, %f129, %f131;\0A\09mul.rn.f32 \09%f133, %f111, 0f3F317200;\0A\09mul.rn.f32 \09%f134, %f111, 0f35BFBE8E;\0A\09add.rn.f32 \09%f135, %f133, %f130;\0A\09sub.rn.f32 \09%f136, %f133, %f135;\0A\09add.rn.f32 \09%f137, %f130, %f136;\0A\09add.rn.f32 \09%f138, %f132, %f137;\0A\09add.rn.f32 \09%f139, %f134, %f138;\0A\09add.rn.f32 \09%f140, %f135, %f139;\0A\09sub.rn.f32 \09%f141, %f135, %f140;\0A\09add.rn.f32 \09%f142, %f139, %f141;\0A\09mul.rn.f32 \09%f143, %f7, %f140;\0A\09neg.f32 \09%f144, %f143;\0A\09fma.rn.f32 \09%f145, %f7, %f140, %f144;\0A\09fma.rn.f32 \09%f146, %f7, %f142, %f145;\0A\09fma.rn.f32 \09%f147, %f140, 0f00000000, %f146;\0A\09add.rn.f32 \09%f148, %f143, %f147;\0A\09sub.rn.f32 \09%f149, %f143, %f148;\0A\09add.rn.f32 \09%f150, %f147, %f149;\0A\09mov.b32 \09%r28, %f148;\0A\09setp.eq.s32 \09%p27, %r28, 1118925336;\0A\09add.rn.f32 \09%f151, %f150, 0f37000000;\0A\09selp.f32 \09%f152, %f151, %f150, %p27;\0A\09selp.f32 \09%f153, 0f42B17217, %f148, %p27;\0A\09mul.rn.f32 \09%f154, %f153, 0f3FB8AA3B;\0A\09cvt.rzi.f32.f32 \09%f155, %f154;\0A\09abs.f32 \09%f156, %f155;\0A\09setp.gt.f32 \09%p28, %f156, 0f42FC0000;\0A\09mov.b32 \09%r29, %f155;\0A\09and.b32  \09%r30, %r29, -2147483648;\0A\09or.b32  \09%r31, %r30, 1123811328;\0A\09mov.b32 \09%f157, %r31;\0A\09selp.f32 \09%f158, %f157, %f155, %p28;\0A\09fma.rn.f32 \09%f159, %f158, 0fBF317218, %f153;\0A\09fma.rn.f32 \09%f160, %f158, 0f3102E308, %f159;\0A\09mul.rn.f32 \09%f161, %f160, 0f3FB8AA3B;\0A\09add.rn.f32 \09%f162, %f158, 0f4B40007F;\0A\09mov.b32 \09%r32, %f162;\0A\09shl.b32 \09%r33, %r32, 23;\0A\09mov.b32 \09%f163, %r33;\0A\09ex2.approx.ftz.f32 \09%f164, %f161;\0A\09mul.rn.f32 \09%f165, %f164, %f163;\0A\09setp.neu.f32 \09%p29, %f165, 0f7F800000;\0A\09fma.rn.f32 \09%f166, %f165, %f152, %f165;\0A\09selp.f32 \09%f18, %f166, %f165, %p29;\0A\09mov.b32 \09%r34, %f18;\0A\09xor.b32  \09%r35, %r34, -2147483648;\0A\09mov.b32 \09%f167, %r35;\0A\09selp.f32 \09%f184, %f167, %f18, %p2;\0ALBB0_13:\0A\09cvta.to.global.u64 \09%rd1, %rd6;\0A\09cvta.to.global.u64 \09%rd2, %rd8;\0A\09add.rn.f32 \09%f169, %f6, %f17;\0A\09mov.b32 \09%r40, %f169;\0A\09setp.lt.s32 \09%p34, %r40, 2139095040;\0A\09@%p34 bra \09LBB0_20;\0A\09setp.gtu.f32 \09%p35, %f17, 0f7F800000;\0A\09or.pred  \09%p37, %p35, %p47;\0A\09@!%p37 bra \09LBB0_16;\0A\09bra.uni \09LBB0_15;\0ALBB0_15:\0A\09add.rn.f32 \09%f184, %f16, %f3;\0A\09bra.uni \09LBB0_20;\0ALBB0_16:\0A\09setp.neu.f32 \09%p38, %f6, 0f7F800000;\0A\09@%p38 bra \09LBB0_18;\0A\09setp.gt.f32 \09%p41, %f17, 0f3F800000;\0A\09selp.b32 \09%r44, 2139095040, 0, %p41;\0A\09setp.lt.s64 \09%p42, %rd4, 0;\0A\09xor.b32  \09%r45, %r44, 2139095040;\0A\09selp.b32 \09%r46, %r45, %r44, %p42;\0A\09setp.eq.f32 \09%p43, %f16, 0fBF800000;\0A\09mov.b32 \09%f170, %r46;\0A\09selp.f32 \09%f184, 0f3F800000, %f170, %p43;\0A\09bra.uni \09LBB0_20;\0ALBB0_18:\0A\09setp.neu.f32 \09%p39, %f17, 0f7F800000;\0A\09@%p39 bra \09LBB0_20;\0A\09setp.gt.s64 \09%p40, %rd4, -1;\0A\09selp.b32 \09%r41, 2139095040, 0, %p40;\0A\09or.b32  \09%r42, %r41, -2147483648;\0A\09selp.b32 \09%r43, %r42, %r41, %p2;\0A\09mov.b32 \09%f184, %r43;\0ALBB0_20:\0A\09setp.eq.s64 \09%p44, %rd4, 0;\0A\09setp.eq.f32 \09%p45, %f2, 0f3F800000;\0A\09mov.f32 \09%f171, 0f3F800000;\0A\09sub.rn.f32 \09%f172, %f171, %f182;\0A\09selp.f32 \09%f173, 0f00000000, %f172, %p44;\0A\09selp.f32 \09%f174, 0f00000000, %f173, %p45;\0A\09sqrt.approx.f32 \09%f175, %f174;\0A\09mul.rn.f32 \09%f176, %f1, %f175;\0A\09setp.eq.f32 \09%p46, %f16, 0f3F800000;\0A\09sub.rn.f32 \09%f177, %f171, %f184;\0A\09selp.f32 \09%f178, 0f00000000, %f177, %p44;\0A\09selp.f32 \09%f179, 0f00000000, %f178, %p46;\0A\09div.full.f32 \09%f180, %f176, %f179;\0A\09st.global.f32 \09[%rd2], %f180;\0A\09st.global.u64 \09[%rd1], %rd4;\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @gpu_module_5(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09fusion_3_a_inference_train_mnist_213_199\0A\0A.visible .entry fusion_3_a_inference_train_mnist_213_199(\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_0,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_1,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_2,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_3,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_4,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_5,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_6,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_7,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_8,\0A\09.param .u64 fusion_3_a_inference_train_mnist_213_199_param_9\0A)\0A.reqntid 256, 1, 1\0A{\0A\09.reg .pred \09%p<2>;\0A\09.reg .b32 \09%r<6>;\0A\09.reg .f32 \09%f<71>;\0A\09.reg .b64 \09%rd<29>;\0A\0A\09mov.u32 \09%r2, %ctaid.x;\0A\09mov.u32 \09%r3, %tid.x;\0A\09shl.b32 \09%r4, %r2, 10;\0A\09shl.b32 \09%r5, %r3, 2;\0A\09or.b32  \09%r1, %r4, %r5;\0A\09setp.lt.u32 \09%p1, %r1, 7840;\0A\09@%p1 bra \09LBB0_2;\0A\09bra.uni \09LBB0_1;\0ALBB0_2:\0A\09ld.param.u64 \09%rd11, [fusion_3_a_inference_train_mnist_213_199_param_0];\0A\09ld.param.u64 \09%rd12, [fusion_3_a_inference_train_mnist_213_199_param_9];\0A\09cvta.to.global.u64 \09%rd1, %rd12;\0A\09ld.param.u64 \09%rd13, [fusion_3_a_inference_train_mnist_213_199_param_1];\0A\09ld.param.u64 \09%rd14, [fusion_3_a_inference_train_mnist_213_199_param_8];\0A\09cvta.to.global.u64 \09%rd2, %rd14;\0A\09ld.param.u64 \09%rd15, [fusion_3_a_inference_train_mnist_213_199_param_2];\0A\09ld.param.u64 \09%rd16, [fusion_3_a_inference_train_mnist_213_199_param_7];\0A\09cvta.to.global.u64 \09%rd3, %rd16;\0A\09ld.param.u64 \09%rd17, [fusion_3_a_inference_train_mnist_213_199_param_3];\0A\09ld.param.u64 \09%rd18, [fusion_3_a_inference_train_mnist_213_199_param_6];\0A\09cvta.to.global.u64 \09%rd4, %rd18;\0A\09ld.param.u64 \09%rd19, [fusion_3_a_inference_train_mnist_213_199_param_4];\0A\09ld.param.u64 \09%rd20, [fusion_3_a_inference_train_mnist_213_199_param_5];\0A\09cvta.to.global.u64 \09%rd5, %rd20;\0A\09cvta.to.global.u64 \09%rd6, %rd19;\0A\09cvta.to.global.u64 \09%rd7, %rd17;\0A\09cvta.to.global.u64 \09%rd8, %rd15;\0A\09cvta.to.global.u64 \09%rd9, %rd13;\0A\09cvta.to.global.u64 \09%rd10, %rd11;\0A\09mul.wide.u32 \09%rd21, %r1, 4;\0A\09add.s64 \09%rd22, %rd10, %rd21;\0A\09ld.global.nc.v4.f32 \09{%f1, %f2, %f3, %f4}, [%rd22];\0A\09add.s64 \09%rd23, %rd8, %rd21;\0A\09ld.global.nc.v4.f32 \09{%f5, %f6, %f7, %f8}, [%rd23];\0A\09add.s64 \09%rd24, %rd6, %rd21;\0A\09ld.global.nc.v4.f32 \09{%f9, %f10, %f11, %f12}, [%rd24];\0A\09sub.rn.f32 \09%f13, %f9, %f5;\0A\09ld.global.nc.f32 \09%f14, [%rd7];\0A\09mov.f32 \09%f15, 0f3F800000;\0A\09sub.rn.f32 \09%f16, %f15, %f14;\0A\09mul.rn.f32 \09%f17, %f13, %f16;\0A\09add.rn.f32 \09%f18, %f5, %f17;\0A\09ld.global.nc.f32 \09%f19, [%rd9];\0A\09mul.rn.f32 \09%f20, %f19, %f18;\0A\09add.s64 \09%rd25, %rd5, %rd21;\0A\09ld.global.nc.v4.f32 \09{%f21, %f22, %f23, %f24}, [%rd25];\0A\09mul.rn.f32 \09%f25, %f9, %f9;\0A\09sub.rn.f32 \09%f26, %f25, %f21;\0A\09ld.global.nc.f32 \09%f27, [%rd4];\0A\09sub.rn.f32 \09%f28, %f15, %f27;\0A\09mul.rn.f32 \09%f29, %f26, %f28;\0A\09add.rn.f32 \09%f30, %f21, %f29;\0A\09sqrt.approx.f32 \09%f31, %f30;\0A\09add.rn.f32 \09%f32, %f31, 0f33D6BF95;\0A\09div.full.f32 \09%f33, %f20, %f32;\0A\09sub.rn.f32 \09%f34, %f1, %f33;\0A\09add.s64 \09%rd26, %rd3, %rd21;\0A\09add.s64 \09%rd27, %rd2, %rd21;\0A\09add.s64 \09%rd28, %rd1, %rd21;\0A\09sub.rn.f32 \09%f35, %f10, %f6;\0A\09mul.rn.f32 \09%f36, %f16, %f35;\0A\09add.rn.f32 \09%f37, %f6, %f36;\0A\09mul.rn.f32 \09%f38, %f19, %f37;\0A\09mul.rn.f32 \09%f39, %f10, %f10;\0A\09sub.rn.f32 \09%f40, %f39, %f22;\0A\09mul.rn.f32 \09%f41, %f28, %f40;\0A\09add.rn.f32 \09%f42, %f22, %f41;\0A\09sqrt.approx.f32 \09%f43, %f42;\0A\09add.rn.f32 \09%f44, %f43, 0f33D6BF95;\0A\09div.full.f32 \09%f45, %f38, %f44;\0A\09sub.rn.f32 \09%f46, %f2, %f45;\0A\09sub.rn.f32 \09%f47, %f11, %f7;\0A\09mul.rn.f32 \09%f48, %f16, %f47;\0A\09add.rn.f32 \09%f49, %f7, %f48;\0A\09mul.rn.f32 \09%f50, %f19, %f49;\0A\09mul.rn.f32 \09%f51, %f11, %f11;\0A\09sub.rn.f32 \09%f52, %f51, %f23;\0A\09mul.rn.f32 \09%f53, %f28, %f52;\0A\09add.rn.f32 \09%f54, %f23, %f53;\0A\09sqrt.approx.f32 \09%f55, %f54;\0A\09add.rn.f32 \09%f56, %f55, 0f33D6BF95;\0A\09div.full.f32 \09%f57, %f50, %f56;\0A\09sub.rn.f32 \09%f58, %f3, %f57;\0A\09sub.rn.f32 \09%f59, %f12, %f8;\0A\09mul.rn.f32 \09%f60, %f16, %f59;\0A\09add.rn.f32 \09%f61, %f8, %f60;\0A\09mul.rn.f32 \09%f62, %f19, %f61;\0A\09mul.rn.f32 \09%f63, %f12, %f12;\0A\09sub.rn.f32 \09%f64, %f63, %f24;\0A\09mul.rn.f32 \09%f65, %f28, %f64;\0A\09add.rn.f32 \09%f66, %f24, %f65;\0A\09sqrt.approx.f32 \09%f67, %f66;\0A\09add.rn.f32 \09%f68, %f67, 0f33D6BF95;\0A\09div.full.f32 \09%f69, %f62, %f68;\0A\09sub.rn.f32 \09%f70, %f4, %f69;\0A\09st.global.v4.f32 \09[%rd26], {%f34, %f46, %f58, %f70};\0A\09st.global.v4.f32 \09[%rd27], {%f18, %f37, %f49, %f61};\0A\09st.global.v4.f32 \09[%rd28], {%f30, %f42, %f54, %f66};\0ALBB0_1:\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @gpu_module_6(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.module {
  %0 = tfrt_gpu.module.load %arg0 {data = "//\0A// Generated by LLVM NVPTX Back-End\0A//\0A\0A.version 6.0\0A.target sm_52\0A.address_size 64\0A\0A\09// .globl\09fusion_a_inference_train_mnist_213\0A\0A.visible .entry fusion_a_inference_train_mnist_213(\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_0,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_1,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_2,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_3,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_4,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_5,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_6,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_7,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_8,\0A\09.param .u64 fusion_a_inference_train_mnist_213_param_9\0A)\0A.reqntid 5, 1, 1\0A{\0A\09.reg .b32 \09%r<3>;\0A\09.reg .f32 \09%f<39>;\0A\09.reg .b64 \09%rd<29>;\0A\0A\09ld.param.u64 \09%rd1, [fusion_a_inference_train_mnist_213_param_0];\0A\09ld.param.u64 \09%rd2, [fusion_a_inference_train_mnist_213_param_9];\0A\09cvta.to.global.u64 \09%rd3, %rd2;\0A\09ld.param.u64 \09%rd4, [fusion_a_inference_train_mnist_213_param_1];\0A\09ld.param.u64 \09%rd5, [fusion_a_inference_train_mnist_213_param_8];\0A\09cvta.to.global.u64 \09%rd6, %rd5;\0A\09ld.param.u64 \09%rd7, [fusion_a_inference_train_mnist_213_param_2];\0A\09ld.param.u64 \09%rd8, [fusion_a_inference_train_mnist_213_param_7];\0A\09cvta.to.global.u64 \09%rd9, %rd8;\0A\09ld.param.u64 \09%rd10, [fusion_a_inference_train_mnist_213_param_3];\0A\09ld.param.u64 \09%rd11, [fusion_a_inference_train_mnist_213_param_6];\0A\09cvta.to.global.u64 \09%rd12, %rd11;\0A\09ld.param.u64 \09%rd13, [fusion_a_inference_train_mnist_213_param_4];\0A\09ld.param.u64 \09%rd14, [fusion_a_inference_train_mnist_213_param_5];\0A\09cvta.to.global.u64 \09%rd15, %rd14;\0A\09cvta.to.global.u64 \09%rd16, %rd13;\0A\09cvta.to.global.u64 \09%rd17, %rd10;\0A\09cvta.to.global.u64 \09%rd18, %rd7;\0A\09cvta.to.global.u64 \09%rd19, %rd4;\0A\09cvta.to.global.u64 \09%rd20, %rd1;\0A\09mov.u32 \09%r1, %tid.x;\0A\09shl.b32 \09%r2, %r1, 1;\0A\09mul.wide.u32 \09%rd21, %r2, 4;\0A\09add.s64 \09%rd22, %rd20, %rd21;\0A\09ld.global.nc.v2.f32 \09{%f1, %f2}, [%rd22];\0A\09add.s64 \09%rd23, %rd18, %rd21;\0A\09ld.global.nc.v2.f32 \09{%f3, %f4}, [%rd23];\0A\09add.s64 \09%rd24, %rd16, %rd21;\0A\09ld.global.nc.v2.f32 \09{%f5, %f6}, [%rd24];\0A\09sub.rn.f32 \09%f7, %f5, %f3;\0A\09ld.global.nc.f32 \09%f8, [%rd17];\0A\09mov.f32 \09%f9, 0f3F800000;\0A\09sub.rn.f32 \09%f10, %f9, %f8;\0A\09mul.rn.f32 \09%f11, %f7, %f10;\0A\09add.rn.f32 \09%f12, %f3, %f11;\0A\09ld.global.nc.f32 \09%f13, [%rd19];\0A\09mul.rn.f32 \09%f14, %f13, %f12;\0A\09add.s64 \09%rd25, %rd15, %rd21;\0A\09ld.global.nc.v2.f32 \09{%f15, %f16}, [%rd25];\0A\09mul.rn.f32 \09%f17, %f5, %f5;\0A\09sub.rn.f32 \09%f18, %f17, %f15;\0A\09ld.global.nc.f32 \09%f19, [%rd12];\0A\09sub.rn.f32 \09%f20, %f9, %f19;\0A\09mul.rn.f32 \09%f21, %f18, %f20;\0A\09add.rn.f32 \09%f22, %f15, %f21;\0A\09sqrt.approx.f32 \09%f23, %f22;\0A\09add.rn.f32 \09%f24, %f23, 0f33D6BF95;\0A\09div.full.f32 \09%f25, %f14, %f24;\0A\09sub.rn.f32 \09%f26, %f1, %f25;\0A\09add.s64 \09%rd26, %rd9, %rd21;\0A\09add.s64 \09%rd27, %rd6, %rd21;\0A\09add.s64 \09%rd28, %rd3, %rd21;\0A\09sub.rn.f32 \09%f27, %f6, %f4;\0A\09mul.rn.f32 \09%f28, %f10, %f27;\0A\09add.rn.f32 \09%f29, %f4, %f28;\0A\09mul.rn.f32 \09%f30, %f13, %f29;\0A\09mul.rn.f32 \09%f31, %f6, %f6;\0A\09sub.rn.f32 \09%f32, %f31, %f16;\0A\09mul.rn.f32 \09%f33, %f20, %f32;\0A\09add.rn.f32 \09%f34, %f16, %f33;\0A\09sqrt.approx.f32 \09%f35, %f34;\0A\09add.rn.f32 \09%f36, %f35, 0f33D6BF95;\0A\09div.full.f32 \09%f37, %f30, %f36;\0A\09sub.rn.f32 \09%f38, %f2, %f37;\0A\09st.global.v2.f32 \09[%rd26], {%f26, %f38};\0A\09st.global.v2.f32 \09[%rd27], {%f12, %f29};\0A\09st.global.v2.f32 \09[%rd28], {%f22, %f34};\0A\09ret;\0A\0A}\0A\00"}
  tfrt.return %0 : !tfrt_gpu.module
}
func.func @tfrt_gpu.blas.create(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.blas.handle {
  %0 = tfrt_gpu.blas.create %arg0
  tfrt.return %0 : !tfrt_gpu.blas.handle
}
func.func @tfrt_gpu.blas.create_0(%arg0: !tfrt_gpu.context) -> !tfrt_gpu.blas.handle {
  %0 = tfrt_gpu.blas.create %arg0
  tfrt.return %0 : !tfrt_gpu.blas.handle
}
func.func @a_inference_train_mnist_213(
  %arg0: !tfrt.chain,
  %arg1: !tfrt_gpu.stream,
  %arg2: !tfrt_gpu.buffer {lmhlo.params = 0 : index},
  %arg3: !tfrt_gpu.buffer {lmhlo.params = 1 : index},
  %arg4: !tfrt_gpu.buffer {lmhlo.output_index = dense<0> : tensor<1xi64>, lmhlo.params = 2 : index},
  %arg5: !tfrt_gpu.buffer {lmhlo.output_index = dense<1> : tensor<1xi64>, lmhlo.params = 3 : index},
  %arg6: !tfrt_gpu.buffer {lmhlo.params = 4 : index},
  %arg7: !tfrt_gpu.buffer {lmhlo.output_index = dense<2> : tensor<1xi64>, lmhlo.params = 5 : index},
  %arg8: !tfrt_gpu.buffer {lmhlo.params = 6 : index},
  %arg9: !tfrt_gpu.buffer {lmhlo.params = 7 : index},
  %arg10: !tfrt_gpu.buffer {lmhlo.output_index = dense<3> : tensor<1xi64>, lmhlo.params = 8 : index},
  %arg11: !tfrt_gpu.buffer {lmhlo.output_index = dense<4> : tensor<1xi64>, lmhlo.params = 9 : index},
  %arg12: !tfrt_gpu.buffer {lmhlo.output_index = dense<5> : tensor<1xi64>, lmhlo.params = 10 : index},
  %arg13: !tfrt_gpu.buffer {lmhlo.output_index = dense<6> : tensor<1xi64>, lmhlo.params = 11 : index},
  %arg14: !tfrt_gpu.buffer {lmhlo.constant_name = "buffer_for_constant_66"},
  %arg15: !tfrt_gpu.buffer
) -> !tfrt.chain attributes {
  result_xla_shape = "(f32[784,10]{1,0}, f32[10]{0}, s64[], f32[784,10]{1,0}, f32[784,10]{1,0}, /*index=5*/f32[10]{0}, f32[10]{0})"
} {
  %0 = tfrt_gpu.stream.get_context %arg1
  %1 = tfrt.constant.ui64 0
  %2 = tfrt.constant.ui64 313600
  %3 = tfrt_gpu.mem.view %arg15, %1, %2
  %4 = tfrt.once @gpu_module(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %5 = tfrt_gpu.module.get_function %4 {name = "fusion_9_a_inference_train_mnist_213_199"}
  %6 = tfrt.constant.ui32 0
  %7 = tfrt.constant.ui64 77
  %8 = tfrt.constant.ui64 1
  %9 = tfrt.constant.ui64 256
  %10 = tfrt_gpu.function.launch %arg1, %5, blocks in (%7, %8, %8), threads in (%9, %8, %8), %6, %arg0, args(%arg2, %3) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer)
  %11 = tfrt.constant.ui64 4000
  %12 = tfrt_gpu.mem.view %arg15, %2, %11
  %13 = tfrt.once @gpu_module_0(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %14 = tfrt_gpu.module.get_function %13 {name = "broadcast_41_a_inference_train_mnist_213_199"}
  %15 = tfrt.constant.ui64 250
  %16 = tfrt_gpu.function.launch %arg1, %14, blocks in (%8, %8, %8), threads in (%15, %8, %8), %6, %10, args(%arg5, %12) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer)
  %17 = tfrt_gpu.mem.copy %12, %12, %arg1, %16 : !tfrt_gpu.buffer, !tfrt_gpu.buffer
  %18 = tfrt.constant.i32 10
  %19 = tfrt.constant.i32 100
  %20 = tfrt.constant.i32 784
  %21 = tfrt.constant.f32 1.000000e+00
  %22 = tfrt_gpu.blas.gemm.algo CUBLAS_GEMM_DEFAULT
  %23 = tfrt_gpu.stream.get_context %arg1
  %24 = tfrt.once @tfrt_gpu.blas.create(%23) : (!tfrt_gpu.context) -> (!tfrt_gpu.blas.handle)
  %25 = tfrt_gpu.blas.gemm %24, %arg1, CUBLAS_OP_N, CUBLAS_OP_N, %18, %19, %20, %21, %arg4, CUDA_R_32F, %18, %3, CUDA_R_32F, %20, %21, %12, CUDA_R_32F, %18, CUBLAS_COMPUTE_32F, %22, %17
  %26 = tfrt.constant.ui64 317696
  %27 = tfrt.constant.ui64 400
  %28 = tfrt_gpu.mem.view %arg15, %26, %27
  %29 = tfrt.once @gpu_module_1(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %30 = tfrt_gpu.module.get_function %29 {name = "reduce_71_a_inference_train_mnist_213_199"}
  %31 = tfrt.constant.ui64 25
  %32 = tfrt_gpu.function.launch %arg1, %30, blocks in (%8, %8, %8), threads in (%31, %8, %8), %6, %25, args(%12, %28) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer)
  %33 = tfrt.constant.ui64 318208
  %34 = tfrt_gpu.mem.view %arg15, %33, %27
  %35 = tfrt.once @gpu_module_2(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %36 = tfrt_gpu.module.get_function %35 {name = "fusion_10_a_inference_train_mnist_213_199"}
  %37 = tfrt_gpu.function.launch %arg1, %36, blocks in (%8, %8, %8), threads in (%31, %8, %8), %6, %32, args(%12, %28, %34) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer)
  %38 = tfrt.constant.ui64 349056
  %39 = tfrt.constant.ui64 40
  %40 = tfrt_gpu.mem.view %arg15, %38, %39
  %41 = tfrt.constant.ui64 344960
  %42 = tfrt_gpu.mem.view %arg15, %41, %11
  %43 = tfrt.once @gpu_module_3(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %44 = tfrt_gpu.module.get_function %43 {name = "input_fusion_reduce_a_inference_train_mnist_213_199"}
  %45 = tfrt.constant.ui64 1024
  %46 = tfrt_gpu.function.launch %arg1, %44, blocks in (%8, %8, %8), threads in (%45, %8, %8), %6, %37, args(%arg3, %34, %12, %28, %40, %42) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer)
  %47 = tfrt.constant.ui64 31360
  %48 = tfrt_gpu.mem.view %arg15, %2, %47
  %49 = tfrt.constant.f32 0.000000e+00
  %50 = tfrt_gpu.blas.gemm.algo CUBLAS_GEMM_DEFAULT
  %51 = tfrt_gpu.stream.get_context %arg1
  %52 = tfrt.once @tfrt_gpu.blas.create_0(%51) : (!tfrt_gpu.context) -> (!tfrt_gpu.blas.handle)
  %53 = tfrt_gpu.blas.gemm %52, %arg1, CUBLAS_OP_N, CUBLAS_OP_T, %18, %20, %19, %21, %42, CUDA_R_32F, %18, %3, CUDA_R_32F, %20, %49, %48, CUDA_R_32F, %18, CUBLAS_COMPUTE_32F, %50, %46
  %54 = tfrt.constant.ui64 4
  %55 = tfrt_gpu.mem.view %arg15, %41, %54
  %56 = tfrt.once @gpu_module_4(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %57 = tfrt_gpu.module.get_function %56 {name = "fusion_5_a_inference_train_mnist_213_199"}
  %58 = tfrt_gpu.function.launch %arg1, %57, blocks in (%8, %8, %8), threads in (%8, %8, %8), %6, %53, args(%arg8, %arg6, %arg9, %arg7, %55, %arg7) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer)
  %59 = tfrt.once @gpu_module_5(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %60 = tfrt_gpu.module.get_function %59 {name = "fusion_3_a_inference_train_mnist_213_199"}
  %61 = tfrt.constant.ui64 8
  %62 = tfrt_gpu.function.launch %arg1, %60, blocks in (%61, %8, %8), threads in (%9, %8, %8), %6, %58, args(%arg4, %55, %arg10, %arg8, %48, %arg11, %arg9, %arg4, %arg10, %arg11) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer)
  %63 = tfrt.once @gpu_module_6(%0) : (!tfrt_gpu.context) -> (!tfrt_gpu.module)
  %64 = tfrt_gpu.module.get_function %63 {name = "fusion_a_inference_train_mnist_213"}
  %65 = tfrt.constant.ui64 5
  %66 = tfrt_gpu.function.launch %arg1, %64, blocks in (%8, %8, %8), threads in (%65, %8, %8), %6, %62, args(%arg5, %55, %arg12, %arg8, %40, %arg13, %arg9, %arg5, %arg12, %arg13) : (!tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer, !tfrt_gpu.buffer)
  tfrt.return %66 : !tfrt.chain
}
