// Licensed under the Apache License, Version 2.0
// <LICENSE-APACHE or http://www.apache.org/licenses/LICENSE-2.0> or the MIT license
// <LICENSE-MIT or http://opensource.org/licenses/MIT>, at your option.
// All files in the project carrying such notice may not be copied, modified, or distributed
// except according to those terms.
//! Constants needed for the Interface Object
// #include <winapifamily.h>
use shared::minwindef::ULONG;
pub type IFTYPE = ULONG;
pub const MIN_IF_TYPE: IFTYPE = 1;
pub const IF_TYPE_OTHER: IFTYPE = 1;
pub const IF_TYPE_REGULAR_1822: IFTYPE = 2;
pub const IF_TYPE_HDH_1822: IFTYPE = 3;
pub const IF_TYPE_DDN_X25: IFTYPE = 4;
pub const IF_TYPE_RFC877_X25: IFTYPE = 5;
pub const IF_TYPE_ETHERNET_CSMACD: IFTYPE = 6;
pub const IF_TYPE_IS088023_CSMACD: IFTYPE = 7;
pub const IF_TYPE_ISO88024_TOKENBUS: IFTYPE = 8;
pub const IF_TYPE_ISO88025_TOKENRING: IFTYPE = 9;
pub const IF_TYPE_ISO88026_MAN: IFTYPE = 10;
pub const IF_TYPE_STARLAN: IFTYPE = 11;
pub const IF_TYPE_PROTEON_10MBIT: IFTYPE = 12;
pub const IF_TYPE_PROTEON_80MBIT: IFTYPE = 13;
pub const IF_TYPE_HYPERCHANNEL: IFTYPE = 14;
pub const IF_TYPE_FDDI: IFTYPE = 15;
pub const IF_TYPE_LAP_B: IFTYPE = 16;
pub const IF_TYPE_SDLC: IFTYPE = 17;
pub const IF_TYPE_DS1: IFTYPE = 18;
pub const IF_TYPE_E1: IFTYPE = 19;
pub const IF_TYPE_BASIC_ISDN: IFTYPE = 20;
pub const IF_TYPE_PRIMARY_ISDN: IFTYPE = 21;
pub const IF_TYPE_PROP_POINT2POINT_SERIAL: IFTYPE = 22;
pub const IF_TYPE_PPP: IFTYPE = 23;
pub const IF_TYPE_SOFTWARE_LOOPBACK: IFTYPE = 24;
pub const IF_TYPE_EON: IFTYPE = 25;
pub const IF_TYPE_ETHERNET_3MBIT: IFTYPE = 26;
pub const IF_TYPE_NSIP: IFTYPE = 27;
pub const IF_TYPE_SLIP: IFTYPE = 28;
pub const IF_TYPE_ULTRA: IFTYPE = 29;
pub const IF_TYPE_DS3: IFTYPE = 30;
pub const IF_TYPE_SIP: IFTYPE = 31;
pub const IF_TYPE_FRAMERELAY: IFTYPE = 32;
pub const IF_TYPE_RS232: IFTYPE = 33;
pub const IF_TYPE_PARA: IFTYPE = 34;
pub const IF_TYPE_ARCNET: IFTYPE = 35;
pub const IF_TYPE_ARCNET_PLUS: IFTYPE = 36;
pub const IF_TYPE_ATM: IFTYPE = 37;
pub const IF_TYPE_MIO_X25: IFTYPE = 38;
pub const IF_TYPE_SONET: IFTYPE = 39;
pub const IF_TYPE_X25_PLE: IFTYPE = 40;
pub const IF_TYPE_ISO88022_LLC: IFTYPE = 41;
pub const IF_TYPE_LOCALTALK: IFTYPE = 42;
pub const IF_TYPE_SMDS_DXI: IFTYPE = 43;
pub const IF_TYPE_FRAMERELAY_SERVICE: IFTYPE = 44;
pub const IF_TYPE_V35: IFTYPE = 45;
pub const IF_TYPE_HSSI: IFTYPE = 46;
pub const IF_TYPE_HIPPI: IFTYPE = 47;
pub const IF_TYPE_MODEM: IFTYPE = 48;
pub const IF_TYPE_AAL5: IFTYPE = 49;
pub const IF_TYPE_SONET_PATH: IFTYPE = 50;
pub const IF_TYPE_SONET_VT: IFTYPE = 51;
pub const IF_TYPE_SMDS_ICIP: IFTYPE = 52;
pub const IF_TYPE_PROP_VIRTUAL: IFTYPE = 53;
pub const IF_TYPE_PROP_MULTIPLEXOR: IFTYPE = 54;
pub const IF_TYPE_IEEE80212: IFTYPE = 55;
pub const IF_TYPE_FIBRECHANNEL: IFTYPE = 56;
pub const IF_TYPE_HIPPIINTERFACE: IFTYPE = 57;
pub const IF_TYPE_FRAMERELAY_INTERCONNECT: IFTYPE = 58;
pub const IF_TYPE_AFLANE_8023: IFTYPE = 59;
pub const IF_TYPE_AFLANE_8025: IFTYPE = 60;
pub const IF_TYPE_CCTEMUL: IFTYPE = 61;
pub const IF_TYPE_FASTETHER: IFTYPE = 62;
pub const IF_TYPE_ISDN: IFTYPE = 63;
pub const IF_TYPE_V11: IFTYPE = 64;
pub const IF_TYPE_V36: IFTYPE = 65;
pub const IF_TYPE_G703_64K: IFTYPE = 66;
pub const IF_TYPE_G703_2MB: IFTYPE = 67;
pub const IF_TYPE_QLLC: IFTYPE = 68;
pub const IF_TYPE_FASTETHER_FX: IFTYPE = 69;
pub const IF_TYPE_CHANNEL: IFTYPE = 70;
pub const IF_TYPE_IEEE80211: IFTYPE = 71;
pub const IF_TYPE_IBM370PARCHAN: IFTYPE = 72;
pub const IF_TYPE_ESCON: IFTYPE = 73;
pub const IF_TYPE_DLSW: IFTYPE = 74;
pub const IF_TYPE_ISDN_S: IFTYPE = 75;
pub const IF_TYPE_ISDN_U: IFTYPE = 76;
pub const IF_TYPE_LAP_D: IFTYPE = 77;
pub const IF_TYPE_IPSWITCH: IFTYPE = 78;
pub const IF_TYPE_RSRB: IFTYPE = 79;
pub const IF_TYPE_ATM_LOGICAL: IFTYPE = 80;
pub const IF_TYPE_DS0: IFTYPE = 81;
pub const IF_TYPE_DS0_BUNDLE: IFTYPE = 82;
pub const IF_TYPE_BSC: IFTYPE = 83;
pub const IF_TYPE_ASYNC: IFTYPE = 84;
pub const IF_TYPE_CNR: IFTYPE = 85;
pub const IF_TYPE_ISO88025R_DTR: IFTYPE = 86;
pub const IF_TYPE_EPLRS: IFTYPE = 87;
pub const IF_TYPE_ARAP: IFTYPE = 88;
pub const IF_TYPE_PROP_CNLS: IFTYPE = 89;
pub const IF_TYPE_HOSTPAD: IFTYPE = 90;
pub const IF_TYPE_TERMPAD: IFTYPE = 91;
pub const IF_TYPE_FRAMERELAY_MPI: IFTYPE = 92;
pub const IF_TYPE_X213: IFTYPE = 93;
pub const IF_TYPE_ADSL: IFTYPE = 94;
pub const IF_TYPE_RADSL: IFTYPE = 95;
pub const IF_TYPE_SDSL: IFTYPE = 96;
pub const IF_TYPE_VDSL: IFTYPE = 97;
pub const IF_TYPE_ISO88025_CRFPRINT: IFTYPE = 98;
pub const IF_TYPE_MYRINET: IFTYPE = 99;
pub const IF_TYPE_VOICE_EM: IFTYPE = 100;
pub const IF_TYPE_VOICE_FXO: IFTYPE = 101;
pub const IF_TYPE_VOICE_FXS: IFTYPE = 102;
pub const IF_TYPE_VOICE_ENCAP: IFTYPE = 103;
pub const IF_TYPE_VOICE_OVERIP: IFTYPE = 104;
pub const IF_TYPE_ATM_DXI: IFTYPE = 105;
pub const IF_TYPE_ATM_FUNI: IFTYPE = 106;
pub const IF_TYPE_ATM_IMA: IFTYPE = 107;
pub const IF_TYPE_PPPMULTILINKBUNDLE: IFTYPE = 108;
pub const IF_TYPE_IPOVER_CDLC: IFTYPE = 109;
pub const IF_TYPE_IPOVER_CLAW: IFTYPE = 110;
pub const IF_TYPE_STACKTOSTACK: IFTYPE = 111;
pub const IF_TYPE_VIRTUALIPADDRESS: IFTYPE = 112;
pub const IF_TYPE_MPC: IFTYPE = 113;
pub const IF_TYPE_IPOVER_ATM: IFTYPE = 114;
pub const IF_TYPE_ISO88025_FIBER: IFTYPE = 115;
pub const IF_TYPE_TDLC: IFTYPE = 116;
pub const IF_TYPE_GIGABITETHERNET: IFTYPE = 117;
pub const IF_TYPE_HDLC: IFTYPE = 118;
pub const IF_TYPE_LAP_F: IFTYPE = 119;
pub const IF_TYPE_V37: IFTYPE = 120;
pub const IF_TYPE_X25_MLP: IFTYPE = 121;
pub const IF_TYPE_X25_HUNTGROUP: IFTYPE = 122;
pub const IF_TYPE_TRANSPHDLC: IFTYPE = 123;
pub const IF_TYPE_INTERLEAVE: IFTYPE = 124;
pub const IF_TYPE_FAST: IFTYPE = 125;
pub const IF_TYPE_IP: IFTYPE = 126;
pub const IF_TYPE_DOCSCABLE_MACLAYER: IFTYPE = 127;
pub const IF_TYPE_DOCSCABLE_DOWNSTREAM: IFTYPE = 128;
pub const IF_TYPE_DOCSCABLE_UPSTREAM: IFTYPE = 129;
pub const IF_TYPE_A12MPPSWITCH: IFTYPE = 130;
pub const IF_TYPE_TUNNEL: IFTYPE = 131;
pub const IF_TYPE_COFFEE: IFTYPE = 132;
pub const IF_TYPE_CES: IFTYPE = 133;
pub const IF_TYPE_ATM_SUBINTERFACE: IFTYPE = 134;
pub const IF_TYPE_L2_VLAN: IFTYPE = 135;
pub const IF_TYPE_L3_IPVLAN: IFTYPE = 136;
pub const IF_TYPE_L3_IPXVLAN: IFTYPE = 137;
pub const IF_TYPE_DIGITALPOWERLINE: IFTYPE = 138;
pub const IF_TYPE_MEDIAMAILOVERIP: IFTYPE = 139;
pub const IF_TYPE_DTM: IFTYPE = 140;
pub const IF_TYPE_DCN: IFTYPE = 141;
pub const IF_TYPE_IPFORWARD: IFTYPE = 142;
pub const IF_TYPE_MSDSL: IFTYPE = 143;
pub const IF_TYPE_IEEE1394: IFTYPE = 144;
pub const IF_TYPE_IF_GSN: IFTYPE = 145;
pub const IF_TYPE_DVBRCC_MACLAYER: IFTYPE = 146;
pub const IF_TYPE_DVBRCC_DOWNSTREAM: IFTYPE = 147;
pub const IF_TYPE_DVBRCC_UPSTREAM: IFTYPE = 148;
pub const IF_TYPE_ATM_VIRTUAL: IFTYPE = 149;
pub const IF_TYPE_MPLS_TUNNEL: IFTYPE = 150;
pub const IF_TYPE_SRP: IFTYPE = 151;
pub const IF_TYPE_VOICEOVERATM: IFTYPE = 152;
pub const IF_TYPE_VOICEOVERFRAMERELAY: IFTYPE = 153;
pub const IF_TYPE_IDSL: IFTYPE = 154;
pub const IF_TYPE_COMPOSITELINK: IFTYPE = 155;
pub const IF_TYPE_SS7_SIGLINK: IFTYPE = 156;
pub const IF_TYPE_PROP_WIRELESS_P2P: IFTYPE = 157;
pub const IF_TYPE_FR_FORWARD: IFTYPE = 158;
pub const IF_TYPE_RFC1483: IFTYPE = 159;
pub const IF_TYPE_USB: IFTYPE = 160;
pub const IF_TYPE_IEEE8023AD_LAG: IFTYPE = 161;
pub const IF_TYPE_BGP_POLICY_ACCOUNTING: IFTYPE = 162;
pub const IF_TYPE_FRF16_MFR_BUNDLE: IFTYPE = 163;
pub const IF_TYPE_H323_GATEKEEPER: IFTYPE = 164;
pub const IF_TYPE_H323_PROXY: IFTYPE = 165;
pub const IF_TYPE_MPLS: IFTYPE = 166;
pub const IF_TYPE_MF_SIGLINK: IFTYPE = 167;
pub const IF_TYPE_HDSL2: IFTYPE = 168;
pub const IF_TYPE_SHDSL: IFTYPE = 169;
pub const IF_TYPE_DS1_FDL: IFTYPE = 170;
pub const IF_TYPE_POS: IFTYPE = 171;
pub const IF_TYPE_DVB_ASI_IN: IFTYPE = 172;
pub const IF_TYPE_DVB_ASI_OUT: IFTYPE = 173;
pub const IF_TYPE_PLC: IFTYPE = 174;
pub const IF_TYPE_NFAS: IFTYPE = 175;
pub const IF_TYPE_TR008: IFTYPE = 176;
pub const IF_TYPE_GR303_RDT: IFTYPE = 177;
pub const IF_TYPE_GR303_IDT: IFTYPE = 178;
pub const IF_TYPE_ISUP: IFTYPE = 179;
pub const IF_TYPE_PROP_DOCS_WIRELESS_MACLAYER: IFTYPE = 180;
pub const IF_TYPE_PROP_DOCS_WIRELESS_DOWNSTREAM: IFTYPE = 181;
pub const IF_TYPE_PROP_DOCS_WIRELESS_UPSTREAM: IFTYPE = 182;
pub const IF_TYPE_HIPERLAN2: IFTYPE = 183;
pub const IF_TYPE_PROP_BWA_P2MP: IFTYPE = 184;
pub const IF_TYPE_SONET_OVERHEAD_CHANNEL: IFTYPE = 185;
pub const IF_TYPE_DIGITAL_WRAPPER_OVERHEAD_CHANNEL: IFTYPE = 186;
pub const IF_TYPE_AAL2: IFTYPE = 187;
pub const IF_TYPE_RADIO_MAC: IFTYPE = 188;
pub const IF_TYPE_ATM_RADIO: IFTYPE = 189;
pub const IF_TYPE_IMT: IFTYPE = 190;
pub const IF_TYPE_MVL: IFTYPE = 191;
pub const IF_TYPE_REACH_DSL: IFTYPE = 192;
pub const IF_TYPE_FR_DLCI_ENDPT: IFTYPE = 193;
pub const IF_TYPE_ATM_VCI_ENDPT: IFTYPE = 194;
pub const IF_TYPE_OPTICAL_CHANNEL: IFTYPE = 195;
pub const IF_TYPE_OPTICAL_TRANSPORT: IFTYPE = 196;
pub const IF_TYPE_IEEE80216_WMAN: IFTYPE = 237;
pub const IF_TYPE_WWANPP: IFTYPE = 243;
pub const IF_TYPE_WWANPP2: IFTYPE = 244;
pub const IF_TYPE_IEEE802154: IFTYPE = 259;
pub const IF_TYPE_XBOX_WIRELESS: IFTYPE = 281;
pub const MAX_IF_TYPE: IFTYPE = 281;
ENUM!{enum IF_ACCESS_TYPE {
    IF_ACCESS_LOOPBACK = 1,
    IF_ACCESS_BROADCAST = 2,
    IF_ACCESS_POINT_TO_POINT = 3,
    IF_ACCESS_POINTTOPOINT = 3,
    IF_ACCESS_POINT_TO_MULTI_POINT = 4,
    IF_ACCESS_POINTTOMULTIPOINT = 4,
}}
ENUM!{enum INTERNAL_IF_OPER_STATUS {
    IF_OPER_STATUS_NON_OPERATIONAL = 0,
    IF_OPER_STATUS_UNREACHABLE = 1,
    IF_OPER_STATUS_DISCONNECTED = 2,
    IF_OPER_STATUS_CONNECTING = 3,
    IF_OPER_STATUS_CONNECTED = 4,
    IF_OPER_STATUS_OPERATIONAL = 5,
}}
pub const MIB_IF_TYPE_OTHER: IFTYPE = 1;
pub const MIB_IF_TYPE_ETHERNET: IFTYPE = 6;
pub const MIB_IF_TYPE_TOKENRING: IFTYPE = 9;
pub const MIB_IF_TYPE_FDDI: IFTYPE = 15;
pub const MIB_IF_TYPE_PPP: IFTYPE = 23;
pub const MIB_IF_TYPE_LOOPBACK: IFTYPE = 24;
pub const MIB_IF_TYPE_SLIP: IFTYPE = 28;
pub const MIB_IF_ADMIN_STATUS_UP: IFTYPE = 1;
pub const MIB_IF_ADMIN_STATUS_DOWN: IFTYPE = 2;
pub const MIB_IF_ADMIN_STATUS_TESTING: IFTYPE = 3;
pub const MIB_IF_OPER_STATUS_NON_OPERATIONAL: INTERNAL_IF_OPER_STATUS = 0;
pub const MIB_IF_OPER_STATUS_UNREACHABLE: INTERNAL_IF_OPER_STATUS = 1;
pub const MIB_IF_OPER_STATUS_DISCONNECTED: INTERNAL_IF_OPER_STATUS = 2;
pub const MIB_IF_OPER_STATUS_CONNECTING: INTERNAL_IF_OPER_STATUS = 3;
pub const MIB_IF_OPER_STATUS_CONNECTED: INTERNAL_IF_OPER_STATUS = 4;
pub const MIB_IF_OPER_STATUS_OPERATIONAL: INTERNAL_IF_OPER_STATUS = 5;
