"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeLogsAPI = void 0;
var transports_1 = require("../../transports");
var utils_1 = require("../../utils");
var const_1 = require("./const");
function initializeLogsAPI(transports, metas, tracesApi) {
    var pushLog = function (args, _a) {
        var _b = _a === void 0 ? {} : _a, context = _b.context, level = _b.level;
        try {
            var item = {
                type: transports_1.TransportItemType.LOG,
                payload: {
                    message: args
                        .map(function (arg) {
                        try {
                            return String(arg);
                        }
                        catch (err) {
                            return '';
                        }
                    })
                        .join(' '),
                    level: level !== null && level !== void 0 ? level : const_1.defaultLogLevel,
                    context: context !== null && context !== void 0 ? context : {},
                    timestamp: (0, utils_1.getCurrentTimestamp)(),
                    trace: tracesApi.getTraceContext(),
                },
                meta: metas.value,
            };
            transports.execute(item);
        }
        catch (err) {
            // TODO: Add proper logging when debug is enabled
        }
    };
    var callOriginalConsoleMethod = function (level) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        const_1.originalConsoleMethods[level].apply(console, args);
    };
    return {
        callOriginalConsoleMethod: callOriginalConsoleMethod,
        pushLog: pushLog,
    };
}
exports.initializeLogsAPI = initializeLogsAPI;
//# sourceMappingURL=initialize.js.map