"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseStacktrace = exports.getStackFramesFromError = exports.buildStackFrame = exports.getDataFromSafariExtensions = void 0;
var agent_core_1 = require("@grafana/agent-core");
var const_1 = require("./const");
function getDataFromSafariExtensions(func, filename) {
    var isSafariExtension = func === null || func === void 0 ? void 0 : func.includes(const_1.safariExtensionString);
    var isSafariWebExtension = !isSafariExtension && (func === null || func === void 0 ? void 0 : func.includes(const_1.safariWebExtensionString));
    if (!isSafariExtension && !isSafariWebExtension) {
        return [func, filename];
    }
    return [
        (func === null || func === void 0 ? void 0 : func.includes(const_1.atString)) ? func.split(const_1.atString)[0] : func,
        isSafariExtension ? "".concat(const_1.safariExtensionString, ":").concat(filename) : "".concat(const_1.safariWebExtensionString, ":").concat(filename),
    ];
}
exports.getDataFromSafariExtensions = getDataFromSafariExtensions;
function buildStackFrame(filename, func, lineno, colno) {
    var stackFrame = {
        filename: filename || document.location.href,
        function: func || const_1.unknownString,
    };
    if (lineno !== undefined) {
        stackFrame.lineno = lineno;
    }
    if (colno !== undefined) {
        stackFrame.colno = colno;
    }
    return stackFrame;
}
exports.buildStackFrame = buildStackFrame;
function getStackFramesFromError(error) {
    var lines = [];
    if (error.stacktrace) {
        lines = error.stacktrace.split(const_1.newLineString).filter(function (_line, idx) { return idx % 2 === 0; });
    }
    else if (error.stack) {
        lines = error.stack.split(const_1.newLineString);
    }
    var stackFrames = lines.reduce(function (acc, line, idx) {
        var _a, _b;
        var parts;
        var func;
        var filename;
        var lineno;
        var colno;
        if ((parts = const_1.chromeLineRegex.exec(line))) {
            func = parts[1];
            filename = parts[2];
            lineno = parts[3];
            colno = parts[4];
            if (filename === null || filename === void 0 ? void 0 : filename.startsWith(const_1.chromeEvalString)) {
                var submatch = const_1.chromeEvalRegex.exec(filename);
                if (submatch) {
                    filename = submatch[1];
                    lineno = submatch[2];
                    colno = submatch[3];
                }
            }
            filename = (filename === null || filename === void 0 ? void 0 : filename.startsWith(const_1.chromeAddressAtString))
                ? filename.substring(const_1.chromeAddressAtStringLength)
                : filename;
            _a = getDataFromSafariExtensions(func, filename), func = _a[0], filename = _a[1];
        }
        else if ((parts = const_1.msLineRegex.exec(line))) {
            func = parts[1];
            filename = parts[2];
            lineno = parts[3];
            colno = parts[4];
        }
        else if ((parts = const_1.firefoxLineRegex.exec(line))) {
            func = parts[1];
            filename = parts[3];
            lineno = parts[4];
            colno = parts[5];
            if (!!filename && filename.includes(const_1.firefoxEvalString)) {
                var submatch = const_1.firefoxEvalRegex.exec(filename);
                if (submatch) {
                    func = func || const_1.evalString;
                    filename = submatch[1];
                    lineno = submatch[2];
                }
            }
            else if (idx === 0 && !colno && (0, agent_core_1.isNumber)(error.columnNumber)) {
                colno = String(error.columnNumber + 1);
            }
            _b = getDataFromSafariExtensions(func, filename), func = _b[0], filename = _b[1];
        }
        else if ((parts = const_1.opera10LineRegex.exec(line))) {
            filename = parts[2];
            func = parts[3];
            lineno = parts[1];
        }
        else if ((parts = const_1.opera11LineRegex.exec(line))) {
            filename = parts[6];
            func = parts[3] || parts[4];
            lineno = parts[1];
            colno = parts[2];
        }
        if (filename || func) {
            acc.push(buildStackFrame(filename, func, lineno ? Number(lineno) : undefined, colno ? Number(colno) : undefined));
        }
        return acc;
    }, []);
    if (error.framesToPop) {
        return stackFrames.slice(error.framesToPop);
    }
    if (const_1.reactMinifiedRegex.test(error.message)) {
        return stackFrames.slice(1);
    }
    return stackFrames;
}
exports.getStackFramesFromError = getStackFramesFromError;
function parseStacktrace(error) {
    return {
        frames: getStackFramesFromError(error),
    };
}
exports.parseStacktrace = parseStacktrace;
//# sourceMappingURL=stackFrames.js.map