"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const tslib_1 = require("tslib");
const fs_1 = tslib_1.__importDefault(require("fs"));
const webpack_plugin_config_1 = require("./webpack.plugin.config");
// eslint-disable-next-line no-duplicate-imports
const webpackConfig = tslib_1.__importStar(require("./webpack.plugin.config"));
jest.mock('./webpack/loaders', () => ({
    getFileLoaders: () => [],
    getStylesheetEntries: () => ({}),
    getStyleLoaders: () => [],
}));
const modulePathsMock = [
    'some/path/module.ts',
    'some/path/module.ts.whatever',
    'some/path/module.tsx',
    'some/path/module.tsx.whatever',
    'some/path/anotherFile.ts',
    'some/path/anotherFile.tsx',
];
describe('Plugin webpack config', () => {
    describe('findModuleTs', () => {
        beforeAll(() => {
            jest.spyOn(fs_1.default, 'statSync').mockReturnValue({
                isDirectory: () => false,
            });
        });
        afterAll(() => {
            jest.restoreAllMocks();
        });
        it('finds module.ts and module.tsx files', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            const moduleFiles = yield (0, webpack_plugin_config_1.findModuleFiles)('/', modulePathsMock);
            expect(moduleFiles.length).toBe(2);
            // normalize windows path - \\ -> /
            expect(moduleFiles.map((p) => p.replace(/\\/g, '/'))).toEqual(['/some/path/module.ts', '/some/path/module.tsx']);
        }));
    });
    describe('loadWebpackConfig', () => {
        beforeAll(() => {
            jest.spyOn(webpackConfig, 'findModuleFiles').mockReturnValue(new Promise((res, _) => res([])));
        });
        afterAll(() => {
            jest.restoreAllMocks();
        });
        it('uses default config if no override exists', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            const spy = jest.spyOn(process, 'cwd');
            spy.mockReturnValue(`${__dirname}/mocks/webpack/noOverride/`);
            yield (0, webpack_plugin_config_1.loadWebpackConfig)({});
        }));
        it('calls customConfig if it exists', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            const spy = jest.spyOn(process, 'cwd');
            spy.mockReturnValue(`${__dirname}/mocks/webpack/overrides/`);
            const config = yield (0, webpack_plugin_config_1.loadWebpackConfig)({});
            expect(config.name).toBe('customConfig');
        }));
        it('loads export named getWebpackConfiguration', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            const spy = jest.spyOn(process, 'cwd');
            spy.mockReturnValue(`${__dirname}/mocks/webpack/overridesNamedExport/`);
            const config = yield (0, webpack_plugin_config_1.loadWebpackConfig)({});
            expect(config.name).toBe('customConfig');
        }));
        it('throws an error if module does not export function', () => tslib_1.__awaiter(void 0, void 0, void 0, function* () {
            const spy = jest.spyOn(process, 'cwd');
            spy.mockReturnValue(`${__dirname}/mocks/webpack/unsupportedOverride/`);
            yield expect((0, webpack_plugin_config_1.loadWebpackConfig)({})).rejects.toThrowError();
        }));
    });
});
//# sourceMappingURL=webpack.plugin.config.test.js.map