import { Editor, Path, Point, PathRef, PointRef, Range, RangeRef } from '../..';
declare class GeneralQueries {
    /**
     * Create a mutable ref for a `Path` object, which will stay in sync as new
     * operations are applied to the this.
     */
    createPathRef(this: Editor, path: Path, options?: {
        affinity?: 'backward' | 'forward' | null;
    }): PathRef;
    /**
     * Create a mutable ref for a `Point` object, which will stay in sync as new
     * operations are applied to the this.
     */
    createPointRef(this: Editor, point: Point, options?: {
        affinity?: 'backward' | 'forward' | null;
    }): PointRef;
    /**
     * Create a mutable ref for a `Range` object, which will stay in sync as new
     * operations are applied to the this.
     */
    createRangeRef(this: Editor, range: Range, options?: {
        affinity?: 'backward' | 'forward' | 'outward' | 'inward' | null;
    }): RangeRef;
}
export default GeneralQueries;
//# sourceMappingURL=general.d.ts.map