; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S %s -passes=instsimplify | FileCheck %s

; A ==> A -> true
define i1 @test(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test(
; CHECK-NEXT:    ret i1 true
;
  %var29 = icmp slt i32 %i, %length.i
  %res = icmp uge i1 %var29, %var29
  ret i1 %res
}

; i +_{nsw} C_{>0} <s L ==> i <s L -> true
define i1 @test2(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nsw i32 %i, 1
  %var29 = icmp slt i32 %i, %length.i
  %var30 = icmp slt i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; i + C_{>0} <s L ==> i <s L -> unknown without the nsw
define i1 @test2_neg(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test2_neg(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp slt i32 [[I]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp slt i32 [[IPLUS1]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add i32 %i, 1
  %var29 = icmp slt i32 %i, %length.i
  %var30 = icmp slt i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; sle is not implication
define i1 @test2_neg2(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test2_neg2(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp slt i32 [[I]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp slt i32 [[IPLUS1]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp sle i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add i32 %i, 1
  %var29 = icmp slt i32 %i, %length.i
  %var30 = icmp slt i32 %iplus1, %length.i
  %res = icmp sle i1 %var30, %var29
  ret i1 %res
}

; The binary operator has to be an add
define i1 @test2_neg3(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test2_neg3(
; CHECK-NEXT:    [[IPLUS1:%.*]] = sub nsw i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp slt i32 [[I]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp slt i32 [[IPLUS1]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = sub nsw i32 %i, 1
  %var29 = icmp slt i32 %i, %length.i
  %var30 = icmp slt i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; i +_{nsw} C_{>0} <s L ==> i <s L -> true
; With an inverted conditional (ule B A rather than canonical ugt A B
define i1 @test3(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nsw i32 %i, 1
  %var29 = icmp slt i32 %i, %length.i
  %var30 = icmp slt i32 %iplus1, %length.i
  %res = icmp uge i1 %var29, %var30
  ret i1 %res
}

; i +_{nuw} C <u L ==> i <u L
define i1 @test4(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nuw i32 %i, 1
  %var29 = icmp ult i32 %i, %length.i
  %var30 = icmp ult i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; A ==> A for vectors
define <4 x i1> @test5(<4 x i1> %vec) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret <4 x i1> <i1 true, i1 true, i1 true, i1 true>
;
  %res = icmp ule <4 x i1> %vec, %vec
  ret <4 x i1> %res
}

; Don't crash on vector inputs - pr25040
define <4 x i1> @test6(<4 x i1> %a, <4 x i1> %b) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    [[RES:%.*]] = icmp ule <4 x i1> [[A:%.*]], [[B:%.*]]
; CHECK-NEXT:    ret <4 x i1> [[RES]]
;
  %res = icmp ule <4 x i1> %a, %b
  ret <4 x i1> %res
}

; i +_{nsw} 1 <s L  ==> i < L +_{nsw} 1
define i1 @test7(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nsw i32 %i, 1
  %len.plus.one = add nsw i32 %length.i, 1
  %var29 = icmp slt i32 %i, %len.plus.one
  %var30 = icmp slt i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; i +_{nuw} 1 <u L  ==> i < L +_{nuw} 1
define i1 @test8(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test8(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nuw i32 %i, 1
  %len.plus.one = add nuw i32 %length.i, 1
  %var29 = icmp ult i32 %i, %len.plus.one
  %var30 = icmp ult i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; i +_{nuw} C <u L ==> i < L, even if C is negative
define i1 @test9(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test9(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nuw i32 %i, -100
  %var29 = icmp ult i32 %i, %length.i
  %var30 = icmp ult i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

define i1 @test10(i32 %length.i, i32 %x.full) {
; CHECK-LABEL: @test10(
; CHECK-NEXT:    ret i1 true
;
  %x = and i32 %x.full, 4294901760  ;; 4294901760 == 0xffff0000
  %large = or i32 %x, 100
  %small = or i32 %x, 90
  %known = icmp ult i32 %large, %length.i
  %to.prove = icmp ult i32 %small, %length.i
  %res = icmp ule i1 %known, %to.prove
  ret i1 %res
}

define i1 @test11(i32 %length.i, i32 %x) {
; CHECK-LABEL: @test11(
; CHECK-NEXT:    [[LARGE:%.*]] = or i32 [[X:%.*]], 100
; CHECK-NEXT:    [[SMALL:%.*]] = or i32 [[X]], 90
; CHECK-NEXT:    [[KNOWN:%.*]] = icmp ult i32 [[LARGE]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[TO_PROVE:%.*]] = icmp ult i32 [[SMALL]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[KNOWN]], [[TO_PROVE]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %large = or i32 %x, 100
  %small = or i32 %x, 90
  %known = icmp ult i32 %large, %length.i
  %to.prove = icmp ult i32 %small, %length.i
  %res = icmp ule i1 %known, %to.prove
  ret i1 %res
}

define i1 @test12(i32 %length.i, i32 %x.full) {
; CHECK-LABEL: @test12(
; CHECK-NEXT:    [[X:%.*]] = and i32 [[X_FULL:%.*]], -65536
; CHECK-NEXT:    [[LARGE:%.*]] = or i32 [[X]], 65536
; CHECK-NEXT:    [[SMALL:%.*]] = or i32 [[X]], 90
; CHECK-NEXT:    [[KNOWN:%.*]] = icmp ult i32 [[LARGE]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[TO_PROVE:%.*]] = icmp ult i32 [[SMALL]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[KNOWN]], [[TO_PROVE]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %x = and i32 %x.full, 4294901760  ;; 4294901760 == 0xffff0000
  %large = or i32 %x, 65536 ;; 65536 == 0x00010000
  %small = or i32 %x, 90
  %known = icmp ult i32 %large, %length.i
  %to.prove = icmp ult i32 %small, %length.i
  %res = icmp ule i1 %known, %to.prove
  ret i1 %res
}

define i1 @test13(i32 %length.i, i32 %x) {
; CHECK-LABEL: @test13(
; CHECK-NEXT:    ret i1 true
;
  %large = add nuw i32 %x, 100
  %small = add nuw i32 %x, 90
  %known = icmp ult i32 %large, %length.i
  %to.prove = icmp ult i32 %small, %length.i
  %res = icmp ule i1 %known, %to.prove
  ret i1 %res
}

define i1 @test14(i32 %length.i, i32 %x.full) {
; CHECK-LABEL: @test14(
; CHECK-NEXT:    ret i1 true
;
  %x = and i32 %x.full, 4294905615  ;; 4294905615 == 0xffff0f0f
  %large = or i32 %x, 8224 ;; == 0x2020
  %small = or i32 %x, 4112 ;; == 0x1010
  %known = icmp ult i32 %large, %length.i
  %to.prove = icmp ult i32 %small, %length.i
  %res = icmp ule i1 %known, %to.prove
  ret i1 %res
}

define i1 @test15(i32 %length.i, i32 %x) {
; CHECK-LABEL: @test15(
; CHECK-NEXT:    [[LARGE:%.*]] = add nuw i32 [[X:%.*]], 100
; CHECK-NEXT:    [[SMALL:%.*]] = add nuw i32 [[X]], 110
; CHECK-NEXT:    [[KNOWN:%.*]] = icmp ult i32 [[LARGE]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[TO_PROVE:%.*]] = icmp ult i32 [[SMALL]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[KNOWN]], [[TO_PROVE]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %large = add nuw i32 %x, 100
  %small = add nuw i32 %x, 110
  %known = icmp ult i32 %large, %length.i
  %to.prove = icmp ult i32 %small, %length.i
  %res = icmp ule i1 %known, %to.prove
  ret i1 %res
}

; X >=(s) Y == X ==> Y (i1 1 becomes -1 for reasoning)
define i1 @test_sge(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sge(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nsw nuw i32 %i, 1
  %var29 = icmp ult i32 %i, %length.i
  %var30 = icmp ult i32 %iplus1, %length.i
  %res = icmp sge i1 %var30, %var29
  ret i1 %res
}

; X <=(s) Y == Y ==> X (i1 1 becomes -1 for reasoning)
define i1 @test_sle(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sle(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nsw nuw i32 %i, 1
  %var29 = icmp ult i32 %i, %length.i
  %var30 = icmp ult i32 %iplus1, %length.i
  %res = icmp sle i1 %var29, %var30
  ret i1 %res
}

; X +_{nsw} 1 <(s) Y ==> X <(s) Y
define i1 @test_sgt_icmp(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sgt_icmp(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nsw i32 %i, 1
  %var29 = icmp sgt i32 %length.i, %i
  %var30 = icmp sgt i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; X +_{nsw} 1 <=(s) Y ==> X <=(s) Y
define i1 @test_sge_icmp(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sge_icmp(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nsw i32 %i, 1
  %var29 = icmp sge i32 %length.i, %i
  %var30 = icmp sge i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; X +_{nuw} 1 <(u) Y ==> X <(u) Y
define i1 @test_ugt_icmp(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_ugt_icmp(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nuw i32 %i, 1
  %var29 = icmp ugt i32 %length.i, %i
  %var30 = icmp ugt i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; X +_{nuw} 1 <=(u) Y ==> X <=(u) Y
define i1 @test_uge_icmp(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_uge_icmp(
; CHECK-NEXT:    ret i1 true
;
  %iplus1 = add nuw i32 %i, 1
  %var29 = icmp uge i32 %length.i, %i
  %var30 = icmp uge i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; Test from PR70374
define i1 @pr70374(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @pr70374(
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[Y:%.*]], [[Z:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[ADD]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %add = add nuw i32 %y, %z
  %cmp1 = icmp ule i32 %add, %x
  %cmp2 = icmp uge i32 %x, %y
  %res = and i1 %cmp2, %cmp1
  ret i1 %res
}

define i1 @pr70374_commuted_add(i32 %x, i32 %y, i32 %z) {
; CHECK-LABEL: @pr70374_commuted_add(
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i32 [[Z:%.*]], [[Y:%.*]]
; CHECK-NEXT:    [[CMP1:%.*]] = icmp ule i32 [[ADD]], [[X:%.*]]
; CHECK-NEXT:    ret i1 [[CMP1]]
;
  %add = add nuw i32 %z, %y
  %cmp1 = icmp ule i32 %add, %x
  %cmp2 = icmp uge i32 %x, %y
  %res = and i1 %cmp2, %cmp1
  ret i1 %res
}

define i1 @test_uge_icmp_value(i32 %length.i, i32 %i, i32 %j) {
; CHECK-LABEL: @test_uge_icmp_value(
; CHECK-NEXT:    ret i1 true
;
  %iplusj = add nuw i32 %i, %j
  %var29 = icmp uge i32 %length.i, %i
  %var30 = icmp uge i32 %length.i, %iplusj
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; negative case, X + 1 <(s) Y !==> X <(s) Y (X = 0x7fffffff, Y = 0x7fbfffff)
define i1 @test_sgt_icmp_no_nsw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sgt_icmp_no_nsw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp sgt i32 [[LENGTH_I:%.*]], [[I]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp sgt i32 [[LENGTH_I]], [[IPLUS1]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add i32 %i, 1
  %var29 = icmp sgt i32 %length.i, %i
  %var30 = icmp sgt i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; negative case, X +_{nuw} 1 <(s) Y !==> X <(s) Y
define i1 @test_sgt_icmp_nuw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sgt_icmp_nuw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add nuw i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp sgt i32 [[I]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp sgt i32 [[IPLUS1]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add nuw i32 %i, 1
  %var29 = icmp sgt i32 %i, %length.i
  %var30 = icmp sgt i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; negative case, X + 1 <=(s) Y !==> X <=(s) Y (X = 0x7fffffff, Y = 0x80000000)
define i1 @test_sge_icmp_no_nsw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sge_icmp_no_nsw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp sge i32 [[LENGTH_I:%.*]], [[I]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp sge i32 [[LENGTH_I]], [[IPLUS1]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add i32 %i, 1
  %var29 = icmp sge i32 %length.i, %i
  %var30 = icmp sge i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; negative case, X +_{nuw} 1 <=(s) Y !==> X <=(s) Y
define i1 @test_sge_icmp_nuw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_sge_icmp_nuw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add nuw i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp sge i32 [[I]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp sge i32 [[IPLUS1]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add nuw i32 %i, 1
  %var29 = icmp sge i32 %i, %length.i
  %var30 = icmp sge i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

;negative case, X + 1 <(u) Y !==> X <(u) Y (X = Y = 0xffffffff)
define i1 @test_ugt_icmp_no_nuw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_ugt_icmp_no_nuw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp ugt i32 [[LENGTH_I:%.*]], [[I]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp ugt i32 [[LENGTH_I]], [[IPLUS1]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add i32 %i, 1
  %var29 = icmp ugt i32 %length.i, %i
  %var30 = icmp ugt i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; negative case, X +_{nsw} 1 <(u) Y !==> X <(u) Y (X = 0xffffffff, Y = 0xfffffffe)
define i1 @test_ugt_icmp_nsw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_ugt_icmp_nsw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add nsw i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp ugt i32 [[LENGTH_I:%.*]], [[I]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp ugt i32 [[LENGTH_I]], [[IPLUS1]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add nsw i32 %i, 1
  %var29 = icmp ugt i32 %length.i, %i
  %var30 = icmp ugt i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; negative case, X + 1 <=(u) Y !==> X <=(u) Y (X = 0xffffffff, Y = 0x0)
define i1 @test_uge_icmp_no_nuw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_uge_icmp_no_nuw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp uge i32 [[LENGTH_I:%.*]], [[I]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp uge i32 [[LENGTH_I]], [[IPLUS1]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add i32 %i, 1
  %var29 = icmp uge i32 %length.i, %i
  %var30 = icmp uge i32 %length.i, %iplus1
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; negative case, X +_{nsw} 1 <=(u) Y !==> X <=(u) Y
define i1 @test_uge_icmp_nsw(i32 %length.i, i32 %i) {
; CHECK-LABEL: @test_uge_icmp_nsw(
; CHECK-NEXT:    [[IPLUS1:%.*]] = add nsw i32 [[I:%.*]], 1
; CHECK-NEXT:    [[VAR29:%.*]] = icmp uge i32 [[I]], [[LENGTH_I:%.*]]
; CHECK-NEXT:    [[VAR30:%.*]] = icmp uge i32 [[IPLUS1]], [[LENGTH_I]]
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[VAR30]], [[VAR29]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %iplus1 = add nsw i32 %i, 1
  %var29 = icmp uge i32 %i, %length.i
  %var30 = icmp uge i32 %iplus1, %length.i
  %res = icmp ule i1 %var30, %var29
  ret i1 %res
}

; (X >> Z) <=(u) Y ==> X <=(u) Y
define i1 @test_shift(i64 %x, i64 %y, i64 %shift) {
; CHECK-LABEL: @test_shift(
; CHECK-NEXT:    [[LSHR:%.*]] = lshr i64 [[X:%.*]], [[SHIFT:%.*]]
; CHECK-NEXT:    [[ICMP1:%.*]] = icmp ugt i64 [[LSHR]], [[Y:%.*]]
; CHECK-NEXT:    call void @llvm.assume(i1 [[ICMP1]])
; CHECK-NEXT:    ret i1 true
;
  %lshr = lshr i64 %x, %shift
  %icmp1 = icmp ugt i64 %lshr, %y
  %icmp2 = icmp ugt i64 %x, %y
  call void @llvm.assume(i1 %icmp1)
  ret i1 %icmp2
}

; (X > Y +_{nuw} 1) ==> X != Y
define i1 @assume_x_ugt_y_plus_1(i64  %x, i64  %y)  {
; CHECK-LABEL: @assume_x_ugt_y_plus_1(
; CHECK-NEXT:    [[TMP1:%.*]] = add nuw i64 [[Y:%.*]], 1
; CHECK-NEXT:    [[TMP2:%.*]] = icmp ugt i64 [[X:%.*]], [[TMP1]]
; CHECK-NEXT:    tail call void @llvm.assume(i1 [[TMP2]])
; CHECK-NEXT:    [[TMP3:%.*]] = icmp eq i64 [[X]], [[Y]]
; CHECK-NEXT:    ret i1 [[TMP3]]
;
  %1 = add nuw i64 %y, 1
  %2 = icmp ugt i64 %x, %1
  tail call void @llvm.assume(i1 %2)
  %3 = icmp eq i64 %x, %y
  ret i1 %3
}

; i <u L ==> i >> C <u L
define i1 @lshr_constant(i32 %length.i, i32 %i) {
; CHECK-LABEL: @lshr_constant(
; CHECK-NEXT:    ret i1 true
;
  %shl = lshr i32 %i, 1
  %var29 = icmp ult i32 %i, %length.i
  %var30 = icmp ult i32 %shl, %length.i
  %res = icmp ule i1 %var29, %var30
  ret i1 %res
}

; i <u L ==> i >> V <u L
define i1 @lshr_value(i32 %length.i, i32 %i, i32 %v) {
; CHECK-LABEL: @lshr_value(
; CHECK-NEXT:    ret i1 true
;
  %shl = lshr i32 %i, %v
  %var29 = icmp ult i32 %i, %length.i
  %var30 = icmp ult i32 %shl, %length.i
  %res = icmp ule i1 %var29, %var30
  ret i1 %res
}

define i1 @same_ops_with_constant(i8 %x) {
; CHECK-LABEL: @same_ops_with_constant(
; CHECK-NEXT:    ret i1 true
;
  %cmp1 = icmp sgt i8 %x, 5
  %cmp2 = icmp ugt i8 %x, 5
  %res = icmp ule i1 %cmp1, %cmp2
  ret i1 %res
}

define i1 @same_ops_with_constant_wrong_sign(i8 %x) {
; CHECK-LABEL: @same_ops_with_constant_wrong_sign(
; CHECK-NEXT:    [[CMP1:%.*]] = icmp sgt i8 [[X:%.*]], -5
; CHECK-NEXT:    [[CMP2:%.*]] = icmp ugt i8 [[X]], -5
; CHECK-NEXT:    [[RES:%.*]] = icmp ule i1 [[CMP1]], [[CMP2]]
; CHECK-NEXT:    ret i1 [[RES]]
;
  %cmp1 = icmp sgt i8 %x, -5
  %cmp2 = icmp ugt i8 %x, -5
  %res = icmp ule i1 %cmp1, %cmp2
  ret i1 %res
}

declare void @llvm.assume(i1)
