/*
 * Note: this file originally auto-generated by mib2c using
 *       version : 14170 $ of $ 
 *
 * $Id:$
 */
/*
 * standard Net-SNMP includes 
 */
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/agent/net-snmp-agent-includes.h>

#if HAVE_UNISTD_H
#include <unistd.h>
#endif

/*
 * include our parent header 
 */
#include "etherStatsTable.h"
#include "etherStatsTable_data_access.h"

#if defined(linux)
#include "ioctl_imp_common.h"
#endif

/** @ingroup interface
 * @addtogroup data_access data_access: Routines to access data
 *
 * These routines are used to locate the data used to satisfy
 * requests.
 * 
 * @{
 */
/**********************************************************************
 **********************************************************************
 ***
 *** Table etherStatsTable
 ***
 **********************************************************************
 **********************************************************************/
/*
 * RMON-MIB::etherStatsTable is subid 1 of statistics.
 * Its status is Current.
 * OID: .1.3.6.1.2.1.16.1.1, length: 9
 */

/**
 * initialization for etherStatsTable data access
 *
 * This function is called during startup to allow you to
 * allocate any resources you need for the data table.
 *
 * @param etherStatsTable_reg
 *        Pointer to etherStatsTable_registration
 *
 * @retval MFD_SUCCESS : success.
 * @retval MFD_ERROR   : unrecoverable error.
 */
int
etherStatsTable_init_data(etherStatsTable_registration *
                          etherStatsTable_reg)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_init_data",
                "called\n"));

    /*
     * TODO:303:o: Initialize etherStatsTable data.
     */

    return MFD_SUCCESS;
}                               /* etherStatsTable_init_data */

/**
 * container overview
 *
 */

/**
 * container initialization
 *
 * @param container_ptr_ptr A pointer to a container pointer. If you
 *        create a custom container, use this parameter to return it
 *        to the MFD helper. If set to NULL, the MFD helper will
 *        allocate a container for you.
 * @param  cache A pointer to a cache structure. You can set the timeout
 *         and other cache flags using this pointer.
 *
 *  This function is called at startup to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases. If no custom
 *  container is allocated, the MFD code will create one for your.
 *
 *  This is also the place to set up cache behavior. The default, to
 *  simply set the cache timeout, will work well with the default
 *  container. If you are using a custom container, you may want to
 *  look at the cache helper documentation to see if there are any
 *  flags you want to set.
 *
 * @remark
 *  This would also be a good place to do any initialization needed
 *  for you data source. For example, opening a connection to another
 *  process that will supply the data, opening a database, etc.
 */
void
etherStatsTable_container_init(netsnmp_container ** container_ptr_ptr,
                               netsnmp_cache * cache)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_container_init",
                "called\n"));

    if (NULL == container_ptr_ptr) {
        snmp_log(LOG_ERR,
                 "bad container param to etherStatsTable_container_init\n");
        return;
    }

    /*
     * For advanced users, you can use a custom container. If you
     * do not create one, one will be created for you.
     */
    *container_ptr_ptr = NULL;

    if (NULL == cache) {
        snmp_log(LOG_ERR,
                 "bad cache param to etherStatsTable_container_init\n");
        return;
    }

    /*
     * TODO:345:A: Set up etherStatsTable cache properties.
     *
     * Also for advanced users, you can set parameters for the
     * cache. Do not change the magic pointer, as it is used
     * by the MFD helper. To completely disable caching, set
     * cache->enabled to 0.
     */
    cache->timeout = ETHERSTATSTABLE_CACHE_TIMEOUT;     /* seconds */
}                               /* etherStatsTable_container_init */

/**
 * container shutdown
 *
 * @param container_ptr A pointer to the container.
 *
 *  This function is called at shutdown to allow you to customize certain
 *  aspects of the access method. For the most part, it is for advanced
 *  users. The default code should suffice for most cases.
 *
 *  This function is called before etherStatsTable_container_free().
 *
 * @remark
 *  This would also be a good place to do any cleanup needed
 *  for you data source. For example, closing a connection to another
 *  process that supplied the data, closing a database, etc.
 */
void
etherStatsTable_container_shutdown(netsnmp_container * container_ptr)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_container_shutdown", "called\n"));

    if (NULL == container_ptr) {
        snmp_log(LOG_ERR,
                 "bad params to etherStatsTable_container_shutdown\n");
        return;
    }

}                               /* etherStatsTable_container_shutdown */

/**
 * load initial data
 *
 * TODO:350:M: Implement etherStatsTable data load
 * This function will also be called by the cache helper to load
 * the container again (after the container free function has been
 * called to free the previous contents).
 *
 * @param container container to which items should be inserted
 *
 * @retval MFD_SUCCESS              : success.
 * @retval MFD_RESOURCE_UNAVAILABLE : Can't access data source
 * @retval MFD_ERROR                : other error.
 *
 *  This function is called to load the index(es) (and data, optionally)
 *  for the every row in the data set.
 *
 * @remark
 *  While loading the data, the only important thing is the indexes.
 *  If access to your data is cheap/fast (e.g. you have a pointer to a
 *  structure in memory), it would make sense to update the data here.
 *  If, however, the accessing the data invovles more work (e.g. parsing
 *  some other existing data, or peforming calculations to derive the data),
 *  then you can limit yourself to setting the indexes and saving any
 *  information you will need later. Then use the saved information in
 *  etherStatsTable_row_prep() for populating data.
 *
 * @note
 *  If you need consistency between rows (like you want statistics
 *  for each row to be from the same time frame), you should set all
 *  data here.
 *
 */
int
etherStatsTable_container_load(netsnmp_container * container)
{
    size_t          count = 0;

    /*
     * TODO:352:M: |   |-> set indexes in new etherStatsTable rowreq context.
     * data context will be set from the param (unless NULL,
     *      in which case a new data context will be allocated)
     */

    /*
     * temporary storage for index values
     */
    
    /*
     * etherStatsIndex(1)/INTEGER32/ASN_INTEGER/long(long)//l/A/w/e/R/d/h
     */

    int             fd;

#if defined(linux)
    struct ifname *list_head = NULL, *p = NULL;
#endif

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_container_load",
                "called\n"));

    
    /*
     * create socket for ioctls
     */

    fd = socket(AF_INET, SOCK_DGRAM, 0);
    if(fd < 0) {
        snmp_log(LOG_ERR, "could not create socket\n");
        return -2;
    }

    /*
     * get the interface names of the devices present in the system, in case of failure retval suggests the reson for failure
     * and list_head contains null
     */

#if defined(linux)
    {
        int retval;

        list_head = etherstats_interface_name_list_get(list_head, &retval);
    }

    if (!list_head) {
        snmp_log (LOG_ERR, "access:etherStatsTable, error getting the interface names present in the system\n");
        DEBUGMSGTL(("access:etherStatsTable", "error getting the interface names present in the system"));
        close(fd);
        return MFD_ERROR;
    }

    /*
     * Walk over the list of interface names present in the system and retreive the statistics 
     */

    for (p = list_head; p; p = p->ifn_next) {
        long            etherStatsIndex;
        etherStatsTable_rowreq_ctx *rowreq_ctx;

        DEBUGMSGTL(("access:etherStatsTable", "processing '%s'\n", p->name));

        /*
         * get index via ioctl.
         */

        etherStatsIndex = (long) etherstats_interface_ioctl_ifindex_get(-1, p->name);

        /* 
         *  get the etherstats contents populated, if the device is not an ethernet device
         *  the operation will not be supported and an error message will be logged
         */
        
        rowreq_ctx = etherStatsTable_allocate_rowreq_ctx(NULL);
        if (NULL == rowreq_ctx) {
            snmp_log(LOG_ERR, "memory allocation failed\n");
            close(fd);
            etherstats_interface_name_list_free(list_head);
            return MFD_RESOURCE_UNAVAILABLE;
        }

        if (MFD_SUCCESS !=
            etherStatsTable_indexes_set(rowreq_ctx, etherStatsIndex)) {
            snmp_log(LOG_ERR,
                     "error setting index while loading "
                     "etherStatsTable data.\n");
            etherStatsTable_release_rowreq_ctx(rowreq_ctx);
            continue;
        }

        /*
         * TODO:352:r: |   |-> populate etherStatsTable data context.
         * Populate data context here. (optionally, delay until row prep)
         */
        /*
         * non-TRANSIENT data: no need to copy. set pointer to data 
         */

        memset (&rowreq_ctx->data, 0, sizeof (rowreq_ctx->data));
        {
            int rc;

            rc = interface_ioctl_etherstats_get (rowreq_ctx, fd, p->name);

            if (rc < 0) {
                DEBUGMSGTL(("access:etherStatsTable", "error getting the statistics for interface |%s| "
                            "etherStatsTable data, operation might not be supported\n", p->name));
                etherStatsTable_release_rowreq_ctx(rowreq_ctx);
                continue;
            }

            /*
             * insert into table container
             */
            rc = CONTAINER_INSERT(container, rowreq_ctx);
            if (rc < 0) {
                DEBUGMSGTL(("access:etherStatsTable", "error inserting |%s| ", p->name));
                etherStatsTable_release_rowreq_ctx(rowreq_ctx);
                continue;
            }
        }

        ++count;
    }

    close(fd);

    /*
     * free the interface names list 
     */

    if ( (etherstats_interface_name_list_free(list_head)) < 0) {
        snmp_log(LOG_ERR, "access:etherStatsTable, error freeing the interface name list \n");
        DEBUGMSGTL(("access:etherStatsTable", "error freeing the interface name list\n"));
        return MFD_ERROR;
    }
#endif
    
    DEBUGMSGT(("verbose:etherStatsTable:etherStatsTable_container_load",
               "inserted %" NETSNMP_PRIz "d records\n", count));

    return MFD_SUCCESS;
}
                               /* etherStatsTable_container_load */


/**
 * container clean up
 *
 * @param container container with all current items
 *
 *  This optional callback is called prior to all
 *  item's being removed from the container. If you
 *  need to do any processing before that, do it here.
 *
 * @note
 *  The MFD helper will take care of releasing all the row contexts.
 *
 */
void
etherStatsTable_container_free(netsnmp_container * container)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_container_free",
                "called\n"));

    /*
     * TODO:380:M: Free etherStatsTable container data.
     */
}                               /* etherStatsTable_container_free */

/**
 * prepare row for processing.
 *
 *  When the agent has located the row for a request, this function is
 *  called to prepare the row for processing. If you fully populated
 *  the data context during the index setup phase, you may not need to
 *  do anything.
 *
 * @param rowreq_ctx pointer to a context.
 *
 * @retval MFD_SUCCESS     : success.
 * @retval MFD_ERROR       : other error.
 */
int
etherStatsTable_row_prep(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_row_prep",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:390:o: Prepare row for request.
     * If populating row data was delayed, this is the place to
     * fill in the row for this request.
     */

    return MFD_SUCCESS;
}                               /* etherStatsTable_row_prep */

/*
 * TODO:420:r: Implement etherStatsTable index validation.
 */
/*---------------------------------------------------------------------
 * RMON-MIB::etherStatsEntry.etherStatsIndex
 * etherStatsIndex is subid 1 of etherStatsEntry.
 * Its status is Current, and its access level is ReadOnly.
 * OID: .1.3.6.1.2.1.16.1.1.1.1
 * Description:
The value of this object uniquely identifies this
        etherStats entry.
 *
 * Attributes:
 *   accessible 1     isscalar 0     enums  0      hasdefval 0
 *   readable   1     iscolumn 1     ranges 1      hashint   0
 *   settable   0
 *
 * Ranges:  1 - 65535;
 *
 * Its syntax is INTEGER32 (based on perltype INTEGER32)
 * The net-snmp type is ASN_INTEGER. The C type decl is long (long)
 */
/**
 * check validity of etherStatsIndex index portion
 *
 * @retval MFD_SUCCESS   : the incoming value is legal
 * @retval MFD_ERROR     : the incoming value is NOT legal
 *
 * @note this is not the place to do any checks for the sanity
 *       of multiple indexes. Those types of checks should be done in the
 *       etherStatsTable_validate_index() function.
 *
 * @note Also keep in mind that if the index refers to a row in this or
 *       some other table, you can't check for that row here to make
 *       decisions, since that row might not be created yet, but may
 *       be created during the processing this request. If you have
 *       such checks, they should be done in the check_dependencies
 *       function, because any new/deleted/changed rows should be
 *       available then.
 *
 * The following checks have already been done for you:
 *    The value is in (one of) the range set(s):  1 - 65535
 *
 * If there a no other checks you need to do, simply return MFD_SUCCESS.
 */
int
etherStatsIndex_check_index(etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsIndex_check_index",
                "called\n"));

    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:426:M: |-> Check etherStatsTable index etherStatsIndex.
     * check that index value in the table context is legal.
     * (rowreq_ctx->tbl_index.etherStatsIndex)
     */

    return MFD_SUCCESS;         /* etherStatsIndex index ok */
}                               /* etherStatsIndex_check_index */

/**
 * verify specified index is valid.
 *
 * This check is independent of whether or not the values specified for
 * the columns of the new row are valid. Column values and row consistency
 * will be checked later. At this point, only the index values should be
 * checked.
 *
 * All of the individual index validation functions have been called, so this
 * is the place to make sure they are valid as a whole when combined. If
 * you only have one index, then you probably don't need to do anything else
 * here.
 * 
 * @note Keep in mind that if the indexes refer to a row in this or
 *       some other table, you can't check for that row here to make
 *       decisions, since that row might not be created yet, but may
 *       be created during the processing this request. If you have
 *       such checks, they should be done in the check_dependencies
 *       function, because any new/deleted/changed rows should be
 *       available then.
 *
 *
 * @param etherStatsTable_reg
 *        Pointer to the user registration data
 * @param etherStatsTable_rowreq_ctx
 *        Pointer to the users context.
 * @retval MFD_SUCCESS            : success
 * @retval MFD_CANNOT_CREATE_NOW  : index not valid right now
 * @retval MFD_CANNOT_CREATE_EVER : index never valid
 */
int
etherStatsTable_validate_index(etherStatsTable_registration *
                               etherStatsTable_reg,
                               etherStatsTable_rowreq_ctx * rowreq_ctx)
{
    int             rc = MFD_SUCCESS;

    DEBUGMSGTL(("verbose:etherStatsTable:etherStatsTable_validate_index",
                "called\n"));

    /** we should have a non-NULL pointer */
    netsnmp_assert(NULL != rowreq_ctx);

    /*
     * TODO:430:M: |-> Validate potential etherStatsTable index.
     */
    if (1) {
        snmp_log(LOG_WARNING, "invalid index for a new row in the "
                 "etherStatsTable table.\n");
        /*
         * determine failure type.
         *
         * If the index could not ever be created, return MFD_NOT_EVER
         * If the index can not be created under the present circumstances
         * (even though it could be created under other circumstances),
         * return MFD_NOT_NOW.
         */
        if (0) {
            return MFD_CANNOT_CREATE_EVER;
        } else {
            return MFD_CANNOT_CREATE_NOW;
        }
    }

    return rc;
}                               /* etherStatsTable_validate_index */

/** @} */
