/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.ocsp.IDefStore;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.ocsp.UpdateCRLThread;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.RepositoryRecord;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.util.StatsSubsystem;
import com.netscape.cmsutil.crypto.CryptoUtil;
import com.netscape.ocsp.OCSPAuthority;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ocsp.OCSPEngine;
import org.dogtagpki.server.ocsp.OCSPEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.crypto.CryptoToken;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddCRLServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(AddCRLServlet.class);
    private static final long serialVersionUID = 1476080474638590902L;
    private static final String TPL_FILE = "addCRL.template";
    private String mFormPath = null;
    private OCSPAuthority mOCSPAuthority;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        this.mFormPath = "/ocsp/addCRL.template";
        this.mTemplates.remove(CMSRequest.SUCCESS);
        OCSPEngine engine = OCSPEngine.getInstance();
        this.mOCSPAuthority = engine.getOCSP();
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void process(CMSRequest cmsReq) throws EBaseException {
        StatsSubsystem statsSub;
        block50: {
            logger.info("AddCRLServlet: Adding CRL");
            OCSPEngine engine = OCSPEngine.getInstance();
            OCSPEngineConfig cs = engine.getConfig();
            boolean CRLFetched = false;
            boolean CRLValidated = false;
            Auditor auditor = engine.getAuditor();
            String auditMessage = null;
            String auditSubjectID = this.auditSubjectID();
            String auditCRLNum = "<null>";
            statsSub = (StatsSubsystem)engine.getSubsystem("stats");
            if (statsSub != null) {
                statsSub.startTiming("add_crl", true);
            }
            try {
                CRLIssuingPointRecord pt;
                X509CRLImpl crl;
                IDefStore defStore;
                CMSTemplateParams argSet;
                CMSTemplate form;
                boolean noUI;
                HttpServletResponse resp;
                HttpServletRequest req;
                block49: {
                    String uid;
                    req = cmsReq.getHttpReq();
                    resp = cmsReq.getHttpResp();
                    AuthToken authToken = this.authenticate(cmsReq);
                    AuthzToken authzToken = null;
                    try {
                        authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "add");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (authzToken == null) {
                        cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Failure", auditCRLNum});
                        auditor.log(auditMessage);
                        return;
                    }
                    if ((auditSubjectID.equals("$NonRoleUser$") || auditSubjectID.equals("$Unidentified$")) && authToken != null && (uid = authToken.getInString("userid")) != null) {
                        logger.debug("AddCRLServlet: auditSubjectID set to " + uid);
                        auditSubjectID = uid;
                    }
                    String b64 = cmsReq.getHttpReq().getParameter("crl");
                    logger.info("AddCRLServlet: CRL: " + b64);
                    if (b64 == null) {
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Failure", auditCRLNum});
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_MISSING_CRL", (String[])new String[0]));
                    }
                    String nouiParm = cmsReq.getHttpReq().getParameter("noui");
                    noUI = false;
                    if (nouiParm != null && nouiParm.equals("true")) {
                        noUI = true;
                        logger.debug("AddCRLServlet: noUI=true");
                    } else {
                        logger.debug("AddCRLServlet: noUI=false");
                    }
                    form = null;
                    Locale[] locale = new Locale[1];
                    try {
                        if (!noUI) {
                            form = this.getTemplate(this.mFormPath, req, locale);
                        }
                    }
                    catch (IOException e) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Failure", auditCRLNum});
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]));
                    }
                    ArgBlock header = new ArgBlock();
                    ArgBlock fixed = new ArgBlock();
                    argSet = new CMSTemplateParams(header, fixed);
                    if (b64.indexOf("-----BEGIN CERTIFICATE REVOCATION LIST-----") == -1) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CRL_HEADER", (Object[])new Object[0]));
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Failure", auditCRLNum});
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CRL_HEADER", (String[])new String[0]));
                    }
                    if (b64.indexOf("-----END CERTIFICATE REVOCATION LIST-----") == -1) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_MISSING_CRL_FOOTER", (Object[])new Object[0]));
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Failure", auditCRLNum});
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getUserMessage((Locale)this.getLocale(req), (String)"CMS_GW_MISSING_CRL_FOOTER", (String[])new String[0]));
                    }
                    defStore = this.mOCSPAuthority.getDefaultStore();
                    crl = null;
                    try {
                        long startTime = new Date().getTime();
                        logger.debug("AddCRLServlet: mapCRL start startTime=" + startTime);
                        if (statsSub != null) {
                            statsSub.startTiming("decode_crl");
                        }
                        crl = this.mapCRL1(b64);
                        if (statsSub != null) {
                            statsSub.endTiming("decode_crl");
                        }
                        long endTime = new Date().getTime();
                        logger.debug("AddCRLServlet: mapCRL done endTime=" + endTime + " diff=" + (endTime - startTime));
                        BigInteger crlNum = crl.getCRLNumber();
                        if (crlNum != null) {
                            auditCRLNum = crlNum.toString();
                        }
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Success", auditCRLNum});
                        auditor.log(auditMessage);
                        CRLFetched = true;
                    }
                    catch (Exception e) {
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Failure", auditCRLNum});
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DECODING_CRL_ERROR", (String[])new String[0]));
                    }
                    logger.info("AddCRLServlet: CRL Issuer DN " + crl.getIssuerDN().getName());
                    pt = null;
                    try {
                        pt = defStore.readCRLIssuingPoint(crl.getIssuerDN().getName());
                    }
                    catch (Exception e) {
                        logger.error(CMS.getLogMessage((String)"CMSGW_NO_CRL_ISSUING_POINT_FOUND", (Object[])new Object[]{crl.getIssuerDN().getName()}), (Throwable)e);
                        auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_VALIDATION_2", (Object[])new Object[]{auditSubjectID, "Failure"});
                        auditor.log(auditMessage);
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DECODING_CRL_ERROR", (String[])new String[0]));
                    }
                    logger.info("AddCRLServlet: IssuingPoint " + pt.getThisUpdate());
                    CryptoManager cmanager = null;
                    boolean tokenSwitched = false;
                    CryptoToken verToken = null;
                    CryptoToken savedToken = null;
                    byte[] caCertData = pt.getCACert();
                    if (caCertData != null) {
                        try {
                            cmanager = CryptoManager.getInstance();
                            X509CertImpl caCert = new X509CertImpl(caCertData);
                            logger.debug("AddCRLServlet: start verify");
                            String tokenName = cs.getString("ocsp.crlVerify.token", "internal");
                            savedToken = cmanager.getThreadToken();
                            verToken = CryptoUtil.getCryptoToken((String)tokenName);
                            if (!savedToken.getName().equals(verToken.getName())) {
                                cmanager.setThreadToken(verToken);
                                tokenSwitched = true;
                            }
                            X509Certificate jssCert = null;
                            try {
                                jssCert = cmanager.importCACertPackage(caCert.getEncoded());
                            }
                            catch (Exception e2) {
                                logger.error("AddCRLServlet: importCACertPackage: " + e2.getMessage(), (Throwable)e2);
                                throw new EBaseException(e2.toString());
                            }
                            if (statsSub != null) {
                                statsSub.startTiming("verify_crl");
                            }
                            crl.verify(jssCert.getPublicKey(), "Mozilla-JSS");
                            if (statsSub != null) {
                                statsSub.endTiming("verify_crl");
                            }
                            logger.debug("AddCRLServlet: done verify");
                            auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_VALIDATION_2", (Object[])new Object[]{auditSubjectID, "Success"});
                            auditor.log(auditMessage);
                            CRLValidated = true;
                            if (!tokenSwitched) break block49;
                        }
                        catch (Exception e) {
                            try {
                                logger.error("AddCRLServlet: failed to verify CRL: " + e.getMessage(), (Throwable)e);
                                logger.error(CMS.getLogMessage((String)"CMSGW_NO_CRL_ISSUING_POINT_FOUND", (Object[])new Object[]{crl.getIssuerDN().getName()}), (Throwable)e);
                                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_VALIDATION_2", (Object[])new Object[]{auditSubjectID, "Failure"});
                                auditor.log(auditMessage);
                                throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DECODING_CRL_ERROR", (String[])new String[0]));
                            }
                            catch (Throwable throwable) {
                                if (!tokenSwitched) throw throwable;
                                cmanager.setThreadToken(savedToken);
                                throw throwable;
                            }
                        }
                        cmanager.setThreadToken(savedToken);
                    }
                }
                if (pt.getThisUpdate() != null && pt.getThisUpdate().getTime() >= crl.getThisUpdate().getTime()) {
                    logger.warn("AddCRLServlet: no update, received CRL is older than current CRL");
                    if (!noUI) {
                        logger.error("AddCRLServlet: CRL is older");
                        throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_OLD_CRL_ERROR", (String[])new String[0]));
                    }
                    try {
                        resp.setContentType("application/text");
                        resp.getOutputStream().write("status=1\n".getBytes());
                        resp.getOutputStream().write("error=Sent CRL is older than the current CRL\n".getBytes());
                        resp.getOutputStream().flush();
                        cmsReq.setStatus(CMSRequest.SUCCESS);
                        return;
                    }
                    catch (Exception e) {}
                }
                if (crl.isDeltaCRL()) {
                    logger.warn("AddCRLServlet: no update, " + CMS.getUserMessage((String)"CMS_GW_DELTA_CRL_NOT_SUPPORTED", (String[])new String[0]));
                    if (!noUI) throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DELTA_CRL_NOT_SUPPORTED", (String[])new String[0]));
                    try {
                        resp.setContentType("application/text");
                        resp.getOutputStream().write("status=1\n".getBytes());
                        resp.getOutputStream().write("error=Delta CRLs are not supported.\n".getBytes());
                        resp.getOutputStream().flush();
                        cmsReq.setStatus(CMSRequest.SUCCESS);
                        return;
                    }
                    catch (Exception e) {}
                }
                logger.info("AddCRLServlet: Start Committing CRL");
                RepositoryRecord repRec = defStore.createRepositoryRecord();
                repRec.set("serialNo", (Object)new BigInteger(Long.toString(crl.getThisUpdate().getTime())));
                try {
                    defStore.addRepository(crl.getIssuerDN().getName(), Long.toString(crl.getThisUpdate().getTime()), repRec);
                    logger.info("AddCRLServlet: Added CRL Updated " + Long.toString(crl.getThisUpdate().getTime()));
                }
                catch (Exception e) {
                    logger.warn("AddCRLServlet: add repository: " + e.getMessage(), (Throwable)e);
                }
                logger.info("AddCRLServlet: Created CRL Repository " + Long.toString(crl.getThisUpdate().getTime()));
                if (defStore.waitOnCRLUpdate()) {
                    defStore.updateCRL((X509CRL)crl);
                } else {
                    UpdateCRLThread uct = new UpdateCRLThread(defStore, (X509CRL)crl);
                    uct.start();
                }
                try {
                    ServletOutputStream out = resp.getOutputStream();
                    if (noUI) {
                        logger.debug("AddCRLServlet: return result noUI=true");
                        resp.setContentType("application/text");
                        resp.getOutputStream().write("status=0".getBytes());
                        resp.getOutputStream().flush();
                        cmsReq.setStatus(CMSRequest.SUCCESS);
                        break block50;
                    }
                    logger.debug("AddCRLServlet: return result noUI=false");
                    String xmlOutput = req.getParameter("xml");
                    if (xmlOutput != null && xmlOutput.equals("true")) {
                        this.outputXML(resp, argSet);
                    } else {
                        resp.setContentType("text/html");
                        form.renderOutput((OutputStream)out, argSet);
                        cmsReq.setStatus(CMSRequest.SUCCESS);
                    }
                }
                catch (IOException e) {
                    logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                    throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
                }
            }
            catch (EBaseException eAudit1) {
                if (!CRLFetched) {
                    auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_RETRIEVAL_3", (Object[])new Object[]{auditSubjectID, "Failure", auditCRLNum});
                    auditor.log(auditMessage);
                    throw eAudit1;
                }
                if (CRLValidated) throw eAudit1;
                auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CRL_VALIDATION_2", (Object[])new Object[]{auditSubjectID, "Failure"});
                auditor.log(auditMessage);
                throw eAudit1;
            }
        }
        if (statsSub == null) return;
        statsSub.endTiming("add_crl");
    }

    public X509CRLImpl mapCRL1(String mime64) throws IOException {
        mime64 = Cert.stripCRLBrackets((String)mime64.trim());
        byte[] rawPub = Utils.base64decode((String)mime64);
        X509CRLImpl crl = null;
        try {
            crl = new X509CRLImpl(rawPub, false);
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        return crl;
    }
}

