/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.cert.CertRequestInfo;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmstools.ca.CACertCLI;
import com.netscape.cmstools.ca.CACertRequestCLI;
import com.netscape.cmstools.cli.MainCLI;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import org.apache.commons.cli.CommandLine;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertReleaseHoldCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertReleaseHoldCLI.class);
    public CACertCLI certCLI;

    public CACertReleaseHoldCLI(CACertCLI certCLI) {
        super("release-hold", "Place certificate off-hold", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <Serial Number> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        this.options.addOption(null, "force", false, "Force");
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length != 1) {
            throw new Exception("Missing Serial Number.");
        }
        CertId certID = new CertId(cmdArgs[0]);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        CACertClient certClient = this.certCLI.getCertClient();
        if (!cmd.hasOption("force")) {
            CertData certData = certClient.getCert(certID);
            System.out.println("Placing certificate off-hold:");
            CACertCLI.printCertData(certData, false, false);
            System.out.print("Are you sure (Y/N)? ");
            System.out.flush();
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line = reader.readLine();
            if (!line.equalsIgnoreCase("Y")) {
                return;
            }
        }
        CertRequestInfo certRequestInfo = certClient.unrevokeCert(certID);
        if (logger.isInfoEnabled()) {
            CACertRequestCLI.printCertRequestInfo(certRequestInfo);
        }
        if (certRequestInfo.getRequestStatus() == RequestStatus.COMPLETE) {
            if (certRequestInfo.getOperationResult().equals("error")) {
                String error = certRequestInfo.getErrorMessage();
                if (error != null) {
                    System.out.println(error);
                }
                MainCLI.printMessage("Could not place certificate \"" + certID.toHexString() + "\" off-hold");
            } else {
                MainCLI.printMessage("Placed certificate \"" + certID.toHexString() + "\" off-hold");
                CertData certData = certClient.getCert(certID);
                CACertCLI.printCertData(certData, false, false);
            }
        } else {
            MainCLI.printMessage("Request \"" + certRequestInfo.getRequestID().toHexString() + "\": " + certRequestInfo.getRequestStatus());
        }
    }
}

