/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.ca;

import com.netscape.certsrv.authority.AuthorityClient;
import com.netscape.certsrv.authority.AuthorityData;
import com.netscape.certsrv.ca.CACertClient;
import com.netscape.certsrv.ca.CAClient;
import com.netscape.certsrv.cert.CertData;
import com.netscape.certsrv.client.ClientConfig;
import com.netscape.certsrv.client.PKIClient;
import com.netscape.certsrv.client.SubsystemClient;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.cmstools.ca.CACertCLI;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmsutil.ocsp.BasicOCSPResponse;
import com.netscape.cmsutil.ocsp.CertStatus;
import com.netscape.cmsutil.ocsp.GoodInfo;
import com.netscape.cmsutil.ocsp.OCSPProcessor;
import com.netscape.cmsutil.ocsp.OCSPRequest;
import com.netscape.cmsutil.ocsp.OCSPResponse;
import com.netscape.cmsutil.ocsp.ResponseData;
import com.netscape.cmsutil.ocsp.RevokedInfo;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.UnknownInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CACertStatusCLI
extends CommandCLI {
    public static Logger logger = LoggerFactory.getLogger(CACertStatusCLI.class);
    public CACertCLI certCLI;

    public CACertStatusCLI(CACertCLI certCLI) {
        super("status", "Check certificate status", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " <serial number> [OPTIONS...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "ocsp", true, "OCSP URL");
        option.setArgName("URL");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new Exception("Missing certificate serial number.");
        }
        CertId certID = new CertId(cmdArgs[0]);
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = this.getClient();
        CAClient caClient = new CAClient(client);
        CACertClient certClient = new CACertClient((SubsystemClient)caClient);
        AuthorityClient authorityClient = new AuthorityClient((SubsystemClient)caClient);
        ClientConfig config = this.getConfig();
        String ocspURL = cmd.getOptionValue("ocsp", config.getServerURL() + "/ca/ocsp");
        OCSPProcessor processor = new OCSPProcessor();
        processor.setURL(ocspURL);
        CertData certData = certClient.getCert(certID);
        String subjectDN = certData.getSubjectDN();
        String issuerDN = certData.getIssuerDN();
        List authorities = authorityClient.findCAs(null, null, issuerDN, null);
        if (authorities.size() == 0) {
            throw new CLIException("Unknown certificate issuer: " + issuerDN, 1);
        }
        AuthorityData authorityData = (AuthorityData)authorities.iterator().next();
        BigInteger issuerSerialNumber = authorityData.getSerial();
        CertData caCertData = certClient.getCert(new CertId(issuerSerialNumber));
        String pemCert = caCertData.getEncoded();
        byte[] binCert = Cert.parseCertificate((String)pemCert);
        X509CertImpl caCert = new X509CertImpl(binCert);
        X500Name caDN = caCert.getSubjectName();
        X509Key caKey = (X509Key)caCert.getPublicKey();
        OCSPRequest request = processor.createRequest(caDN, caKey, certID.toBigInteger());
        OCSPResponse response = processor.submitRequest(request);
        byte[] binResponse = response.getResponseBytes().getResponse().toByteArray();
        BasicOCSPResponse basic = (BasicOCSPResponse)BasicOCSPResponse.getTemplate().decode((InputStream)new ByteArrayInputStream(binResponse));
        ResponseData rd = basic.getResponseData();
        SingleResponse sr = rd.getResponseAt(0);
        CertStatus status = sr.getCertStatus();
        System.out.println("  Serial Number: " + certID.toHexString());
        System.out.println("  Subject DN: " + subjectDN);
        System.out.println("  Issuer DN: " + issuerDN);
        if (status instanceof GoodInfo) {
            System.out.println("  Status: Good");
        } else if (status instanceof UnknownInfo) {
            System.out.println("  Status: Unknown");
        } else if (status instanceof RevokedInfo) {
            System.out.println("  Status: Revoked");
            RevokedInfo info = (RevokedInfo)status;
            System.out.println("  Revoked On: " + info.getRevocationTime().toDate());
        }
    }
}

