/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.pkcs7;

import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.pkcs7.PKCS7CertCLI;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.cert.X509Certificate;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CommandCLI;
import org.mozilla.jss.netscape.security.pkcs.PKCS7;
import org.mozilla.jss.netscape.security.util.Cert;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7CertExportCLI
extends CommandCLI {
    private static Logger logger = LoggerFactory.getLogger(PKCS7CertExportCLI.class);
    public PKCS7CertCLI certCLI;

    public PKCS7CertExportCLI(PKCS7CertCLI certCLI) {
        super("export", "Export certificates from PKCS #7 file", (CLI)certCLI);
        this.certCLI = certCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] [nicknames...]", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "pkcs7", true, "PKCS #7 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "pkcs7-file", true, "DEPRECATED: PKCS #7 file");
        option.setArgName("path");
        this.options.addOption(option);
        option = new Option(null, "output-file", true, "Output file");
        option.setArgName("string");
        this.options.addOption(option);
        option = new Option(null, "output-prefix", true, "Prefix for output file");
        option.setArgName("string");
        this.options.addOption(option);
        option = new Option(null, "output-suffix", true, "Suffix for output file");
        option.setArgName("string");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String filename = cmd.getOptionValue("pkcs7");
        if (filename == null && (filename = cmd.getOptionValue("pkcs7-file")) != null) {
            logger.warn("The --pkcs7-file has been deprecated. Use --pkcs7 instead.");
        }
        if (filename == null) {
            throw new Exception("Missing PKCS #7 file.");
        }
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        logger.info("Loading PKCS #7 data from " + filename);
        String str = new String(Files.readAllBytes(Paths.get(filename, new String[0]))).trim();
        PKCS7 pkcs7 = new PKCS7(str);
        X509Certificate[] certs = pkcs7.getCertificates();
        if (certs == null || certs.length == 0) {
            System.out.println("PKCS #7 data contains no certificates");
            return;
        }
        certs = Cert.sortCertificateChain((X509Certificate[])certs);
        String outputFile = cmd.getOptionValue("output-file");
        if (outputFile != null) {
            try (PrintWriter out = new PrintWriter(outputFile);){
                for (X509Certificate cert : certs) {
                    out.println("-----BEGIN CERTIFICATE-----");
                    out.print(Utils.base64encodeMultiLine((byte[])cert.getEncoded()));
                    out.println("-----END CERTIFICATE-----");
                }
            }
            return;
        }
        String prefix = cmd.getOptionValue("output-prefix", filename + "-");
        String suffix = cmd.getOptionValue("output-suffix", "");
        int i = 0;
        for (X509Certificate cert : certs) {
            logger.info("Exporting certificate #" + i + ": " + cert.getSubjectDN());
            String output = prefix + i + suffix;
            try (PrintWriter out = new PrintWriter(new FileWriter(output));){
                out.println("-----BEGIN CERTIFICATE-----");
                out.print(Utils.base64encode((byte[])cert.getEncoded(), (boolean)true));
                out.println("-----END CERTIFICATE-----");
            }
            System.out.println(output + ": " + cert.getSubjectDN());
            ++i;
        }
    }
}

