/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmstools.system;

import com.netscape.certsrv.client.PKIClient;
import com.netscape.cmstools.cli.MainCLI;
import com.netscape.cmstools.system.SecurityDomainCLI;
import com.netscape.cmsutil.xml.XMLObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang3.StringUtils;
import org.dogtagpki.cli.CLI;
import org.dogtagpki.cli.CLIException;
import org.dogtagpki.cli.CommandCLI;

public class SecurityDomainLeaveCLI
extends CommandCLI {
    SecurityDomainCLI securityDomainCLI;

    public SecurityDomainLeaveCLI(SecurityDomainCLI securityDomainCLI) {
        super("leave", "Leave security domain", (CLI)securityDomainCLI);
        this.securityDomainCLI = securityDomainCLI;
    }

    public void printHelp() {
        formatter.printHelp(this.getFullName() + " [OPTIONS...] <host ID>", this.options);
    }

    public void createOptions() {
        Option option = new Option(null, "type", true, "Subsystem type");
        option.setArgName("type");
        this.options.addOption(option);
        option = new Option(null, "hostname", true, "Hostname");
        option.setArgName("hostname");
        this.options.addOption(option);
        option = new Option(null, "secure-port", true, "Secure port (default: 8443)");
        option.setArgName("port");
        this.options.addOption(option);
    }

    public void execute(CommandLine cmd) throws Exception {
        String[] cmdArgs = cmd.getArgs();
        if (cmdArgs.length < 1) {
            throw new CLIException("Missing host ID");
        }
        String hostID = cmdArgs[0];
        String type = cmd.getOptionValue("type");
        if (type == null) {
            throw new CLIException("Missing subsystem type");
        }
        String hostname = cmd.getOptionValue("hostname");
        if (hostname == null) {
            throw new CLIException("Missing hostname");
        }
        String securePort = cmd.getOptionValue("secure-port", "8443");
        MultivaluedHashMap content = new MultivaluedHashMap();
        content.putSingle((Object)"type", (Object)type);
        content.putSingle((Object)"name", (Object)hostID);
        content.putSingle((Object)"host", (Object)hostname);
        content.putSingle((Object)"sport", (Object)securePort);
        content.putSingle((Object)"operation", (Object)"remove");
        MainCLI mainCLI = (MainCLI)this.getRoot();
        mainCLI.init();
        PKIClient client = mainCLI.getClient();
        String response = (String)client.post("ca/agent/ca/updateDomainXML", (MultivaluedMap)content, String.class);
        if (StringUtils.isEmpty((CharSequence)response)) {
            logger.error("Missing response");
            throw new CLIException("Missing response");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(response.getBytes());
        XMLObject obj = new XMLObject((InputStream)bis);
        String status = obj.getValue("Status");
        logger.info("Status: " + status);
        if (status.equals("0")) {
            return;
        }
        if (status.equals("1")) {
            throw new CLIException("Authentication failure");
        }
        String error = obj.getValue("Error");
        throw new CLIException(error);
    }
}

