/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmsutil.http;

import com.netscape.cmsutil.http.HttpMessage;
import com.netscape.cmsutil.http.HttpProtocolException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class HttpResponse
extends HttpMessage {
    protected String mStatusCode = null;
    protected String mReasonPhrase = null;
    protected String mHttpVers = null;

    public void setStatusCode(int code) {
        this.mStatusCode = String.valueOf(code);
    }

    public void setReasonPhrase(String phrase) {
        this.mReasonPhrase = phrase;
    }

    public String getStatusCode() {
        return this.mStatusCode;
    }

    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    @Override
    public void write(OutputStreamWriter writer) throws IOException {
        if (this.mStatusCode == null) {
            throw new HttpProtocolException("status code not set in response");
        }
        this.mLine = "HTTP/1.0 " + this.mStatusCode + " ";
        if (this.mReasonPhrase != null) {
            this.mLine = this.mLine + this.mReasonPhrase;
        }
        this.mLine = this.mLine + "\r\n";
        super.write(writer);
    }

    @Override
    public void parse(BufferedReader reader) throws IOException {
        this.mHttpVers = null;
        this.mStatusCode = null;
        this.mReasonPhrase = null;
        super.parse(reader);
        int httpvers = this.mLine.indexOf(32);
        if (httpvers == -1) {
            this.reset();
            throw new HttpProtocolException("no Http version in response");
        }
        this.mHttpVers = this.mLine.substring(0, httpvers);
        if (!this.mHttpVers.equals("HTTP/1.0") && !this.mHttpVers.equals("HTTP/1.1")) {
            this.reset();
            throw new HttpProtocolException("Bad Http version in response");
        }
        int code = this.mLine.indexOf(32, httpvers + 1);
        if (code == -1) {
            this.reset();
            throw new HttpProtocolException("no status code in response");
        }
        this.mStatusCode = this.mLine.substring(httpvers + 1, code);
        try {
            Integer.parseInt(this.mStatusCode);
        }
        catch (NumberFormatException e) {
            this.reset();
            throw new HttpProtocolException("Bad status code in response");
        }
        this.mReasonPhrase = this.mLine.substring(code + 1);
    }

    @Override
    public void reset() {
        this.mStatusCode = null;
        this.mHttpVers = null;
        this.mReasonPhrase = null;
        super.reset();
    }

    public String getHttpVers() {
        return this.mHttpVers;
    }
}

