/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CMSCRLExtensions;
import com.netscape.ca.CRLConfig;
import com.netscape.ca.CRLExtensionConfig;
import com.netscape.ca.CRLExtensionsConfig;
import com.netscape.ca.CRLIssuingPointConfig;
import com.netscape.ca.CertRecordProcessor;
import com.netscape.ca.CertificateAuthority;
import com.netscape.ca.RevocationRequestListener;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.ca.ECAException;
import com.netscape.certsrv.ca.EErrorPublishCRL;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.dbs.EDBNotAvailException;
import com.netscape.certsrv.dbs.EDBRecordNotFoundException;
import com.netscape.certsrv.dbs.certdb.CertId;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.DeltaCRLGenerationEvent;
import com.netscape.certsrv.logging.event.DeltaCRLPublishingEvent;
import com.netscape.certsrv.logging.event.FullCRLGenerationEvent;
import com.netscape.certsrv.logging.event.FullCRLPublishingEvent;
import com.netscape.certsrv.request.IRequestVirtualList;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CRLIssuingPointRecord;
import com.netscape.cmscore.dbs.CRLRepository;
import com.netscape.cmscore.ldap.CAPublisherProcessor;
import com.netscape.cmscore.ldap.LdapRule;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.util.StatsSubsystem;
import java.io.IOException;
import java.math.BigInteger;
import java.security.cert.X509CRL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import org.dogtagpki.server.ca.CAConfig;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.dogtagpki.server.ca.ProfileSubsystemConfig;
import org.mozilla.jss.netscape.security.x509.AlgorithmId;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.DeltaCRLIndicatorExtension;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPoint;
import org.mozilla.jss.netscape.security.x509.IssuingDistributionPointExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.RevokedCertificate;
import org.mozilla.jss.netscape.security.x509.X509CRLImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CRLIssuingPoint
implements Runnable {
    public static final Logger logger = LoggerFactory.getLogger(CRLIssuingPoint.class);
    public static final String PROP_PUBLISH_DN = "publishDN";
    public static final String PROP_PUBLISH_ON_START = "publishOnStart";
    public static final String PROP_MIN_UPDATE_INTERVAL = "minUpdateInterval";
    public static final String PROP_BEGIN_SERIAL = "crlBeginSerialNo";
    public static final String PROP_END_SERIAL = "crlEndSerialNo";
    public static final String SC_ISSUING_POINT_ID = "issuingPointId";
    public static final String SC_IS_DELTA_CRL = "isDeltaCRL";
    public static final String SC_CRL_COUNT = "crlCount";
    public static final int CRL_UPDATE_DONE = 0;
    public static final int CRL_UPDATE_STARTED = 1;
    public static final int CRL_PUBLISHING_STARTED = 2;
    public static final String PROP_CACERTS = "onlyContainsCACerts";
    public static final long SECOND = 1000L;
    public static final long MINUTE = 60000L;
    private static final int CRL_PAGE_SIZE = 10000;
    private static final String PROP_CRL_STARTING_NUMBER = "startingCrlNumber";
    public CAPublisherProcessor mPublisherProcessor;
    private CRLIssuingPointConfig mConfigStore;
    private int mCountMod = 0;
    private int mCount = 0;
    private int mPageSize = 10000;
    private CMSCRLExtensions mCMSCRLExtensions = null;
    protected String mId = null;
    protected CertificateAuthority mCA;
    protected CRLRepository mCRLRepository;
    private boolean mEnable = true;
    private String mDescription = null;
    private Hashtable<BigInteger, RevokedCertificate> mCRLCerts = new Hashtable();
    private Hashtable<BigInteger, RevokedCertificate> mRevokedCerts = new Hashtable();
    private Hashtable<BigInteger, RevokedCertificate> mUnrevokedCerts = new Hashtable();
    private Hashtable<BigInteger, RevokedCertificate> mExpiredCerts = new Hashtable();
    private boolean mIncludeExpiredCerts = false;
    private boolean mIncludeExpiredCertsOneExtraTime = false;
    private boolean mCACertsOnly = false;
    private boolean mProfileCertsOnly = false;
    private Vector<String> mProfileList = null;
    private boolean mEnableCRLCache = true;
    private boolean mCRLCacheIsCleared = true;
    private boolean mEnableCacheRecovery = false;
    private String mFirstUnsaved = null;
    private boolean mEnableCacheTesting = false;
    private long mLastCacheUpdate = 0L;
    private long mCacheUpdateInterval;
    private boolean mEnableCRLUpdates = true;
    private int mUpdateSchema = 1;
    private int mSchemaCounter = 0;
    private boolean mEnableDailyUpdates = false;
    private Vector<Vector<Integer>> mDailyUpdates = null;
    private int mCurrentDay = 0;
    private int mLastDay = 0;
    private int mTimeListSize = 0;
    private boolean mExtendedTimeList = false;
    private boolean mEnableUpdateFreq = false;
    private long mAutoUpdateInterval;
    private long mMinUpdateInterval;
    boolean mAlwaysUpdate = false;
    private long mNextUpdateGracePeriod;
    private long mUnexpectedExceptionWaitTime;
    private int mUnexpectedExceptionLoopMax;
    private long mNextAsThisUpdateExtension;
    private boolean mAllowExtensions = false;
    private String mPublishDN = null;
    private String mSigningAlgorithm = null;
    private String mLastSigningAlgorithm = null;
    private BigInteger mCRLNumber;
    private BigInteger mNextCRLNumber;
    private BigInteger mLastCRLNumber;
    private BigInteger mDeltaCRLNumber;
    private BigInteger mNextDeltaCRLNumber;
    private Date mLastUpdate;
    private Date mLastFullUpdate;
    private Date mNextUpdate;
    private Date mNextDeltaUpdate;
    private boolean mExtendedNextUpdate;
    private Thread mUpdateThread = null;
    private boolean mDoLastAutoUpdate = false;
    private CRLIssuingPointStatus mInitialized = CRLIssuingPointStatus.NotInitialized;
    private long mCRLSize = -1L;
    private long mDeltaCRLSize = -1L;
    String mCrlUpdateStatus;
    String mCrlUpdateError;
    String mCrlPublishStatus;
    String mCrlPublishError;
    protected BigInteger mBeginSerial = null;
    protected BigInteger mEndSerial = null;
    private int mUpdatingCRL = 0;
    private boolean mDoManualUpdate = false;
    private String mSignatureAlgorithmForManualUpdate = null;
    private boolean mPublishOnStart = false;
    private long[] mSplits = new long[10];
    private boolean mSaveMemory = false;
    private boolean mAutoUpdateIntervalEffectiveAtStart = false;
    private Date mCustomFutureThisUpdateValue = null;
    private boolean mForbidCustomFutureThisUpdateValue = true;
    private boolean mCancelCurFutureThisUpdateValue = false;
    private Object configMonitor = new Object();
    private static final int REVOKED_CERT = 1;
    private static final int UNREVOKED_CERT = 2;
    private Object cacheMonitor = new Object();
    private Object repositoryMonitor = new Object();

    public boolean isCRLIssuingPointEnabled() {
        return this.mEnable;
    }

    public void enableCRLIssuingPoint(boolean enable) {
        if (!enable && this.mEnable) {
            this.clearCRLCache();
            this.updateCRLCacheRepository();
        } else if (enable && !this.mEnable) {
            this.mInitialized = CRLIssuingPointStatus.NotInitialized;
        }
        this.mEnable = enable;
        this.setAutoUpdates();
    }

    public boolean isCRLGenerationEnabled() {
        return this.mEnableCRLUpdates;
    }

    public String getCrlUpdateStatusStr() {
        return this.mCrlUpdateStatus;
    }

    public String getCrlUpdateErrorStr() {
        return this.mCrlUpdateError;
    }

    public String getCrlPublishStatusStr() {
        return this.mCrlPublishStatus;
    }

    public String getCrlPublishErrorStr() {
        return this.mCrlPublishError;
    }

    public CMSCRLExtensions getCRLExtensions() {
        return this.mCMSCRLExtensions;
    }

    public void setCustomFutureThisUpdateValue(Date futureThisUpdate) {
        this.mCustomFutureThisUpdateValue = futureThisUpdate;
    }

    public void setCancelCurFutureThisUpdateValue(boolean b) {
        this.mCancelCurFutureThisUpdateValue = b;
    }

    public boolean isCRLIssuingPointInitialized() {
        return this.mInitialized == CRLIssuingPointStatus.Initialized;
    }

    public boolean isManualUpdateSet() {
        return this.mDoManualUpdate;
    }

    public boolean areExpiredCertsIncluded() {
        return this.mIncludeExpiredCerts;
    }

    public boolean isCACertsOnly() {
        return this.mCACertsOnly;
    }

    public boolean isProfileCertsOnly() {
        return this.mProfileCertsOnly && this.mProfileList != null && !this.mProfileList.isEmpty();
    }

    public boolean checkCurrentProfile(String id) {
        boolean b = false;
        if (this.mProfileCertsOnly && this.mProfileList != null && !this.mProfileList.isEmpty()) {
            for (int k = 0; k < this.mProfileList.size(); ++k) {
                String profileId = this.mProfileList.elementAt(k);
                if (id == null || profileId == null || !profileId.equalsIgnoreCase(id)) continue;
                b = true;
                break;
            }
        }
        return b;
    }

    public void init(CertificateAuthority ca, String id, CRLIssuingPointConfig config) throws EBaseException {
        logger.info("CRLIssuingPoint: Initializing " + id);
        this.mCA = ca;
        this.mId = id;
        if (this.mId.equals("MasterCRL")) {
            this.mCrlUpdateStatus = "crlUpdateStatus";
            this.mCrlUpdateError = "crlUpdateError";
            this.mCrlPublishStatus = "crlPublishStatus";
            this.mCrlPublishError = "crlPublishError";
        } else {
            this.mCrlUpdateStatus = "crlUpdateStatus_" + this.mId;
            this.mCrlUpdateError = "crlUpdateError_" + this.mId;
            this.mCrlPublishStatus = "crlPublishStatus_" + this.mId;
            this.mCrlPublishError = "crlPublishError_" + this.mId;
        }
        this.mConfigStore = config;
        CAConfig caConfig = this.mCA.getConfigStore();
        CRLConfig crlConfig = caConfig.getCRLConfig();
        this.mPageSize = crlConfig.getInteger("pageSize", 10000);
        logger.debug("CRLIssuingPoint: - page size: " + this.mPageSize);
        this.mCountMod = this.mConfigStore.getCountMod();
        CAEngine engine = CAEngine.getInstance();
        this.mCRLRepository = engine.getCRLRepository();
        this.mPublisherProcessor = engine.getPublisherProcessor();
        this.initConfig(this.mConfigStore);
        String lname = RevocationRequestListener.class.getName();
        String crlListName = lname + "_" + this.mId;
        if (engine.getRequestListener(crlListName) == null) {
            engine.registerRequestListener(crlListName, new RevocationRequestListener(this));
        }
        for (int i = 0; i < this.mSplits.length; ++i) {
            this.mSplits[i] = 0L;
        }
        this.setAutoUpdates();
    }

    private int checkTime(String time) {
        String digits = "0123456789";
        int len = time.length();
        if (len < 3 || len > 5) {
            return -1;
        }
        int s = time.indexOf(58);
        if (s < 0 || s > 2 || len - s != 3) {
            return -1;
        }
        int h = 0;
        for (int i = 0; i < s; ++i) {
            h *= 10;
            int k = digits.indexOf(time.charAt(i));
            if (k < 0) {
                return -1;
            }
            h += k;
        }
        if (h > 23) {
            return -1;
        }
        int m = 0;
        for (int i = s + 1; i < len; ++i) {
            m *= 10;
            int k = digits.indexOf(time.charAt(i));
            if (k < 0) {
                return -1;
            }
            m += k;
        }
        if (m > 59) {
            return -1;
        }
        return h * 60 + m;
    }

    private boolean areTimeListsIdentical(Vector<Vector<Integer>> list1, Vector<Vector<Integer>> list2) {
        boolean identical = true;
        if (list1 == null || list2 == null) {
            identical = false;
        }
        if (identical && list1.size() != list2.size()) {
            identical = false;
        }
        for (int i = 0; identical && i < list1.size(); ++i) {
            Vector<Integer> times1 = list1.elementAt(i);
            Vector<Integer> times2 = list2.elementAt(i);
            if (times1.size() != times2.size()) {
                identical = false;
            }
            for (int j = 0; identical && j < times1.size(); ++j) {
                if (times1.elementAt(j).intValue() == times2.elementAt(j).intValue()) continue;
                identical = false;
            }
        }
        logger.debug("CRLIssuingPoint: time lists identical: " + identical);
        return identical;
    }

    private int getTimeListSize(Vector<Vector<Integer>> listedDays) {
        int listSize = 0;
        for (int i = 0; listedDays != null && i < listedDays.size(); ++i) {
            Vector<Integer> listedTimes = listedDays.elementAt(i);
            listSize += listedTimes != null ? listedTimes.size() : 0;
        }
        logger.debug("CRLIssuingPoint: time list size: " + listSize);
        return listSize;
    }

    private boolean isTimeListExtended(String list) {
        boolean extendedTimeList = true;
        if (list == null || list.indexOf(42) == -1) {
            extendedTimeList = false;
        }
        return extendedTimeList;
    }

    private Vector<Vector<Integer>> getTimeList(String list) {
        boolean timeListPresent = false;
        if (list == null || list.length() == 0) {
            return null;
        }
        if (list.charAt(0) == ',' || list.charAt(list.length() - 1) == ',') {
            return null;
        }
        Vector<Vector<Integer>> listedDays = new Vector<Vector<Integer>>();
        StringTokenizer days = new StringTokenizer(list, ";", true);
        Vector<Integer> listedTimes = null;
        while (days.hasMoreTokens()) {
            String dayList = days.nextToken().trim();
            if (dayList == null) continue;
            if (dayList.equals(";")) {
                if (timeListPresent) {
                    timeListPresent = false;
                    continue;
                }
                listedTimes = new Vector();
                listedDays.addElement(listedTimes);
                continue;
            }
            listedTimes = new Vector();
            listedDays.addElement(listedTimes);
            timeListPresent = true;
            int t0 = -1;
            StringTokenizer times = new StringTokenizer(dayList, ",");
            while (times.hasMoreTokens()) {
                int t;
                String time = times.nextToken();
                int k = 1;
                if (time.charAt(0) == '*') {
                    time = time.substring(1);
                    k = -1;
                }
                if ((t = this.checkTime(time)) < 0) {
                    return null;
                }
                if (t > t0) {
                    listedTimes.addElement(k * t);
                    t0 = t;
                    continue;
                }
                return null;
            }
        }
        if (!timeListPresent) {
            listedTimes = new Vector<Integer>();
            listedDays.addElement(listedTimes);
        }
        return listedDays;
    }

    private String checkProfile(String id, Enumeration<String> e) {
        if (e != null) {
            while (e.hasMoreElements()) {
                String profileId = e.nextElement();
                if (profileId == null || !profileId.equalsIgnoreCase(id)) continue;
                return id;
            }
        }
        return null;
    }

    private Vector<String> getProfileList(String list) {
        Enumeration<String> e = null;
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig engineConfig = engine.getConfig();
        ProfileSubsystemConfig profileSubsystemConfig = engineConfig.getProfileSubsystemConfig();
        if (profileSubsystemConfig != null) {
            e = profileSubsystemConfig.getSubStoreNames().elements();
        }
        if (list == null) {
            return null;
        }
        if (list.length() > 0 && list.charAt(list.length() - 1) == ',') {
            return null;
        }
        Vector<String> listedProfiles = new Vector<String>();
        StringTokenizer elements = new StringTokenizer(list, ",", true);
        int n = 0;
        while (elements.hasMoreTokens()) {
            String id;
            String element = elements.nextToken().trim();
            if (element == null || element.length() == 0) {
                return null;
            }
            if (element.equals(",") && n % 2 == 0) {
                return null;
            }
            if (n % 2 == 0 && (id = this.checkProfile(element, e)) != null) {
                listedProfiles.addElement(id);
            }
            ++n;
        }
        if (n % 2 == 0) {
            return null;
        }
        return listedProfiles;
    }

    protected void initConfig(CRLIssuingPointConfig config) throws EBaseException {
        this.mEnable = config.getEnable();
        this.mDescription = config.getDescription();
        this.mEnableCRLCache = config.getEnableCRLCache();
        this.mCacheUpdateInterval = 60000L * (long)config.getCacheUpdateInterval();
        this.mEnableCacheRecovery = config.getEnableCacheRecovery();
        this.mEnableCacheTesting = config.getEnableCacheTesting();
        this.mEnableCRLUpdates = config.getEnableCRLUpdates();
        this.mUpdateSchema = config.getUpdateSchema();
        this.mSchemaCounter = 0;
        this.mAlwaysUpdate = config.getAlwaysUpdate();
        this.mEnableDailyUpdates = config.getEnableDailyUpdates();
        String daily = config.getDailyUpdates();
        this.mDailyUpdates = this.getTimeList(daily);
        this.mExtendedTimeList = this.isTimeListExtended(daily);
        this.mTimeListSize = this.getTimeListSize(this.mDailyUpdates);
        if (this.mDailyUpdates == null || this.mDailyUpdates.isEmpty() || this.mTimeListSize == 0) {
            this.mEnableDailyUpdates = false;
            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_INVALID_TIME_LIST", (Object[])new Object[0]));
        }
        this.mEnableUpdateFreq = config.getEnableUpdateInterval();
        this.mAutoUpdateInterval = 60000L * (long)config.getAutoUpdateInterval();
        this.mMinUpdateInterval = 60000L * (long)config.getMinUpdateInterval();
        if (this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L && this.mAutoUpdateInterval < this.mMinUpdateInterval) {
            this.mAutoUpdateInterval = this.mMinUpdateInterval;
        }
        this.mNextUpdateGracePeriod = 60000L * (long)config.getNextUpdateGracePeriod();
        this.mUnexpectedExceptionWaitTime = 60000L * (long)config.getUnexpectedExceptionWaitTime();
        logger.debug("CRLIssuingPoint: unexpected exception wait time: " + this.mUnexpectedExceptionWaitTime);
        this.mUnexpectedExceptionLoopMax = config.getUnexpectedExceptionLoopMax();
        logger.debug("CRLIssuingPoint: unexpected exception loop max: " + this.mUnexpectedExceptionLoopMax);
        this.mNextAsThisUpdateExtension = 60000L * (long)config.getNextAsThisUpdateExtension();
        this.mAllowExtensions = config.getAllowExtensions();
        this.mIncludeExpiredCerts = config.getIncludeExpiredCerts();
        this.mIncludeExpiredCertsOneExtraTime = config.getIncludeExpiredCertsOneExtraTime();
        this.mCACertsOnly = config.getCACertsOnly();
        this.mProfileCertsOnly = config.getProfileCertsOnly();
        if (this.mProfileCertsOnly) {
            String profiles = config.getProfileList();
            this.mProfileList = this.getProfileList(profiles);
        }
        this.mSigningAlgorithm = this.mCA.getCRLSigningUnit().getDefaultAlgorithm();
        String algorithm = config.getSigningAlgorithm();
        if (algorithm != null) {
            this.mCA.getCRLSigningUnit().checkSigningAlgorithmFromName(algorithm);
            this.mSigningAlgorithm = algorithm;
        }
        this.mPublishOnStart = config.getPublishOnStart();
        this.mPublishDN = config.getPublishDN();
        this.mSaveMemory = config.getSaveMemory();
        this.mCMSCRLExtensions = new CMSCRLExtensions(this, config);
        this.mExtendedNextUpdate = (this.mUpdateSchema > 1 || this.mEnableDailyUpdates && this.mExtendedTimeList) && this.isDeltaCRLEnabled() && config.getExtendedNextUpdate();
        this.mBeginSerial = config.getCRLBeginSerialNo();
        if (this.mBeginSerial != null && this.mBeginSerial.compareTo(BigInteger.ZERO) < 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_PROPERTY_1", (String[])new String[]{PROP_BEGIN_SERIAL, "BigInteger", "positive number"}));
        }
        this.mEndSerial = config.getCRLEndSerialNo();
        if (this.mEndSerial != null && this.mEndSerial.compareTo(BigInteger.ZERO) < 0) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_PROPERTY_1", (String[])new String[]{PROP_END_SERIAL, "BigInteger", "positive number"}));
        }
        this.mAutoUpdateIntervalEffectiveAtStart = config.getAutoUpdateIntervalEffectiveAtStart();
        logger.debug("CRLIssuingPoint: auto update interval effective at start: " + this.mAutoUpdateIntervalEffectiveAtStart);
        this.mForbidCustomFutureThisUpdateValue = config.getBoolean("forbidCustomFutureThisUpdateValue", true);
        logger.debug("CRLIssuingPoint: forbid future thisUpdate: " + this.mForbidCustomFutureThisUpdateValue);
    }

    private void initCRL() throws EBaseException {
        CRLIssuingPointRecord crlRecord = null;
        this.mLastCacheUpdate = System.currentTimeMillis() + this.mCacheUpdateInterval;
        try {
            logger.info("CRLIssuingPoint: reading CRL issuing point: " + this.mId);
            crlRecord = this.mCRLRepository.readCRLIssuingPointRecord(this.mId);
        }
        catch (EDBNotAvailException e) {
            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_INST_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.mInitialized = CRLIssuingPointStatus.InitializationFailed;
            return;
        }
        catch (EDBRecordNotFoundException e) {
            logger.warn("CRLIssuingPoint: CRL issuing point not found: " + this.mId);
        }
        if (crlRecord != null) {
            this.mCRLNumber = crlRecord.getCRLNumber();
            if (crlRecord.getCRLSize() != null) {
                this.mCRLSize = crlRecord.getCRLSize();
            }
            this.mNextCRLNumber = this.mCRLNumber.add(BigInteger.ONE);
            if (crlRecord.getDeltaCRLSize() != null) {
                this.mDeltaCRLSize = crlRecord.getDeltaCRLSize();
            }
            this.mDeltaCRLNumber = crlRecord.getDeltaCRLNumber();
            if (this.mDeltaCRLNumber == null) {
                this.mDeltaCRLNumber = this.mCRLNumber;
            } else if (this.mDeltaCRLNumber.compareTo(this.mCRLNumber) < 0) {
                this.mDeltaCRLNumber = this.mCRLNumber;
                this.clearCRLCache();
                this.mDeltaCRLSize = -1L;
            }
            this.mNextDeltaCRLNumber = this.mDeltaCRLNumber.add(BigInteger.ONE);
            if (this.mNextDeltaCRLNumber.compareTo(this.mNextCRLNumber) > 0) {
                this.mNextCRLNumber = this.mNextDeltaCRLNumber;
            }
            this.mLastCRLNumber = BigInteger.ZERO;
            this.mLastUpdate = crlRecord.getThisUpdate();
            if (this.mLastUpdate == null) {
                this.mLastUpdate = new Date(0L);
            }
            this.mLastFullUpdate = null;
            this.mNextUpdate = crlRecord.getNextUpdate();
            logger.debug("CRLIssuingPoint: next update: " + this.mNextUpdate);
            if (this.isDeltaCRLEnabled()) {
                this.mNextDeltaUpdate = this.mNextUpdate != null ? new Date(this.mNextUpdate.getTime()) : null;
            }
            this.mFirstUnsaved = crlRecord.getFirstUnsaved();
            logger.debug("CRLIssuingPoint: CRL number: " + this.mCRLNumber);
            logger.debug("CRLIssuingPoint: CRL size: " + this.mCRLSize);
            logger.debug("CRLIssuingPoint: first unsaved: " + this.mFirstUnsaved);
            if (this.mFirstUnsaved == null || this.mFirstUnsaved != null && this.mFirstUnsaved.equals("-2")) {
                this.clearCRLCache();
                this.updateCRLCacheRepository();
            } else {
                byte[] crl = crlRecord.getCRL();
                if (crl != null) {
                    X509CRLImpl x509crl = null;
                    if (this.mEnableCRLCache || this.mPublishOnStart) {
                        try {
                            x509crl = new X509CRLImpl(crl);
                        }
                        catch (Exception e) {
                            this.clearCRLCache();
                            logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_DECODE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                        }
                        catch (OutOfMemoryError e) {
                            this.clearCRLCache();
                            logger.error(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_DECODE_CRL", (Object[])new Object[]{e.toString()}), (Throwable)e);
                            this.mInitialized = CRLIssuingPointStatus.InitializationFailed;
                            return;
                        }
                    }
                    if (x509crl != null) {
                        this.mLastFullUpdate = x509crl.getThisUpdate();
                        if (this.mEnableCRLCache) {
                            logger.info("CRLIssuingPoint: Loading CRL cache");
                            if (this.mCRLCacheIsCleared && this.mUpdatingCRL == 0) {
                                this.mRevokedCerts = crlRecord.getRevokedCerts();
                                if (this.mRevokedCerts == null) {
                                    this.mRevokedCerts = new Hashtable();
                                }
                                logger.debug("CRLIssuingPoint: - revoked certs: " + this.mRevokedCerts.size());
                                this.mUnrevokedCerts = crlRecord.getUnrevokedCerts();
                                if (this.mUnrevokedCerts == null) {
                                    this.mUnrevokedCerts = new Hashtable();
                                }
                                logger.debug("CRLIssuingPoint: - unrevoked certs: " + this.mUnrevokedCerts.size());
                                this.mExpiredCerts = crlRecord.getExpiredCerts();
                                if (this.mExpiredCerts == null) {
                                    this.mExpiredCerts = new Hashtable();
                                }
                                logger.debug("CRLIssuingPoint: - expired certs: " + this.mExpiredCerts.size());
                                if (this.isDeltaCRLEnabled()) {
                                    this.mNextUpdate = x509crl.getNextUpdate();
                                }
                                this.mCRLCerts = x509crl.getListOfRevokedCertificates();
                                logger.debug("CRLIssuingPoint: - CRL certs: " + this.mCRLCerts.size());
                            }
                            if (this.mFirstUnsaved != null && !this.mFirstUnsaved.equals("-1")) {
                                this.recoverCRLCache();
                            } else {
                                this.mCRLCacheIsCleared = false;
                            }
                            this.mInitialized = CRLIssuingPointStatus.Initialized;
                        }
                        if (this.mPublishOnStart) {
                            try {
                                this.publishCRL(x509crl);
                                x509crl = null;
                            }
                            catch (EBaseException | OutOfMemoryError e) {
                                x509crl = null;
                                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_PUBLISH_CRL", (Object[])new Object[]{this.mCRLNumber.toString(), e.toString()}), e);
                            }
                        }
                    }
                }
            }
        }
        if (crlRecord == null) {
            logger.info("CRLIssuingPoint: Creating new CRL issuing point: " + this.mId);
            CAConfig caConfig = this.mCA.getConfigStore();
            CRLConfig crlConfig = caConfig.getCRLConfig();
            CRLIssuingPointConfig ipConfig = crlConfig.getCRLIssuingPointConfig(this.mId);
            try {
                BigInteger startingCrlNumberBig = ipConfig.getBigInteger(PROP_CRL_STARTING_NUMBER, BigInteger.ZERO);
                logger.debug("CRLIssuingPoint: starting CRL number: " + startingCrlNumberBig);
                if (startingCrlNumberBig.compareTo(BigInteger.ZERO) < 0) {
                    startingCrlNumberBig = BigInteger.ZERO;
                }
                crlRecord = new CRLIssuingPointRecord(this.mId, startingCrlNumberBig, Long.valueOf(-1L), null, null, BigInteger.ZERO, Long.valueOf(-1L), this.mRevokedCerts, this.mUnrevokedCerts, this.mExpiredCerts);
                this.mCRLRepository.addCRLIssuingPointRecord(crlRecord);
                this.mCRLNumber = startingCrlNumberBig;
                this.mNextCRLNumber = this.mCRLNumber.compareTo(BigInteger.ZERO) == 0 ? BigInteger.ONE : this.mCRLNumber;
                this.mLastCRLNumber = this.mCRLNumber;
                this.mDeltaCRLNumber = this.mCRLNumber;
                this.mNextDeltaCRLNumber = this.mNextCRLNumber;
                this.mLastUpdate = new Date(0L);
                if (crlRecord != null && !this.mDoManualUpdate && (this.mEnableCRLCache || this.mAlwaysUpdate || this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L)) {
                    this.mInitialized = CRLIssuingPointStatus.Initialized;
                    this.setManualUpdate(null);
                }
            }
            catch (EBaseException ex) {
                logger.error(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_CREATE_CRL", (Object[])new Object[]{ex.toString()}), (Throwable)ex);
                this.mInitialized = CRLIssuingPointStatus.InitializationFailed;
                return;
            }
        }
        this.mInitialized = CRLIssuingPointStatus.Initialized;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateConfig(NameValuePairs params) {
        Object object = this.configMonitor;
        synchronized (object) {
            boolean noRestart = true;
            boolean modifiedSchedule = false;
            for (Map.Entry entry : params.entrySet()) {
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                if (name.equals("enableCRLUpdates")) {
                    if (value.equals("false") && this.mEnableCRLUpdates) {
                        this.mEnableCRLUpdates = false;
                        modifiedSchedule = true;
                    } else if (value.equals("true") && !this.mEnableCRLUpdates) {
                        this.mEnableCRLUpdates = true;
                        modifiedSchedule = true;
                    }
                }
                if (name.equals("updateSchema")) {
                    try {
                        int schema;
                        if (value != null && value.length() > 0 && this.mUpdateSchema != (schema = Integer.parseInt(value.trim()))) {
                            this.mUpdateSchema = schema;
                            this.mSchemaCounter = 0;
                            modifiedSchedule = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        noRestart = false;
                    }
                }
                if (name.equals("extendedNextUpdate")) {
                    if (value.equals("false") && this.mExtendedNextUpdate) {
                        this.mExtendedNextUpdate = false;
                    } else if (value.equals("true") && !this.mExtendedNextUpdate) {
                        this.mExtendedNextUpdate = true;
                    }
                }
                if (name.equals("alwaysUpdate")) {
                    if (value.equals("false") && this.mAlwaysUpdate) {
                        this.mAlwaysUpdate = false;
                    } else if (value.equals("true") && !this.mAlwaysUpdate) {
                        this.mAlwaysUpdate = true;
                    }
                }
                if (name.equals("enableDailyUpdates")) {
                    if (value.equals("false") && this.mEnableDailyUpdates) {
                        this.mEnableDailyUpdates = false;
                        modifiedSchedule = true;
                    } else if (value.equals("true") && !this.mEnableDailyUpdates) {
                        this.mEnableDailyUpdates = true;
                        modifiedSchedule = true;
                    }
                }
                if (name.equals("dailyUpdates")) {
                    boolean extendedTimeList = this.isTimeListExtended(value);
                    Vector<Vector<Integer>> dailyUpdates = this.getTimeList(value);
                    if (this.mExtendedTimeList != extendedTimeList) {
                        this.mExtendedTimeList = extendedTimeList;
                        modifiedSchedule = true;
                    }
                    if (!this.areTimeListsIdentical(this.mDailyUpdates, dailyUpdates)) {
                        this.mCurrentDay = 0;
                        this.mLastDay = 0;
                        this.mDailyUpdates = dailyUpdates;
                        this.mTimeListSize = this.getTimeListSize(this.mDailyUpdates);
                        modifiedSchedule = true;
                    }
                    if (this.mDailyUpdates == null || this.mDailyUpdates.isEmpty() || this.mTimeListSize == 0) {
                        this.mEnableDailyUpdates = false;
                        logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_INVALID_TIME_LIST", (Object[])new Object[0]));
                    }
                }
                if (name.equals("enableUpdateInterval")) {
                    if (value.equals("false") && this.mEnableUpdateFreq) {
                        this.mEnableUpdateFreq = false;
                        modifiedSchedule = true;
                    } else if (value.equals("true") && !this.mEnableUpdateFreq) {
                        this.mEnableUpdateFreq = true;
                        modifiedSchedule = true;
                    }
                }
                if (name.equals("autoUpdateInterval")) {
                    try {
                        if (value != null && value.length() > 0) {
                            long t = 60000L * Long.parseLong(value.trim());
                            if (this.mAutoUpdateInterval != t) {
                                this.mAutoUpdateInterval = t;
                                modifiedSchedule = true;
                            }
                        } else if (this.mAutoUpdateInterval != 0L) {
                            this.mAutoUpdateInterval = 0L;
                            modifiedSchedule = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        noRestart = false;
                    }
                }
                if (name.equals("nextUpdateGracePeriod")) {
                    try {
                        if (value != null && value.length() > 0) {
                            this.mNextUpdateGracePeriod = 60000L * Long.parseLong(value.trim());
                        }
                    }
                    catch (NumberFormatException e) {
                        noRestart = false;
                    }
                }
                if (name.equals("nextAsThisUpdateExtension")) {
                    try {
                        if (value != null && value.length() > 0) {
                            this.mNextAsThisUpdateExtension = 60000L * Long.parseLong(value.trim());
                        }
                    }
                    catch (NumberFormatException e) {
                        noRestart = false;
                    }
                }
                if (name.equals("enableCRLCache")) {
                    if (value.equals("false") && this.mEnableCRLCache) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mEnableCRLCache = false;
                        modifiedSchedule = true;
                    } else if (value.equals("true") && !this.mEnableCRLCache) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mEnableCRLCache = true;
                        modifiedSchedule = true;
                    }
                }
                if (name.equals("cacheUpdateInterval")) {
                    try {
                        long t;
                        if (value != null && value.length() > 0 && this.mCacheUpdateInterval != (t = 60000L * Long.parseLong(value.trim()))) {
                            this.mCacheUpdateInterval = t;
                            modifiedSchedule = true;
                        }
                    }
                    catch (NumberFormatException e) {
                        noRestart = false;
                    }
                }
                if (name.equals("enableCacheRecovery")) {
                    if (value.equals("false") && this.mEnableCacheRecovery) {
                        this.mEnableCacheRecovery = false;
                    } else if (value.equals("true") && !this.mEnableCacheRecovery) {
                        this.mEnableCacheRecovery = true;
                    }
                }
                if (name.equals("enableCacheTesting")) {
                    if (value.equals("false") && this.mEnableCacheTesting) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mEnableCacheTesting = false;
                        this.setManualUpdate(null);
                    } else if (value.equals("true") && !this.mEnableCacheTesting) {
                        this.mEnableCacheTesting = true;
                    }
                }
                if (name.equals("signingAlgorithm")) {
                    if (value != null) {
                        value = value.trim();
                    }
                    if (!this.mSigningAlgorithm.equals(value)) {
                        this.mSigningAlgorithm = value;
                    }
                }
                if (name.equals("allowExtensions")) {
                    if (value.equals("false") && this.mAllowExtensions) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mAllowExtensions = false;
                    } else if (value.equals("true") && !this.mAllowExtensions) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mAllowExtensions = true;
                    }
                }
                if (name.equals("includeExpiredCerts")) {
                    if (value.equals("false") && this.mIncludeExpiredCerts) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mIncludeExpiredCerts = false;
                    } else if (value.equals("true") && !this.mIncludeExpiredCerts) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mIncludeExpiredCerts = true;
                    }
                }
                if (name.equals("includeExpiredCertsOneExtraTime")) {
                    if (value.equals("false") && this.mIncludeExpiredCertsOneExtraTime) {
                        this.mIncludeExpiredCertsOneExtraTime = false;
                    } else if (value.equals("true") && !this.mIncludeExpiredCertsOneExtraTime) {
                        this.mIncludeExpiredCertsOneExtraTime = true;
                    }
                }
                if (name.equals("caCertsOnly")) {
                    CAConfig caConfig;
                    CRLConfig crlConfig;
                    CRLIssuingPointConfig ipConfig;
                    CRLExtensionsConfig crlExtsConfig;
                    CRLExtensionConfig crlExtsSubStore;
                    boolean onlyContainsCACerts;
                    Extension distExt = this.getCRLExtension("IssuingDistributionPoint");
                    IssuingDistributionPointExtension iExt = (IssuingDistributionPointExtension)distExt;
                    IssuingDistributionPoint issuingDistributionPoint = null;
                    if (iExt != null) {
                        issuingDistributionPoint = iExt.getIssuingDistributionPoint();
                    }
                    if (value.equals("false") && this.mCACertsOnly) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mCACertsOnly = false;
                    } else if (value.equals("true") && !this.mCACertsOnly) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mCACertsOnly = true;
                    }
                    if (issuingDistributionPoint != null && params.size() > 1 && (onlyContainsCACerts = issuingDistributionPoint.getOnlyContainsCACerts()) != this.mCACertsOnly && (crlExtsSubStore = (crlExtsConfig = (ipConfig = (crlConfig = (caConfig = this.mCA.getConfigStore()).getCRLConfig()).getCRLIssuingPointConfig(this.mId)).getExtensionsConfig()).getExtensionConfig("IssuingDistributionPoint")) != null) {
                        String val = this.mCACertsOnly ? "true" : "false";
                        crlExtsSubStore.putString(PROP_CACERTS, val);
                        try {
                            crlExtsSubStore.commit(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (name.equals("profileCertsOnly")) {
                    if (value.equals("false") && this.mProfileCertsOnly) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mProfileCertsOnly = false;
                    } else if (value.equals("true") && !this.mProfileCertsOnly) {
                        this.clearCRLCache();
                        this.updateCRLCacheRepository();
                        this.mProfileCertsOnly = true;
                    }
                }
                if (!name.equals("profileList")) continue;
                Vector<String> profileList = this.getProfileList(value);
                if (profileList != null ^ this.mProfileList != null || profileList != null && this.mProfileList != null && !this.mProfileList.equals(profileList)) {
                    Vector newProfileList;
                    this.mProfileList = profileList != null ? (newProfileList = (Vector)profileList.clone()) : null;
                    this.clearCRLCache();
                    this.updateCRLCacheRepository();
                }
                if (this.mProfileList != null && !this.mProfileList.isEmpty()) continue;
                this.mProfileCertsOnly = false;
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_INVALID_PROFILE_LIST", (Object[])new Object[0]));
            }
            if (modifiedSchedule) {
                this.setAutoUpdates();
            }
            return noRestart;
        }
    }

    public synchronized void shutdown() {
        if (this.mEnableCRLCache && this.mCacheUpdateInterval > 0L) {
            this.updateCRLCacheRepository();
        }
        this.mEnable = false;
        this.setAutoUpdates();
    }

    public String getId() {
        return this.mId;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String description) {
        this.mDescription = description;
    }

    public String getPublishDN() {
        return this.mPublishDN;
    }

    public String getSigningAlgorithm() {
        return this.mSigningAlgorithm;
    }

    public synchronized String getLastSigningAlgorithm() {
        return this.mLastSigningAlgorithm;
    }

    public int getCRLSchema() {
        return this.mUpdateSchema;
    }

    public BigInteger getCRLNumber() {
        return this.mCRLNumber;
    }

    public BigInteger getDeltaCRLNumber() {
        return this.isDeltaCRLEnabled() && this.mDeltaCRLSize > -1L ? this.mDeltaCRLNumber : BigInteger.ZERO;
    }

    public BigInteger getNextCRLNumber() {
        return this.mNextDeltaCRLNumber;
    }

    public long getCRLSize() {
        return this.mCRLCerts.size() > 0 && this.mCRLSize == 0L ? (long)this.mCRLCerts.size() : this.mCRLSize;
    }

    public long getDeltaCRLSize() {
        return this.mDeltaCRLSize;
    }

    public Date getLastUpdate() {
        return this.mLastUpdate;
    }

    public Date getNextUpdate() {
        return this.mNextUpdate;
    }

    public Date getNextDeltaUpdate() {
        return this.mNextDeltaUpdate;
    }

    public Set<RevokedCertificate> getRevokedCertificates(int start, int end) {
        if (this.mCRLCacheIsCleared || this.mCRLCerts == null || this.mCRLCerts.isEmpty()) {
            return null;
        }
        return new LinkedHashSet<RevokedCertificate>(this.mCRLCerts.values());
    }

    public CertificateAuthority getCertificateAuthority() {
        return this.mCA;
    }

    private synchronized void setAutoUpdates() {
        if (this.mEnable && this.mUpdateThread == null && (this.mEnableCRLCache && this.mCacheUpdateInterval > 0L || this.mEnableCRLUpdates && (this.mEnableDailyUpdates && this.mDailyUpdates != null && this.mTimeListSize > 0 || this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L || this.mInitialized == CRLIssuingPointStatus.NotInitialized || this.mDoLastAutoUpdate || this.mDoManualUpdate))) {
            logger.info(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_START_CRL", (Object[])new Object[]{this.mId}));
            this.mUpdateThread = new Thread((Runnable)this, "CRLIssuingPoint-" + this.mId);
            this.mUpdateThread.setDaemon(true);
            this.mUpdateThread.start();
        }
        if (this.isCRLIssuingPointInitialized() && (this.mNextUpdate != null ^ (this.mEnableDailyUpdates && this.mDailyUpdates != null && this.mTimeListSize > 0 || this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L) || !this.mEnableCRLUpdates && this.mNextUpdate != null)) {
            this.mDoLastAutoUpdate = true;
        }
        if (this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L && this.mAutoUpdateInterval < this.mMinUpdateInterval) {
            this.mAutoUpdateInterval = this.mMinUpdateInterval;
        }
        this.notifyAll();
    }

    public synchronized void setManualUpdate(String signatureAlgorithm) {
        if (!this.mDoManualUpdate) {
            this.mDoManualUpdate = true;
            this.mSignatureAlgorithmForManualUpdate = signatureAlgorithm;
            if (this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L && this.mUpdateThread != null) {
                this.notifyAll();
            } else {
                this.setAutoUpdates();
            }
        }
    }

    public long getAutoUpdateInterval() {
        return this.mEnableUpdateFreq ? this.mAutoUpdateInterval : 0L;
    }

    public boolean getAlwaysUpdate() {
        return this.mAlwaysUpdate;
    }

    public long getNextUpdateGracePeriod() {
        return this.mNextUpdateGracePeriod;
    }

    private long findNextUpdate(boolean fromLastUpdate, boolean delta) {
        long now = System.currentTimeMillis();
        long futureNow = 0L;
        if (this.mCustomFutureThisUpdateValue != null && (futureNow = this.mCustomFutureThisUpdateValue.getTime()) > now) {
            now = futureNow;
        }
        TimeZone tz = TimeZone.getDefault();
        int offset = tz.getOffset(now);
        long oneDay = 86400000L;
        long nowToday = (now + (long)offset) % oneDay;
        long startOfToday = now - nowToday;
        long lastUpdated = this.mLastUpdate != null ? this.mLastUpdate.getTime() : now;
        long lastUpdateDay = lastUpdated - (lastUpdated + (long)offset) % oneDay;
        long lastUpdate = this.mLastUpdate != null && fromLastUpdate ? this.mLastUpdate.getTime() : now;
        long last = (lastUpdate + (long)offset) % oneDay;
        long lastDay = lastUpdate - last;
        boolean isDeltaEnabled = this.isDeltaCRLEnabled();
        long next = 0L;
        long nextUpdate = 0L;
        logger.debug("CRLIssuingPoint: last update: " + this.mLastUpdate);
        logger.debug("CRLIssuingPoint: next update: " + this.mNextUpdate);
        logger.debug("CRLIssuingPoint: auto update interval: " + this.mAutoUpdateInterval / 60000L);
        logger.debug("CRLIssuingPOint: last lpdate: " + new Date(lastUpdate));
        int numberOfDays = (int)((startOfToday - lastUpdateDay) / oneDay);
        if (numberOfDays > 0 && this.mDailyUpdates.size() > 1 && (this.mCurrentDay == this.mLastDay || this.mCurrentDay != (this.mLastDay + numberOfDays) % this.mDailyUpdates.size())) {
            this.mCurrentDay = (this.mLastDay + numberOfDays) % this.mDailyUpdates.size();
        }
        if ((delta || fromLastUpdate) && isDeltaEnabled && (this.mUpdateSchema > 1 || this.mEnableDailyUpdates && this.mExtendedTimeList) && this.mNextDeltaUpdate != null) {
            nextUpdate = this.mNextDeltaUpdate.getTime();
        } else if (this.mNextUpdate != null) {
            nextUpdate = this.mNextUpdate.getTime();
        }
        if (this.mEnableDailyUpdates && this.mDailyUpdates != null && !this.mDailyUpdates.isEmpty()) {
            int n = 0;
            if (this.mDailyUpdates.size() == 1 && this.mDailyUpdates.elementAt(0).size() == 1 && this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L) {
                long firstTime;
                long t = firstTime = 60000L * this.mDailyUpdates.elementAt(0).elementAt(0).longValue();
                long interval = this.mAutoUpdateInterval;
                if (this.mExtendedNextUpdate && !fromLastUpdate && !delta && isDeltaEnabled && this.mUpdateSchema > 1) {
                    interval *= (long)this.mUpdateSchema;
                }
                while (t < oneDay && t - this.mMinUpdateInterval <= last) {
                    t += interval;
                    ++n;
                }
                if (t <= oneDay) {
                    next = lastDay + t;
                    if (fromLastUpdate) {
                        n %= this.mUpdateSchema;
                        if (t == firstTime) {
                            this.mSchemaCounter = 0;
                        } else if (n != this.mSchemaCounter && this.mSchemaCounter != 0 && (this.mSchemaCounter < n || n == 0)) {
                            this.mSchemaCounter = n;
                        }
                    }
                } else {
                    next = lastDay + oneDay + firstTime;
                    if (fromLastUpdate) {
                        this.mSchemaCounter = 0;
                    }
                }
            } else {
                int i;
                if (last > nowToday) {
                    last = nowToday - 100L;
                }
                int m = 0;
                for (i = 0; i < this.mCurrentDay; ++i) {
                    m += this.mDailyUpdates.elementAt(i).size();
                }
                for (i = 0; i < this.mDailyUpdates.elementAt(this.mCurrentDay).size(); ++i) {
                    long t = 60000L * this.mDailyUpdates.elementAt(this.mCurrentDay).elementAt(i).longValue();
                    if (this.mEnableDailyUpdates && this.mExtendedTimeList) {
                        if (this.mExtendedNextUpdate && !fromLastUpdate && !delta && isDeltaEnabled) {
                            t = t < 0L ? (t *= -1L) : 0L;
                        } else if (t < 0L) {
                            t *= -1L;
                        }
                    }
                    if (t - this.mMinUpdateInterval > last) {
                        if (!this.mExtendedNextUpdate || fromLastUpdate || this.mEnableDailyUpdates && this.mExtendedTimeList || delta || !isDeltaEnabled || this.mUpdateSchema <= 1) break;
                        i += this.mUpdateSchema - (i + m) % this.mUpdateSchema;
                        break;
                    }
                    ++n;
                }
                if (i < this.mDailyUpdates.elementAt(this.mCurrentDay).size()) {
                    next = 60000L * this.mDailyUpdates.elementAt(this.mCurrentDay).elementAt(i).longValue();
                    if (this.mEnableDailyUpdates && this.mExtendedTimeList && next < 0L) {
                        next *= -1L;
                        if (fromLastUpdate) {
                            this.mSchemaCounter = 0;
                        }
                    }
                    next += (lastDay < lastUpdateDay ? lastDay : lastUpdateDay) + oneDay * (long)(this.mCurrentDay - this.mLastDay);
                    if (!(!fromLastUpdate || this.mEnableDailyUpdates && this.mExtendedTimeList)) {
                        n %= this.mUpdateSchema;
                        if (i == 0 && this.mCurrentDay == 0) {
                            this.mSchemaCounter = 0;
                        } else if (n != this.mSchemaCounter && this.mSchemaCounter != 0 && (n == 0 && this.mCurrentDay == 0 || this.mSchemaCounter < n)) {
                            this.mSchemaCounter = n;
                        }
                    }
                } else {
                    int j = i - this.mDailyUpdates.elementAt(this.mCurrentDay).size();
                    int nDays = 1;
                    long t = 0L;
                    if (!this.mDailyUpdates.isEmpty()) {
                        while (nDays <= this.mDailyUpdates.size()) {
                            int nextDay = (this.mCurrentDay + nDays) % this.mDailyUpdates.size();
                            if (j < this.mDailyUpdates.elementAt(nextDay).size()) {
                                if (!(nextDay != 0 || this.mEnableDailyUpdates && this.mExtendedTimeList)) {
                                    j = 0;
                                }
                                t = 60000L * this.mDailyUpdates.elementAt(nextDay).elementAt(j).longValue();
                                if (!this.mEnableDailyUpdates || !this.mExtendedTimeList) break;
                                if (this.mExtendedNextUpdate && !fromLastUpdate && !delta && isDeltaEnabled) {
                                    if (t < 0L) {
                                        t *= -1L;
                                        break;
                                    }
                                    ++j;
                                    continue;
                                }
                                if (t >= 0L) break;
                                t *= -1L;
                                if (!fromLastUpdate) break;
                                this.mSchemaCounter = 0;
                                break;
                            }
                            j -= this.mDailyUpdates.elementAt(nextDay).size();
                            ++nDays;
                        }
                    }
                    next = (lastDay < lastUpdateDay ? lastDay : lastUpdateDay) + oneDay * (long)nDays + t;
                    if (fromLastUpdate && this.mDailyUpdates.size() < 2) {
                        this.mSchemaCounter = 0;
                    }
                }
            }
        } else if (this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L) {
            next = this.mExtendedNextUpdate && !fromLastUpdate && !delta && isDeltaEnabled && this.mUpdateSchema > 1 ? lastUpdate + (long)this.mUpdateSchema * this.mAutoUpdateInterval : lastUpdate + this.mAutoUpdateInterval;
        }
        logger.debug("CRLIssuingPoint: next update: " + new Date(nextUpdate) + " next: " + new Date(next));
        if (fromLastUpdate && nextUpdate > 0L && (nextUpdate < next || nextUpdate >= now)) {
            if (this.mAutoUpdateIntervalEffectiveAtStart) {
                if (next <= now) {
                    this.mNextUpdate = new Date(now);
                    logger.debug("CRLIssuingPoint: schedule updated to the past. Making nextUpdate now: " + this.mNextUpdate);
                    next = now;
                } else {
                    this.mNextUpdate = new Date(next);
                }
                logger.debug("CRLIssuingPoint: taking updated schedule value: " + this.mNextUpdate);
                this.mAutoUpdateIntervalEffectiveAtStart = false;
            } else {
                logger.debug("CRLIssuingPoint: taking current schedule's nextUpdate value: " + new Date(nextUpdate));
                next = nextUpdate;
            }
        }
        logger.debug("CRLIssuingPoint: nextUpdate: " + new Date(next).toString() + (String)(fromLastUpdate ? "  delay: " + (next - now) : ""));
        return fromLastUpdate ? next - now : next;
    }

    public void handleUnexpectedFailure(int loopCounter, long timeOfUnexpectedFailure) {
        logger.info("CRLIssuingPoint: Handling unexpected failure");
        logger.info("CRLIssuingPoint: - loop counter: " + loopCounter);
        if (loopCounter <= this.mUnexpectedExceptionLoopMax) {
            logger.info("CRLIssuingPoint: Max loop not reached, no wait time");
            return;
        }
        logger.info("CRLIssuingPoint: Max loop reached, slowdown procedure ensues");
        long now = System.currentTimeMillis();
        logger.info("CRLIssuingPoint: - now: " + now);
        logger.info("CRLIssuingPoint: - time of unexpected failure: " + timeOfUnexpectedFailure);
        long timeLapse = now - timeOfUnexpectedFailure;
        logger.info("CRLIssuingPoint: - time lapse: " + timeLapse);
        long waitTime = this.mUnexpectedExceptionWaitTime - timeLapse;
        logger.info("CRLIssuingPoint: Wait time after last failure:" + waitTime);
        if (waitTime <= 0L) {
            logger.info("CRLIssuingPoint: No wait after failure");
            return;
        }
        logger.info("CRLIssuingPoint: Waiting for " + waitTime + " ms");
        try {
            this.wait(waitTime);
        }
        catch (InterruptedException e) {
            logger.error("CRLIssuingPoint: " + e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        boolean unexpectedFailure = false;
        long timeOfUnexpectedFailure = 0L;
        int loopCounter = 0;
        try {
            while (this.mEnable && (this.mEnableCRLCache && this.mCacheUpdateInterval > 0L || this.mInitialized == CRLIssuingPointStatus.NotInitialized || this.mDoLastAutoUpdate || this.mEnableCRLUpdates && (this.mEnableDailyUpdates && this.mDailyUpdates != null && this.mTimeListSize > 0 || this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L || this.mDoManualUpdate))) {
                CRLIssuingPoint cRLIssuingPoint = this;
                synchronized (cRLIssuingPoint) {
                    boolean scheduledUpdates;
                    long delay = 0L;
                    long delay2 = 0L;
                    boolean doCacheUpdate = false;
                    boolean bl = scheduledUpdates = this.mEnableCRLUpdates && (this.mEnableDailyUpdates && this.mDailyUpdates != null && this.mTimeListSize > 0 || this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L);
                    if (this.mInitialized == CRLIssuingPointStatus.NotInitialized) {
                        this.initCRL();
                    }
                    if (this.mEnableCRLUpdates && this.mDoManualUpdate || this.mDoLastAutoUpdate) {
                        delay = 0L;
                    } else if (scheduledUpdates) {
                        delay = this.findNextUpdate(true, false);
                    }
                    if (!(!this.mEnableCRLCache || this.mCacheUpdateInterval <= 0L || (delay2 = this.mLastCacheUpdate + this.mCacheUpdateInterval - System.currentTimeMillis()) >= delay && (scheduledUpdates || this.mDoLastAutoUpdate || this.mEnableCRLUpdates && this.mDoManualUpdate) || (delay = delay2) > 0L)) {
                        doCacheUpdate = true;
                        this.mLastCacheUpdate = System.currentTimeMillis();
                    }
                    if (delay > 0L) {
                        try {
                            this.wait(delay);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        if (unexpectedFailure) {
                            this.handleUnexpectedFailure(++loopCounter, timeOfUnexpectedFailure);
                        }
                        logger.debug("CRLIssuingPoint: Before CRL generation");
                        try {
                            if (doCacheUpdate) {
                                logger.info("CRLIssuingPoint: Updating CRL cache");
                                this.updateCRLCacheRepository();
                            } else if (this.mAutoUpdateInterval > 0L || this.mDoLastAutoUpdate || this.mDoManualUpdate) {
                                logger.info("CRLIssuingPoint: Updating CRL");
                                this.updateCRL();
                            }
                            if (unexpectedFailure) {
                                logger.debug("CRLIssuingPoint: reset unexpectedFailure values if no exception");
                                unexpectedFailure = false;
                                timeOfUnexpectedFailure = 0L;
                                loopCounter = 0;
                            }
                        }
                        catch (Exception e) {
                            logger.warn("CRLIssuingPoint: Unable to update " + (doCacheUpdate ? "CRL cache" : "CRL") + ": " + e.getMessage(), (Throwable)e);
                            unexpectedFailure = true;
                            timeOfUnexpectedFailure = System.currentTimeMillis();
                        }
                        if (this.mDoLastAutoUpdate) {
                            logger.debug("CRLIssuingPoint: mDoLastAutoUpdate set to false");
                        }
                        this.mDoLastAutoUpdate = false;
                        if (this.mDoManualUpdate) {
                            logger.debug("CRLIssuingPoint: mDoManualUpdate set to false");
                            this.mDoManualUpdate = false;
                            this.mSignatureAlgorithmForManualUpdate = null;
                        }
                    }
                }
            }
        }
        catch (EBaseException e1) {
            e1.printStackTrace();
        }
        logger.debug("CRLIssuingPoint: out of the while loop");
        this.mUpdateThread = null;
    }

    private void updateCRL() throws EBaseException {
        if (this.mDoManualUpdate && this.mSignatureAlgorithmForManualUpdate != null) {
            logger.info("CRLIssuingPoint: Updating CRL now with " + this.mSignatureAlgorithmForManualUpdate);
            this.updateCRLNow(this.mSignatureAlgorithmForManualUpdate);
        } else {
            logger.info("CRLIssuingPoint: Updating CRL now");
            this.updateCRLNow();
        }
    }

    public String getFilter() {
        Object filter = "";
        if (this.mIncludeExpiredCerts) {
            filter = (String)filter + "(|";
        }
        filter = (String)filter + "(certStatus=REVOKED)";
        if (this.mIncludeExpiredCerts) {
            filter = (String)filter + "(certStatus=REVOKED_EXPIRED))";
        }
        if (this.mCACertsOnly) {
            filter = (String)filter + "(x509cert.BasicConstraints.isCA=on)";
        }
        if (this.mProfileCertsOnly && this.mProfileList != null && !this.mProfileList.isEmpty()) {
            if (this.mProfileList.size() > 1) {
                filter = (String)filter + "(|";
            }
            StringBuffer tempBuffer = new StringBuffer();
            for (int k = 0; k < this.mProfileList.size(); ++k) {
                String id = this.mProfileList.elementAt(k);
                tempBuffer.append("(certMetaInfo=profileId:" + id + ")");
            }
            filter = (String)filter + tempBuffer.toString();
            if (this.mProfileList.size() > 1) {
                filter = (String)filter + ")";
            }
        }
        if (this.mBeginSerial != null) {
            filter = (String)filter + "(certRecordId>=" + this.mBeginSerial.toString() + ")";
        }
        if (this.mEndSerial != null) {
            filter = (String)filter + "(certRecordId<=" + this.mEndSerial.toString() + ")";
        }
        String issuerFilter = "(x509cert.issuer=" + this.mCA.getX500Name().toString() + ")";
        if (this.mCA.isHostAuthority()) {
            issuerFilter = "(|(!(x509cert.issuer=*))" + issuerFilter + ")";
        }
        filter = (String)filter + issuerFilter;
        filter = "(&" + (String)filter + ")";
        return filter;
    }

    public void processRevokedCerts() throws EBaseException {
        logger.info("CRLIssuingPoint: Processing revoked certs");
        CertRecordProcessor cp = new CertRecordProcessor(this.mCRLCerts, this, this.mAllowExtensions);
        String filter = this.getFilter();
        logger.info("CRLIssuingPoint: - filter: " + filter);
        CAEngine engine = CAEngine.getInstance();
        engine.certStatusUpdateTask.processRevokedCerts(cp, filter, this.mPageSize);
    }

    public void clearCRLCache() {
        logger.info("CRLIssuingPoint: Clearing CRL cache");
        this.mCRLCacheIsCleared = true;
        this.mCRLCerts.clear();
        this.mRevokedCerts.clear();
        this.mUnrevokedCerts.clear();
        this.mExpiredCerts.clear();
        this.mSchemaCounter = 0;
    }

    public void clearDeltaCRLCache() {
        logger.info("CRLIssuingPoint: Clearing delta CRL cache");
        this.mRevokedCerts.clear();
        this.mUnrevokedCerts.clear();
        this.mExpiredCerts.clear();
        this.mSchemaCounter = 0;
    }

    private void recoverCRLCache() throws EBaseException {
        logger.info("CRLIssuingPoint: Recovering CRL cache");
        if (this.mEnableCacheRecovery) {
            logger.debug("CRLIssuingPoint: first unsaved: " + this.mFirstUnsaved);
            String filter = "(requeststate=complete)";
            logger.debug("CRLIssuingPoint: filter: " + filter);
            CAEngine engine = CAEngine.getInstance();
            CertRequestRepository requestRepository = engine.getCertRequestRepository();
            IRequestVirtualList list = requestRepository.getPagedRequestsByFilter(new RequestId(this.mFirstUnsaved), false, filter, 500, "requestId");
            logger.debug("CRLIssuingPoint: size: " + list.getSize());
            logger.debug("CRLIssuingPoint: index: " + list.getCurrentIndex());
            CertRecordProcessor cp = new CertRecordProcessor(this.mCRLCerts, this, this.mAllowExtensions);
            boolean includeCert = true;
            int s = list.getSize() - list.getCurrentIndex();
            for (int i = 0; i < s; ++i) {
                int j;
                Request request = null;
                try {
                    request = list.getElementAt(i);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (request == null) continue;
                logger.debug("CRLIssuingPoint: request: " + request.getRequestId());
                logger.debug("CRLIssuingPoint: type: " + request.getRequestType());
                if ("revocation".equals(request.getRequestType())) {
                    RevokedCertImpl[] revokedCert = request.getExtDataInRevokedCertArray("CERT_INFO");
                    if (revokedCert != null) {
                        for (j = 0; j < revokedCert.length; ++j) {
                            logger.debug("CRLIssuingPoint: R j: " + j + " length: " + revokedCert.length + " serial number: 0x" + revokedCert[j].getSerialNumber().toString(16));
                            if (cp != null) {
                                includeCert = cp.checkRevokedCertExtensions(revokedCert[j].getExtensions());
                            }
                            if (!includeCert) continue;
                            this.updateRevokedCert(1, revokedCert[j].getSerialNumber(), revokedCert[j]);
                        }
                        continue;
                    }
                    logger.error("CRLIssuingPoint: Revoked certificates is null or has invalid values");
                    throw new EBaseException("Revoked certificates is null or has invalid values");
                }
                if (!"unrevocation".equals(request.getRequestType())) continue;
                BigInteger[] serialNo = request.getExtDataInBigIntegerArray("OLD_SERIALS");
                if (serialNo != null) {
                    for (j = 0; j < serialNo.length; ++j) {
                        logger.debug("CRLIssuingPoint: U j: " + j + " length: " + serialNo.length + " serial number: 0x" + serialNo[j].toString(16));
                        this.updateRevokedCert(2, serialNo[j], null);
                    }
                    continue;
                }
                logger.error("CRLIssuingPoint: Serial number is null or has invalid values");
                throw new EBaseException("Serial number is null or has invalid values");
            }
            try {
                this.mCRLRepository.updateRevokedCerts(this.mId, this.mRevokedCerts, this.mUnrevokedCerts);
                this.mFirstUnsaved = "-1";
                this.mCRLCacheIsCleared = false;
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_STORE_CRL_CACHE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
        } else {
            this.clearCRLCache();
            this.updateCRLCacheRepository();
        }
    }

    public int getNumberOfRecentlyRevokedCerts() {
        return this.mRevokedCerts.size();
    }

    public int getNumberOfRecentlyUnrevokedCerts() {
        return this.mUnrevokedCerts.size();
    }

    public int getNumberOfRecentlyExpiredCerts() {
        return this.mExpiredCerts.size();
    }

    private Extension getCRLExtension(String extName) {
        if (!this.mAllowExtensions) {
            return null;
        }
        if (!this.mCMSCRLExtensions.isCRLExtensionEnabled(extName)) {
            return null;
        }
        CMSCRLExtensions exts = this.getCRLExtensions();
        CRLExtensions ext = new CRLExtensions();
        Vector<String> extNames = exts.getCRLExtensionNames();
        for (int i = 0; i < extNames.size(); ++i) {
            String curName = extNames.elementAt(i);
            if (!curName.equals(extName)) continue;
            exts.addToCRLExtensions(ext, extName, null);
        }
        Extension theExt = null;
        try {
            theExt = ext.get(extName);
        }
        catch (Exception exception) {
            // empty catch block
        }
        logger.debug("CRLIssuingPoint: extension: " + theExt);
        return theExt;
    }

    public CRLExtensions getRequiredEntryExtensions(CRLExtensions exts) {
        CRLExtensions entryExt = null;
        if (this.mAllowExtensions && exts != null && !exts.isEmpty()) {
            entryExt = new CRLExtensions();
            Vector<String> extNames = this.mCMSCRLExtensions.getCRLEntryExtensionNames();
            for (int i = 0; i < extNames.size(); ++i) {
                int k;
                String extName = extNames.elementAt(i);
                if (!this.mCMSCRLExtensions.isCRLExtensionEnabled(extName)) continue;
                for (k = 0; k < exts.size(); ++k) {
                    CRLReasonExtension crlreasonextension;
                    Extension ext = (Extension)exts.elementAt(k);
                    String name = this.mCMSCRLExtensions.getCRLExtensionName(ext.getExtensionId().toString());
                    if (!extName.equals(name)) continue;
                    if (ext instanceof CRLReasonExtension && (crlreasonextension = (CRLReasonExtension)ext).getReason().getCode() <= RevocationReason.UNSPECIFIED.getCode()) break;
                    this.mCMSCRLExtensions.addToCRLExtensions(entryExt, extName, ext);
                    break;
                }
                if (k != exts.size()) continue;
                this.mCMSCRLExtensions.addToCRLExtensions(entryExt, extName, null);
            }
        }
        return entryExt;
    }

    private void updateRevokedCert(int certType, BigInteger serialNumber, RevokedCertImpl revokedCert) {
        this.updateRevokedCert(certType, serialNumber, revokedCert, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRevokedCert(int certType, BigInteger serialNumber, RevokedCertImpl revokedCert, String requestId) {
        CertId certID = new CertId(serialNumber);
        logger.info("CRLIssuingPoint: Updating revoked cert " + certID.toHexString());
        Object object = this.cacheMonitor;
        synchronized (object) {
            if (requestId != null && this.mFirstUnsaved != null && this.mFirstUnsaved.equals("-1")) {
                this.mFirstUnsaved = requestId;
                try {
                    this.mCRLRepository.updateFirstUnsaved(this.mId, this.mFirstUnsaved);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_STORE_CRL_CACHE", (Object[])new Object[]{e.toString()}), (Throwable)e);
                }
            }
            if (certType == 1) {
                if (this.mUnrevokedCerts.containsKey(serialNumber)) {
                    this.mUnrevokedCerts.remove(serialNumber);
                    if (this.mCRLCerts.containsKey(serialNumber)) {
                        Date revocationDate = revokedCert.getRevocationDate();
                        CRLExtensions entryExt = this.getRequiredEntryExtensions(revokedCert.getExtensions());
                        RevokedCertImpl newRevokedCert = new RevokedCertImpl(serialNumber, revocationDate, entryExt);
                        this.mCRLCerts.put(serialNumber, (RevokedCertificate)newRevokedCert);
                    }
                } else {
                    Date revocationDate = revokedCert.getRevocationDate();
                    CRLExtensions entryExt2 = this.getRequiredEntryExtensions(revokedCert.getExtensions());
                    RevokedCertImpl newRevokedCert = new RevokedCertImpl(serialNumber, revocationDate, entryExt2);
                    this.mRevokedCerts.put(serialNumber, (RevokedCertificate)newRevokedCert);
                }
            } else if (certType == 2) {
                if (this.mRevokedCerts.containsKey(serialNumber)) {
                    this.mRevokedCerts.remove(serialNumber);
                } else {
                    CRLExtensions entryExt = new CRLExtensions();
                    try {
                        entryExt.set(CRLReasonExtension.REMOVE_FROM_CRL.getName(), (Extension)CRLReasonExtension.REMOVE_FROM_CRL);
                    }
                    catch (IOException entryExt2) {
                        // empty catch block
                    }
                    RevokedCertImpl newRevokedCert = new RevokedCertImpl(serialNumber, new Date(), entryExt);
                    this.mUnrevokedCerts.put(serialNumber, (RevokedCertificate)newRevokedCert);
                }
            }
        }
        logger.debug("CRLIssuingPoint: - CRL certs: " + this.mCRLCerts.size());
        logger.debug("CRLIssuingPoint: - revoked certs: " + this.mRevokedCerts.size());
        logger.debug("CRLIssuingPoint: - unrevoked certs: " + this.mUnrevokedCerts.size());
    }

    public void addRevokedCert(BigInteger serialNumber, RevokedCertImpl revokedCert) {
        this.addRevokedCert(serialNumber, revokedCert, null);
    }

    public void addRevokedCert(BigInteger serialNumber, RevokedCertImpl revokedCert, String requestId) {
        CertId certID = new CertId(serialNumber);
        logger.info("CRLIssuingPoint: Adding revoked cert " + certID.toHexString());
        CertRecordProcessor cp = new CertRecordProcessor(this.mCRLCerts, this, this.mAllowExtensions);
        boolean includeCert = cp.checkRevokedCertExtensions(revokedCert.getExtensions());
        if (this.mEnable && this.mEnableCRLCache && includeCert) {
            this.updateRevokedCert(1, serialNumber, revokedCert, requestId);
            if (this.mCacheUpdateInterval == 0L) {
                try {
                    this.mCRLRepository.updateRevokedCerts(this.mId, this.mRevokedCerts, this.mUnrevokedCerts);
                    this.mFirstUnsaved = "-1";
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_STORE_REVOKED_CERT", (Object[])new Object[]{this.mId, e.toString()}), (Throwable)e);
                }
            }
        }
    }

    public void addUnrevokedCert(BigInteger serialNumber) {
        this.addUnrevokedCert(serialNumber, null);
    }

    public void addUnrevokedCert(BigInteger serialNumber, String requestId) {
        CertId certID = new CertId(serialNumber);
        logger.info("CRLIssuingPoint: Adding unrevoked cert " + certID.toHexString());
        if (this.mEnable && this.mEnableCRLCache) {
            this.updateRevokedCert(2, serialNumber, null, requestId);
            if (this.mCacheUpdateInterval == 0L) {
                try {
                    this.mCRLRepository.updateRevokedCerts(this.mId, this.mRevokedCerts, this.mUnrevokedCerts);
                    this.mFirstUnsaved = "-1";
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_STORE_UNREVOKED_CERT", (Object[])new Object[]{this.mId, e.toString()}), (Throwable)e);
                }
            }
        }
    }

    public void addExpiredCert(BigInteger serialNumber) {
        CertId certID = new CertId(serialNumber);
        logger.info("CRLIssuingPoint: Adding expired cert " + certID.toHexString());
        if (this.mEnable && this.mEnableCRLCache && !this.mIncludeExpiredCerts) {
            if (!this.mExpiredCerts.containsKey(serialNumber)) {
                CRLExtensions entryExt = new CRLExtensions();
                try {
                    entryExt.set(CRLReasonExtension.REMOVE_FROM_CRL.getName(), (Extension)CRLReasonExtension.REMOVE_FROM_CRL);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                RevokedCertImpl newRevokedCert = new RevokedCertImpl(serialNumber, new Date(), entryExt);
                this.mExpiredCerts.put(serialNumber, (RevokedCertificate)newRevokedCert);
            }
            if (this.mCacheUpdateInterval == 0L) {
                try {
                    this.mCRLRepository.updateExpiredCerts(this.mId, this.mExpiredCerts);
                }
                catch (EBaseException e) {
                    logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_STORE_EXPIRED_CERT", (Object[])new Object[]{this.mId, e.toString()}), (Throwable)e);
                }
            }
        }
        logger.debug("CRLIssuingPoint: - expired certs: " + this.mExpiredCerts.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCRLCacheRepository() {
        Object object = this.repositoryMonitor;
        synchronized (object) {
            try {
                this.mCRLRepository.updateCRLCache(this.mId, this.mCRLSize, this.mRevokedCerts, this.mUnrevokedCerts, this.mExpiredCerts);
                this.mFirstUnsaved = "-1";
            }
            catch (EBaseException e) {
                logger.warn(CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_STORE_CRL_CACHE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            }
        }
    }

    public boolean isDeltaCRLEnabled() {
        return this.mAllowExtensions && this.mEnableCRLCache && this.mCMSCRLExtensions.isCRLExtensionEnabled("DeltaCRLIndicator") && this.mCMSCRLExtensions.isCRLExtensionEnabled("CRLNumber") && this.mCMSCRLExtensions.isCRLExtensionEnabled("CRLReason");
    }

    public boolean isThisCurrentDeltaCRL(X509CRLImpl deltaCRL) {
        CRLExtensions crlExtensions;
        boolean result = false;
        if (this.isDeltaCRLEnabled() && this.mDeltaCRLSize > -1L && deltaCRL != null && (crlExtensions = deltaCRL.getExtensions()) != null) {
            for (int k = 0; k < crlExtensions.size(); ++k) {
                Extension ext = (Extension)crlExtensions.elementAt(k);
                if (!"2.5.29.27".equals(ext.getExtensionId().toString())) continue;
                DeltaCRLIndicatorExtension dExt = (DeltaCRLIndicatorExtension)ext;
                BigInteger crlNumber = null;
                try {
                    crlNumber = (BigInteger)dExt.get("value");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (crlNumber == null || !crlNumber.equals(this.mLastCRLNumber) && !this.mLastCRLNumber.equals(BigInteger.ZERO)) continue;
                result = true;
            }
        }
        return result;
    }

    public boolean isCRLCacheEnabled() {
        return this.mEnableCRLCache;
    }

    public boolean isCRLCacheEmpty() {
        return this.mCRLCerts == null || this.mCRLCerts.isEmpty();
    }

    public boolean isCRLCacheTestingEnabled() {
        return this.mEnableCacheTesting;
    }

    public Date getRevocationDateFromCache(BigInteger serialNumber, boolean checkDeltaCache, boolean includeExpiredCerts) {
        Date revocationDate = null;
        if (this.mCRLCerts.containsKey(serialNumber)) {
            revocationDate = this.mCRLCerts.get(serialNumber).getRevocationDate();
        }
        if (checkDeltaCache && this.isDeltaCRLEnabled()) {
            if (this.mUnrevokedCerts.containsKey(serialNumber)) {
                revocationDate = null;
            }
            if (this.mRevokedCerts.containsKey(serialNumber)) {
                revocationDate = this.mRevokedCerts.get(serialNumber).getRevocationDate();
            }
            if (!includeExpiredCerts && this.mExpiredCerts.containsKey(serialNumber)) {
                revocationDate = null;
            }
        }
        return revocationDate;
    }

    public synchronized Vector<Long> getSplitTimes() {
        Vector<Long> splits = new Vector<Long>();
        for (int i = 0; i < this.mSplits.length; ++i) {
            splits.addElement(this.mSplits[i]);
        }
        return splits;
    }

    public synchronized int isCRLUpdateInProgress() {
        return this.mUpdatingCRL;
    }

    public void updateCRLNow() throws EBaseException {
        this.updateCRLNow(null);
    }

    public synchronized void updateCRLNow(String signingAlgorithm) throws EBaseException {
        logger.info("CRLIssuingPoint: Updating " + this.mId);
        logger.debug("CRLIssuingPoint: - signing algorithm: " + signingAlgorithm);
        logger.debug("CRLIssuingPoint: - enable: " + this.mEnable);
        logger.debug("CRLIssuingPoint: - enable CRL updates: " + this.mEnableCRLUpdates);
        logger.debug("CRLIssuingPoint: - do last auto update: " + this.mDoLastAutoUpdate);
        CAEngine engine = CAEngine.getInstance();
        if (!this.mEnable || !this.mEnableCRLUpdates && !this.mDoLastAutoUpdate) {
            logger.info("CRLIssuingPoint: Not enabled");
            return;
        }
        logger.debug("CRLIssuingPoint: - next CRL number: " + this.mNextDeltaCRLNumber);
        logger.debug("CRLIssuingPoint: - delta CRL enabled: " + this.isDeltaCRLEnabled());
        logger.debug("CRLIssuingPoint: - CRL cache enabled: " + this.mEnableCRLCache);
        logger.debug("CRLIssuingPoint: - cache recovery enabled: " + this.mCRLCacheIsCleared);
        logger.debug("CRLIssuingPoint: - CRL certs: " + this.mCRLCerts.size());
        logger.debug("CRLIssuingPoint: - revoked certs: " + this.mRevokedCerts.size());
        logger.debug("CRLIssuingPoint: - unrevoked certs: " + this.mUnrevokedCerts.size());
        logger.debug("CRLIssuingPoint: - expired certs: " + this.mExpiredCerts.size());
        this.mUpdatingCRL = 1;
        if (signingAlgorithm == null || signingAlgorithm.length() == 0) {
            signingAlgorithm = this.mSigningAlgorithm;
        }
        this.mLastSigningAlgorithm = signingAlgorithm;
        Date thisUpdate = null;
        Date nowDate = new Date();
        if (this.mForbidCustomFutureThisUpdateValue && this.mCustomFutureThisUpdateValue != null) {
            logger.error("CRLIssuingPoint: Unable to update CRL: Future thisUpdate not allowed");
            this.mUpdatingCRL = 0;
            this.mCustomFutureThisUpdateValue = null;
            throw new EBaseException("Unable to update CRL: Future thisUpdate not allowed");
        }
        if (this.mCustomFutureThisUpdateValue != null && this.mCustomFutureThisUpdateValue.after(nowDate)) {
            logger.info("CRLIssuingPoint: Setting thisUpdate to " + this.mCustomFutureThisUpdateValue);
            thisUpdate = this.mCustomFutureThisUpdateValue;
        } else {
            logger.info("CRLIssuingPoint: Cancel future thisUpdate: " + this.mCancelCurFutureThisUpdateValue);
            if (nowDate.before(this.getLastUpdate()) && !this.mCancelCurFutureThisUpdateValue) {
                logger.error("CRLIssuingPoint: Unable to update CRL: Future thisUpdate already set");
                this.mUpdatingCRL = 0;
                this.mCancelCurFutureThisUpdateValue = false;
                throw new EBaseException("Unable to update CRL: Future thisUpdate already set");
            }
            thisUpdate = nowDate;
        }
        this.mCancelCurFutureThisUpdateValue = false;
        Date nextUpdate = null;
        Date nextDeltaUpdate = null;
        if (this.mEnableCRLUpdates && (this.mEnableDailyUpdates && this.mDailyUpdates != null && this.mTimeListSize > 0 || this.mEnableUpdateFreq && this.mAutoUpdateInterval > 0L)) {
            if (!this.isDeltaCRLEnabled() || this.mSchemaCounter == 0 || this.mUpdateSchema == 1) {
                nextUpdate = new Date(this.findNextUpdate(false, false));
                this.mNextUpdate = new Date(nextUpdate.getTime());
            }
            if (this.isDeltaCRLEnabled()) {
                if (this.mUpdateSchema > 1 || this.mEnableDailyUpdates && this.mExtendedTimeList && this.mTimeListSize > 1) {
                    nextDeltaUpdate = new Date(this.findNextUpdate(false, true));
                    if (this.mExtendedNextUpdate && this.mSchemaCounter > 0 && this.mNextUpdate != null && this.mNextUpdate.equals(nextDeltaUpdate)) {
                        this.mSchemaCounter = this.mEnableDailyUpdates && this.mExtendedTimeList && this.mTimeListSize > 1 ? this.mTimeListSize - 1 : this.mUpdateSchema - 1;
                    }
                } else {
                    nextDeltaUpdate = new Date(nextUpdate.getTime());
                    if (this.mUpdateSchema == 1) {
                        this.mSchemaCounter = 0;
                    }
                }
            }
        }
        for (int i = 0; i < this.mSplits.length; ++i) {
            this.mSplits[i] = 0L;
        }
        this.mLastUpdate = thisUpdate;
        this.mCustomFutureThisUpdateValue = null;
        Date date = this.mNextDeltaUpdate = nextDeltaUpdate != null ? new Date(nextDeltaUpdate.getTime()) : null;
        if (this.mNextAsThisUpdateExtension > 0L) {
            Date nextUpdateAsThisUpdateExtension = new Date(thisUpdate.getTime() + this.mNextAsThisUpdateExtension);
            if (nextUpdate != null && nextUpdate.before(nextUpdateAsThisUpdateExtension)) {
                nextUpdate = nextUpdateAsThisUpdateExtension;
            }
            if (nextDeltaUpdate != null && nextDeltaUpdate.before(nextUpdateAsThisUpdateExtension)) {
                nextDeltaUpdate = nextUpdateAsThisUpdateExtension;
            }
        }
        if (nextUpdate != null) {
            nextUpdate.setTime(nextUpdate.getTime() + this.mNextUpdateGracePeriod);
        }
        if (nextDeltaUpdate != null) {
            nextDeltaUpdate.setTime(nextDeltaUpdate.getTime() + this.mNextUpdateGracePeriod);
        }
        this.mSplits[0] = this.mSplits[0] - System.currentTimeMillis();
        Hashtable clonedRevokedCerts = (Hashtable)this.mRevokedCerts.clone();
        Hashtable clonedUnrevokedCerts = (Hashtable)this.mUnrevokedCerts.clone();
        Hashtable clonedExpiredCerts = (Hashtable)this.mExpiredCerts.clone();
        this.mSplits[0] = this.mSplits[0] + System.currentTimeMillis();
        if (!this.mEnableCRLCache || this.mCRLCacheIsCleared && this.mCRLCerts.isEmpty() && clonedRevokedCerts.isEmpty() && clonedUnrevokedCerts.isEmpty() && clonedExpiredCerts.isEmpty() || this.mCRLCerts.isEmpty() && !clonedUnrevokedCerts.isEmpty() || this.mCRLCerts.size() < clonedUnrevokedCerts.size() || this.mCRLCerts.isEmpty() && this.mCRLSize > 0L || this.mCRLCerts.size() > 0 && this.mCRLSize == 0L) {
            this.mSplits[5] = this.mSplits[5] - System.currentTimeMillis();
            this.mDeltaCRLSize = -1L;
            this.clearCRLCache();
            clonedRevokedCerts.clear();
            clonedUnrevokedCerts.clear();
            clonedExpiredCerts.clear();
            this.mSchemaCounter = 0;
            StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
            if (statsSub != null) {
                statsSub.startTiming("generation");
            }
            this.processRevokedCerts();
            if (statsSub != null) {
                statsSub.endTiming("generation");
            }
            this.mCRLCacheIsCleared = false;
            this.mSplits[5] = this.mSplits[5] + System.currentTimeMillis();
        } else {
            if (this.isDeltaCRLEnabled()) {
                this.generateDeltaCRL(clonedRevokedCerts, clonedUnrevokedCerts, clonedExpiredCerts, signingAlgorithm, thisUpdate, nextDeltaUpdate);
            } else {
                this.mDeltaCRLSize = -1L;
            }
            this.mSplits[5] = this.mSplits[5] - System.currentTimeMillis();
            if (this.mSchemaCounter == 0) {
                if (!this.mCRLCerts.isEmpty() && (!clonedRevokedCerts.isEmpty() || !clonedUnrevokedCerts.isEmpty() || !clonedExpiredCerts.isEmpty()) || this.mCRLCerts.isEmpty() && this.mCRLSize == 0L && !clonedRevokedCerts.isEmpty()) {
                    CertId certID;
                    BigInteger serialNumber;
                    Enumeration e;
                    if (!clonedUnrevokedCerts.isEmpty()) {
                        e = clonedUnrevokedCerts.keys();
                        while (e.hasMoreElements()) {
                            serialNumber = (BigInteger)e.nextElement();
                            certID = new CertId(serialNumber);
                            if (this.mCRLCerts.containsKey(serialNumber)) {
                                logger.info("CRLIssuingPoint: Removing unrevoked cert " + certID.toHexString() + " from cache");
                                this.mCRLCerts.remove(serialNumber);
                            }
                            this.mUnrevokedCerts.remove(serialNumber);
                        }
                    }
                    if (!clonedRevokedCerts.isEmpty()) {
                        e = clonedRevokedCerts.keys();
                        while (e.hasMoreElements()) {
                            serialNumber = (BigInteger)e.nextElement();
                            certID = new CertId(serialNumber);
                            logger.info("CRLIssuingPoint: Adding revoked cert " + certID.toHexString() + " to cache");
                            this.mCRLCerts.put(serialNumber, this.mRevokedCerts.get(serialNumber));
                            this.mRevokedCerts.remove(serialNumber);
                        }
                    }
                    if (!clonedExpiredCerts.isEmpty()) {
                        e = clonedExpiredCerts.keys();
                        while (e.hasMoreElements()) {
                            serialNumber = (BigInteger)e.nextElement();
                            certID = new CertId(serialNumber);
                            if (this.mIncludeExpiredCertsOneExtraTime && (this.mLastFullUpdate == null || !this.mLastFullUpdate.after(this.mExpiredCerts.get(serialNumber).getRevocationDate())) && this.mLastFullUpdate != null) continue;
                            logger.info("CRLIssuingPoint: Removing expired cert " + certID.toHexString() + " from cache");
                            if (this.mCRLCerts.containsKey(serialNumber)) {
                                this.mCRLCerts.remove(serialNumber);
                            }
                            this.mExpiredCerts.remove(serialNumber);
                        }
                    }
                }
                this.mLastFullUpdate = this.mLastUpdate;
            }
            this.mSplits[5] = this.mSplits[5] + System.currentTimeMillis();
        }
        logger.debug("CRLIssuingPoint: - CRL certs: " + this.mCRLCerts.size());
        clonedRevokedCerts.clear();
        clonedUnrevokedCerts.clear();
        clonedExpiredCerts.clear();
        clonedRevokedCerts = null;
        clonedUnrevokedCerts = null;
        clonedExpiredCerts = null;
        if (!this.isDeltaCRLEnabled() || this.mSchemaCounter == 0) {
            this.generateFullCRL(signingAlgorithm, thisUpdate, nextUpdate);
        }
        if (this.isDeltaCRLEnabled() && this.mDeltaCRLSize > -1L && this.mSchemaCounter > 0) {
            this.mDeltaCRLNumber = this.mNextDeltaCRLNumber;
            this.mNextDeltaCRLNumber = this.mDeltaCRLNumber.add(BigInteger.ONE);
        }
        if (!this.mEnableDailyUpdates || !this.mExtendedTimeList || this.mSchemaCounter == 0) {
            ++this.mSchemaCounter;
        }
        if (this.mEnableDailyUpdates && this.mExtendedTimeList && this.mSchemaCounter >= this.mTimeListSize || this.mUpdateSchema > 1 && this.mSchemaCounter >= this.mUpdateSchema) {
            this.mSchemaCounter = 0;
        }
        this.mLastDay = this.mCurrentDay;
        this.mUpdatingCRL = 0;
        this.notifyAll();
    }

    CRLExtensions generateCRLExtensions(String excludedExtension) {
        CRLExtensions ext = new CRLExtensions();
        Vector<String> extNames = this.mCMSCRLExtensions.getCRLExtensionNames();
        for (int i = 0; i < extNames.size(); ++i) {
            String extName = extNames.elementAt(i);
            if (extName.equals(excludedExtension) || !this.mCMSCRLExtensions.isCRLExtensionEnabled(extName)) continue;
            this.mCMSCRLExtensions.addToCRLExtensions(ext, extName, null);
        }
        return ext;
    }

    void generateDeltaCRL(Hashtable<BigInteger, RevokedCertificate> clonedRevokedCerts, Hashtable<BigInteger, RevokedCertificate> clonedUnrevokedCerts, Hashtable<BigInteger, RevokedCertificate> clonedExpiredCerts, String signingAlgorithm, Date thisUpdate, Date nextDeltaUpdate) {
        logger.info("CRLIssuingPoint: Generating delta CRL");
        this.mSplits[1] = this.mSplits[1] - System.currentTimeMillis();
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        Hashtable deltaCRLCerts = (Hashtable)clonedRevokedCerts.clone();
        deltaCRLCerts.putAll(clonedUnrevokedCerts);
        if (this.mIncludeExpiredCertsOneExtraTime) {
            Enumeration<BigInteger> e = clonedExpiredCerts.keys();
            while (e.hasMoreElements()) {
                BigInteger serialNumber = e.nextElement();
                if (this.mLastFullUpdate != null && !this.mLastFullUpdate.after(this.mExpiredCerts.get(serialNumber).getRevocationDate())) continue;
                deltaCRLCerts.put(serialNumber, clonedExpiredCerts.get(serialNumber));
            }
        } else {
            deltaCRLCerts.putAll(clonedExpiredCerts);
        }
        this.mLastCRLNumber = this.mCRLNumber;
        CRLExtensions ext = this.generateCRLExtensions("FreshestCRL");
        this.mSplits[1] = this.mSplits[1] + System.currentTimeMillis();
        X509CRLImpl newX509DeltaCRL = null;
        try {
            this.mSplits[2] = this.mSplits[2] - System.currentTimeMillis();
            if (this.mConfigStore.getNoCRLIfNoRevokedCert() && deltaCRLCerts.size() == 0) {
                logger.info("CRLIssuingPoint: Not generating delta CRL since there are no revoked certificates");
                this.mDeltaCRLSize = -1L;
                auditor.log((LogEvent)DeltaCRLGenerationEvent.createSuccessEvent((String)this.getAuditSubjectID(), (String)"No Revoked Certificates"));
                return;
            }
            logger.info("CRLIssuingPoint: Generating delta CRL with " + deltaCRLCerts.size() + " cert(s)");
            X509CRLImpl crl = new X509CRLImpl(this.mCA.getCRLX500Name(), AlgorithmId.get((String)signingAlgorithm), thisUpdate, nextDeltaUpdate, deltaCRLCerts, ext);
            logger.info("CRLIssuingPoint: Signing delta CRL with " + signingAlgorithm);
            newX509DeltaCRL = this.mCA.sign(crl, signingAlgorithm);
            logger.info("CRLIssuingPoint: Encoding delta CRL");
            byte[] newDeltaCRL = newX509DeltaCRL.getEncoded();
            this.mSplits[2] = this.mSplits[2] + System.currentTimeMillis();
            this.mSplits[3] = this.mSplits[3] - System.currentTimeMillis();
            this.mCRLRepository.updateDeltaCRL(this.mId, this.mNextDeltaCRLNumber, Long.valueOf(deltaCRLCerts.size()), this.mNextDeltaUpdate, newDeltaCRL);
            this.mSplits[3] = this.mSplits[3] + System.currentTimeMillis();
            this.mDeltaCRLSize = deltaCRLCerts.size();
            long totalTime = 0L;
            StringBuffer splitTimes = new StringBuffer("  (");
            for (int i = 1; i < this.mSplits.length && i < 5; ++i) {
                totalTime += this.mSplits[i];
                if (i > 1) {
                    splitTimes.append(",");
                }
                splitTimes.append(String.valueOf(this.mSplits[i]));
            }
            splitTimes.append(")");
            logger.debug("CRLIssuingPoint: - delta CRL number: " + this.mNextDeltaCRLNumber);
            logger.debug("CRLIssuingPoint: - against CRL number: " + this.mCRLNumber);
            logger.debug("CRLIssuingPoint: - last update: " + this.mLastUpdate);
            logger.debug("CRLIssuingPoint: - next update: " + this.mNextDeltaUpdate);
            logger.debug("CRLIssuingPoint: - delta CRL size: " + this.mDeltaCRLSize);
            logger.debug("CRLIssuingPoint: - total time: " + totalTime + splitTimes);
            auditor.log((LogEvent)DeltaCRLGenerationEvent.createSuccessEvent((String)this.getAuditSubjectID(), (BigInteger)this.mCRLNumber));
            logger.info("CRLIssuingPoint: Done generating delta CRL");
        }
        catch (EBaseException e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_SIGN_OR_STORE_DELTA", (Object[])new Object[]{e.toString()});
            logger.error(message, (Throwable)e);
            this.mDeltaCRLSize = -1L;
            auditor.log((LogEvent)DeltaCRLGenerationEvent.createFailureEvent((String)this.getAuditSubjectID(), (String)e.getMessage()));
            return;
        }
        catch (Exception e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_SIGN_DELTA", (Object[])new Object[]{e.toString()});
            logger.error(message, (Throwable)e);
            this.mDeltaCRLSize = -1L;
            auditor.log((LogEvent)DeltaCRLGenerationEvent.createFailureEvent((String)this.getAuditSubjectID(), (String)e.getMessage()));
            return;
        }
        logger.info("CRLIssuingPoint: Publishing delta CRL");
        try {
            this.mSplits[4] = this.mSplits[4] - System.currentTimeMillis();
            this.publishCRL(newX509DeltaCRL, true);
            this.mSplits[4] = this.mSplits[4] + System.currentTimeMillis();
            auditor.log((LogEvent)new DeltaCRLPublishingEvent(this.getAuditSubjectID(), this.mCRLNumber));
        }
        catch (Exception e) {
            String message = CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_PUBLISH_DELTA", (Object[])new Object[]{this.mCRLNumber.toString(), e.toString()});
            logger.error(message, (Throwable)e);
            auditor.log((LogEvent)new DeltaCRLPublishingEvent(this.getAuditSubjectID(), this.mCRLNumber, e.getMessage()));
        }
    }

    void generateFullCRL(String signingAlgorithm, Date thisUpdate, Date nextUpdate) throws EBaseException {
        logger.info("CRLIssuingPoint: Generating full CRL");
        logger.debug("CRLIssuingPoint: - thisUpdate: " + thisUpdate);
        logger.debug("CRLIssuingPoint: - nextUpdate: " + nextUpdate);
        this.mSplits[6] = this.mSplits[6] - System.currentTimeMillis();
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        if (this.mNextDeltaCRLNumber.compareTo(this.mNextCRLNumber) > 0) {
            this.mNextCRLNumber = this.mNextDeltaCRLNumber;
        }
        CRLExtensions ext = this.mAllowExtensions ? this.generateCRLExtensions("DeltaCRLIndicator") : null;
        this.mSplits[6] = this.mSplits[6] + System.currentTimeMillis();
        X509CRLImpl newX509CRL = null;
        try {
            logger.debug("CRLIssuingPoint: - signing algorithm: " + signingAlgorithm);
            this.mSplits[7] = this.mSplits[7] - System.currentTimeMillis();
            logger.debug("CRLIssuingPoint: - CRL certs: " + this.mCRLCerts.size());
            if (this.mConfigStore.getNoCRLIfNoRevokedCert() && this.mCRLCerts.size() == 0) {
                logger.info("CRLIssuingPoint: Not generating full CRL since there are no revoked certificates");
                auditor.log((LogEvent)FullCRLGenerationEvent.createSuccessEvent((String)this.getAuditSubjectID(), (String)"No Revoked Certificates"));
                return;
            }
            logger.info("CRLIssuingPoint: Generating full CRL with " + this.mCRLCerts.size() + " cert(s)");
            X509CRLImpl crl = new X509CRLImpl(this.mCA.getCRLX500Name(), AlgorithmId.get((String)signingAlgorithm), thisUpdate, nextUpdate, this.mCRLCerts, ext);
            logger.info("CRLIssuingPoint: Signing full CRL with " + signingAlgorithm);
            newX509CRL = this.mCA.sign(crl, signingAlgorithm);
            logger.info("CRLIssuingPoint: Encoding full CRL");
            byte[] newCRL = newX509CRL.getEncoded();
            this.mSplits[7] = this.mSplits[7] + System.currentTimeMillis();
            this.mSplits[8] = this.mSplits[8] - System.currentTimeMillis();
            Date nextUpdateDate = this.mNextUpdate;
            if (this.isDeltaCRLEnabled() && (this.mUpdateSchema > 1 || this.mEnableDailyUpdates && this.mExtendedTimeList) && this.mNextDeltaUpdate != null) {
                nextUpdateDate = this.mNextDeltaUpdate;
            }
            logger.info("CRLIssuingPoint: Storing full CRL");
            if (this.mSaveMemory) {
                this.mCRLRepository.updateCRLIssuingPointRecord(this.mId, newCRL, thisUpdate, nextUpdateDate, this.mNextCRLNumber, Long.valueOf(this.mCRLCerts.size()));
                this.updateCRLCacheRepository();
            } else {
                this.mCRLRepository.updateCRLIssuingPointRecord(this.mId, newCRL, thisUpdate, nextUpdateDate, this.mNextCRLNumber, Long.valueOf(this.mCRLCerts.size()), this.mRevokedCerts, this.mUnrevokedCerts, this.mExpiredCerts);
                this.mFirstUnsaved = "-1";
            }
            this.mSplits[8] = this.mSplits[8] + System.currentTimeMillis();
            this.mCRLSize = this.mCRLCerts.size();
            this.mDeltaCRLNumber = this.mCRLNumber = this.mNextCRLNumber;
            this.mNextDeltaCRLNumber = this.mNextCRLNumber = this.mCRLNumber.add(BigInteger.ONE);
            long totalTime = 0L;
            long crlTime = 0L;
            long deltaTime = 0L;
            StringBuilder splitTimes = new StringBuilder("  (");
            for (int i = 0; i < this.mSplits.length; ++i) {
                totalTime += this.mSplits[i];
                if (i > 0 && i < 5) {
                    deltaTime += this.mSplits[i];
                } else {
                    crlTime += this.mSplits[i];
                }
                if (i > 0) {
                    splitTimes.append(",");
                }
                splitTimes.append(this.mSplits[i]);
            }
            splitTimes.append(String.format(",%d,%d,%d)", deltaTime, crlTime, totalTime));
            logger.debug("CRLIssuingPoint: - CRL number: " + this.mCRLNumber);
            logger.debug("CRLIssuingPoint: - last update: " + this.mLastUpdate);
            logger.debug("CRLIssuingPoint: - next update: " + this.mNextUpdate);
            logger.debug("CRLIssuingPoint: - CRL size: " + this.mCRLSize);
            logger.debug("CRLIssuingPoint: - total time: " + totalTime);
            logger.debug("CRLIssuingPoint: - CRL time: " + crlTime);
            logger.debug("CRLIssuingPoint: - delta CRL time: " + deltaTime + splitTimes);
            auditor.log((LogEvent)FullCRLGenerationEvent.createSuccessEvent((String)this.getAuditSubjectID(), (BigInteger)this.mCRLNumber));
            logger.info("CRLIssuingPoint: Done generating full CRL");
        }
        catch (EBaseException e) {
            this.mUpdatingCRL = 0;
            String message = CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_SIGN_OR_STORE_CRL", (Object[])new Object[]{e.toString()});
            logger.error(message, (Throwable)e);
            auditor.log((LogEvent)FullCRLGenerationEvent.createFailureEvent((String)this.getAuditSubjectID(), (String)e.getMessage()));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_FAILED_CONSTRUCTING_CRL", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            this.mUpdatingCRL = 0;
            String message = CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_SIGN_CRL", (Object[])new Object[]{e.toString()});
            logger.error(message, (Throwable)e);
            auditor.log((LogEvent)FullCRLGenerationEvent.createFailureEvent((String)this.getAuditSubjectID(), (String)e.getMessage()));
            throw new ECAException(CMS.getUserMessage((String)"CMS_CA_FAILED_CONSTRUCTING_CRL", (String[])new String[]{e.toString()}), (Throwable)e);
        }
        logger.info("CRLIssuingPoint: Publishing full CRL");
        try {
            this.mSplits[9] = this.mSplits[9] - System.currentTimeMillis();
            this.mUpdatingCRL = 2;
            this.publishCRL(newX509CRL);
            this.mSplits[9] = this.mSplits[9] + System.currentTimeMillis();
            auditor.log((LogEvent)new FullCRLPublishingEvent(this.getAuditSubjectID(), this.mCRLNumber));
        }
        catch (Exception e) {
            this.mUpdatingCRL = 0;
            String message = CMS.getLogMessage((String)"CMSCORE_CA_ISSUING_PUBLISH_CRL", (Object[])new Object[]{this.mCRLNumber.toString(), e.toString()});
            logger.error(message, (Throwable)e);
            auditor.log((LogEvent)new FullCRLPublishingEvent(this.getAuditSubjectID(), this.mCRLNumber, e.getMessage()));
            throw new ECAException(message, (Throwable)e);
        }
    }

    public void publishCRL() throws EBaseException {
        this.publishCRL(null);
    }

    protected void publishCRL(X509CRLImpl x509crl) throws EBaseException {
        this.publishCRL(x509crl, false);
    }

    protected void publishCRL(X509CRLImpl x509crl, boolean isDeltaCRL) throws EBaseException {
        SessionContext sc = SessionContext.getContext();
        CAEngine engine = CAEngine.getInstance();
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming("crl_publishing");
        }
        if (this.mCountMod == 0) {
            sc.put((Object)SC_CRL_COUNT, (Object)Integer.toString(this.mCount));
        } else {
            sc.put((Object)SC_CRL_COUNT, (Object)Integer.toString(this.mCount % this.mCountMod));
        }
        ++this.mCount;
        sc.put((Object)SC_ISSUING_POINT_ID, (Object)this.mId);
        if (isDeltaCRL) {
            sc.put((Object)SC_IS_DELTA_CRL, (Object)"true");
        } else {
            sc.put((Object)SC_IS_DELTA_CRL, (Object)"false");
        }
        CRLIssuingPointRecord crlRecord = null;
        logger.info("CRLIssuingPoint: Publishing " + this.mId);
        try {
            if (x509crl == null && (crlRecord = this.mCRLRepository.readCRLIssuingPointRecord(this.mId)) != null) {
                byte[] crl;
                byte[] byArray = crl = isDeltaCRL ? crlRecord.getDeltaCRL() : crlRecord.getCRL();
                if (crl != null) {
                    x509crl = new X509CRLImpl(crl);
                }
            }
            if (x509crl != null && this.mPublisherProcessor != null && this.mPublisherProcessor.isCRLPublishingEnabled()) {
                Enumeration<LdapRule> rules = this.mPublisherProcessor.getRules("crl");
                if (rules == null || !rules.hasMoreElements()) {
                    logger.debug("CRLIssuingPoint: CRL publishing is not enabled");
                } else if (this.mPublishDN != null) {
                    this.mPublisherProcessor.publishCRL(this.mPublishDN, (X509CRL)x509crl);
                    logger.debug("CRLIssuingPoint: CRL published to " + this.mPublishDN);
                } else {
                    this.mPublisherProcessor.publishCRL(x509crl, this.getId());
                    logger.debug("CRLIssuingPoint: CRL published");
                }
            }
        }
        catch (Exception e) {
            logger.error("CRLIssuingPoint: Could not publish " + this.mId + ": " + e.getMessage(), (Throwable)e);
            throw new EErrorPublishCRL(CMS.getUserMessage((String)"CMS_CA_ERROR_PUBLISH_CRL", (String[])new String[]{this.mId, e.toString()}));
        }
        finally {
            if (statsSub != null) {
                statsSub.endTiming("crl_publishing");
            }
        }
    }

    void setConfigParam(String name, String value) {
        this.mConfigStore.putString(name, value);
    }

    String getAuditSubjectID() {
        SessionContext context = SessionContext.getExistingContext();
        if (context == null) {
            return "$Unidentified$";
        }
        String subjectID = (String)context.get((Object)"userid");
        if (subjectID == null) {
            return Thread.currentThread() == this.mUpdateThread ? "$System$" : "$NonRoleUser$";
        }
        return subjectID.trim();
    }

    public static enum CRLIssuingPointStatus {
        NotInitialized,
        Initialized,
        InitializationFailed;

    }
}

