/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.ca;

import com.netscape.ca.CAService;
import com.netscape.ca.IServant;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.MetaInfo;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertRecordList;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.Request;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.Vector;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceCheckChallenge
implements IServant {
    public static Logger logger = LoggerFactory.getLogger(ServiceCheckChallenge.class);
    private MessageDigest mSHADigest = null;

    public ServiceCheckChallenge(CAService service) {
        try {
            this.mSHADigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn(CMS.getLogMessage((String)"OPERATION_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
    }

    @Override
    public boolean service(Request request) throws EBaseException {
        BigInteger serialno = request.getExtDataInBigInteger("serialNumber");
        String pwd = request.getExtDataInString("challengePhrase");
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository certDB = engine.getCertificateRepository();
        Object[] bigIntArray = null;
        if (serialno != null) {
            CertRecord record = null;
            try {
                record = certDB.readCertificateRecord(serialno);
            }
            catch (EBaseException ee) {
                logger.warn(ee.toString());
            }
            if (record != null) {
                String status = record.getStatus();
                if (status.equals("VALID")) {
                    boolean samepwd = this.compareChallengePassword(record, pwd);
                    if (samepwd) {
                        bigIntArray = new BigInteger[]{record.getSerialNumber()};
                    }
                } else {
                    bigIntArray = new BigInteger[]{};
                }
            } else {
                bigIntArray = new BigInteger[]{};
            }
        } else {
            String subjectName = request.getExtDataInString("subjectName");
            if (subjectName != null) {
                int size;
                String filter = "(&(x509cert.subject=" + subjectName + ")(certStatus=VALID))";
                CertRecordList list = certDB.findCertRecordsInList(filter, null, 10);
                Enumeration en = list.getCertRecords(0, (size = list.getSize()) - 1);
                if (!en.hasMoreElements()) {
                    bigIntArray = new BigInteger[]{};
                } else {
                    Vector<BigInteger> idv = new Vector<BigInteger>();
                    while (en.hasMoreElements()) {
                        CertRecord record = (CertRecord)en.nextElement();
                        boolean samepwd = this.compareChallengePassword(record, pwd);
                        if (!samepwd) continue;
                        BigInteger id = record.getSerialNumber();
                        idv.addElement(id);
                    }
                    bigIntArray = new BigInteger[idv.size()];
                    idv.copyInto(bigIntArray);
                }
            }
        }
        if (bigIntArray == null) {
            bigIntArray = new BigInteger[]{};
        }
        request.setExtData("serialNoArray", (BigInteger[])bigIntArray);
        return true;
    }

    private boolean compareChallengePassword(CertRecord record, String pwd) throws EBaseException {
        MetaInfo metaInfo = (MetaInfo)record.get("certMetaInfo");
        if (metaInfo == null) {
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTRIBUTE", (String[])new String[]{"metaInfo"}));
        }
        String hashpwd = this.hashPassword(pwd);
        String challengeString = (String)metaInfo.get("challengePhrase");
        return challengeString.equals(hashpwd);
    }

    private String hashPassword(String pwd) {
        String salt = "lala123";
        byte[] pwdDigest = this.mSHADigest.digest((salt + pwd).getBytes());
        String b64E = Utils.base64encode((byte[])pwdDigest, (boolean)true);
        return "{SHA-256}" + b64E;
    }
}

