/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.constraint;

import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.constraint.EnrollConstraint;
import com.netscape.cms.profile.def.BasicConstraintsExtDefault;
import com.netscape.cms.profile.def.NoDefault;
import com.netscape.cms.profile.def.PolicyDefault;
import com.netscape.cms.profile.def.UserExtensionDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.BasicConstraintsExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicConstraintsExtConstraint
extends EnrollConstraint {
    public static Logger logger = LoggerFactory.getLogger(BasicConstraintsExtConstraint.class);
    public static final String CONFIG_CRITICAL = "basicConstraintsCritical";
    public static final String CONFIG_IS_CA = "basicConstraintsIsCA";
    public static final String CONFIG_MIN_PATH_LEN = "basicConstraintsMinPathLen";
    public static final String CONFIG_MAX_PATH_LEN = "basicConstraintsMaxPathLen";

    public BasicConstraintsExtConstraint() {
        this.addConfigName(CONFIG_CRITICAL);
        this.addConfigName(CONFIG_IS_CA);
        this.addConfigName(CONFIG_MIN_PATH_LEN);
        this.addConfigName(CONFIG_MAX_PATH_LEN);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_CRITICAL)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_IS_CA)) {
            return new Descriptor("choice", "true,false,-", "-", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_IS_CA", (String[])new String[0]));
        }
        if (name.equals(CONFIG_MIN_PATH_LEN)) {
            return new Descriptor("integer", null, "-1", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_MIN_PATH_LEN", (String[])new String[0]));
        }
        if (name.equals(CONFIG_MAX_PATH_LEN)) {
            return new Descriptor("integer", null, "100", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_MAX_PATH_LEN", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void validate(Request request, X509CertInfo info) throws ERejectException {
        try {
            Integer extPathLen;
            int pathLen;
            Boolean extIsCA;
            boolean isCA;
            boolean critical;
            BasicConstraintsExtension ext = (BasicConstraintsExtension)this.getExtension(PKIXExtensions.BasicConstraints_Id.toString(), info);
            if (ext == null) {
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EXTENSION_NOT_FOUND", (String[])new String[]{PKIXExtensions.BasicConstraints_Id.toString()}));
            }
            String value = this.getConfig(CONFIG_CRITICAL);
            if (!this.isOptional(value) && (critical = this.getBoolean(value)) != ext.isCritical()) {
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CRITICAL_NOT_MATCHED", (String[])new String[0]));
            }
            value = this.getConfig(CONFIG_IS_CA);
            if (!this.isOptional(value) && (isCA = this.getBoolean(value)) != (extIsCA = (Boolean)ext.get("is_ca"))) {
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CONSTRAINT_BASIC_CONSTRAINTS_EXT_IS_CA", (String[])new String[0]));
            }
            value = this.getConfig(CONFIG_MIN_PATH_LEN);
            if (!this.isOptional(value) && (pathLen = this.getInt(value)) > (extPathLen = (Integer)ext.get("path_len"))) {
                logger.error("BasicCOnstraintsExtConstraint: pathLen=" + pathLen + " > extPathLen=" + extPathLen);
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CONSTRAINT_BASIC_CONSTRAINTS_EXT_MIN_PATH", (String[])new String[0]));
            }
            value = this.getConfig(CONFIG_MAX_PATH_LEN);
            if (!this.isOptional(value) && (pathLen = this.getInt(value)) < (extPathLen = (Integer)ext.get("path_len"))) {
                logger.error("BasicCOnstraintsExtConstraint: pathLen=" + pathLen + " < extPathLen=" + extPathLen);
                throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_CONSTRAINT_BASIC_CONSTRAINTS_EXT_MAX_PATH", (String[])new String[0]));
            }
        }
        catch (IOException e) {
            logger.error("BasicConstraintsExt: validate " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_EXTENSION_NOT_FOUND", (String[])new String[]{PKIXExtensions.BasicConstraints_Id.toString()}));
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig(CONFIG_CRITICAL), this.getConfig(CONFIG_IS_CA), this.getConfig(CONFIG_MIN_PATH_LEN), this.getConfig(CONFIG_MAX_PATH_LEN)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONSTRAINT_BASIC_CONSTRAINTS_EXT_TEXT", (String[])params);
    }

    @Override
    public boolean isApplicable(PolicyDefault def) {
        if (def instanceof NoDefault) {
            return true;
        }
        if (def instanceof BasicConstraintsExtDefault) {
            return true;
        }
        return def instanceof UserExtensionDefault;
    }

    @Override
    public void setConfig(String name, String value) throws EPropertyException {
        if (this.mConfig.getSubStore("params") == null) {
            logger.warn("BasicConstraintsExt: mConfig.getSubStore is null");
        } else {
            logger.debug("BasicConstraintsExt: setConfig name " + name + " value " + value);
            if (name.equals(CONFIG_MAX_PATH_LEN)) {
                String minPathLen = this.getConfig(CONFIG_MIN_PATH_LEN);
                int minLen = this.getInt(minPathLen);
                int maxLen = this.getInt(value);
                if (maxLen >= 0 && minLen >= maxLen) {
                    logger.error("BasicConstraintExt:  minPathLen >= maxPathLen!");
                    throw new EPropertyException("bad value");
                }
            }
            this.mConfig.getSubStore("params").putString(name, value);
        }
    }
}

