/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.GeneralName;
import org.mozilla.jss.netscape.security.x509.GeneralNameInterface;
import org.mozilla.jss.netscape.security.x509.GeneralNames;
import org.mozilla.jss.netscape.security.x509.IssuerAlternativeNameExtension;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssuerAltNameExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(IssuerAltNameExtDefault.class);
    public static final String CONFIG_CRITICAL = "issuerAltNameExtCritical";
    public static final String CONFIG_TYPE = "issuerAltExtType";
    public static final String CONFIG_PATTERN = "issuerAltExtPattern";
    public static final String VAL_CRITICAL = "issuerAltNameExtCritical";
    public static final String VAL_GENERAL_NAMES = "issuerAltNames";

    public IssuerAltNameExtDefault() {
        this.addValueName("issuerAltNameExtCritical");
        this.addValueName(VAL_GENERAL_NAMES);
        this.addConfigName("issuerAltNameExtCritical");
        this.addConfigName(CONFIG_TYPE);
        this.addConfigName(CONFIG_PATTERN);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("issuerAltNameExtCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(CONFIG_TYPE)) {
            return new Descriptor("choice", "RFC822Name,DNSName,DirectoryName,EDIPartyName,URIName,IPAddress,OIDName", "RFC822Name", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ISSUER_ALT_NAME_TYPE", (String[])new String[0]));
        }
        if (name.equals(CONFIG_PATTERN)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_ISSUER_ALT_NAME_PATTERN", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("issuerAltNameExtCritical")) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_GENERAL_NAMES)) {
            return new Descriptor("string_list", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_GENERAL_NAMES", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        try {
            IssuerAlternativeNameExtension ext = null;
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            ext = (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), info);
            if (ext == null) {
                try {
                    this.populate(null, info);
                }
                catch (EProfileException e) {
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            }
            if (name.equals("issuerAltNameExtCritical")) {
                ext = (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                boolean critical = Boolean.valueOf(value);
                ext.setCritical(critical);
            } else if (name.equals(VAL_GENERAL_NAMES)) {
                ext = (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return;
                }
                if (value.equals("")) {
                    this.deleteExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), info);
                    return;
                }
                GeneralNames gn = new GeneralNames();
                StringTokenizer st = new StringTokenizer(value, "\r\n");
                while (st.hasMoreTokens()) {
                    String gname = st.nextToken();
                    GeneralNameInterface n = this.parseGeneralName(gname);
                    if (n == null) continue;
                    if (!n.validSingle()) {
                        throw new EPropertyException("Not valid for Issuer Alternative Name: " + gname);
                    }
                    gn.addElement((Object)n);
                }
                ext.set("issuer_name", (Object)gn);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            this.replaceExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), (Extension)ext, info);
        }
        catch (Exception e) {
            logger.error("IssuerAltNameExtDefault: setValue " + e.getMessage(), (Throwable)e);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        try {
            if (name == null) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            IssuerAlternativeNameExtension ext = (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), info);
            if (ext == null) {
                try {
                    this.populate(null, info);
                }
                catch (EProfileException e) {
                    throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
                }
            }
            if (name.equals("issuerAltNameExtCritical")) {
                ext = (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return null;
                }
                return ext.isCritical() ? "true" : "false";
            }
            if (name.equals(VAL_GENERAL_NAMES)) {
                ext = (IssuerAlternativeNameExtension)this.getExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), info);
                if (ext == null) {
                    return "";
                }
                GeneralNames names = (GeneralNames)ext.get("issuer_name");
                StringBuffer sb = new StringBuffer();
                Enumeration e = names.elements();
                while (e.hasMoreElements()) {
                    GeneralName gn = (GeneralName)e.nextElement();
                    if (!sb.toString().equals("")) {
                        sb.append("\r\n");
                    }
                    sb.append(this.toGeneralNameString((GeneralNameInterface)gn));
                }
                return sb.toString();
            }
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        catch (IOException e) {
            logger.warn("IssuerAltNameExtDefault: getValue " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String getText(Locale locale) {
        String[] params = new String[]{this.getConfig("issuerAltNameExtCritical"), this.getConfig(CONFIG_PATTERN), this.getConfig(CONFIG_TYPE)};
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_ISSUER_ALT_NAME_EXT", (String[])params);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        IssuerAlternativeNameExtension ext = null;
        try {
            ext = this.createExtension(request);
        }
        catch (IOException e) {
            logger.warn("IssuerAltNameExtDefault: populate " + e.getMessage(), (Throwable)e);
        }
        this.addExtension(PKIXExtensions.IssuerAlternativeName_Id.toString(), (Extension)ext, info);
    }

    public IssuerAlternativeNameExtension createExtension(Request request) throws IOException, EProfileException {
        IssuerAlternativeNameExtension ext = null;
        try {
            ext = new IssuerAlternativeNameExtension();
        }
        catch (Exception e) {
            logger.warn("IssuerAltNameExtDefault: " + e.getMessage(), (Throwable)e);
            throw new IOException(e.toString());
        }
        boolean critical = Boolean.valueOf(this.getConfig("issuerAltNameExtCritical"));
        String pattern = this.getConfig(CONFIG_PATTERN);
        if (!pattern.equals("")) {
            String gtype;
            GeneralNameInterface n;
            GeneralNames gn = new GeneralNames();
            String gname = "";
            if (request != null) {
                gname = this.mapPattern(request, pattern);
            }
            if ((n = this.parseGeneralName((gtype = this.getConfig(CONFIG_TYPE)) + ":" + gname)) != null) {
                if (!n.validSingle()) {
                    throw new EProfileException("Not valid for Issuer Alternative Name: " + gtype + ":" + gname);
                }
                gn.addElement((Object)n);
            }
            ext.set("issuer_name", (Object)gn);
        }
        ext.setCritical(critical);
        return ext;
    }
}

