/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollExtDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateX509Key;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.KeyIdentifier;
import org.mozilla.jss.netscape.security.x509.PKIXExtensions;
import org.mozilla.jss.netscape.security.x509.SubjectKeyIdentifierExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectKeyIdentifierExtDefault
extends EnrollExtDefault {
    public static Logger logger = LoggerFactory.getLogger(SubjectKeyIdentifierExtDefault.class);
    public static final String CONFIG_CRITICAL = "critical";
    public static final String CONFIG_USE_SKI_IF_IN_REQUEST = "useSKIFromCertRequest";
    public static final String VAL_CRITICAL = "critical";
    public static final String VAL_KEY_ID = "keyid";
    public static final String CONFIG_MD = "messageDigest";
    public static final String VAL_MD = "messageDigest";
    public static final String DEF_CONFIG_MDS = "SHA-1,SHA-256,SHA-384,SHA-512";
    public static final String MD_LABEL = "Message digest";
    public static final String USE_SKI_LABEL = "Use SKI From Cert Request";
    public static final String VAL_USE_SKI_IF_IN_REQUEST = "useSKIFromCertRequest";

    public SubjectKeyIdentifierExtDefault() {
        logger.debug("SubjectKeyIdentifierExtDefault: adding config name. messageDigest");
        this.addConfigName("messageDigest");
        this.addConfigName("useSKIFromCertRequest");
        logger.debug("SubjectKeyIdentifierExtDefault: done adding config name. messageDigest");
        this.addValueName("critical");
        this.addValueName(VAL_KEY_ID);
        this.addValueName("messageDigest");
        this.addValueName("useSKIFromCertRequest");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("messageDigest")) {
            return new Descriptor("choice", DEF_CONFIG_MDS, "SHA-1", MD_LABEL);
        }
        if (name.equals("useSKIFromCertRequest")) {
            return new Descriptor("boolean", null, "false", USE_SKI_LABEL);
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("critical")) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CRITICAL", (String[])new String[0]));
        }
        if (name.equals(VAL_KEY_ID)) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_KEY_ID", (String[])new String[0]));
        }
        if (name.equals("messageDigest")) {
            return new Descriptor("string", "readonly", null, MD_LABEL);
        }
        if (name.equals("useSKIFromCertRequest")) {
            return new Descriptor("string", "readonly", null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_USE_SKI_IN_CSR", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (!name.equals("critical") && !name.equals(VAL_KEY_ID)) {
            if (name.equals("messageDigest")) {
                logger.debug("value: " + value);
            } else if (name.equals("useSKIFromCertRequest")) {
                logger.debug("value: " + value);
            } else {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        SubjectKeyIdentifierExtension ext = (SubjectKeyIdentifierExtension)this.getExtension(PKIXExtensions.SubjectKey_Id.toString(), info);
        if (ext == null) {
            try {
                this.populate(null, info);
            }
            catch (EProfileException e) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        if (name.equals("critical")) {
            ext = (SubjectKeyIdentifierExtension)this.getExtension(PKIXExtensions.SubjectKey_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            return ext.isCritical() ? "true" : "false";
        }
        if (name.equals(VAL_KEY_ID)) {
            ext = (SubjectKeyIdentifierExtension)this.getExtension(PKIXExtensions.SubjectKey_Id.toString(), info);
            if (ext == null) {
                return null;
            }
            KeyIdentifier kid = null;
            try {
                kid = (KeyIdentifier)ext.get("key_id");
            }
            catch (IOException e) {
                logger.error("SubjectKeyIdentifierExtDefault::getValue() key ID is null: " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
            return this.toHexString(kid.getIdentifier());
        }
        if (name.equals("messageDigest")) {
            String alg = this.getConfig("messageDigest");
            if (alg == null || alg.length() == 0) {
                alg = "SHA-1";
            }
            return alg;
        }
        if (name.equals("useSKIFromCertRequest")) {
            return this.getConfig("useSKIFromCertRequest", "false");
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SUBJECT_KEY_ID_EXT", (String[])new String[0]);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificateExtensions extensions = null;
        extensions = request.getExtDataInCertExts("req_extensions");
        SubjectKeyIdentifierExtension ext = this.createExtension(info, extensions);
        this.addExtension(PKIXExtensions.SubjectKey_Id.toString(), (Extension)ext, info);
    }

    public SubjectKeyIdentifierExtension createExtension(X509CertInfo info, CertificateExtensions extensions) {
        boolean useSKIFromRequest = Boolean.valueOf(this.getConfig("useSKIFromCertRequest", "false"));
        SubjectKeyIdentifierExtension keyIdExt = null;
        if (extensions != null && useSKIFromRequest) {
            try {
                keyIdExt = (SubjectKeyIdentifierExtension)extensions.get("SubjectKeyIdentifier");
            }
            catch (IOException e1) {
                keyIdExt = null;
            }
        }
        KeyIdentifier kid = null;
        if (keyIdExt != null) {
            try {
                kid = (KeyIdentifier)keyIdExt.get("key_id");
            }
            catch (IOException e) {
                kid = null;
            }
            if (kid == null) {
                kid = this.getKeyIdentifier(info);
            }
        } else {
            kid = this.getKeyIdentifier(info);
        }
        if (kid == null) {
            logger.error("SubjectKeyIdentifierExtDefault: KeyIdentifier not found");
            return null;
        }
        SubjectKeyIdentifierExtension ext = null;
        boolean critical = Boolean.valueOf(this.getConfig("critical"));
        try {
            ext = new SubjectKeyIdentifierExtension(critical, kid.getIdentifier());
        }
        catch (IOException e) {
            logger.warn("SubjectKeyIdentifierExtDefault: createExtension " + e.getMessage(), (Throwable)e);
        }
        return ext;
    }

    public KeyIdentifier getKeyIdentifier(X509CertInfo info) {
        String method = "SubjectKeyIdentifierExtDefault: getKeyIdentifier: ";
        try {
            String configHashAlg = this.getConfig("messageDigest");
            logger.debug(method + " configured hash alg: " + configHashAlg);
            CertificateX509Key infokey = (CertificateX509Key)info.get("key");
            X509Key key = (X509Key)infokey.get("value");
            byte[] hash = null;
            if (configHashAlg != null && configHashAlg.length() != 0) {
                logger.debug(method + " generating hash with alg: " + configHashAlg);
                hash = CryptoUtil.generateKeyIdentifier((byte[])key.getKey(), (String)configHashAlg);
            } else {
                logger.debug(method + " generating hash with default alg: SHA-1");
                hash = CryptoUtil.generateKeyIdentifier((byte[])key.getKey());
            }
            if (hash == null) {
                logger.error(method + "CryptoUtil.generateKeyIdentifier returns null");
                return null;
            }
            return new KeyIdentifier(hash);
        }
        catch (Exception e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

