/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.profile.ERejectException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubjectNameDefault
extends EnrollDefault {
    public static Logger logger = LoggerFactory.getLogger(SubjectNameDefault.class);
    public static final String CONFIG_NAME = "name";
    public static final String VAL_NAME = "name";

    public SubjectNameDefault() {
        this.addValueName("name");
        this.addConfigName("name");
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals("name")) {
            return new Descriptor("string", null, "CN=TEST", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals("name")) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals("name")) {
            X500Name x500name = null;
            try {
                x500name = new X500Name(value);
                if (x500name != null) {
                    logger.debug("SubjectNameDefault: setValue x500name=" + x500name.toString());
                }
            }
            catch (IOException e) {
                logger.warn("SubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
            }
            logger.debug("SubjectNameDefault: setValue name=" + x500name.toString());
            try {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
            catch (Exception e) {
                logger.error("SubjectNameDefault: setValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
        }
        if (name.equals("name")) {
            CertificateSubjectName sn = null;
            try {
                logger.debug("SubjectNameDefault: getValue info=" + info);
                sn = (CertificateSubjectName)info.get("subject");
                logger.debug("SubjectNameDefault: getValue name=" + sn);
                return sn.toString();
            }
            catch (Exception e) {
                logger.warn("SubjectNameDefault: getValue " + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)"CMS_INVALID_PROPERTY", (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_SUBJECT_NAME", (String[])new String[]{this.getConfig("name")});
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        X500Name name = null;
        String subjectName = null;
        try {
            subjectName = this.mapPattern(request, this.getConfig("name"));
        }
        catch (IOException e) {
            logger.warn("SubjectNameDefault: mapPattern " + e.getMessage(), (Throwable)e);
        }
        logger.debug("subjectName=" + subjectName);
        if (subjectName == null || subjectName.equals("")) {
            return;
        }
        try {
            name = new X500Name(subjectName);
            info.set("subject", (Object)new CertificateSubjectName(name));
        }
        catch (Exception e) {
            logger.error("SubjectNameDefault: failed to populate: " + e.getMessage(), (Throwable)e);
            throw new ERejectException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_INVALID_SUBJECT_NAME", (String[])new String[]{subjectName}), (Throwable)e);
        }
    }
}

