/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.profile.def;

import com.netscape.certsrv.profile.EProfileException;
import com.netscape.certsrv.property.Descriptor;
import com.netscape.certsrv.property.EPropertyException;
import com.netscape.certsrv.property.IDescriptor;
import com.netscape.cms.profile.def.EnrollDefault;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.util.Locale;
import org.mozilla.jss.netscape.security.x509.CertificateSubjectName;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserSubjectNameDefault
extends EnrollDefault {
    public static final Logger logger = LoggerFactory.getLogger(UserSubjectNameDefault.class);
    private static final String CMS_INVALID_PROPERTY = "CMS_INVALID_PROPERTY";
    public static final String VAL_NAME = "name";
    public static final String CONFIG_USE_SYS_ENCODING = "useSysEncoding";

    public UserSubjectNameDefault() {
        this.addConfigName(CONFIG_USE_SYS_ENCODING);
        this.addValueName(VAL_NAME);
    }

    @Override
    public IDescriptor getConfigDescriptor(Locale locale, String name) {
        if (name.equals(CONFIG_USE_SYS_ENCODING)) {
            return new Descriptor("boolean", null, "false", CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_CONFIG_USE_SYS_ENCODING", (String[])new String[0]));
        }
        return null;
    }

    @Override
    public IDescriptor getValueDescriptor(Locale locale, String name) {
        if (name.equals(VAL_NAME)) {
            return new Descriptor("string", null, null, CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_SUBJECT_NAME", (String[])new String[0]));
        }
        return null;
    }

    private X500Name getX500Name(X509CertInfo info, String value) {
        String method = "UserSubjectNameDefault: getX500Name: ";
        X500Name x500name = null;
        boolean useSysEncoding = this.getConfigBoolean(CONFIG_USE_SYS_ENCODING);
        logger.debug("{} use system encoding: {}", (Object)method, (Object)useSysEncoding);
        try {
            CertificateSubjectName oldName;
            if (value != null) {
                x500name = new X500Name(value);
            }
            if ((oldName = info.getSubjectObj()) == null) {
                logger.debug("{} subjectDN does not exist in CSR.", (Object)method);
            } else {
                logger.debug("{} subjectDN exists in CSR: {}", (Object)method, (Object)oldName);
            }
            if (!useSysEncoding && oldName != null) {
                X500Name oldX500name = oldName.getX500Name();
                if (x500name == null) {
                    logger.debug("{} new Subject DN is null; retaining current value: {}", (Object)method, (Object)oldX500name);
                    x500name = oldX500name;
                } else if (x500name.toString().equals(oldX500name.toString())) {
                    logger.debug("{} new Subject DN has same string representation as current value; retaining current value: {}", (Object)method, (Object)oldX500name);
                    x500name = oldX500name;
                } else {
                    logger.debug("{} replacing current value `{}` with new value `{}`", new Object[]{method, oldX500name, x500name});
                }
            }
        }
        catch (IOException e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
        logger.debug("{} subject: {}", (Object)method, (Object)x500name);
        return x500name;
    }

    @Override
    public void setValue(String name, Locale locale, X509CertInfo info, String value) throws EPropertyException {
        String method = "UserSubjectNameDefault: setValue: ";
        if (name == null) {
            logger.error("{} name = null", (Object)method);
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
        }
        logger.debug("{} name = {}", (Object)method, (Object)name);
        logger.debug("{} value = {}", (Object)method, (Object)value);
        if (name.equals(VAL_NAME)) {
            X500Name x500name = this.getX500Name(info, value);
            logger.debug("{} setting name={}", (Object)method, (Object)x500name);
            try {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
            catch (Exception e) {
                logger.error(method + e.getMessage(), (Throwable)e);
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
            }
        } else {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
        }
    }

    @Override
    public String getValue(String name, Locale locale, X509CertInfo info) throws EPropertyException {
        if (name == null) {
            throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
        }
        if (name.equals(VAL_NAME)) {
            CertificateSubjectName sn = null;
            try {
                sn = (CertificateSubjectName)info.get("subject");
                return sn.toString();
            }
            catch (Exception exception) {
                throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
            }
        }
        throw new EPropertyException(CMS.getUserMessage((Locale)locale, (String)CMS_INVALID_PROPERTY, (String[])new String[]{name}));
    }

    @Override
    public String getText(Locale locale) {
        return CMS.getUserMessage((Locale)locale, (String)"CMS_PROFILE_DEF_USER_SUBJECT_NAME", (String[])new String[0]);
    }

    @Override
    public void populate(Request request, X509CertInfo info) throws EProfileException {
        CertificateSubjectName reqSbj = request.getExtDataInCertSubjectName("req_subject_name");
        logger.info("UserSubjectNameDefault: Subject: {}", (Object)reqSbj);
        if (reqSbj == null) {
            logger.error("UserSubjectNameDefault: populate req_sbj is null");
            throw new EProfileException(CMS.getUserMessage((Locale)this.getLocale(request), (String)"CMS_PROFILE_SUBJECT_NAME_NOT_FOUND", (String[])new String[0]));
        }
        try {
            info.set("subject", (Object)reqSbj);
            X500Name x500name = this.getX500Name(info, reqSbj.toString());
            if (x500name != null) {
                info.set("subject", (Object)new CertificateSubjectName(x500name));
            }
        }
        catch (Exception e) {
            throw new EProfileException(e.toString());
        }
    }
}

