/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.cert;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authorization.EAuthzAccessDenied;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.CMSTemplate;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.request.RequestList;
import com.netscape.cmscore.request.RequestRecord;
import com.netscape.cmscore.request.RequestRepository;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.dogtagpki.server.ca.CAEngine;
import org.mozilla.jss.netscape.security.x509.X500Name;

@WebServlet(name="caMonitor", urlPatterns={"/agent/ca/monitor"}, initParams={@WebInitParam(name="GetClientCert", value="true"), @WebInitParam(name="AuthzMgr", value="BasicAclAuthz"), @WebInitParam(name="authority", value="ca"), @WebInitParam(name="interface", value="agent"), @WebInitParam(name="templatePath", value="/agent/ca/monitor.template"), @WebInitParam(name="ID", value="caMonitor"), @WebInitParam(name="resourceID", value="certServer.ca.systemstatus"), @WebInitParam(name="AuthMgr", value="certUserDBAuthMgr")})
public class Monitor
extends CMSServlet {
    private static final long serialVersionUID = -8492837942132357692L;
    private static final String TPL_FILE = "monitor.template";
    private CertificateRepository mCertDB;
    private RequestRepository requestRepository;
    private X500Name mAuthName = null;
    private String mFormPath = null;
    private int mTotalCerts = 0;
    private int mTotalReqs = 0;

    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        CAEngine engine = CAEngine.getInstance();
        this.mTemplates.remove(CMSRequest.SUCCESS);
        CertificateAuthority ca = engine.getCA();
        this.mCertDB = engine.getCertificateRepository();
        this.mAuthName = ca.getX500Name();
        this.requestRepository = engine.getRequestRepository();
        this.mFormPath = "/ca/monitor.template";
        if (this.mOutputTemplatePath != null) {
            this.mFormPath = this.mOutputTemplatePath;
        }
    }

    public void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest req = cmsReq.getHttpReq();
        HttpServletResponse resp = cmsReq.getHttpResp();
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "read");
        }
        catch (EAuthzAccessDenied e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(CMS.getLogMessage((String)"ADMIN_SRVLT_AUTH_FAILURE", (Object[])new Object[]{e.toString()}), (Throwable)e);
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        String startTime = null;
        String endTime = null;
        String interval = null;
        String numberOfIntervals = null;
        EBaseException error = null;
        ArgBlock header = new ArgBlock();
        ArgBlock ctx = new ArgBlock();
        CMSTemplateParams argSet = new CMSTemplateParams(header, ctx);
        CMSTemplate form = null;
        Locale[] locale = new Locale[1];
        try {
            form = this.getTemplate(this.mFormPath, req, locale);
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_GET_TEMPLATE", (Object[])new Object[]{this.mFormPath, e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
        try {
            startTime = req.getParameter("startTime");
            endTime = req.getParameter("endTime");
            interval = req.getParameter("interval");
            numberOfIntervals = req.getParameter("numberOfIntervals");
            this.process(argSet, header, startTime, endTime, interval, numberOfIntervals, locale[0]);
        }
        catch (EBaseException e) {
            logger.warn(CMS.getLogMessage((String)"CMSGW_ERR_PROCESSING_REQ", (Object[])new Object[]{e.toString()}), (Throwable)e);
            error = e;
        }
        try {
            ServletOutputStream out = resp.getOutputStream();
            if (error == null) {
                String xmlOutput = req.getParameter("xml");
                if (xmlOutput != null && xmlOutput.equals("true")) {
                    this.outputXML(resp, argSet);
                } else {
                    resp.setContentType("text/html");
                    form.renderOutput((OutputStream)out, argSet);
                    cmsReq.setStatus(CMSRequest.SUCCESS);
                }
            } else {
                cmsReq.setStatus(CMSRequest.ERROR);
                cmsReq.setError(error);
            }
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"CMSGW_ERR_STREAM_TEMPLATE", (Object[])new Object[]{e.toString()}), (Throwable)e);
            throw new ECMSGWException(CMS.getUserMessage((String)"CMS_GW_DISPLAY_TEMPLATE_ERROR", (String[])new String[0]), (Exception)e);
        }
    }

    private void process(CMSTemplateParams argSet, ArgBlock header, String startTime, String endTime, String interval, String numberOfIntervals, Locale locale) throws EBaseException {
        if (interval == null || interval.length() == 0) {
            header.addStringValue("error", "Invalid interval: " + interval);
            return;
        }
        if (numberOfIntervals == null || numberOfIntervals.length() == 0) {
            header.addStringValue("error", "Invalid number of intervals: " + numberOfIntervals);
            return;
        }
        Date startDate = this.StringToDate(startTime);
        if (startDate == null) {
            header.addStringValue("error", "Invalid start time: " + startTime);
            return;
        }
        int iInterval = 0;
        try {
            iInterval = Integer.parseInt(interval);
        }
        catch (NumberFormatException nfe) {
            header.addStringValue("error", "Invalid interval: " + interval);
            return;
        }
        int iNumberOfIntervals = 0;
        try {
            iNumberOfIntervals = Integer.parseInt(numberOfIntervals);
        }
        catch (NumberFormatException nfe) {
            header.addStringValue("error", "Invalid number of intervals: " + numberOfIntervals);
            return;
        }
        header.addStringValue("startDate", startDate.toString());
        header.addStringValue("startTime", startTime);
        header.addIntegerValue("interval", iInterval);
        header.addIntegerValue("numberOfIntervals", iNumberOfIntervals);
        this.mTotalCerts = 0;
        this.mTotalReqs = 0;
        Date d1 = startDate;
        for (int i = 0; i < iNumberOfIntervals; ++i) {
            ArgBlock rarg = new ArgBlock();
            Date d2 = this.nextDate(d1, iInterval - 1);
            String e = this.getIntervalInfo(rarg, d1, d2);
            if (e != null) {
                header.addStringValue("error", e);
                return;
            }
            argSet.addRepeatRecord(rarg);
            d1 = this.nextDate(d2, 1);
        }
        header.addIntegerValue("totalNumberOfCertificates", this.mTotalCerts);
        header.addIntegerValue("totalNumberOfRequests", this.mTotalReqs);
        if (this.mAuthName != null) {
            header.addStringValue("issuerName", this.mAuthName.toString());
        }
    }

    Date nextDate(Date d, int seconds) {
        return new Date(d.getTime() + (long)(seconds * 1000));
    }

    String getIntervalInfo(ArgBlock arg, Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return "Missing start or end date";
        }
        String startTime = this.DateToZString(startDate);
        String endTime = this.DateToZString(endDate);
        String filter = null;
        arg.addStringValue("startTime", startTime);
        arg.addStringValue("endTime", endTime);
        try {
            CertRecord rec;
            int count;
            if (this.mCertDB != null) {
                filter = this.Filter("certCreateTime", startTime, endTime);
                Enumeration<Object> e = this.mCertDB.findCertRecs(filter);
                count = 0;
                while (e != null && e.hasMoreElements()) {
                    rec = (CertRecord)e.nextElement();
                    if (rec == null) continue;
                    ++count;
                }
                arg.addIntegerValue("numberOfCertificates", count);
                this.mTotalCerts += count;
            }
            if (this.requestRepository != null) {
                filter = this.Filter("requestCreateTime", startTime, endTime);
                RequestList reqList = this.requestRepository.listRequestsByFilter(filter);
                count = 0;
                while (reqList != null && reqList.hasMoreElements()) {
                    rec = (RequestRecord)reqList.nextRequest();
                    if (rec == null) continue;
                    if (count == 0) {
                        arg.addStringValue("firstRequest", rec.getRequestId().toString());
                    }
                    ++count;
                }
                arg.addIntegerValue("numberOfRequests", count);
                this.mTotalReqs += count;
            }
        }
        catch (Exception ex) {
            return "Exception: " + ex;
        }
        return null;
    }

    Date StringToDate(String z) {
        Date d = null;
        if (z != null && (z.length() == 14 || z.length() == 15 && (z.charAt(14) == 'Z' || z.charAt(14) == 'z'))) {
            try {
                int year = Integer.parseInt(z.substring(0, 4));
                int month = Integer.parseInt(z.substring(4, 6)) - 1;
                int date = Integer.parseInt(z.substring(6, 8));
                int hour = Integer.parseInt(z.substring(8, 10));
                int minute = Integer.parseInt(z.substring(10, 12));
                int second = Integer.parseInt(z.substring(12, 14));
                Calendar calendar = Calendar.getInstance();
                calendar.set(year, month, date, hour, minute, second);
                d = calendar.getTime();
            }
            catch (NumberFormatException year) {}
        } else if (z != null && z.length() > 1 && z.charAt(0) == '-') {
            try {
                int i = Integer.parseInt(z);
                d = new Date();
                d = this.nextDate(d, i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return d;
    }

    String DateToZString(Date d) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(d);
        String time = "" + calendar.get(1);
        int i = calendar.get(2) + 1;
        if (i < 10) {
            time = time + "0";
        }
        time = time + i;
        i = calendar.get(5);
        if (i < 10) {
            time = time + "0";
        }
        time = time + i;
        i = calendar.get(11);
        if (i < 10) {
            time = time + "0";
        }
        time = time + i;
        i = calendar.get(12);
        if (i < 10) {
            time = time + "0";
        }
        time = time + i;
        i = calendar.get(13);
        if (i < 10) {
            time = time + "0";
        }
        time = time + i + "Z";
        return time;
    }

    String Filter(String name, String start, String end) {
        String filter = "(&(" + name + ">=" + start + ")(" + name + "<=" + end + "))";
        return filter;
    }

    String uriFilter(String name, String start, String end) {
        String filter = "(%26(" + name + "%3e%3d" + start + ")(" + name + "%3c%3d" + end + "))";
        return filter;
    }
}

