/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.authentication.ISharedToken;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.SessionContext;
import com.netscape.certsrv.logging.LogEvent;
import com.netscape.certsrv.logging.event.CertStatusChangeRequestProcessedEvent;
import com.netscape.certsrv.request.RequestId;
import com.netscape.certsrv.request.RequestStatus;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.authentication.AuthSubsystem;
import com.netscape.cmscore.dbs.CertRecord;
import com.netscape.cmscore.dbs.CertificateRepository;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.request.CertRequestRepository;
import com.netscape.cmscore.request.Request;
import com.netscape.cmscore.request.RequestQueue;
import com.netscape.cmscore.request.RequestRepository;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateExpiredException;
import java.util.Date;
import java.util.Hashtable;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthManager;
import org.dogtagpki.server.ca.CAEngine;
import org.dogtagpki.server.ca.CAEngineConfig;
import org.mozilla.jss.CryptoManager;
import org.mozilla.jss.asn1.ANY;
import org.mozilla.jss.asn1.ASN1Template;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.asn1.ENUMERATED;
import org.mozilla.jss.asn1.GeneralizedTime;
import org.mozilla.jss.asn1.INTEGER;
import org.mozilla.jss.asn1.InvalidBERException;
import org.mozilla.jss.asn1.OBJECT_IDENTIFIER;
import org.mozilla.jss.asn1.OCTET_STRING;
import org.mozilla.jss.asn1.SEQUENCE;
import org.mozilla.jss.asn1.SET;
import org.mozilla.jss.asn1.UTF8String;
import org.mozilla.jss.crypto.DigestAlgorithm;
import org.mozilla.jss.crypto.EncryptionAlgorithm;
import org.mozilla.jss.crypto.PrivateKey;
import org.mozilla.jss.crypto.SignatureAlgorithm;
import org.mozilla.jss.crypto.X509Certificate;
import org.mozilla.jss.netscape.security.util.Utils;
import org.mozilla.jss.netscape.security.x509.CRLExtensions;
import org.mozilla.jss.netscape.security.x509.CRLReasonExtension;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.Extension;
import org.mozilla.jss.netscape.security.x509.InvalidityDateExtension;
import org.mozilla.jss.netscape.security.x509.RevocationReason;
import org.mozilla.jss.netscape.security.x509.RevokedCertImpl;
import org.mozilla.jss.netscape.security.x509.X500Name;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.mozilla.jss.netscape.security.x509.X509Key;
import org.mozilla.jss.pkcs11.PK11PubKey;
import org.mozilla.jss.pkix.cert.Certificate;
import org.mozilla.jss.pkix.cert.CertificateInfo;
import org.mozilla.jss.pkix.cmc.CMCCertId;
import org.mozilla.jss.pkix.cmc.CMCStatusInfoV2;
import org.mozilla.jss.pkix.cmc.EncryptedPOP;
import org.mozilla.jss.pkix.cmc.GetCert;
import org.mozilla.jss.pkix.cmc.OtherInfo;
import org.mozilla.jss.pkix.cmc.OtherMsg;
import org.mozilla.jss.pkix.cmc.PendInfo;
import org.mozilla.jss.pkix.cmc.ResponseBody;
import org.mozilla.jss.pkix.cmc.RevokeRequest;
import org.mozilla.jss.pkix.cmc.TaggedAttribute;
import org.mozilla.jss.pkix.cmc.TaggedRequest;
import org.mozilla.jss.pkix.cms.ContentInfo;
import org.mozilla.jss.pkix.cms.EncapsulatedContentInfo;
import org.mozilla.jss.pkix.cms.EnvelopedData;
import org.mozilla.jss.pkix.cms.IssuerAndSerialNumber;
import org.mozilla.jss.pkix.cms.SignedData;
import org.mozilla.jss.pkix.cms.SignerIdentifier;
import org.mozilla.jss.pkix.cms.SignerInfo;
import org.mozilla.jss.pkix.primitive.AlgorithmIdentifier;
import org.mozilla.jss.pkix.primitive.Name;
import org.mozilla.jss.util.Password;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMCOutputTemplate {
    public static Logger logger = LoggerFactory.getLogger(CMCOutputTemplate.class);

    public void createFullResponseWithFailedStatus(HttpServletResponse resp, SEQUENCE bpids, int code, UTF8String s) {
        SEQUENCE controlSeq = new SEQUENCE();
        SEQUENCE cmsSeq = new SEQUENCE();
        SEQUENCE otherMsgSeq = new SEQUENCE();
        int bpid = 1;
        OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER((long)code), null, null);
        CMCStatusInfoV2 cmcStatusInfoV2 = new CMCStatusInfoV2(new INTEGER(2L), bpids, s, otherInfo);
        TaggedAttribute tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
        controlSeq.addElement((ASN1Value)tagattr);
        try {
            ResponseBody respBody = new ResponseBody(controlSeq, cmsSeq, otherMsgSeq);
            SET certs = new SET();
            ContentInfo contentInfo = this.getContentInfo(respBody, certs);
            if (contentInfo == null) {
                return;
            }
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            contentInfo.encode((OutputStream)fos);
            fos.close();
            byte[] contentBytes = fos.toByteArray();
            resp.setContentType("application/pkcs7-mime");
            resp.setContentLength(contentBytes.length);
            ServletOutputStream os = resp.getOutputStream();
            os.write(contentBytes);
            os.flush();
            this.auditCMCResponseSent(Utils.base64encode((byte[])contentBytes, (boolean)false));
        }
        catch (Exception e) {
            logger.warn("CMCOutputTemplate createFullResponseWithFailedStatus: " + e.getMessage(), (Throwable)e);
            return;
        }
    }

    public void createFullResponse(HttpServletResponse resp, Request[] reqs, String cert_request_type, int[] error_codes) {
        String method = "CMCOutputTemplate: createFullResponse: ";
        logger.debug(method + "begins with cert_request_type=" + cert_request_type);
        SEQUENCE controlSeq = new SEQUENCE();
        SEQUENCE cmsSeq = new SEQUENCE();
        SEQUENCE otherMsgSeq = new SEQUENCE();
        SessionContext context = SessionContext.getContext();
        int bpid = 1;
        SEQUENCE pending_bpids = null;
        SEQUENCE popRequired_bpids = null;
        SEQUENCE success_bpids = null;
        SEQUENCE failed_bpids = null;
        if (cert_request_type.equals("crmf") || cert_request_type.equals("pkcs10")) {
            String reqId = reqs[0].getRequestId().toString();
            OtherInfo otherInfo = null;
            if (error_codes[0] == 2) {
                PendInfo pendInfo = new PendInfo(reqId, new Date());
                otherInfo = new OtherInfo(OtherInfo.PEND, null, pendInfo, null);
            } else {
                otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(2L), null, null);
            }
            SEQUENCE bpids = new SEQUENCE();
            bpids.addElement((ASN1Value)new INTEGER(1L));
            CMCStatusInfoV2 cmcStatusInfoV2 = new CMCStatusInfoV2(3, bpids, (String)null, otherInfo);
            TaggedAttribute tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
            controlSeq.addElement((ASN1Value)tagattr);
        } else if (cert_request_type.equals("cmc")) {
            OtherInfo otherInfo;
            OtherInfo otherInfo2;
            SEQUENCE POPLinkWitnessBpids;
            SEQUENCE POPLinkWitnessV2Bpids;
            SEQUENCE identityBpids;
            SEQUENCE identityV2Bpids;
            SEQUENCE identificationBpids;
            logger.debug(method + " processing cmc");
            pending_bpids = new SEQUENCE();
            popRequired_bpids = new SEQUENCE();
            success_bpids = new SEQUENCE();
            failed_bpids = new SEQUENCE();
            EncryptedPOP encPop = null;
            if (reqs != null) {
                for (int i = 0; i < reqs.length; ++i) {
                    logger.debug(method + " error_codes[" + i + "]=" + error_codes[i]);
                    if (error_codes[i] == 0) {
                        success_bpids.addElement((ASN1Value)new INTEGER(reqs[i].getExtDataInBigInteger("bodyPartId")));
                        continue;
                    }
                    if (error_codes[i] == 2) {
                        pending_bpids.addElement((ASN1Value)new INTEGER(reqs[i].getExtDataInBigInteger("bodyPartId")));
                        continue;
                    }
                    if (error_codes[i] == 4) {
                        popRequired_bpids.addElement((ASN1Value)new INTEGER(reqs[i].getExtDataInBigInteger("bodyPartId")));
                        try {
                            encPop = this.constructEncryptedPop(reqs[i]);
                        }
                        catch (Exception e) {
                            logger.warn(method + e.getMessage(), (Throwable)e);
                            failed_bpids.addElement((ASN1Value)new INTEGER(reqs[i].getExtDataInBigInteger("bodyPartId")));
                        }
                        continue;
                    }
                    failed_bpids.addElement((ASN1Value)new INTEGER(reqs[i].getExtDataInBigInteger("bodyPartId")));
                }
            } else {
                logger.debug(method + " reqs null. could be revocation");
            }
            TaggedAttribute tagattr = null;
            CMCStatusInfoV2 cmcStatusInfoV2 = null;
            SEQUENCE decryptedPOPBpids = (SEQUENCE)context.get((Object)"decryptedPOP");
            if (decryptedPOPBpids != null && decryptedPOPBpids.size() > 0) {
                OtherInfo otherInfo3 = new OtherInfo(OtherInfo.FAIL, new INTEGER(9L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, decryptedPOPBpids, (String)null, otherInfo3);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if ((identificationBpids = (SEQUENCE)context.get((Object)"identification")) != null && identificationBpids.size() > 0) {
                OtherInfo otherInfo4 = new OtherInfo(OtherInfo.FAIL, new INTEGER(7L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, identificationBpids, (String)null, otherInfo4);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if ((identityV2Bpids = (SEQUENCE)context.get((Object)"identityProofV2")) != null && identityV2Bpids.size() > 0) {
                OtherInfo otherInfo5 = new OtherInfo(OtherInfo.FAIL, new INTEGER(7L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, identityV2Bpids, (String)null, otherInfo5);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if ((identityBpids = (SEQUENCE)context.get((Object)"identityProof")) != null && identityBpids.size() > 0) {
                OtherInfo otherInfo6 = new OtherInfo(OtherInfo.FAIL, new INTEGER(7L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, identityBpids, (String)null, otherInfo6);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if ((POPLinkWitnessV2Bpids = (SEQUENCE)context.get((Object)"POPLinkWitnessV2")) != null && POPLinkWitnessV2Bpids.size() > 0) {
                OtherInfo otherInfo7 = new OtherInfo(OtherInfo.FAIL, new INTEGER(2L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, POPLinkWitnessV2Bpids, (String)null, otherInfo7);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if ((POPLinkWitnessBpids = (SEQUENCE)context.get((Object)"POPLinkWitness")) != null && POPLinkWitnessBpids.size() > 0) {
                otherInfo2 = new OtherInfo(OtherInfo.FAIL, new INTEGER(2L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, POPLinkWitnessBpids, (String)null, otherInfo2);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if (popRequired_bpids.size() > 0) {
                if (encPop != null) {
                    logger.debug(method + "adding encPop");
                    tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_encryptedPOP, (ASN1Value)encPop);
                    controlSeq.addElement((ASN1Value)tagattr);
                    logger.debug(method + "encPop added");
                }
                otherInfo2 = new OtherInfo(OtherInfo.FAIL, new INTEGER(8L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(6, popRequired_bpids, (String)null, otherInfo2);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
                byte[] reqId = reqs[0].getRequestId().toBigInteger().toByteArray();
                TaggedAttribute reqIdTA = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_responseInfo, (ASN1Value)new OCTET_STRING(reqId));
                controlSeq.addElement((ASN1Value)reqIdTA);
            }
            if (pending_bpids.size() > 0) {
                String reqId = reqs[0].getRequestId().toString();
                PendInfo pendInfo = new PendInfo(reqId, new Date());
                otherInfo = new OtherInfo(OtherInfo.PEND, null, pendInfo, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(3, pending_bpids, (String)null, otherInfo);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            CAEngine engine = CAEngine.getInstance();
            CAEngineConfig cs = engine.getConfig();
            if (success_bpids.size() > 0) {
                String configName = "cmc.cert.confirmRequired";
                boolean confirmRequired = false;
                try {
                    confirmRequired = cs.getBoolean(configName, false);
                }
                catch (Exception e) {
                    logger.error("Unable to get " + configName + ": " + e.getMessage(), (Throwable)e);
                }
                logger.debug("CMCOutputTemplate: confirm required: " + confirmRequired);
                if (confirmRequired) {
                    logger.debug(method + " confirmRequired in the request");
                    cmcStatusInfoV2 = new CMCStatusInfoV2(5, success_bpids, (String)null, null);
                } else {
                    cmcStatusInfoV2 = new CMCStatusInfoV2(0, success_bpids, (String)null, null);
                }
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if (failed_bpids.size() > 0) {
                otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(2L), null, null);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)null, otherInfo);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
        }
        SET certs = new SET();
        try {
            Integer nums = (Integer)context.get((Object)"numOfControls");
            if (nums != null && nums > 0) {
                logger.debug(method + " processing controls");
                TaggedAttribute attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_getCert);
                if (attr != null) {
                    try {
                        this.processGetCertControl(attr, certs);
                    }
                    catch (EBaseException ee) {
                        logger.warn(method + ee.getMessage(), (Throwable)ee);
                        OtherInfo otherInfo1 = new OtherInfo(OtherInfo.FAIL, new INTEGER(4L), null, null);
                        SEQUENCE bpids1 = new SEQUENCE();
                        bpids1.addElement((ASN1Value)attr.getBodyPartID());
                        CMCStatusInfoV2 cmcStatusInfoV2 = new CMCStatusInfoV2(new INTEGER(2L), bpids1, null, otherInfo1);
                        TaggedAttribute tagattr1 = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                        controlSeq.addElement((ASN1Value)tagattr1);
                    }
                }
                if ((attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_dataReturn)) != null) {
                    bpid = this.processDataReturnControl(attr, controlSeq, bpid);
                }
                if ((attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_transactionId)) != null) {
                    bpid = this.processTransactionControl(attr, controlSeq, bpid);
                }
                if ((attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_senderNonce)) != null) {
                    bpid = this.processSenderNonceControl(attr, controlSeq, bpid);
                }
                if ((attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_QueryPending)) != null) {
                    bpid = this.processQueryPendingControl(attr, controlSeq, bpid);
                }
                if ((attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_idConfirmCertAcceptance)) != null) {
                    bpid = this.processConfirmCertAcceptanceControl(attr, controlSeq, bpid);
                }
                if ((attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_revokeRequest)) != null) {
                    bpid = this.processRevokeRequestControl(attr, controlSeq, bpid);
                }
            }
            if (success_bpids != null && success_bpids.size() > 0) {
                for (int i = 0; i < reqs.length; ++i) {
                    if (error_codes[i] != 0) continue;
                    X509CertImpl impl = reqs[i].getExtDataInCert("req_issued_cert");
                    byte[] bin = impl.getEncoded();
                    Certificate.Template certTemplate = new Certificate.Template();
                    Certificate cert = (Certificate)certTemplate.decode((InputStream)new ByteArrayInputStream(bin));
                    certs.addElement((ASN1Value)cert);
                }
            }
            ResponseBody respBody = new ResponseBody(controlSeq, cmsSeq, otherMsgSeq);
            logger.debug(method + " after new ResponseBody, respBody not null");
            ContentInfo contentInfo = this.getContentInfo(respBody, certs);
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            contentInfo.encode((OutputStream)fos);
            fos.close();
            byte[] contentBytes = fos.toByteArray();
            resp.setContentType("application/pkcs7-mime");
            resp.setContentLength(contentBytes.length);
            ServletOutputStream os = resp.getOutputStream();
            os.write(contentBytes);
            os.flush();
            this.auditCMCResponseSent(Utils.base64encode((byte[])contentBytes, (boolean)false));
            logger.debug(method + "ends");
        }
        catch (CertificateEncodingException e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
        catch (InvalidBERException e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.warn(method + e.getMessage(), (Throwable)e);
        }
    }

    public EncryptedPOP constructEncryptedPop(Request req) throws EBaseException {
        String method = "CMCOutputTemplate: constructEncryptedPop: ";
        Object msg = "";
        logger.debug(method + "begins");
        EncryptedPOP encPop = null;
        if (req == null) {
            msg = method + "method parameters cannot be null";
            logger.error((String)msg);
            throw new EBaseException((String)msg);
        }
        boolean popChallengeRequired = req.getExtDataInBoolean("cmc_POPchallengeRequired", false);
        if (!popChallengeRequired) {
            logger.debug(method + "popChallengeRequired false");
            return null;
        }
        logger.debug(method + "popChallengeRequired true");
        byte[] cmc_msg = req.getExtDataInByteArray("cert_request");
        byte[] pop_encryptedData = req.getExtDataInByteArray("pop_encryptedData");
        byte[] pop_sysPubEncryptedSession = req.getExtDataInByteArray("pop_sysPubEncryptedSession");
        byte[] pop_userPubEncryptedSession = req.getExtDataInByteArray("pop_userPubEncryptedSession");
        byte[] iv = req.getExtDataInByteArray("pop_encryptedDataIV");
        if (pop_encryptedData != null && pop_sysPubEncryptedSession != null && pop_userPubEncryptedSession != null) {
            try {
                EnvelopedData envData = CryptoUtil.createEnvelopedData((byte[])pop_encryptedData, (byte[])pop_userPubEncryptedSession);
                if (envData == null) {
                    msg = "envData null returned by createEnvelopedData";
                    throw new EBaseException(method + (String)msg);
                }
                ContentInfo ci = new ContentInfo(envData);
                logger.debug(method + "now we can compose encryptedPOP");
                TaggedRequest.Template tReqTemplate = new TaggedRequest.Template();
                TaggedRequest tReq = (TaggedRequest)tReqTemplate.decode((InputStream)new ByteArrayInputStream(cmc_msg));
                if (tReq == null) {
                    msg = "tReq null from tReqTemplate.decode";
                    logger.warn((String)msg);
                    throw new EBaseException(method + (String)msg);
                }
                OBJECT_IDENTIFIER oid = EncryptionAlgorithm.AES_128_CBC.toOID();
                AlgorithmIdentifier aid = new AlgorithmIdentifier(oid, (ASN1Value)new OCTET_STRING(iv));
                encPop = new EncryptedPOP(tReq, ci, aid, CryptoUtil.getDefaultHashAlg(), new OCTET_STRING(req.getExtDataInByteArray("pop_witness")));
            }
            catch (Exception e) {
                logger.error(method + " excepton:" + e.getMessage(), (Throwable)e);
                throw new EBaseException(method + " exception:" + e);
            }
        } else {
            msg = "popChallengeRequired, but one or more of the pop_ data not found in request";
            logger.error(method + (String)msg);
            throw new EBaseException(method + (String)msg);
        }
        return encPop;
    }

    private ContentInfo getContentInfo(ResponseBody respBody, SET certs) {
        String method = "CMCOutputTemplate: getContentInfo: ";
        logger.debug(method + "begins");
        CAEngine engine = CAEngine.getInstance();
        try {
            CertificateAuthority ca = engine.getCA();
            CertificateChain certchains = ca.getCACertChain();
            java.security.cert.X509Certificate[] chains = certchains.getChain();
            for (int i = 0; i < chains.length; ++i) {
                Certificate.Template certTemplate = new Certificate.Template();
                Certificate cert = (Certificate)certTemplate.decode((InputStream)new ByteArrayInputStream(chains[i].getEncoded()));
                certs.addElement((ASN1Value)cert);
            }
            EncapsulatedContentInfo enContentInfo = new EncapsulatedContentInfo(OBJECT_IDENTIFIER.id_cct_PKIResponse, (ASN1Value)respBody);
            X509Certificate x509CAcert = null;
            x509CAcert = ca.getCaX509Cert();
            X509CertImpl caimpl = new X509CertImpl(x509CAcert.getEncoded());
            X500Name issuerName = caimpl.getIssuerName();
            byte[] issuerByte = issuerName.getEncoded();
            ByteArrayInputStream istream = new ByteArrayInputStream(issuerByte);
            Name issuer = (Name)Name.getTemplate().decode((InputStream)istream);
            IssuerAndSerialNumber ias = new IssuerAndSerialNumber(issuer, new INTEGER(x509CAcert.getSerialNumber().toString()));
            SignerIdentifier si = new SignerIdentifier(SignerIdentifier.ISSUER_AND_SERIALNUMBER, ias, null);
            SignatureAlgorithm signAlg = ca.getDefaultSignatureAlgorithm();
            PrivateKey privKey = CryptoManager.getInstance().findPrivKeyByCert(x509CAcert);
            DigestAlgorithm digestAlg = signAlg.getDigestAlg();
            MessageDigest msgDigest = null;
            byte[] digest = null;
            msgDigest = MessageDigest.getInstance(digestAlg.toString());
            ByteArrayOutputStream ostream = new ByteArrayOutputStream();
            respBody.encode((OutputStream)ostream);
            digest = msgDigest.digest(ostream.toByteArray());
            SignerInfo signInfo = new SignerInfo(si, null, null, OBJECT_IDENTIFIER.id_cct_PKIResponse, digest, signAlg, privKey);
            SET signInfos = new SET();
            signInfos.addElement((ASN1Value)signInfo);
            SET digestAlgs = new SET();
            if (digestAlg != null) {
                AlgorithmIdentifier ai = new AlgorithmIdentifier(digestAlg.toOID(), null);
                digestAlgs.addElement((ASN1Value)ai);
            }
            SignedData signedData = new SignedData(digestAlgs, enContentInfo, certs, null, signInfos);
            ContentInfo contentInfo = new ContentInfo(signedData);
            logger.debug(method + " - done");
            return contentInfo;
        }
        catch (Exception e) {
            logger.warn(method + " Failed to create CMCContentInfo: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void createSimpleResponse(HttpServletResponse resp, Request[] reqs) {
        SET certs = new SET();
        SessionContext context = SessionContext.getContext();
        try {
            TaggedAttribute attr = (TaggedAttribute)context.get((Object)OBJECT_IDENTIFIER.id_cmc_getCert);
            this.processGetCertControl(attr, certs);
        }
        catch (Exception e) {
            logger.debug("CMCOutputTemplate: No certificate is found.");
        }
        SET digestAlgorithms = new SET();
        SET signedInfos = new SET();
        OBJECT_IDENTIFIER oid = new OBJECT_IDENTIFIER("1.2.840.113549.1.7.1");
        EncapsulatedContentInfo enContentInfo = new EncapsulatedContentInfo(oid, null);
        try {
            if (reqs != null) {
                for (int i = 0; i < reqs.length; ++i) {
                    X509CertImpl impl = reqs[i].getExtDataInCert("req_issued_cert");
                    byte[] bin = impl.getEncoded();
                    Certificate.Template certTemplate = new Certificate.Template();
                    Certificate cert = (Certificate)certTemplate.decode((InputStream)new ByteArrayInputStream(bin));
                    certs.addElement((ASN1Value)cert);
                }
                CAEngine engine = CAEngine.getInstance();
                CertificateAuthority ca = engine.getCA();
                CertificateChain certchains = ca.getCACertChain();
                java.security.cert.X509Certificate[] chains = certchains.getChain();
                for (int i = 0; i < chains.length; ++i) {
                    Certificate.Template certTemplate = new Certificate.Template();
                    Certificate cert = (Certificate)certTemplate.decode((InputStream)new ByteArrayInputStream(chains[i].getEncoded()));
                    certs.addElement((ASN1Value)cert);
                }
            }
            if (certs.size() == 0) {
                return;
            }
            SignedData signedData = new SignedData(digestAlgorithms, enContentInfo, certs, null, signedInfos);
            ContentInfo contentInfo = new ContentInfo(signedData);
            ByteArrayOutputStream fos = new ByteArrayOutputStream();
            contentInfo.encode((OutputStream)fos);
            fos.close();
            byte[] contentBytes = fos.toByteArray();
            resp.setContentType("application/pkcs7-mime");
            resp.setContentLength(contentBytes.length);
            ServletOutputStream os = resp.getOutputStream();
            os.write(contentBytes);
            os.flush();
            this.auditCMCResponseSent(Utils.base64encode((byte[])contentBytes, (boolean)false));
        }
        catch (CertificateEncodingException e) {
            logger.warn("CMCOutputTemplate exception: " + e.getMessage(), (Throwable)e);
        }
        catch (InvalidBERException e) {
            logger.warn("CMCOutputTemplate exception: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.warn("CMCOutputTemplate exception: " + e.getMessage(), (Throwable)e);
        }
    }

    private int processConfirmCertAcceptanceControl(TaggedAttribute attr, SEQUENCE controlSeq, int bpid) {
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository repository = engine.getCertificateRepository();
        if (attr != null) {
            INTEGER bodyId = attr.getBodyPartID();
            SEQUENCE seq = new SEQUENCE();
            seq.addElement((ASN1Value)bodyId);
            SET values = attr.getValues();
            if (values != null && values.size() > 0) {
                try {
                    CMCCertId cmcCertId = (CMCCertId)ASN1Util.decode((ASN1Template)CMCCertId.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)values.elementAt(0)));
                    INTEGER serialno = cmcCertId.getSerial();
                    SEQUENCE issuers = cmcCertId.getIssuer();
                    ANY issuer = (ANY)ASN1Util.decode((ASN1Template)ANY.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)issuers.elementAt(0)));
                    byte[] b = issuer.getEncoded();
                    X500Name n = new X500Name(b);
                    CertificateAuthority ca = engine.getCA();
                    X500Name caName = ca.getX500Name();
                    boolean confirmAccepted = false;
                    if (n.toString().equalsIgnoreCase(caName.toString())) {
                        logger.debug("CMCOutputTemplate: Issuer names are equal");
                        try {
                            repository.getX509Certificate((BigInteger)serialno);
                        }
                        catch (EBaseException ee) {
                            logger.warn("CMCOutputTemplate: Certificate in the confirm acceptance control was not found: " + ee.getMessage(), (Throwable)ee);
                        }
                    }
                    CMCStatusInfoV2 cmcStatusInfoV2 = null;
                    if (confirmAccepted) {
                        logger.debug("CMCOutputTemplate: Confirm Acceptance received. The certificate exists in the certificate repository.");
                        cmcStatusInfoV2 = new CMCStatusInfoV2(0, seq, (String)null, null);
                    } else {
                        logger.warn("CMCOutputTemplate: Confirm Acceptance received. The certificate does not exist in the certificate repository.");
                        OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(4L), null, null);
                        cmcStatusInfoV2 = new CMCStatusInfoV2(2, seq, (String)null, otherInfo);
                    }
                    TaggedAttribute statustagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                    controlSeq.addElement((ASN1Value)statustagattr);
                }
                catch (Exception e) {
                    logger.warn("CMCOutputTemplate exception: " + e.getMessage(), (Throwable)e);
                }
            }
        }
        return bpid;
    }

    private void processGetCertControl(TaggedAttribute attr, SET certs) throws InvalidBERException, CertificateEncodingException, IOException, EBaseException {
        SET vals;
        CAEngine engine = CAEngine.getInstance();
        CertificateRepository repository = engine.getCertificateRepository();
        if (attr != null && (vals = attr.getValues()).size() == 1) {
            GetCert getCert = (GetCert)ASN1Util.decode((ASN1Template)GetCert.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
            INTEGER serialno = getCert.getSerialNumber();
            ANY issuer = getCert.getIssuer();
            byte[] b = issuer.getEncoded();
            X500Name n = new X500Name(b);
            CertificateAuthority ca = engine.getCA();
            X500Name caName = ca.getX500Name();
            if (!n.toString().equalsIgnoreCase(caName.toString())) {
                logger.error("CMCOutputTemplate: Issuer names are equal in the GetCert Control");
                throw new EBaseException("Certificate is not found");
            }
            X509CertImpl impl = repository.getX509Certificate((BigInteger)serialno);
            byte[] bin = impl.getEncoded();
            Certificate.Template certTemplate = new Certificate.Template();
            Certificate cert = (Certificate)certTemplate.decode((InputStream)new ByteArrayInputStream(bin));
            certs.addElement((ASN1Value)cert);
        }
    }

    private int processQueryPendingControl(TaggedAttribute attr, SEQUENCE controlSeq, int bpid) {
        SET values;
        CAEngine engine = CAEngine.getInstance();
        RequestRepository requestRepository = engine.getRequestRepository();
        if (attr != null && (values = attr.getValues()) != null && values.size() > 0) {
            TaggedAttribute tagattr;
            SEQUENCE pending_bpids = new SEQUENCE();
            SEQUENCE success_bpids = new SEQUENCE();
            SEQUENCE failed_bpids = new SEQUENCE();
            for (int i = 0; i < values.size(); ++i) {
                try {
                    INTEGER reqId = (INTEGER)ASN1Util.decode((ASN1Template)INTEGER.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)values.elementAt(i)));
                    String requestId = new String(reqId.toByteArray());
                    Request r = requestRepository.readRequest(new RequestId(requestId));
                    if (r == null) continue;
                    RequestStatus status = r.getRequestStatus();
                    if (status.equals((Object)RequestStatus.PENDING)) {
                        pending_bpids.addElement((ASN1Value)reqId);
                        continue;
                    }
                    if (status.equals((Object)RequestStatus.APPROVED)) {
                        success_bpids.addElement((ASN1Value)reqId);
                        continue;
                    }
                    if (!status.equals((Object)RequestStatus.REJECTED)) continue;
                    failed_bpids.addElement((ASN1Value)reqId);
                    continue;
                }
                catch (Exception reqId) {
                    // empty catch block
                }
            }
            if (pending_bpids.size() > 0) {
                CMCStatusInfoV2 cmcStatusInfoV2 = new CMCStatusInfoV2(3, pending_bpids, (String)null, null);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if (success_bpids.size() > 0) {
                CMCStatusInfoV2 cmcStatusInfoV2 = new CMCStatusInfoV2(0, pending_bpids, (String)null, null);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
            if (failed_bpids.size() > 0) {
                CMCStatusInfoV2 cmcStatusInfoV2 = new CMCStatusInfoV2(2, pending_bpids, (String)null, null);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
            }
        }
        return bpid;
    }

    private int processTransactionControl(TaggedAttribute attr, SEQUENCE controlSeq, int bpid) {
        SET transIds;
        if (attr != null && (transIds = attr.getValues()) != null) {
            TaggedAttribute tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_transactionId, transIds);
            controlSeq.addElement((ASN1Value)tagattr);
        }
        return bpid;
    }

    private int processSenderNonceControl(TaggedAttribute attr, SEQUENCE controlSeq, int bpid) {
        SET sNonce;
        if (attr != null && (sNonce = attr.getValues()) != null) {
            byte[] dig;
            TaggedAttribute tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_recipientNonce, sNonce);
            controlSeq.addElement((ASN1Value)tagattr);
            Date date = new Date();
            String salt = "lala123" + date.toString();
            try {
                MessageDigest SHA2Digest = MessageDigest.getInstance("SHA256");
                dig = SHA2Digest.digest(salt.getBytes());
            }
            catch (NoSuchAlgorithmException ex) {
                dig = salt.getBytes();
            }
            String b64E = Utils.base64encode((byte[])dig, (boolean)true);
            tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_senderNonce, (ASN1Value)new OCTET_STRING(b64E.getBytes()));
            controlSeq.addElement((ASN1Value)tagattr);
        }
        return bpid;
    }

    private int processDataReturnControl(TaggedAttribute attr, SEQUENCE controlSeq, int bpid) throws InvalidBERException {
        SET vals;
        if (attr != null && (vals = attr.getValues()).size() > 0) {
            OCTET_STRING str = (OCTET_STRING)ASN1Util.decode((ASN1Template)OCTET_STRING.getTemplate(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
            TaggedAttribute tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_dataReturn, (ASN1Value)str);
            controlSeq.addElement((ASN1Value)tagattr);
        }
        return bpid;
    }

    private int processRevokeRequestControl(TaggedAttribute attr, SEQUENCE controlSeq, int bpid) throws InvalidBERException, EBaseException, IOException {
        String method = "CMCOutputTemplate: processRevokeRequestControl: ";
        Object msg = "";
        logger.debug(method + "begins");
        CAEngine engine = CAEngine.getInstance();
        CAEngineConfig cs = engine.getConfig();
        CertificateRepository repository = engine.getCertificateRepository();
        boolean revoke = false;
        SessionContext context = SessionContext.getContext();
        String authManagerId = (String)context.get((Object)"authManagerId");
        if (authManagerId == null) {
            logger.debug(method + "authManagerId null.????");
            authManagerId = "none";
        } else {
            logger.debug(method + "authManagerId =" + authManagerId);
        }
        Auditor auditor = engine.getAuditor();
        String auditRequesterID = null;
        auditRequesterID = (String)context.get((Object)"userid");
        auditRequesterID = auditRequesterID != null ? auditRequesterID.trim() : "$NonRoleUser$";
        X500Name reqSignerPrincipal = (X500Name)context.get((Object)"cmcSignerPrincipal");
        X500Name reqIssuerPrincipal = (X500Name)context.get((Object)"cmcISSUERPrincipal");
        String auditSubjectID = null;
        String auditRequestType = "revoke";
        String auditSerialNumber = null;
        String auditReasonNum = null;
        RequestStatus auditApprovalStatus = RequestStatus.REJECTED;
        String auditReqID = null;
        if (attr != null) {
            INTEGER attrbpid = attr.getBodyPartID();
            CMCStatusInfoV2 cmcStatusInfoV2 = null;
            SET vals = attr.getValues();
            if (vals.size() > 0) {
                RevokeRequest revRequest = (RevokeRequest)ASN1Util.decode((ASN1Template)new RevokeRequest.Template(), (byte[])ASN1Util.encode((ASN1Value)vals.elementAt(0)));
                OCTET_STRING reqSecret = revRequest.getSharedSecret();
                INTEGER pid = attr.getBodyPartID();
                TaggedAttribute tagattr = null;
                INTEGER revokeCertSerial = revRequest.getSerialNumber();
                ENUMERATED n = revRequest.getReason();
                RevocationReason reason = this.toRevocationReason(n);
                auditReasonNum = reason.toString();
                BigInteger revokeSerial = new BigInteger(revokeCertSerial.toByteArray());
                auditSerialNumber = revokeSerial.toString();
                if (reqSecret == null) {
                    logger.debug(method + "no shared secret in request; Checking signature;");
                    configName = "cmc.revokeCert.verify";
                    boolean needVerify = true;
                    try {
                        needVerify = cs.getBoolean(configName, true);
                    }
                    catch (Exception e) {
                        logger.error("Unable to get " + configName + ": " + e.getMessage(), (Throwable)e);
                    }
                    logger.debug("CMCOutputTemplate: need verify: " + needVerify);
                    if (needVerify) {
                        if (authManagerId.equals("CMCUserSignedAuth")) {
                            if (reqSignerPrincipal == null) {
                                logger.warn(method + "missing CMC signer principal");
                                OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(1L), null, null);
                                SEQUENCE failed_bpids = new SEQUENCE();
                                failed_bpids.addElement((ASN1Value)attrbpid);
                                cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)null, otherInfo);
                                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                                controlSeq.addElement((ASN1Value)tagattr);
                                return bpid;
                            }
                        } else {
                            Integer num1 = (Integer)context.get((Object)"numOfOtherMsgs");
                            logger.debug(method + "found numOfOtherMsgs =" + num1.toString());
                            int num = num1;
                            for (int i = 0; i < num; ++i) {
                                OtherMsg data = (OtherMsg)context.get((Object)("otherMsg" + i));
                                INTEGER dpid = data.getBodyPartID();
                                if (pid.longValue() == dpid.longValue()) {
                                    logger.debug(method + "body part id match;");
                                    ANY msgValue = data.getOtherMsgValue();
                                    SignedData msgData = (SignedData)msgValue.decodeWith((ASN1Template)SignedData.getTemplate());
                                    if (this.verifyRevRequestSignature(msgData)) continue;
                                    OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(1L), null, null);
                                    SEQUENCE failed_bpids = new SEQUENCE();
                                    failed_bpids.addElement((ASN1Value)attrbpid);
                                    cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)null, otherInfo);
                                    tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                                    controlSeq.addElement((ASN1Value)tagattr);
                                    return bpid;
                                }
                                logger.warn(method + "body part id do not match;");
                            }
                        }
                    }
                    revoke = true;
                } else {
                    logger.debug(method + "checking shared secret");
                    configName = "SharedToken";
                    AuthSubsystem authSS = engine.getAuthSubsystem();
                    AuthManager sharedTokenAuth = authSS.getAuthManager(configName);
                    if (sharedTokenAuth == null) {
                        logger.warn(method + " Failed to retrieve shared secret authentication plugin class");
                        OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(11L), null, null);
                        SEQUENCE failed_bpids = new SEQUENCE();
                        failed_bpids.addElement((ASN1Value)attrbpid);
                        cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)null, otherInfo);
                        tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                        controlSeq.addElement((ASN1Value)tagattr);
                        return bpid;
                    }
                    ISharedToken tokenClass = (ISharedToken)sharedTokenAuth;
                    char[] sharedSecret = null;
                    try {
                        sharedSecret = tokenClass.getSharedToken(revokeSerial);
                    }
                    catch (Exception eShrTok) {
                        msg = "CMCOutputTemplate: " + eShrTok.toString();
                    }
                    if (sharedSecret == null) {
                        if (((String)msg).equals("")) {
                            msg = " shared secret not found";
                        }
                        logger.warn((String)msg);
                        auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus, (String)msg));
                        OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(7L), null, null);
                        SEQUENCE failed_bpids = new SEQUENCE();
                        failed_bpids.addElement((ASN1Value)attrbpid);
                        cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)null, otherInfo);
                        tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                        controlSeq.addElement((ASN1Value)tagattr);
                        return bpid;
                    }
                    byte[] reqSecretb = reqSecret.toByteArray();
                    char[] reqSecretbChars = CryptoUtil.bytesToChars((byte[])reqSecretb);
                    Password secret1 = new Password(sharedSecret);
                    Password secret2 = new Password(reqSecretbChars);
                    CryptoUtil.obscureChars((char[])sharedSecret);
                    CryptoUtil.obscureChars((char[])reqSecretbChars);
                    CryptoUtil.obscureBytes((byte[])reqSecretb, (String)"random");
                    if (secret1.equals((Object)secret2)) {
                        logger.debug(method + " Client and server shared secret are the same, can go ahead and revoke certificate.");
                        revoke = true;
                        secret1.clear();
                        secret2.clear();
                    } else {
                        msg = " Client and server shared secret are not the same, cannot revoke certificate.";
                        logger.warn(method + (String)msg);
                        OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(7L), null, null);
                        SEQUENCE failed_bpids = new SEQUENCE();
                        failed_bpids.addElement((ASN1Value)attrbpid);
                        cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)null, otherInfo);
                        tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                        controlSeq.addElement((ASN1Value)tagattr);
                        auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus, (String)msg));
                        secret1.clear();
                        secret2.clear();
                        return bpid;
                    }
                }
                if (revoke) {
                    SEQUENCE failed_bpids;
                    OtherInfo otherInfo;
                    CertificateAuthority ca = engine.getCA();
                    CertRecord record = null;
                    try {
                        record = repository.readCertificateRecord(revokeSerial);
                    }
                    catch (EBaseException ee) {
                        logger.warn(method + "Exception: " + ee.getMessage(), (Throwable)ee);
                    }
                    if (record == null) {
                        msg = " The certificate is not found";
                        logger.warn(method + (String)msg);
                        auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus, (String)msg));
                        OtherInfo otherInfo2 = new OtherInfo(OtherInfo.FAIL, new INTEGER(4L), null, null);
                        SEQUENCE failed_bpids2 = new SEQUENCE();
                        failed_bpids2.addElement((ASN1Value)attrbpid);
                        cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids2, (String)null, otherInfo2);
                        tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                        controlSeq.addElement((ASN1Value)tagattr);
                        return bpid;
                    }
                    if (record.getStatus().equals("REVOKED")) {
                        msg = " The certificate is already revoked:" + auditSerialNumber;
                        logger.warn(method + (String)msg);
                        auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus, (String)msg));
                        SEQUENCE success_bpids = new SEQUENCE();
                        success_bpids.addElement((ASN1Value)attrbpid);
                        cmcStatusInfoV2 = new CMCStatusInfoV2(0, success_bpids, (String)null, null);
                        tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                        controlSeq.addElement((ASN1Value)tagattr);
                        return bpid;
                    }
                    X509CertImpl impl = record.getCertificate();
                    X500Name certPrincipal = impl.getSubjectName();
                    X500Name certIssuerPrincipal = impl.getIssuerName();
                    auditSubjectID = certPrincipal.toString();
                    if (reqSecret != null) {
                        logger.debug(method + "shared secret revocation: checking issuer DN");
                        if (reqIssuerPrincipal == null || !reqIssuerPrincipal.equals((Object)certIssuerPrincipal)) {
                            msg = " certificate issuer DN and revocation request issuer DN do not match";
                            logger.warn(method + (String)msg);
                            otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(7L), null, null);
                            failed_bpids = new SEQUENCE();
                            failed_bpids.addElement((ASN1Value)attrbpid);
                            cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)msg, otherInfo);
                            tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                            controlSeq.addElement((ASN1Value)tagattr);
                            auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus, (String)msg));
                            return bpid;
                        }
                        logger.debug(method + "certificate issuer DN and revocation request issuer DN match");
                    }
                    if (reqSecret == null && authManagerId.equals("CMCUserSignedAuth")) {
                        if (certPrincipal.equals((Object)reqSignerPrincipal)) {
                            logger.debug(method + "certificate principal and signer match");
                        } else {
                            msg = " certificate principal and signer do not match";
                            logger.warn(method + (String)msg);
                            otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(7L), null, null);
                            failed_bpids = new SEQUENCE();
                            failed_bpids.addElement((ASN1Value)attrbpid);
                            cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)msg, otherInfo);
                            tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                            controlSeq.addElement((ASN1Value)tagattr);
                            auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus, (String)msg));
                            return bpid;
                        }
                    }
                    X509CertImpl[] impls = new X509CertImpl[]{impl};
                    CRLReasonExtension crlReasonExtn = new CRLReasonExtension(reason);
                    CRLExtensions entryExtn = new CRLExtensions();
                    GeneralizedTime t = revRequest.getInvalidityDate();
                    InvalidityDateExtension invalidityDateExtn = null;
                    if (t != null) {
                        invalidityDateExtn = new InvalidityDateExtension(t.toDate());
                        entryExtn.set(invalidityDateExtn.getName(), (Extension)invalidityDateExtn);
                    }
                    if (crlReasonExtn != null) {
                        entryExtn.set(crlReasonExtn.getName(), (Extension)crlReasonExtn);
                    }
                    RevokedCertImpl revCertImpl = new RevokedCertImpl(impl.getSerialNumber(), new Date(), entryExtn);
                    RevokedCertImpl[] revCertImpls = new RevokedCertImpl[]{revCertImpl};
                    CertRequestRepository requestRepository = engine.getCertRequestRepository();
                    Request revReq = requestRepository.createRequest("revocation");
                    auditReqID = revReq.getRequestId().toString();
                    revReq.setExtData("CERT_INFO", revCertImpls);
                    revReq.setExtData("revocationReason", Integer.valueOf(reason.getCode()));
                    UTF8String utfstr = revRequest.getComment();
                    if (utfstr != null) {
                        revReq.setExtData("csrRequestorComments", utfstr.toString());
                    }
                    revReq.setExtData("requestorType", "Agent");
                    RequestQueue queue = engine.getRequestQueue();
                    queue.processRequest(revReq);
                    RequestStatus stat = revReq.getRequestStatus();
                    if (stat == RequestStatus.COMPLETE) {
                        Integer result = revReq.getExtDataInInteger("Result");
                        logger.debug(method + " revReq result = " + result);
                        if (result.equals(Request.RES_ERROR)) {
                            msg = " revReq exception: " + revReq.getExtDataInString("Error");
                            logger.warn(method + (String)msg);
                            OtherInfo otherInfo3 = new OtherInfo(OtherInfo.FAIL, new INTEGER(2L), null, null);
                            SEQUENCE failed_bpids3 = new SEQUENCE();
                            failed_bpids3.addElement((ASN1Value)attrbpid);
                            cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids3, (String)null, otherInfo3);
                            tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                            controlSeq.addElement((ASN1Value)tagattr);
                            auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus, (String)msg));
                            return bpid;
                        }
                    }
                    String initiative = "fromUser";
                    logger.info("Revocation request reqID {} {} is {}. DN requested: {} serial number: 0x{} revocation reason: {}", new Object[]{revReq.getRequestId(), initiative, "completed", impl.getSubjectName(), impl.getSerialNumber().toString(16), reason});
                    logger.debug(method + " Certificate revoked.");
                    SEQUENCE success_bpids = new SEQUENCE();
                    success_bpids.addElement((ASN1Value)attrbpid);
                    cmcStatusInfoV2 = new CMCStatusInfoV2(0, success_bpids, (String)null, null);
                    tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                    controlSeq.addElement((ASN1Value)tagattr);
                    auditApprovalStatus = RequestStatus.COMPLETE;
                    auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Success", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
                    return bpid;
                }
                OtherInfo otherInfo = new OtherInfo(OtherInfo.FAIL, new INTEGER(11L), null, null);
                SEQUENCE failed_bpids = new SEQUENCE();
                failed_bpids.addElement((ASN1Value)attrbpid);
                cmcStatusInfoV2 = new CMCStatusInfoV2(2, failed_bpids, (String)null, otherInfo);
                tagattr = new TaggedAttribute(new INTEGER((long)bpid++), OBJECT_IDENTIFIER.id_cmc_statusInfoV2, (ASN1Value)cmcStatusInfoV2);
                controlSeq.addElement((ASN1Value)tagattr);
                auditor.log((LogEvent)new CertStatusChangeRequestProcessedEvent(auditSubjectID, "Failure", auditReqID, auditSerialNumber, auditRequestType, auditReasonNum, auditApprovalStatus));
                return bpid;
            }
        }
        return bpid;
    }

    protected void auditCMCResponseSent(String response) {
        CAEngine engine = CAEngine.getInstance();
        Auditor auditor = engine.getAuditor();
        SessionContext context = SessionContext.getContext();
        String auditMessage = CMS.getLogMessage((String)"LOGGING_SIGNED_AUDIT_CMC_RESPONSE_SENT_3", (Object[])new Object[]{context.get((Object)"userid"), "Success", Utils.normalizeString((String)response)});
        auditor.log(auditMessage);
    }

    private RevocationReason toRevocationReason(ENUMERATED n) {
        long code = n.getValue();
        if (code == RevokeRequest.aACompromise.getValue()) {
            return RevocationReason.UNSPECIFIED;
        }
        if (code == RevokeRequest.affiliationChanged.getValue()) {
            return RevocationReason.AFFILIATION_CHANGED;
        }
        if (code == RevokeRequest.cACompromise.getValue()) {
            return RevocationReason.CA_COMPROMISE;
        }
        if (code == RevokeRequest.certificateHold.getValue()) {
            return RevocationReason.CERTIFICATE_HOLD;
        }
        if (code == RevokeRequest.cessationOfOperation.getValue()) {
            return RevocationReason.CESSATION_OF_OPERATION;
        }
        if (code == RevokeRequest.keyCompromise.getValue()) {
            return RevocationReason.KEY_COMPROMISE;
        }
        if (code == RevokeRequest.privilegeWithdrawn.getValue()) {
            return RevocationReason.UNSPECIFIED;
        }
        if (code == RevokeRequest.removeFromCRL.getValue()) {
            return RevocationReason.REMOVE_FROM_CRL;
        }
        if (code == RevokeRequest.superseded.getValue()) {
            return RevocationReason.SUPERSEDED;
        }
        if (code == RevokeRequest.unspecified.getValue()) {
            return RevocationReason.UNSPECIFIED;
        }
        return RevocationReason.UNSPECIFIED;
    }

    private boolean verifyRevRequestSignature(SignedData msgData) {
        String method = "CMCOutputTemplate: verifyRevRequestSignature: ";
        logger.debug(method + "begins");
        try {
            EncapsulatedContentInfo ci = msgData.getContentInfo();
            OCTET_STRING content = ci.getContent();
            ByteArrayInputStream s = new ByteArrayInputStream(content.toByteArray());
            TaggedAttribute tattr = (TaggedAttribute)new TaggedAttribute.Template().decode((InputStream)s);
            SET values = tattr.getValues();
            RevokeRequest revRequest = null;
            if (values == null || values.size() <= 0) {
                logger.warn(method + "attribute null");
                return false;
            }
            revRequest = (RevokeRequest)ASN1Util.decode((ASN1Template)new RevokeRequest.Template(), (byte[])ASN1Util.encode((ASN1Value)values.elementAt(0)));
            SET dias = msgData.getDigestAlgorithmIdentifiers();
            int numDig = dias.size();
            Hashtable<String, byte[]> digs = new Hashtable<String, byte[]>();
            for (int i = 0; i < numDig; ++i) {
                AlgorithmIdentifier dai = (AlgorithmIdentifier)dias.elementAt(i);
                String name = DigestAlgorithm.fromOID((OBJECT_IDENTIFIER)dai.getOID()).toString();
                MessageDigest md = MessageDigest.getInstance(name);
                byte[] digest = md.digest(content.toByteArray());
                digs.put(name, digest);
            }
            SET sis = msgData.getSignerInfos();
            int numSis = sis.size();
            for (int i = 0; i < numSis; ++i) {
                SignerIdentifier sid;
                SignerInfo si = (SignerInfo)sis.elementAt(i);
                String name = si.getDigestAlgorithm().toString();
                byte[] digest = (byte[])digs.get(name);
                if (digest == null) {
                    MessageDigest md = MessageDigest.getInstance(name);
                    ByteArrayOutputStream ostream = new ByteArrayOutputStream();
                    revRequest.encode((OutputStream)ostream);
                    digest = md.digest(ostream.toByteArray());
                }
                if ((sid = si.getSignerIdentifier()).getType().equals(SignerIdentifier.ISSUER_AND_SERIALNUMBER)) {
                    IssuerAndSerialNumber issuerAndSerialNumber = sid.getIssuerAndSerialNumber();
                    java.security.cert.Certificate cert = null;
                    if (msgData.hasCertificates()) {
                        SET certs = msgData.getCertificates();
                        int numCerts = certs.size();
                        for (int j = 0; j < numCerts; ++j) {
                            Certificate certJss = (Certificate)certs.elementAt(j);
                            CertificateInfo certI = certJss.getInfo();
                            Name issuer = certI.getIssuer();
                            byte[] issuerB = ASN1Util.encode((ASN1Value)issuer);
                            INTEGER sn = certI.getSerialNumber();
                            if (!new String(issuerB).equalsIgnoreCase(new String(ASN1Util.encode((ASN1Value)issuerAndSerialNumber.getIssuer()))) || !sn.toString().equals(issuerAndSerialNumber.getSerialNumber().toString())) continue;
                            ByteArrayOutputStream os = new ByteArrayOutputStream();
                            certJss.encode((OutputStream)os);
                            cert = new X509CertImpl(os.toByteArray());
                            break;
                        }
                    }
                    if (cert == null) {
                        logger.warn(method + "cert not found");
                        continue;
                    }
                    logger.debug(method + "found cert");
                    PublicKey pbKey = cert.getPublicKey();
                    PK11PubKey pubK = PK11PubKey.fromSPKI((byte[])((X509Key)pbKey).getKey());
                    si.verify(digest, ci.getContentType(), (PublicKey)pubK);
                    java.security.cert.X509Certificate[] x509Certs = new java.security.cert.X509Certificate[]{cert};
                    CAEngine engine = CAEngine.getInstance();
                    if (engine.isRevoked(x509Certs)) {
                        logger.warn(method + "CMC signing cert is a revoked certificate");
                        return false;
                    }
                    try {
                        ((java.security.cert.X509Certificate)cert).checkValidity();
                    }
                    catch (CertificateExpiredException e) {
                        logger.warn(method + "CMC signing cert is an expired certificate");
                        return false;
                    }
                    catch (Exception e) {
                        return false;
                    }
                    return true;
                }
                logger.warn(method + "unsupported SignerIdentifier for CMC revocation");
            }
            return false;
        }
        catch (Exception e) {
            logger.warn("CMCOutputTemplate: verifyRevRequestSignature: " + e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

