/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.ldap;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.Subsystem;
import com.netscape.certsrv.ldap.ELdapException;
import com.netscape.certsrv.request.RequestListener;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.ldap.LdapMappers;
import com.netscape.cmscore.ldap.LdapPublishModule;
import com.netscape.cmscore.request.Request;
import java.security.cert.X509Certificate;
import org.mozilla.jss.netscape.security.x509.X509CertImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HandleRevocation
extends RequestListener {
    public static Logger logger = LoggerFactory.getLogger(HandleRevocation.class);
    private LdapPublishModule mModule = null;

    public HandleRevocation(LdapPublishModule module) {
        this.mModule = module;
    }

    public void init(Subsystem sub, ConfigStore config) throws EBaseException {
    }

    public void set(String name, String val) {
    }

    public void accept(Request r) {
        logger.debug("Handle publishing for revoke request id " + r.getRequestId());
        X509CertImpl[] revcerts = r.getExtDataInCertArray("OLD_CERTS");
        if (revcerts == null || revcerts.length == 0 || revcerts[0] == null) {
            logger.debug("Nothing to unpublish for revocation request " + r.getRequestId());
            return;
        }
        LdapMappers mappers = this.mModule.getMappers("client");
        if (mappers == null || mappers.publisher == null) {
            logger.debug("publisher for client is null");
            return;
        }
        boolean error = false;
        Integer[] results = new Integer[revcerts.length];
        for (int i = 0; i < revcerts.length; ++i) {
            X509CertImpl cert = revcerts[i];
            results[i] = Request.RES_ERROR;
            try {
                this.mModule.unpublish(mappers.mapper, mappers.publisher, (X509Certificate)cert);
                results[i] = Request.RES_SUCCESS;
                logger.debug("Unpublished cert serial no 0x" + cert.getSerialNumber().toString(16));
                continue;
            }
            catch (ELdapException e) {
                error = true;
                logger.warn(CMS.getLogMessage((String)"CMSCORE_LDAP_CERT_NOT_UNPUBLISH", (Object[])new Object[]{cert.getSerialNumber().toString(16), e.getMessage()}), (Throwable)e);
            }
        }
        r.setExtData("ldapPublishStatus", results);
        r.setExtData("ldapPublishOverAllStatus", error ? Request.RES_ERROR : Request.RES_SUCCESS);
    }
}

