/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.ca.CertificateAuthority;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.server.authentication.AuthToken;
import org.mozilla.jss.netscape.security.extensions.NSCertTypeExtension;
import org.mozilla.jss.netscape.security.x509.CertificateChain;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSCertTypeExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(NSCertTypeExt.class);
    protected static final String PROP_SET_DEFAULT_BITS = "setDefaultBits";
    protected static final boolean DEF_SET_DEFAULT_BITS = true;
    protected static final String DEF_SET_DEFAULT_BITS_VAL = Boolean.valueOf(true).toString();
    protected static final int DEF_PATHLEN = -1;
    protected static final boolean[] DEF_BITS = new boolean[8];
    protected static final String PROP_AGENT_OVERR = "allowAgentOverride";
    protected static final String PROP_EE_OVERR = "AllowEEOverride";
    protected static final String PROP_CRITICAL = "critical";
    protected boolean mAllowAgentOverride = false;
    protected boolean mAllowEEOverride = false;
    protected boolean mCritical = false;
    protected int mCAPathLen = -1;
    protected ConfigStore mConfig;
    protected boolean mSetDefaultBits = false;
    private static Vector<String> mDefParams;

    public NSCertTypeExt() {
        this.NAME = "NSCertType";
        this.DESC = "Sets Netscape Cert Type on all certs";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        this.mConfig = config;
        this.mCritical = config.getBoolean(PROP_CRITICAL, false);
        CertificateAuthority certAuthority = (CertificateAuthority)owner.getAuthority();
        CertificateChain caChain = certAuthority.getCACertChain();
        X509Certificate caCert = null;
        if (caChain != null && (caCert = caChain.getFirstCertificate()) != null) {
            this.mCAPathLen = caCert.getBasicConstraints();
        }
        this.mSetDefaultBits = this.mConfig.getBoolean(PROP_SET_DEFAULT_BITS, true);
    }

    public PolicyResult apply(Request req) {
        logger.debug("NSCertTypeExt: Impl: " + this.NAME + ", Instance: " + this.getInstanceName() + "::apply()");
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            int j;
            String certType = req.getExtDataInString("HTTP_PARAMS", "certType");
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            NSCertTypeExtension nsCertTypeExt = null;
            if (extensions != null) {
                try {
                    nsCertTypeExt = (NSCertTypeExtension)extensions.get("NSCertType");
                }
                catch (IOException e) {
                    nsCertTypeExt = null;
                }
                if (nsCertTypeExt != null && this.extensionIsGood(nsCertTypeExt, req)) {
                    logger.debug("NSCertTypeExt: already has correct ns cert type ext");
                    return PolicyResult.ACCEPTED;
                }
                if (nsCertTypeExt != null && certType.equals("ocspResponder")) {
                    extensions.delete("NSCertType");
                    return PolicyResult.ACCEPTED;
                }
            } else if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
                logger.debug("NSCertTypeExt: Created extensions for adding ns cert type..");
            }
            boolean[] bits = null;
            bits = this.getBitsFromRequest(req, this.mSetDefaultBits);
            if (this.mCAPathLen == 0 && bits != null && (bits[5] || bits[6] || bits[7])) {
                this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_SUB_CA_CERTS_ALLOWED", (String[])new String[0]), this.NAME);
                return PolicyResult.REJECTED;
            }
            if (nsCertTypeExt != null) {
                extensions.delete("NSCertType");
            }
            for (j = 0; bits != null && j < bits.length && !bits[j]; ++j) {
            }
            if (bits == null || j == bits.length) {
                if (!this.mSetDefaultBits) {
                    logger.debug("NSCertTypeExt: no bits requested, not setting default.");
                    return PolicyResult.ACCEPTED;
                }
                bits = DEF_BITS;
            }
            nsCertTypeExt = new NSCertTypeExtension(this.mCritical, bits);
            extensions.set("NSCertType", (Object)nsCertTypeExt);
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.warn(CMS.getLogMessage((String)"BASE_IO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.warn(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
    }

    protected boolean extensionIsGood(NSCertTypeExtension nsCertTypeExt, Request req) throws IOException, CertificateException {
        AuthToken token = req.getExtDataInAuthToken("AUTH_TOKEN");
        if (!this.agentApproved(req) && token == null) {
            logger.debug("NSCertTypeExt: unknown origin: setting ns cert type bits to false");
            boolean[] bits = new boolean[8];
            for (int i = bits.length - 1; i >= 0; --i) {
                nsCertTypeExt.set(i, false);
            }
            return false;
        }
        String certType = req.getExtDataInString("HTTP_PARAMS", "certType");
        if (certType != null && certType.equals("ocspResponder")) {
            return false;
        }
        if (certType == null || certType.length() == 0) {
            return true;
        }
        if (certType.equals("ca")) {
            if (!(nsCertTypeExt.isSet(5) || nsCertTypeExt.isSet(6) || nsCertTypeExt.isSet(7))) {
                logger.debug("NSCertTypeExt: is extension good: no ca bits set. set all");
                nsCertTypeExt.set("ssl_ca", (Object)true);
                nsCertTypeExt.set("email_ca", (Object)true);
                nsCertTypeExt.set("object_signing_ca", (Object)true);
            }
            return true;
        }
        if (certType.equals("client")) {
            if (!(nsCertTypeExt.isSet(0) || nsCertTypeExt.isSet(2) || nsCertTypeExt.isSet(1) || nsCertTypeExt.isSet(3))) {
                logger.debug("NSCertTypeExt: is extension good: no cl bits set. set all");
                nsCertTypeExt.set("ssl_client", (Object)true);
                nsCertTypeExt.set("email", (Object)true);
                nsCertTypeExt.set("object_signing", (Object)true);
            }
            return true;
        }
        if (certType.equals("server")) {
            nsCertTypeExt.set(1, true);
            return true;
        }
        return false;
    }

    protected boolean[] getBitsFromRequest(Request req, boolean setDefault) {
        boolean[] bits = null;
        logger.debug("NSCertTypeExt: ns cert type getting ns cert type vars");
        bits = this.getNSCertTypeBits(req);
        if (bits == null && setDefault) {
            logger.debug("NSCertTypeExt: ns cert type getting cert type vars");
            bits = this.getCertTypeBits(req);
            if (bits == null && setDefault) {
                logger.debug("NSCertTypeExt: ns cert type getting def bits");
                bits = DEF_BITS;
            }
        }
        return bits;
    }

    protected boolean[] getNSCertTypeBits(Request req) {
        int i;
        boolean[] bits = new boolean[8];
        bits[0] = req.getExtDataInBoolean("HTTP_PARAMS", "ssl_client", false);
        bits[1] = req.getExtDataInBoolean("HTTP_PARAMS", "ssl_server", false);
        bits[2] = req.getExtDataInBoolean("HTTP_PARAMS", "email", false);
        bits[3] = req.getExtDataInBoolean("HTTP_PARAMS", "object_signing", false);
        bits[5] = req.getExtDataInBoolean("HTTP_PARAMS", "ssl_ca", false);
        bits[6] = req.getExtDataInBoolean("HTTP_PARAMS", "email_ca", false);
        bits[7] = req.getExtDataInBoolean("HTTP_PARAMS", "object_signing_ca", false);
        for (i = bits.length - 1; i >= 0; --i) {
            if (!bits[i]) continue;
            logger.debug("NSCertTypeExt: bit " + i + " is set.");
            break;
        }
        if (i < 0) {
            logger.debug("NSCertTypeExt: No bits were set.");
            bits = null;
        }
        return bits;
    }

    protected boolean[] getCertTypeBits(Request req) {
        String certType = req.getExtDataInString("HTTP_PARAMS", "certType");
        if (certType == null || certType.length() == 0) {
            return null;
        }
        boolean[] bits = new boolean[9];
        for (int i = bits.length - 1; i >= 0; --i) {
            bits[i] = false;
        }
        if (certType.equals("client")) {
            logger.debug("NSCertTypeExt: setting bits for client cert");
            bits[0] = true;
            bits[2] = true;
        } else if (certType.equals("server")) {
            logger.debug("NSCertTypeExt: setting bits for server cert");
            bits[1] = true;
        } else if (certType.equals("ca")) {
            logger.debug("NSCertType: setting bits for ca cert");
            bits[5] = true;
            bits[6] = true;
            bits[7] = true;
        } else if (certType.equals("ra")) {
            logger.debug("NSCertType: setting bits for ra cert");
            bits[0] = true;
        } else {
            logger.debug("NSCertTypeExt: no other cert bits set");
            bits = DEF_BITS;
        }
        return bits;
    }

    public void mergeBits(NSCertTypeExtension nsCertTypeExt, boolean[] bits) {
        for (int i = bits.length - 1; i >= 0; --i) {
            if (!bits[i]) continue;
            logger.debug("NSCertTypeExt: ns cert type merging bit " + i);
            nsCertTypeExt.set(i, true);
        }
    }

    public Vector<String> getInstanceParams() {
        Vector<String> params = new Vector<String>();
        params.addElement("critical=" + this.mCritical);
        params.addElement("setDefaultBits=" + this.mSetDefaultBits);
        return params;
    }

    public String[] getExtendedPluginInfo() {
        String[] params = new String[]{"critical;boolean;Netscape recommendation: non-critical.", "setDefaultBits;boolean;Specify whether to set the Netscape certificate type extension with default bits ('ssl client' and 'email') in certificates specified by the predicate expression.", "HELP_TOKEN;configuration-policyrules-nscerttype", "HELP_TEXT;Adds Netscape Certificate Type extension."};
        return params;
    }

    public Vector<String> getDefaultParams() {
        return mDefParams;
    }

    static {
        NSCertTypeExt.DEF_BITS[0] = true;
        NSCertTypeExt.DEF_BITS[1] = false;
        NSCertTypeExt.DEF_BITS[2] = true;
        NSCertTypeExt.DEF_BITS[3] = true;
        NSCertTypeExt.DEF_BITS[5] = false;
        NSCertTypeExt.DEF_BITS[6] = false;
        NSCertTypeExt.DEF_BITS[7] = false;
        mDefParams = new Vector();
        mDefParams.addElement("critical=false");
        mDefParams.addElement("setDefaultBits=true");
    }
}

