/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.legacy.server.policy.extensions;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.base.IExtendedPluginInfo;
import com.netscape.certsrv.request.PolicyResult;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.request.Request;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.Vector;
import org.dogtagpki.legacy.policy.IEnrollmentPolicy;
import org.dogtagpki.legacy.policy.IPolicyProcessor;
import org.dogtagpki.legacy.server.policy.APolicyRule;
import org.dogtagpki.legacy.server.policy.extensions.PolicyMap;
import org.mozilla.jss.netscape.security.x509.CertificateExtensions;
import org.mozilla.jss.netscape.security.x509.CertificatePolicyMap;
import org.mozilla.jss.netscape.security.x509.CertificateVersion;
import org.mozilla.jss.netscape.security.x509.PolicyMappingsExtension;
import org.mozilla.jss.netscape.security.x509.X509CertInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyMappingsExt
extends APolicyRule
implements IEnrollmentPolicy,
IExtendedPluginInfo {
    public static Logger logger = LoggerFactory.getLogger(PolicyMappingsExt.class);
    protected static final String PROP_CRITICAL = "critical";
    protected static final String PROP_NUM_POLICYMAPPINGS = "numPolicyMappings";
    protected static final String PROP_POLICYMAP = "policyMap";
    protected static final boolean DEF_CRITICAL = false;
    protected static final int DEF_NUM_POLICYMAPPINGS = 1;
    protected boolean mEnabled = false;
    protected ConfigStore mConfig;
    protected boolean mCritical = false;
    protected int mNumPolicyMappings = 1;
    protected PolicyMap[] mPolicyMaps = null;
    protected PolicyMappingsExtension mPolicyMappingsExtension = null;
    protected Vector<String> mInstanceParams = new Vector();
    private static Vector<String> mDefParams = new Vector();

    public PolicyMappingsExt() {
        this.NAME = "PolicyMappingsExt";
        this.DESC = "Sets Policy Mappings Extension on subordinate CA certificates";
    }

    public void init(IPolicyProcessor owner, ConfigStore config) throws EBaseException {
        int i;
        this.mConfig = config;
        this.mEnabled = this.mConfig.getBoolean("enable", false);
        this.mCritical = this.mConfig.getBoolean(PROP_CRITICAL, false);
        this.mNumPolicyMappings = this.mConfig.getInteger(PROP_NUM_POLICYMAPPINGS, 1);
        if (this.mNumPolicyMappings < 1) {
            logger.error(CMS.getLogMessage((String)"BASE_INVALID_ATTR_VALUE_2", (Object[])new Object[]{this.NAME, ""}));
            throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INVALID_ATTR_VALUE", (String[])new String[]{PROP_NUM_POLICYMAPPINGS, "value must be greater than or equal to 1"}));
        }
        this.mPolicyMaps = new PolicyMap[this.mNumPolicyMappings];
        for (i = 0; i < this.mNumPolicyMappings; ++i) {
            String subtreeName = PROP_POLICYMAP + i;
            try {
                this.mPolicyMaps[i] = new PolicyMap(subtreeName, this.mConfig, this.mEnabled);
                continue;
            }
            catch (EBaseException e) {
                logger.error(this.NAME + ": " + CMS.getLogMessage((String)"POLICY_ERROR_CREATE_MAP", (Object[])new Object[]{e.toString()}), (Throwable)e);
                throw e;
            }
        }
        if (this.mEnabled) {
            try {
                Vector<CertificatePolicyMap> certPolicyMaps = new Vector<CertificatePolicyMap>();
                for (int j = 0; j < this.mNumPolicyMappings; ++j) {
                    certPolicyMaps.addElement(this.mPolicyMaps[j].mCertificatePolicyMap);
                }
                this.mPolicyMappingsExtension = new PolicyMappingsExtension(this.mCritical, certPolicyMaps);
            }
            catch (IOException e) {
                throw new EBaseException(CMS.getUserMessage((String)"CMS_BASE_INTERNAL_ERROR", (String[])new String[]{"Error initializing " + this.NAME + " Error: " + e}));
            }
        }
        this.mInstanceParams.addElement("critical=" + this.mCritical);
        this.mInstanceParams.addElement("numPolicyMappings=" + this.mNumPolicyMappings);
        for (i = 0; i < this.mNumPolicyMappings; ++i) {
            this.mPolicyMaps[i].getInstanceParams(this.mInstanceParams);
        }
    }

    public PolicyResult apply(Request req) {
        if (this.mPolicyMappingsExtension == null) {
            return PolicyResult.ACCEPTED;
        }
        X509CertInfo[] ci = req.getExtDataInCertInfoArray("CERT_INFO");
        if (ci == null || ci[0] == null) {
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_NO_CERT_INFO", (String[])new String[0]), this.NAME);
            return PolicyResult.REJECTED;
        }
        for (int i = 0; i < ci.length; ++i) {
            PolicyResult certRes = this.applyCert(req, ci[i]);
            if (certRes != PolicyResult.REJECTED) continue;
            return certRes;
        }
        return PolicyResult.ACCEPTED;
    }

    public PolicyResult applyCert(Request req, X509CertInfo certInfo) {
        try {
            PolicyMappingsExtension policyMappingsExt = null;
            CertificateExtensions extensions = (CertificateExtensions)certInfo.get("extensions");
            try {
                if (extensions != null) {
                    policyMappingsExt = (PolicyMappingsExtension)extensions.get("PolicyMappings");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (policyMappingsExt != null) {
                if (this.agentApproved(req)) {
                    return PolicyResult.ACCEPTED;
                }
                extensions.delete("PolicyMappings");
            }
            if (extensions == null) {
                certInfo.set("version", (Object)new CertificateVersion(2));
                extensions = new CertificateExtensions();
                certInfo.set("extensions", (Object)extensions);
            }
            extensions.set("PolicyMappings", (Object)this.mPolicyMappingsExtension);
            return PolicyResult.ACCEPTED;
        }
        catch (IOException e) {
            logger.error(CMS.getLogMessage((String)"POLICY_ERROR_PROCESS_POLICYMAP_EXT", (Object[])new Object[]{e.getMessage()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, e.getMessage());
            return PolicyResult.REJECTED;
        }
        catch (CertificateException e) {
            logger.error(CMS.getLogMessage((String)"CA_CERT_INFO_ERROR", (Object[])new Object[]{e.toString()}), (Throwable)e);
            this.setError(req, CMS.getUserMessage((String)"CMS_POLICY_UNEXPECTED_POLICY_ERROR", (String[])new String[0]), this.NAME, "Certificate Info Error");
            return PolicyResult.REJECTED;
        }
    }

    public Vector<String> getInstanceParams() {
        return this.mInstanceParams;
    }

    public Vector<String> getDefaultParams() {
        return mDefParams;
    }

    public String[] getExtendedPluginInfo() {
        Vector<Object> theparams = new Vector<Object>();
        theparams.addElement("critical;boolean;RFC 2459 recommendation: MUST be non-critical.");
        theparams.addElement("numPolicyMappings;number; Number of policy mappings. The value must be greater than or equal to 1");
        String policyInfo = ";string;An object identifier in the form n.n.n.n";
        for (int k = 0; k < 5; ++k) {
            String policyMapkDot = PROP_POLICYMAP + k + ".";
            theparams.addElement(policyMapkDot + PolicyMap.PROP_ISSUER_DOMAIN_POLICY + policyInfo);
            theparams.addElement(policyMapkDot + PolicyMap.PROP_SUBJECT_DOMAIN_POLICY + policyInfo);
        }
        theparams.addElement("HELP_TOKEN;configuration-policyrules-policymappings");
        theparams.addElement("HELP_TEXT;Adds Policy Mappings Extension. See RFC 2459 (4.2.1.6)");
        Object[] params = new String[theparams.size()];
        theparams.copyInto(params);
        return params;
    }

    static {
        mDefParams.addElement("critical=false");
        mDefParams.addElement("numPolicyMappings=1");
        String policyMap0Dot = "policyMap0.";
        mDefParams.addElement(policyMap0Dot + PolicyMap.PROP_ISSUER_DOMAIN_POLICY + "=");
        mDefParams.addElement(policyMap0Dot + PolicyMap.PROP_SUBJECT_DOMAIN_POLICY + "=");
    }
}

