/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.acme.database;

import org.dogtagpki.acme.database.PostgreSQLDatabase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLConfigMonitor
implements Runnable {
    public static Logger logger = LoggerFactory.getLogger(PostgreSQLConfigMonitor.class);
    public static final int DEFAULT_INTERVAL = 5;
    PostgreSQLDatabase database;
    int interval = 5;
    boolean running;

    public PostgreSQLDatabase getDatabase() {
        return this.database;
    }

    public void setDatabase(PostgreSQLDatabase database) {
        this.database = database;
    }

    public int getInterval() {
        return this.interval;
    }

    public void setInterval(int interval) {
        this.interval = interval;
    }

    @Override
    public void run() {
        logger.info("Start monitoring ACME configuration");
        this.running = true;
        while (this.running) {
            try {
                this.database.connect();
                logger.info("Updating ACME configuration");
                String value = this.database.getConfig("enabled");
                this.database.enabled = value == null ? null : Boolean.valueOf(value);
                logger.info("- enabled: " + this.database.enabled);
            }
            catch (Exception e) {
                logger.error("Unable to monitor ACME configuration: " + e.getMessage(), (Throwable)e);
            }
            try {
                Thread.sleep(this.interval * 60 * 1000);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        }
        logger.info("Stop monitoring ACME configuration");
    }

    public void stop() throws Exception {
        this.running = false;
    }
}

