/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.admin;

import com.netscape.certsrv.acls.ACLEntry;
import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.common.NameValuePairs;
import com.netscape.certsrv.evaluators.AccessEvaluator;
import com.netscape.cms.authorization.ACL;
import com.netscape.cms.servlet.admin.AdminServlet;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.base.ConfigStore;
import com.netscape.cmscore.logging.Auditor;
import java.io.IOException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authorization.AuthzManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ACLAdminServlet
extends AdminServlet {
    public static Logger logger = LoggerFactory.getLogger(ACLAdminServlet.class);
    private static final long serialVersionUID = -322237202045924779L;
    private static final String PROP_EVAL = "accessEvaluator";
    private static final String INFO = "ACLAdminServlet";
    private AuthzManager mAuthzMgr;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.mAuthzMgr = this.mAuthz.get(this.mAclMethod);
    }

    public String getServletInfo() {
        return INFO;
    }

    @Override
    public void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        block23: {
            String scope = super.getParameter(req, "OP_SCOPE");
            String op = super.getParameter(req, "OP_TYPE");
            if (op == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_INVALID_PROTOCOL", new Object[0]));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_PROTOCOL", new String[0]), null, resp);
                return;
            }
            try {
                super.authenticate(req);
            }
            catch (IOException e) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_FAIL_AUTHS", new Object[0]));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHS_FAILED", new String[0]), null, resp);
                return;
            }
            try {
                AUTHZ_RES_NAME = "certServer.acl.configuration";
                if (op.equals("OP_SEARCH")) {
                    this.mOp = "read";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("acls")) {
                        this.listResources(req, resp);
                        return;
                    }
                    if (scope.equals("impl")) {
                        this.listACLsEvaluators(req, resp);
                        return;
                    }
                    if (scope.equals("evaluatorTypes")) {
                        this.listACLsEvaluatorTypes(req, resp);
                        return;
                    }
                    break block23;
                }
                if (op.equals("OP_READ")) {
                    this.mOp = "read";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("acls")) {
                        this.getResourceACL(req, resp);
                        return;
                    }
                    break block23;
                }
                if (op.equals("OP_MODIFY")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("acls")) {
                        this.updateResources(req, resp);
                        return;
                    }
                    break block23;
                }
                if (op.equals("OP_ADD")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("impl")) {
                        this.addACLsEvaluator(req, resp, scope);
                        return;
                    }
                    break block23;
                }
                if (op.equals("OP_DELETE")) {
                    this.mOp = "modify";
                    this.mToken = super.authorize(req);
                    if (this.mToken == null) {
                        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_AUTHZ_FAILED", new String[0]), null, resp);
                        return;
                    }
                    if (scope.equals("impl")) {
                        this.deleteACLsEvaluator(req, resp, scope);
                        return;
                    }
                    break block23;
                }
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_INVALID_OP_SCOPE", new Object[0]));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_INVALID_OP_SCOPE", new String[0]), null, resp);
                return;
            }
            catch (EBaseException e) {
                logger.error("ACLAdminServlet: " + e.getMessage(), (Throwable)e);
                this.sendResponse(ERROR, e.toString(this.getLocale(req)), null, resp);
                return;
            }
            catch (Exception e) {
                logger.error("ACLAdminServlet: " + e.getMessage(), (Throwable)e);
                logger.debug("SRVLT_FAIL_PERFORM 2");
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_PERFORM_FAILED", new String[0]), null, resp);
                return;
            }
        }
        logger.debug("SRVLT_FAIL_PERFORM 3");
        this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_PERFORM_FAILED", new String[0]), null, resp);
    }

    private void listResources(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Collection<ACL> res = this.mAuthzMgr.getACLs();
        for (ACL acl : res) {
            String desc = acl.getDescription();
            if (desc == null) {
                params.put((Object)acl.getName(), (Object)"");
                continue;
            }
            params.put((Object)acl.getName(), (Object)desc);
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void getResourceACL(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        String resourceId = super.getParameter(req, "RS_ID");
        if (resourceId == null) {
            logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
            return;
        }
        ACL acl = this.mAuthzMgr.getACL(resourceId);
        if (acl == null) {
            logger.error(CMS.getLogMessage("ACLS_SRVLT_RESOURCE_NOT_FOUND", new Object[0]));
            this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_RESOURCE_NOT_FOUND", new String[0]), null, resp);
            return;
        }
        Enumeration<String> rightsEnum = acl.rights();
        StringBuffer rights = new StringBuffer();
        if (rightsEnum.hasMoreElements()) {
            while (rightsEnum.hasMoreElements()) {
                if (rights.length() != 0) {
                    rights.append(",");
                }
                String right = rightsEnum.nextElement();
                rights.append(right);
            }
        }
        params.put((Object)"aclOperations", (Object)rights.toString());
        Enumeration<ACLEntry> aclEntryEnum = acl.entries();
        Object acis = "";
        if (aclEntryEnum.hasMoreElements()) {
            while (aclEntryEnum.hasMoreElements()) {
                if (acis != "") {
                    acis = (String)acis + ";";
                }
                ACLEntry aclEntry = aclEntryEnum.nextElement();
                String aci = aclEntry.getACLEntryString();
                acis = (String)acis + aci;
            }
        }
        params.put((Object)"aci", acis);
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void updateResources(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String resourceId = super.getParameter(req, "RS_ID");
            if (resourceId == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            String resourceACLs = super.getParameter(req, "aci");
            String rights = super.getParameter(req, "rights");
            String desc = super.getParameter(req, "desc");
            try {
                this.mAuthzMgr.updateACLs(resourceId, rights, resourceACLs, desc);
                NameValuePairs params = new NameValuePairs();
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Success", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(SUCCESS, null, params, resp);
                return;
            }
            catch (Exception e) {
                logger.error("ACLAdminServlet: " + e.getMessage(), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_UPDATE_FAIL", new String[0]), null, resp);
                return;
            }
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private void listACLsEvaluators(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<AccessEvaluator> res = this.mAuthzMgr.aclEvaluatorElements();
        while (res.hasMoreElements()) {
            AccessEvaluator evaluator = res.nextElement();
            params.put((Object)evaluator.getType(), (Object)evaluator.getClass().getName());
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private void listACLsEvaluatorTypes(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException, EBaseException {
        NameValuePairs params = new NameValuePairs();
        Enumeration<AccessEvaluator> res = this.mAuthzMgr.aclEvaluatorElements();
        while (res.hasMoreElements()) {
            AccessEvaluator evaluator = res.nextElement();
            String[] operators = evaluator.getSupportedOperators();
            StringBuffer str = new StringBuffer();
            for (int i = 0; i < operators.length; ++i) {
                if (str.length() > 0) {
                    str.append(",");
                }
                str.append(operators[i]);
            }
            params.put((Object)evaluator.getType(), (Object)str.toString());
        }
        this.sendResponse(SUCCESS, null, params, resp);
    }

    private synchronized void addACLsEvaluator(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            String type = super.getParameter(req, "RS_ID");
            if (type == null) {
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            String classPath = super.getParameter(req, "class");
            ConfigStore destStore = this.mConfig.getSubStore(PROP_EVAL, ConfigStore.class);
            ConfigStore mStore = destStore.getSubStore("impl", ConfigStore.class);
            Class<?> newImpl = null;
            try {
                newImpl = Class.forName(classPath);
            }
            catch (ClassNotFoundException e) {
                String errMsg = "class " + classPath + " not found";
                logger.error(errMsg, (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_CLASS_LOAD_FAIL", new String[0]), null, resp);
                return;
            }
            try {
                if (!Class.forName("com.netscape.certsrv.evaluators.IAccessEvaluator").isAssignableFrom(newImpl)) {
                    String errMsg = "class not com.netscape.certsrv.evaluators.IAccessEvaluator" + classPath;
                    logger.error(errMsg);
                    auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                    auditor.log(auditMessage);
                    this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_ILL_CLASS", new String[0]), null, resp);
                    return;
                }
            }
            catch (Exception e) {
                String errMsg = "class not com.netscape.certsrv.evaluators.IAccessEvaluator" + classPath;
                logger.error(errMsg, (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_ILL_CLASS", new String[0]), null, resp);
                return;
            }
            ConfigStore substore = mStore.makeSubStore(type);
            substore.put("class", classPath);
            try {
                this.mConfig.commit(true);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage("ACLS_SRVLT_FAIL_COMMIT", new Object[0]), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_COMMIT_FAIL", new String[0]), null, resp);
                return;
            }
            AccessEvaluator evaluator = null;
            try {
                evaluator = (AccessEvaluator)Class.forName(classPath).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error("ACLAdminServlet: " + e.getMessage(), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_INST_CLASS_FAIL", new String[0]), null, resp);
                return;
            }
            if (evaluator != null) {
                evaluator.setCMSEngine(engine);
                evaluator.init();
                this.mAuthzMgr.registerEvaluator(type, evaluator);
            }
            NameValuePairs params = new NameValuePairs();
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Success", this.auditParams(req));
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, params, resp);
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }

    private synchronized void deleteACLsEvaluator(HttpServletRequest req, HttpServletResponse resp, String scope) throws ServletException, IOException, EBaseException {
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        String auditMessage = null;
        String auditSubjectID = this.auditSubjectID();
        try {
            NameValuePairs params = new NameValuePairs();
            String id = req.getParameter("RS_ID");
            if (id == null) {
                logger.error(CMS.getLogMessage("ADMIN_SRVLT_NULL_RS_ID", new Object[0]));
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ADMIN_SRVLT_NULL_RS_ID", new String[0]), null, resp);
                return;
            }
            Hashtable<String, AccessEvaluator> mEvaluators = this.mAuthzMgr.getAccessEvaluators();
            if (!mEvaluators.containsKey(id)) {
                logger.error("evaluator attempted to be removed not found");
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_EVAL_NOT_FOUND", new String[0]), null, resp);
                return;
            }
            mEvaluators.remove(id);
            try {
                ConfigStore destStore = this.mConfig.getSubStore(PROP_EVAL, ConfigStore.class);
                ConfigStore mStore = destStore.getSubStore("impl", ConfigStore.class);
                mStore.removeSubStore(id);
            }
            catch (Exception destStore) {
                // empty catch block
            }
            try {
                this.mConfig.commit(true);
            }
            catch (Exception e) {
                logger.error(CMS.getLogMessage("ACLS_SRVLT_FAIL_COMMIT", new Object[0]), (Throwable)e);
                auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
                auditor.log(auditMessage);
                this.sendResponse(ERROR, CMS.getUserMessage(this.getLocale(req), "CMS_ACL_COMMIT_FAIL", new String[0]), null, resp);
                return;
            }
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Success", this.auditParams(req));
            auditor.log(auditMessage);
            this.sendResponse(SUCCESS, null, params, resp);
            return;
        }
        catch (IOException eAudit2) {
            auditMessage = CMS.getLogMessage("LOGGING_SIGNED_AUDIT_CONFIG_ACL_3", auditSubjectID, "Failure", this.auditParams(req));
            auditor.log(auditMessage);
            throw eAudit2;
        }
    }
}

