/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.common;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.common.CMSFile;
import com.netscape.cms.servlet.common.CMSTemplateParams;
import com.netscape.cms.servlet.common.ECMSGWException;
import com.netscape.cms.servlet.common.IRawJS;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.base.ArgBlock;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Enumeration;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMSTemplate
extends CMSFile {
    public static Logger logger = LoggerFactory.getLogger(CMSTemplate.class);
    public static final String SUFFIX = ".template";
    public String mPreOutput;
    public String mPostOutput;
    public static final String TEMPLATE_TAG = "<CMS_TEMPLATE>";
    private String mCharset = null;

    public CMSTemplate(File file, String charset) throws IOException, EBaseException {
        this.mCharset = charset;
        this.mAbsPath = file.getAbsolutePath();
        this.mLastModified = file.lastModified();
        try {
            this.init(file);
        }
        catch (IOException e) {
            logger.error("CMSTemplate: " + CMS.getLogMessage("CMSGW_CANT_LOAD_TEMPLATE", this.mAbsPath, e.toString()), (Throwable)e);
            throw new ECMSGWException(CMS.getLogMessage("CMSGW_ERROR_LOADING_TEMPLATE", new Object[0]));
        }
        String content = this.mPreOutput + this.mPostOutput;
        this.mContent = content.getBytes(this.mCharset);
    }

    public boolean init(File template) throws EBaseException, IOException {
        String content = this.loadFile(template);
        if (content == null) {
            logger.error("CMSTemplate: " + CMS.getLogMessage("CMSGW_TEMPLATE_EMPTY", this.mAbsPath));
            throw new ECMSGWException(CMS.getLogMessage("CMSGW_TEMPLATE_NO_CONTENT_1", this.mAbsPath));
        }
        int location = content.indexOf(TEMPLATE_TAG);
        if (location == -1) {
            logger.error("CMSTemplate: " + CMS.getLogMessage("CMSGW_TEMPLATE_MISSING", this.mAbsPath, TEMPLATE_TAG));
            throw new ECMSGWException(CMS.getLogMessage("CMSGW_MISSING_TEMPLATE_TAG_2", TEMPLATE_TAG, this.mAbsPath));
        }
        this.mPreOutput = content.substring(0, location);
        this.mPostOutput = content.substring(TEMPLATE_TAG.length() + location);
        return true;
    }

    public void renderOutput(OutputStream rout, CMSTemplateParams input) throws IOException {
        Enumeration<String> e = null;
        Enumeration<ArgBlock> q = null;
        ArgBlock r = null;
        CMSTemplateParams data = input;
        try (HTTPOutputStreamWriter http_out = this.mCharset == null ? new HTTPOutputStreamWriter(rout) : new HTTPOutputStreamWriter(rout, this.mCharset);){
            Object v;
            String n;
            templateLine out = new templateLine();
            out.print(this.mPreOutput);
            out.println("<SCRIPT LANGUAGE=\"JavaScript\">");
            out.println("var header = new Object();");
            out.println("var fixed = new Object();");
            out.println("var recordSet = new Array;");
            out.println("var result = new Object();");
            out.println("var httpParamsCount = 0;");
            out.println("var httpHeadersCount = 0;");
            out.println("var authTokenCount = 0;");
            out.println("var serverAttrsCount = 0;");
            out.println("header.HTTP_PARAMS = new Array;");
            out.println("header.HTTP_HEADERS = new Array;");
            out.println("header.AUTH_TOKEN = new Array;");
            out.println("header.SERVER_ATTRS = new Array;");
            r = data.getHeader();
            if (r != null) {
                e = r.elements();
                while (e.hasMoreElements()) {
                    n = e.nextElement();
                    v = r.getValue(n);
                    out.println("header." + n + " = " + this.renderValue(v) + ";");
                }
            }
            if ((r = data.getFixed()) != null) {
                e = r.elements();
                while (e.hasMoreElements()) {
                    n = e.nextElement();
                    v = r.getValue(n);
                    out.println("fixed." + n + " = " + this.renderValue(v) + ";");
                }
            }
            if ((q = data.queryRecords()) != null && q.hasMoreElements()) {
                out.println("var recordCount = 0;");
                out.println("var record;");
                while (q.hasMoreElements()) {
                    out.println("record = new Object;");
                    out.println("record.HTTP_PARAMS = new Array;");
                    out.println("record.HTTP_HEADERS = new Array;");
                    out.println("record.AUTH_TOKEN = new Array;");
                    out.println("record.SERVER_ATTRS = new Array;");
                    r = q.nextElement();
                    e = r.elements();
                    while (e.hasMoreElements()) {
                        n = e.nextElement();
                        v = r.getValue(n);
                        out.println("record." + n + "=" + this.renderValue(v) + ";");
                    }
                    out.println("recordSet[recordCount++] = record;");
                }
                out.println("record.recordSet = recordSet;");
            }
            out.println("result.header = header;");
            out.println("result.fixed = fixed;");
            out.println("result.recordSet = recordSet;");
            out.println("</SCRIPT>");
            out.println(this.mPostOutput);
            http_out.print(out.toString());
        }
        catch (EBaseException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    public boolean outputProlog(PrintWriter out) {
        out.print(this.mPreOutput);
        out.println("<SCRIPT LANGUAGE=\"JavaScript\">");
        out.println("var header = new Object();");
        out.println("var result = new Object();");
        return true;
    }

    public boolean outputEpilog(PrintWriter out) {
        out.println("</SCRIPT>");
        out.println(this.mPostOutput);
        return true;
    }

    public String getTemplateName() {
        return this.mAbsPath;
    }

    private String loadFile(File template) throws IOException {
        StringBuffer buf = new StringBuffer();
        try (FileInputStream inStream = new FileInputStream(template);
             InputStreamReader inReader = new InputStreamReader((InputStream)inStream, this.mCharset);
             BufferedReader in = new BufferedReader(inReader);){
            String line;
            while ((line = in.readLine()) != null) {
                buf.append(line);
                buf.append('\n');
            }
        }
        return buf.toString();
    }

    private String renderValue(Object v) {
        Object s = null;
        s = v instanceof IRawJS ? v.toString() : (v instanceof String ? (v.equals("") ? "null" : "\"" + CMSTemplate.escapeJavaScriptString((String)v) + "\"") : (v instanceof Integer ? ((Integer)v).toString() : (v instanceof Boolean ? (((Boolean)v).booleanValue() ? "true" : "false") : (v instanceof BigInteger ? ((BigInteger)v).toString(10) : (v instanceof Character && ((Character)v).equals(Character.valueOf('\u0000')) ? "null" : "\"" + CMSTemplate.escapeJavaScriptString(v.toString()) + "\"")))));
        return s;
    }

    public static String escapeJavaScriptString(String v) {
        return CMSTemplate.escapeJavaScriptStringHTML(v);
    }

    public static String escapeJavaScriptStringHTML(String v) {
        if (v == null) {
            return null;
        }
        return StringEscapeUtils.escapeEcmaScript((String)StringEscapeUtils.escapeHtml4((String)v));
    }

    public String getOutput(CMSTemplateParams input) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.renderOutput(out, input);
        return out.toString();
    }

    private class HTTPOutputStreamWriter
    extends OutputStreamWriter {
        public HTTPOutputStreamWriter(OutputStream out) throws UnsupportedEncodingException {
            super(out);
        }

        public HTTPOutputStreamWriter(OutputStream out, String enc) throws UnsupportedEncodingException {
            super(out, enc);
        }

        public void print(String s) throws IOException {
            this.write(s, 0, s.length());
            this.flush();
        }
    }

    private class templateLine {
        private StringBuffer s = new StringBuffer();

        private templateLine() {
        }

        void println(String p) {
            this.s.append('\n');
            this.s.append(p);
        }

        void print(String p) {
            this.s.append(p);
        }

        public String toString() {
            return this.s.toString();
        }
    }
}

