/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.csadmin;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.base.UserInfo;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cms.servlet.common.ICMSTemplateFiller;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.apps.EngineConfig;
import com.netscape.cmscore.apps.PreOpConfig;
import com.netscape.cmsutil.crypto.CryptoUtil;
import java.io.IOException;
import java.util.Locale;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadPKCS12
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(DownloadPKCS12.class);
    private static final long serialVersionUID = -7770226137155537526L;
    private static final String AUTH_FAILURE = "2";

    @Override
    public void init(ServletConfig sc) throws ServletException {
        logger.debug("DownloadPKCS12: initializing...");
        super.init(sc);
        logger.debug("DownloadPKCS12: done initializing...");
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        logger.debug("DownloadPKCS12: processing...");
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        EngineConfig cs = engine.getConfig();
        PreOpConfig preopConfig = cs.getPreOpConfig();
        this.mRenderResult = false;
        String pin = (String)httpReq.getSession().getAttribute("pin");
        if (pin == null) {
            logger.warn("DownloadPKCS12 process: Failed to get the pin from the cookie.");
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        String cspin = "";
        try {
            cspin = preopConfig.getString("pin");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!pin.equals(cspin)) {
            logger.warn("DownloadPKCS12 process: Wrong pin");
            this.outputError(httpResp, AUTH_FAILURE, "Error: Not authenticated", null);
            return;
        }
        byte[] pkcs12 = null;
        try {
            String str = preopConfig.getString("pkcs12");
            pkcs12 = CryptoUtil.string2byte((String)str);
        }
        catch (Exception str) {
            // empty catch block
        }
        try {
            httpResp.setContentType("application/x-pkcs12");
            httpResp.getOutputStream().write(pkcs12);
            return;
        }
        catch (Exception e) {
            logger.warn("DownloadPKCS12 process: " + e.getMessage(), (Throwable)e);
            return;
        }
    }

    @Override
    protected void setDefaultTemplates(ServletConfig sc) {
    }

    @Override
    protected void renderTemplate(CMSRequest cmsReq, String templateName, ICMSTemplateFiller filler) throws IOException {
    }

    @Override
    protected void renderResult(CMSRequest cmsReq) throws IOException {
    }

    @Override
    protected Locale getLocale(HttpServletRequest req) {
        Locale locale = null;
        String lang = req.getHeader("accept-language");
        locale = lang == null ? Locale.getDefault() : new Locale(UserInfo.getUserLanguage(lang), UserInfo.getUserCountry(lang));
        return locale;
    }
}

