/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cms.servlet.ocsp;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.logging.event.OCSPGenerationEvent;
import com.netscape.certsrv.ocsp.IOCSPService;
import com.netscape.cms.servlet.base.CMSServlet;
import com.netscape.cms.servlet.common.CMSRequest;
import com.netscape.cmscore.apps.CMSEngine;
import com.netscape.cmscore.logging.Auditor;
import com.netscape.cmscore.util.StatsSubsystem;
import com.netscape.cmsutil.ocsp.BasicOCSPResponse;
import com.netscape.cmsutil.ocsp.OCSPRequest;
import com.netscape.cmsutil.ocsp.OCSPResponse;
import com.netscape.cmsutil.ocsp.Request;
import com.netscape.cmsutil.ocsp.ResponseBytes;
import com.netscape.cmsutil.ocsp.ResponseData;
import com.netscape.cmsutil.ocsp.SingleResponse;
import com.netscape.cmsutil.ocsp.TBSRequest;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dogtagpki.server.authentication.AuthToken;
import org.dogtagpki.server.authorization.AuthzToken;
import org.mozilla.jss.asn1.ASN1Util;
import org.mozilla.jss.asn1.ASN1Value;
import org.mozilla.jss.netscape.security.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPServlet
extends CMSServlet {
    public static Logger logger = LoggerFactory.getLogger(OCSPServlet.class);
    private static final long serialVersionUID = 120903601883352030L;
    public static final String PROP_AUTHORITY = "authority";
    public static final String PROP_CLIENTAUTH = "GetClientCert";
    public static final String PROP_MAX_REQUEST_SIZE = "MaxRequestSize";
    public static final String PROP_ID = "ID";
    private int m_maxRequestSize = 5000;

    @Override
    public void init(ServletConfig sc) throws ServletException {
        super.init(sc);
        String s = sc.getInitParameter(PROP_MAX_REQUEST_SIZE);
        if (s != null) {
            try {
                this.m_maxRequestSize = Integer.parseInt(s);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected void process(CMSRequest cmsReq) throws EBaseException {
        HttpServletRequest httpReq = cmsReq.getHttpReq();
        HttpServletResponse httpResp = cmsReq.getHttpResp();
        CMSEngine engine = this.getCMSEngine();
        Auditor auditor = engine.getAuditor();
        StatsSubsystem statsSub = (StatsSubsystem)engine.getSubsystem("stats");
        if (statsSub != null) {
            statsSub.startTiming("ocsp", true);
        }
        AuthToken authToken = this.authenticate(cmsReq);
        AuthzToken authzToken = null;
        try {
            authzToken = this.authorize(this.mAclMethod, authToken, this.mAuthzResourceName, "submit");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (authzToken == null) {
            cmsReq.setStatus(CMSRequest.UNAUTHORIZED);
            return;
        }
        logger.debug("OCSPServlet: Servlet Path: " + httpReq.getServletPath());
        logger.debug("OCSPServlet: RequestURI: " + httpReq.getRequestURI());
        String pathInfo = httpReq.getPathInfo();
        if (pathInfo != null && pathInfo.indexOf(37) != -1) {
            try {
                pathInfo = URLDecoder.decode(pathInfo, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                logger.error("OCSPServlet: " + e.getMessage(), (Throwable)e);
                throw new EBaseException("OCSPServlet: Unsupported encoding: " + e, (Throwable)e);
            }
        }
        logger.debug("OCSPServlet: PathInfo: " + pathInfo);
        OCSPRequest ocspReq = null;
        try {
            Object is = httpReq.getInputStream();
            byte[] reqbuf = null;
            String method = httpReq.getMethod();
            logger.debug("OCSPServlet: HTTP method: " + method);
            if (method != null && method.equals("POST")) {
                logger.debug("OCSPServlet: processing POST request");
                int reqlen = httpReq.getContentLength();
                if (reqlen == -1) {
                    throw new Exception("OCSPServlet: Content-Length not supplied");
                }
                if (reqlen == 0) {
                    throw new Exception("OCSPServlet: Invalid Content-Length");
                }
                if (reqlen > this.m_maxRequestSize) {
                    throw new Exception("OCSPServlet: Client sending too much OCSP request data (" + reqlen + ")");
                }
                reqbuf = new byte[reqlen];
                int bytesread = 0;
                boolean partial = false;
                while (bytesread < reqlen) {
                    int r = ((InputStream)is).read(reqbuf, bytesread, reqlen - bytesread);
                    if (r == -1) {
                        throw new Exception("OCSPServlet: Client did not supply enough OCSP data");
                    }
                    if (partial || (bytesread += r) >= reqlen) continue;
                    partial = true;
                }
                is = new ByteArrayInputStream(reqbuf);
            } else {
                logger.debug("OCSPServlet: processing GET request");
                if (pathInfo == null || pathInfo.equals("") || pathInfo.substring(1) == null || pathInfo.substring(1).equals("")) {
                    throw new Exception("OCSPServlet: OCSP request not provided in GET method");
                }
                is = new ByteArrayInputStream(Utils.base64decode((String)pathInfo.substring(1)));
            }
            OCSPResponse response = null;
            try {
                OCSPRequest.Template reqTemplate = new OCSPRequest.Template();
                if (is == null || is.toString().equals("")) {
                    throw new Exception("OCSPServlet: OCSP request is empty or malformed");
                }
                logger.debug("OCSPServlet: decoding request");
                ocspReq = (OCSPRequest)reqTemplate.decode((InputStream)is);
                if (ocspReq == null || ocspReq.toString().equals("")) {
                    throw new Exception("OCSPServlet: Decoded OCSP request is empty or malformed");
                }
                logger.debug("OCSPServlet: validating request");
                response = ((IOCSPService)((Object)this.mAuthority)).validate(ocspReq);
                if (response == null) {
                    auditor.log(OCSPGenerationEvent.createFailureEvent(this.auditSubjectID(), "Missing OCSP response"));
                } else {
                    auditor.log(OCSPGenerationEvent.createSuccessEvent(this.auditSubjectID()));
                }
            }
            catch (Exception e) {
                logger.warn("OCSPServlet: " + e.getMessage(), (Throwable)e);
                auditor.log(OCSPGenerationEvent.createFailureEvent(this.auditSubjectID(), e.getMessage()));
            }
            if (response != null) {
                ByteArrayOutputStream fos1 = new ByteArrayOutputStream();
                response.encode((OutputStream)fos1);
                fos1.close();
                byte[] respbytes = fos1.toByteArray();
                if (logger.isDebugEnabled()) {
                    logger.debug("OCSPServlet: OCSP Request:");
                    logger.debug("OCSPServlet: " + Utils.base64encode((byte[])ASN1Util.encode((ASN1Value)ocspReq), (boolean)true));
                    TBSRequest tbsReq = ocspReq.getTBSRequest();
                    for (int i = 0; i < tbsReq.getRequestCount(); ++i) {
                        Request req = tbsReq.getRequestAt(i);
                        logger.debug("Serial Number: " + req.getCertID().getSerialNumber());
                    }
                    logger.debug("OCSPServlet: OCSP Response Size:");
                    logger.debug("OCSPServlet: " + Integer.toString(respbytes.length));
                    logger.debug("OCSPServlet: OCSP Response Data:");
                    logger.debug("OCSPServlet: " + Utils.base64encode((byte[])respbytes, (boolean)true));
                    ResponseBytes rbytes = response.getResponseBytes();
                    if (rbytes == null) {
                        logger.debug("OCSPServlet: Response bytes is null");
                    } else if (rbytes.getObjectIdentifier().equals((Object)ResponseBytes.OCSP_BASIC)) {
                        BasicOCSPResponse basicRes = (BasicOCSPResponse)BasicOCSPResponse.getTemplate().decode((InputStream)new ByteArrayInputStream(rbytes.getResponse().toByteArray()));
                        if (basicRes == null) {
                            logger.warn("OCSPServlet: Basic Res is null");
                        } else {
                            ResponseData data = basicRes.getResponseData();
                            for (int i = 0; i < data.getResponseCount(); ++i) {
                                SingleResponse res = data.getResponseAt(i);
                                logger.debug("OCSPServlet: Serial Number: " + res.getCertID().getSerialNumber());
                                logger.debug("OCSPServlet: Status: " + res.getCertStatus().getClass().getName());
                            }
                        }
                    }
                }
                httpResp.setContentType("application/ocsp-response");
                httpResp.setContentLength(respbytes.length);
                ServletOutputStream ooss = httpResp.getOutputStream();
                ooss.write(respbytes);
                ooss.flush();
                if (statsSub != null) {
                    statsSub.endTiming("ocsp");
                }
                this.mRenderResult = false;
            } else {
                logger.warn("OCSPServlet: response is null");
            }
        }
        catch (Exception e) {
            logger.warn("OCSPServlet: " + e.getMessage(), (Throwable)e);
        }
    }
}

