/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.cmscore.request;

import com.netscape.certsrv.base.EBaseException;
import com.netscape.certsrv.dbs.IDBObj;
import com.netscape.certsrv.request.RequestId;
import com.netscape.cmscore.apps.CMS;
import com.netscape.cmscore.request.DBDynAttrMapper;
import com.netscape.cmscore.request.RequestRecord;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtAttrDynMapper
extends DBDynAttrMapper {
    public static Logger logger = LoggerFactory.getLogger(ExtAttrDynMapper.class);
    protected static final String extAttrPrefix = "extdata-";
    protected static final Vector<String> mAttrs = new Vector();

    @Override
    public boolean supportsLDAPAttributeName(String attrName) {
        return attrName != null && attrName.toLowerCase().startsWith(extAttrPrefix);
    }

    @Override
    public Enumeration<String> getSupportedLDAPAttributeNames() {
        return mAttrs.elements();
    }

    public String decodeKey(String key) {
        StringBuffer output = null;
        char[] input = key.toCharArray();
        int startCopyIndex = 0;
        int index = 0;
        while (index < input.length) {
            if (input[index] != '-') {
                ++index;
                continue;
            }
            if (index + 1 >= input.length || input[index + 1] != '-') {
                ++index;
                continue;
            }
            if (output == null) {
                output = new StringBuffer(input.length);
            }
            output.append(input, startCopyIndex, index - startCopyIndex);
            if ((index += 2) + 3 < input.length) {
                String value = new String(input, index, 4);
                int codePoint = Integer.parseInt(value, 16);
                char[] chars = Character.toChars(codePoint);
                output.append(chars);
            }
            startCopyIndex = index += 4;
        }
        if (output == null) {
            return key;
        }
        output.append(input, startCopyIndex, index - startCopyIndex);
        return output.toString();
    }

    public String encodeKey(String key) {
        StringBuffer output = null;
        char[] input = key.toCharArray();
        int startCopyIndex = 0;
        int index = 0;
        while (index < input.length) {
            if (this.isAlphaNum(input[index])) {
                ++index;
                continue;
            }
            if (input[index] == '-' && index + 1 < input.length && this.isAlphaNum(input[index + 1])) {
                index += 2;
                continue;
            }
            if (input[index] == '-' && index + 1 == input.length) {
                ++index;
                continue;
            }
            if (output == null) {
                output = new StringBuffer(input.length + 5);
            }
            output.append(input, startCopyIndex, index - startCopyIndex);
            while (index < input.length && !this.isAlphaNum(input[index])) {
                output.append("--");
                String hexString = Integer.toHexString(input[index]);
                for (int padding = 4 - hexString.length(); padding > 0; --padding) {
                    output.append('0');
                }
                output.append(hexString);
                ++index;
            }
            startCopyIndex = index;
        }
        if (output == null) {
            return key;
        }
        output.append(input, startCopyIndex, index - startCopyIndex);
        return output.toString();
    }

    protected boolean isAlphaNum(char in) {
        if (in >= 'a' && in <= 'z') {
            return true;
        }
        if (in >= 'A' && in <= 'Z') {
            return true;
        }
        return in >= '0' && in <= '9';
    }

    @Override
    public void mapObjectToLDAPAttributeSet(IDBObj parent, String name, Object obj, LDAPAttributeSet attrs) throws EBaseException {
        if (obj == null) {
            throw new EBaseException(CMS.getUserMessage("CMS_DBS_SERIALIZE_FAILED", name));
        }
        Hashtable ht = (Hashtable)obj;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Object value = ht.get(key);
            if (value instanceof String) {
                String stringValue = ((String)value).trim();
                if ("".equals(stringValue)) continue;
                String attrName = extAttrPrefix + this.encodeKey(key);
                logger.debug("ExtAttrDynMapper: Mapping " + name + " to " + attrName);
                attrs.add(new LDAPAttribute(attrName, stringValue));
                continue;
            }
            if (!(value instanceof Hashtable)) continue;
            Hashtable innerHash = (Hashtable)value;
            Enumeration innerHashEnum = innerHash.keys();
            while (innerHashEnum.hasMoreElements()) {
                String innerKey = (String)innerHashEnum.nextElement();
                String innerValue = ((String)innerHash.get(innerKey)).trim();
                if ("".equals(innerValue)) continue;
                String attrName = extAttrPrefix + this.encodeKey(key) + ";" + this.encodeKey(innerKey);
                logger.debug("ExtAttrDynMapper: Mapping " + name + " to " + attrName);
                attrs.add(new LDAPAttribute(attrName, innerValue));
            }
        }
    }

    @Override
    public void mapLDAPAttributeSetToObject(LDAPAttributeSet attrs, String name, IDBObj parent) throws EBaseException {
        Hashtable<String, Object> ht = new Hashtable<String, Object>();
        Enumeration attrEnum = attrs.getAttributes();
        while (attrEnum.hasMoreElements()) {
            RequestId requestID;
            LDAPAttribute attr = (LDAPAttribute)attrEnum.nextElement();
            String baseName = attr.getBaseName();
            if (!baseName.toLowerCase().startsWith(extAttrPrefix)) continue;
            String keyName = this.decodeKey(baseName.substring(extAttrPrefix.length()));
            String[] subTypes = attr.getSubtypes();
            String[] values = attr.getStringValueArray();
            if (values.length != 1) {
                requestID = ((RequestRecord)parent).getRequestId();
                String message = "Output Mapping Error in request ID " + requestID + " : more than one value returned for " + keyName;
                logger.error(message);
                throw new EBaseException(message);
            }
            if (subTypes == null || subTypes.length <= 0) {
                ht.put(keyName, values[0]);
                continue;
            }
            if (subTypes.length != 1) {
                requestID = ((RequestRecord)parent).getRequestId();
                String message = "Output Mapping Error in request ID " + requestID + " : more than one subType returned for " + keyName;
                logger.error(message);
                throw new EBaseException(message);
            }
            Object value = ht.get(keyName);
            if (value != null && !(value instanceof Hashtable)) {
                RequestId requestID2 = ((RequestRecord)parent).getRequestId();
                String message = "Output Mapping Error in request ID " + requestID2 + " : combined no-subtype and subtype data for key " + keyName;
                logger.error(message);
                throw new EBaseException(message);
            }
            Hashtable<String, String> valueHashtable = (Hashtable<String, String>)value;
            if (valueHashtable == null) {
                valueHashtable = new Hashtable<String, String>();
                ht.put(keyName, valueHashtable);
            }
            valueHashtable.put(this.decodeKey(subTypes[0]), values[0]);
        }
        parent.set(name, ht);
    }

    @Override
    public String mapSearchFilter(String name, String op, String value) throws EBaseException {
        return name + op + value;
    }

    static {
        mAttrs.add("extAttr");
    }
}

