/*
 * Decompiled with CFR 0.152.
 */
package org.dogtagpki.server.rest;

import com.netscape.cms.servlet.base.PKIService;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.ResourceMethodInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class MessageFormatInterceptor
implements ContainerRequestFilter {
    public static Logger logger = LoggerFactory.getLogger(MessageFormatInterceptor.class);

    public void filter(ContainerRequestContext requestContext) throws IOException {
        ResourceMethodInvoker methodInvoker = (ResourceMethodInvoker)requestContext.getProperty("org.jboss.resteasy.core.ResourceMethodInvoker");
        Method method = methodInvoker.getMethod();
        Class clazz = methodInvoker.getResourceClass();
        logger.debug("MessageFormatInterceptor: " + clazz.getSimpleName() + "." + method.getName() + "()");
        MediaType contentType = requestContext.getMediaType();
        if (contentType != null) {
            logger.debug("MessageFormatInterceptor: content-type: " + contentType);
        }
        List acceptableFormats = requestContext.getAcceptableMediaTypes();
        logger.debug("MessageFormatInterceptor: accept: " + acceptableFormats);
        MediaType requestFormat = null;
        if (contentType != null) {
            requestFormat = PKIService.resolveFormat(contentType);
            logger.debug("MessageFormatInterceptor: request format: " + requestFormat);
            if (requestFormat == null) {
                throw new WebApplicationException(Response.Status.UNSUPPORTED_MEDIA_TYPE);
            }
        }
        MediaType responseFormat = acceptableFormats == null || acceptableFormats.isEmpty() ? (contentType == null ? PKIService.MESSAGE_FORMATS.get(0) : requestFormat) : PKIService.resolveFormat(acceptableFormats);
        logger.debug("MessageFormatInterceptor: response format: " + responseFormat);
        if (responseFormat == null) {
            throw new WebApplicationException(Response.Status.NOT_ACCEPTABLE);
        }
    }
}

